/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Joiner;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.collect.$HashMultimap;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Maps;
import org.immutables.value.internal.$guava$.collect.$Multimap;
import org.immutables.value.internal.$guava$.collect.$Ordering;
import org.immutables.value.internal.$guava$.collect.$Sets;

final class $PostprocessingMachine {
    private static final $Joiner JOINER = $Joiner.on("");

    private $PostprocessingMachine() {
    }

    static CharSequence rewrite(CharSequence content) {
        String currentPackage = "";
        ImportsBuilder importsBuilder = new ImportsBuilder();
        State state = State.UNDEFINED;
        int packageFrom = -1;
        int importFrom = -1;
        int nextPartFrom = 0;
        boolean importStarts = false;
        int classNameOccurrencesInImportBlock = 0;
        int classNameFrom = -1;
        int classNameTo = -1;
        FiniteStateMachine machine = new FiniteStateMachine();
        FullyQualifiedNameMachine fullyNameMachine = new FullyQualifiedNameMachine();
        CommentMachine commentMachine = new CommentMachine();
        ClassNameMachine nameMachine = new ClassNameMachine();
        block7: for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            commentMachine.nextChar(c);
            if (commentMachine.isInComment()) continue;
            switch (state) {
                case UNDEFINED: {
                    state = machine.nextChar(c).or(state);
                    continue block7;
                }
                case PACKAGE: {
                    if (c == ' ') {
                        packageFrom = i + 1;
                    }
                    if (c != ';') continue block7;
                    nextPartFrom = i + 2;
                    currentPackage = content.subSequence(packageFrom, i).toString();
                    importsBuilder.setCurrentPackage(currentPackage);
                    state = State.UNDEFINED;
                    packageFrom = -1;
                    continue block7;
                }
                case IMPORTS: {
                    nameMachine.nextChar(c, i, true);
                    if (!fullyNameMachine.isFinished()) {
                        fullyNameMachine.nextChar(c, i);
                    }
                    if (nameMachine.isFound()) {
                        ++classNameOccurrencesInImportBlock;
                        classNameFrom = nameMachine.classNameFrom;
                        classNameTo = nameMachine.classNameTo;
                    }
                    if (!importStarts && c == ' ') {
                        importFrom = i + 1;
                        importStarts = true;
                    }
                    if (c != ';') continue block7;
                    nextPartFrom = i + 2;
                    if (fullyNameMachine.isFinished()) {
                        importsBuilder.addOriginalImport(content.subSequence(fullyNameMachine.packageTo, fullyNameMachine.importTo).toString(), content.subSequence(fullyNameMachine.importFrom, fullyNameMachine.importTo).toString(), content.subSequence(importFrom, i).toString());
                    } else {
                        importsBuilder.addImport(content.subSequence(importFrom, i).toString());
                    }
                    fullyNameMachine.reset();
                    state = State.UNDEFINED;
                    importFrom = -1;
                    importStarts = false;
                    if (classNameOccurrencesInImportBlock != 1) continue block7;
                    importsBuilder.addToStopList(content.subSequence(classNameFrom, classNameTo).toString());
                    nameMachine.reset();
                    classNameOccurrencesInImportBlock = 0;
                    continue block7;
                }
                case ANNOTATION: {
                    c = content.charAt(--i);
                    state = State.CLASS;
                }
                case CLASS: {
                    nameMachine.nextChar(c, i);
                    fullyNameMachine.nextChar(c, i);
                    if (fullyNameMachine.isFinished()) {
                        importsBuilder.addImportCandidate(content.subSequence(fullyNameMachine.packageTo, fullyNameMachine.importTo).toString(), content.subSequence(fullyNameMachine.importFrom, fullyNameMachine.importTo).toString(), fullyNameMachine.importFrom, fullyNameMachine.importTo, fullyNameMachine.packageTo);
                        fullyNameMachine.reset();
                    }
                    if (fullyNameMachine.state.equals((Object)FullyQualifiedNameState.CLASS)) {
                        nameMachine.reset();
                    }
                    if (!nameMachine.isFound()) continue block7;
                    importsBuilder.addException(content.subSequence(nameMachine.classNameFrom, nameMachine.classNameTo).toString());
                }
            }
        }
        importsBuilder.preBuild();
        StringBuilder stringBuilder = new StringBuilder(content.length() << 1);
        for (ImportCandidate importCandidate : importsBuilder.candidates()) {
            if (importCandidate.importTo != -1) {
                importsBuilder.addImport(importCandidate.preparedImport);
            }
            stringBuilder.append(content.subSequence(nextPartFrom, importCandidate.importFrom));
            nextPartFrom = importCandidate.packageTo;
        }
        String imports = importsBuilder.build();
        stringBuilder.append(content.subSequence(nextPartFrom, content.length())).insert(0, imports);
        if (!currentPackage.isEmpty()) {
            stringBuilder.insert(0, ";\n\n").insert(0, currentPackage).insert(0, "package ");
        }
        return stringBuilder.toString();
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphabetic(char c) {
        return $PostprocessingMachine.isLowerCaseAlphabetic(c) || $PostprocessingMachine.isUpperCaseAlphabetic(c);
    }

    private static boolean isLowerCaseAlphabetic(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isUpperCaseAlphabetic(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static final class ImportCandidate
    implements Comparable<ImportCandidate> {
        final int importFrom;
        final int importTo;
        final int packageTo;
        String preparedImport;
        String simpleName;

        private ImportCandidate(int importFrom, int importTo, int packageTo, String preparedImport, String simpleName) {
            this.importFrom = importFrom;
            this.importTo = importTo;
            this.packageTo = packageTo;
            this.preparedImport = preparedImport;
            this.simpleName = simpleName;
        }

        @Override
        public int compareTo(ImportCandidate other) {
            return this.importFrom - other.importFrom;
        }
    }

    static enum ClassNameState {
        UNDEFINED,
        IDLE,
        CLASS_NAME;

    }

    static final class ClassNameMachine {
        ClassNameState state = ClassNameState.UNDEFINED;
        int classNameFrom = -1;
        int classNameTo = -1;

        ClassNameMachine() {
        }

        boolean isFound() {
            return this.classNameFrom != -1 && this.classNameTo != -1;
        }

        void reset() {
            this.state = ClassNameState.UNDEFINED;
            this.classNameFrom = -1;
            this.classNameTo = -1;
        }

        void nextChar(char c, int i) {
            this.nextChar(c, i, false);
        }

        void nextChar(char c, int i, boolean noIdle) {
            switch (this.state) {
                case UNDEFINED: {
                    if ($PostprocessingMachine.isUpperCaseAlphabetic(c)) {
                        this.state = ClassNameState.CLASS_NAME;
                        this.classNameFrom = i;
                        this.classNameTo = -1;
                        break;
                    }
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c)) {
                        if (noIdle) break;
                        this.state = ClassNameState.IDLE;
                        break;
                    }
                    this.classNameFrom = -1;
                    this.classNameTo = -1;
                    break;
                }
                case IDLE: {
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c) || c == '.') break;
                    this.state = ClassNameState.UNDEFINED;
                    break;
                }
                case CLASS_NAME: {
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c) || c == '_') break;
                    this.state = ClassNameState.UNDEFINED;
                    this.classNameTo = i;
                }
            }
        }
    }

    static enum CommentState {
        NOT_IN_COMMENT,
        COMMENT_CANDIDATE,
        STRING_LITERAL,
        LINE_COMMENT,
        BLOCK_COMMENT,
        BLOCK_COMMENT_OUT_CANDIDATE;

    }

    static final class CommentMachine {
        CommentState state = CommentState.NOT_IN_COMMENT;

        CommentMachine() {
        }

        void nextChar(char c) {
            switch (this.state) {
                case NOT_IN_COMMENT: {
                    if (c == '\"') {
                        this.state = CommentState.STRING_LITERAL;
                        break;
                    }
                    if (c != '/') break;
                    this.state = CommentState.COMMENT_CANDIDATE;
                    break;
                }
                case COMMENT_CANDIDATE: {
                    if (c == '/') {
                        this.state = CommentState.LINE_COMMENT;
                        break;
                    }
                    if (c != '*') break;
                    this.state = CommentState.BLOCK_COMMENT;
                    break;
                }
                case STRING_LITERAL: {
                    if (c != '\"') break;
                    this.state = CommentState.NOT_IN_COMMENT;
                    break;
                }
                case LINE_COMMENT: {
                    if (c != '\n') break;
                    this.state = CommentState.NOT_IN_COMMENT;
                    break;
                }
                case BLOCK_COMMENT: {
                    if (c != '*') break;
                    this.state = CommentState.BLOCK_COMMENT_OUT_CANDIDATE;
                    break;
                }
                case BLOCK_COMMENT_OUT_CANDIDATE: {
                    if (c == '/') {
                        this.state = CommentState.NOT_IN_COMMENT;
                        break;
                    }
                    if (c == '*') break;
                    this.state = CommentState.BLOCK_COMMENT;
                }
            }
        }

        boolean isInComment() {
            return CommentState.LINE_COMMENT.equals((Object)this.state) || CommentState.BLOCK_COMMENT.equals((Object)this.state) || CommentState.BLOCK_COMMENT_OUT_CANDIDATE.equals((Object)this.state) || CommentState.STRING_LITERAL.equals((Object)this.state);
        }
    }

    static enum FullyQualifiedNameState {
        UNDEFINED,
        IDLE,
        PACKAGE_PART_CANDIDATE,
        DOT,
        CLASS,
        FINISH;

    }

    static final class FullyQualifiedNameMachine {
        FullyQualifiedNameState state = FullyQualifiedNameState.UNDEFINED;
        int importFrom = -1;
        int importTo = -1;
        int packageTo = -1;

        FullyQualifiedNameMachine() {
        }

        void nextChar(char c, int i) {
            switch (this.state) {
                case UNDEFINED: {
                    if ($PostprocessingMachine.isLowerCaseAlphabetic(c)) {
                        this.state = FullyQualifiedNameState.PACKAGE_PART_CANDIDATE;
                        this.importFrom = i;
                        break;
                    }
                    if (!$PostprocessingMachine.isAlphabetic(c) && !$PostprocessingMachine.isDigit(c)) break;
                    this.state = FullyQualifiedNameState.IDLE;
                    break;
                }
                case IDLE: {
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c) || c == '.') break;
                    this.state = FullyQualifiedNameState.UNDEFINED;
                    break;
                }
                case PACKAGE_PART_CANDIDATE: {
                    if (c == '.') {
                        this.state = FullyQualifiedNameState.DOT;
                        break;
                    }
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c)) break;
                    this.reset();
                    break;
                }
                case DOT: {
                    if ($PostprocessingMachine.isLowerCaseAlphabetic(c)) {
                        this.state = FullyQualifiedNameState.PACKAGE_PART_CANDIDATE;
                        break;
                    }
                    if ($PostprocessingMachine.isUpperCaseAlphabetic(c)) {
                        this.state = FullyQualifiedNameState.CLASS;
                        break;
                    }
                    this.reset();
                    break;
                }
                case CLASS: {
                    if (this.packageTo == -1) {
                        this.packageTo = i - 1;
                    }
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c)) break;
                    this.state = FullyQualifiedNameState.FINISH;
                    this.importTo = i;
                    break;
                }
                case FINISH: {
                    this.reset();
                }
            }
        }

        boolean isFinished() {
            return FullyQualifiedNameState.FINISH.equals((Object)this.state);
        }

        void reset() {
            this.state = FullyQualifiedNameState.UNDEFINED;
            this.importFrom = -1;
            this.importTo = -1;
            this.packageTo = -1;
        }
    }

    private static enum ToImportStatement implements $Function<String, String>
    {
        FUNCTION;


        @Override
        public String apply(String input) {
            return "import " + input + ";\n";
        }
    }

    static final class ImportsBuilder {
        private static final String JAVA_LANG = "java.lang.";
        private final TreeSet<String> imports = $Sets.newTreeSet();
        private final HashMap<String, String> originalImports = $Maps.newHashMap();
        private $Optional<String> currentPackage = $Optional.absent();
        private final $Multimap<String, ImportCandidate> importCandidates = $HashMultimap.create();
        private final HashMap<String, String> nameToFully = $Maps.newHashMap();
        private final HashSet<String> exceptions = $Sets.newHashSet();
        private final HashSet<String> stopList = $Sets.newHashSet();

        ImportsBuilder() {
        }

        void addImportCandidate(String name, String fullyName, int importFrom, int importTo, int packageTo) {
            String foundFully = this.nameToFully.get(name);
            if (foundFully != null && !foundFully.equals(fullyName)) {
                return;
            }
            this.nameToFully.put(name, fullyName);
            if ((JAVA_LANG + name).equals(fullyName)) {
                this.importCandidates.put(fullyName, new ImportCandidate(importFrom, -1, packageTo, fullyName, name));
                return;
            }
            if (this.currentPackage.isPresent() && fullyName.startsWith(this.currentPackage.get())) {
                this.importCandidates.put(fullyName, new ImportCandidate(importFrom, -1, packageTo, fullyName, name));
                return;
            }
            this.importCandidates.put(fullyName, new ImportCandidate(importFrom, importTo, packageTo, fullyName, name));
        }

        void addImport(String importedPackage) {
            this.imports.add(importedPackage);
        }

        void addOriginalImport(String name, String fullyName, String importedPackage) {
            this.originalImports.put(name, fullyName);
            if ((JAVA_LANG + name).equals(fullyName)) {
                return;
            }
            if (this.currentPackage.isPresent() && fullyName.startsWith(this.currentPackage.get())) {
                return;
            }
            this.imports.add(importedPackage);
        }

        void addToStopList(String name) {
            this.stopList.add(name);
        }

        void addException(String name) {
            if (!this.stopList.contains(name)) {
                this.exceptions.add(name);
            }
        }

        void setCurrentPackage(String currentPackage) {
            this.currentPackage = $Optional.of(currentPackage);
        }

        void preBuild() {
            for (String string : this.exceptions) {
                this.importCandidates.removeAll(this.nameToFully.get(string));
            }
            for (Map.Entry entry : this.importCandidates.entries()) {
                ImportCandidate candidate = (ImportCandidate)entry.getValue();
                String originalFullyName = this.originalImports.get(candidate.simpleName);
                if (originalFullyName == null || originalFullyName.equals(candidate.preparedImport)) continue;
                this.importCandidates.remove(entry.getKey(), entry.getValue());
            }
        }

        String build() {
            return JOINER.join($Iterables.transform(this.imports, ToImportStatement.FUNCTION));
        }

        List<ImportCandidate> candidates() {
            return $Ordering.natural().sortedCopy(this.importCandidates.values());
        }
    }

    static final class FiniteStateMachine {
        private static final int NO_POSITION = -1;
        private static final int AT_POSSIBLE_WORD = -1;
        private static final int UNTRACKED_WORD = -2;
        private static final char[][] vocabulary = new char[][]{"package".toCharArray(), "import".toCharArray(), "class".toCharArray(), "interface".toCharArray(), "enum".toCharArray(), "@".toCharArray()};
        private static final State[] finalState = new State[]{State.PACKAGE, State.IMPORTS, State.CLASS, State.CLASS, State.CLASS, State.ANNOTATION};
        int wordIndex;
        int charIndex;

        FiniteStateMachine() {
            this.resetWord();
        }

        State nextChar(char c) {
            State newState = State.UNDEFINED;
            if (this.wordIndex == -2) {
                if (!this.isWordChar(c)) {
                    this.resetWord();
                }
            } else if (this.wordIndex == -1) {
                if (this.isWordChar(c)) {
                    for (int i = 0; i < vocabulary.length; ++i) {
                        if (c != vocabulary[i][0]) continue;
                        this.wordIndex = i;
                        this.charIndex = 0;
                        break;
                    }
                    if (this.wordIndex == -1) {
                        this.wordIndex = -2;
                    }
                }
            } else if (vocabulary[this.wordIndex].length == 1) {
                newState = finalState[this.wordIndex];
                this.resetWord();
            } else if (vocabulary[this.wordIndex][this.charIndex + 1] == c) {
                ++this.charIndex;
                if (vocabulary[this.wordIndex].length == this.charIndex + 1) {
                    newState = finalState[this.wordIndex];
                    this.resetWord();
                }
            } else {
                this.resetWord();
            }
            return newState;
        }

        private void resetWord() {
            this.wordIndex = -1;
            this.charIndex = -1;
        }

        private boolean isWordChar(char c) {
            return $PostprocessingMachine.isAlphabetic(c) || c == '@';
        }
    }

    static enum State {
        UNDEFINED,
        PACKAGE,
        IMPORTS,
        CLASS,
        ANNOTATION;


        State or(State state) {
            return this == UNDEFINED ? state : this;
        }
    }
}

