/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.immutables.value.internal.;
import org.immutables.value.internal.$generator$.$SourceOrdering;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.meta.$CachingElements;
import org.immutables.value.internal.$processor$.meta.$CheckMirror;
import org.immutables.value.internal.$processor$.meta.$DefaultMirror;
import org.immutables.value.internal.$processor$.meta.$DerivedMirror;
import org.immutables.value.internal.$processor$.meta.$LazyMirror;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;
import org.immutables.value.internal.$processor$.meta.$ValueType;

final class $AccessorAttributesCollector {
    private static final int USEFUL_PARAMETER_COUNT_LIMIT = 120;
    private static final String EQUALS_METHOD = "equals";
    private static final String TO_STRING_METHOD = "toString";
    private static final String HASH_CODE_METHOD = "hashCode";
    private final .processor..Proto.Protoclass protoclass;
    private final $ValueType type;
    private final ProcessingEnvironment processing;
    private final List<$ValueAttribute> attributes = $Lists.newArrayList();
    private final $Styles styles;
    private final $Reporter reporter;

    $AccessorAttributesCollector(.processor..Proto.Protoclass protoclass, $ValueType type) {
        this.protoclass = protoclass;
        this.processing = protoclass.processing();
        this.styles = protoclass.styles();
        this.type = type;
        this.reporter = protoclass.report();
    }

    void collect() {
        this.collectGeneratedCandidateMethods(this.getTypeElement());
        if (this.attributes.size() > 120) {
            ArrayList<$ValueAttribute> list = $Lists.newArrayListWithCapacity(120);
            list.addAll(this.attributes.subList(0, 120));
            this.attributes.clear();
            this.attributes.addAll(list);
            this.protoclass.report().error("Value objects with more than %d attributes (including inherited) are not supported. You can decompose '%s' class into a smaller ones", 120, this.protoclass.name());
        }
        for ($ValueAttribute attribute : this.attributes) {
            attribute.initAndValidate();
        }
        this.type.attributes.addAll(this.attributes);
    }

    private TypeElement getTypeElement() {
        return (TypeElement)this.type.element;
    }

    private void collectGeneratedCandidateMethods(TypeElement type) {
        for (Element element : this.getAccessorsInSourceOrder($CachingElements.getDelegate(type))) {
            if (!this.isElegibleAccessorMethod(element)) continue;
            this.processGenerationCandidateMethod((ExecutableElement)element);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(type.getEnclosedElements())) {
            switch (executableElement.getSimpleName().toString()) {
                case "equals": 
                case "hashCode": 
                case "toString": {
                    this.processGenerationCandidateMethod(executableElement);
                    break;
                }
            }
        }
    }

    private List<? extends Element> getAccessorsInSourceOrder(TypeElement type) {
        return type.getKind() == ElementKind.ANNOTATION_TYPE ? $SourceOrdering.getEnclosedElements(type) : $SourceOrdering.getAllAccessors(this.processing.getElementUtils(), this.processing.getTypeUtils(), type);
    }

    private boolean isElegibleAccessorMethod(Element element) {
        if (element.getKind() != ElementKind.METHOD) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        switch (element.getSimpleName().toString()) {
            case "hashCode": 
            case "toString": {
                return false;
            }
        }
        String definitionType = element.getEnclosingElement().toString();
        if (definitionType.equals(Object.class.getName())) {
            return false;
        }
        return !definitionType.startsWith("org.immutables.ordinal.OrdinalValue");
    }

    private void processGenerationCandidateMethod(ExecutableElement attributeMethodCandidate) {
        Name name = attributeMethodCandidate.getSimpleName();
        List<? extends VariableElement> parameters = attributeMethodCandidate.getParameters();
        if (name.contentEquals(EQUALS_METHOD) && parameters.size() == 1 && parameters.get(0).asType().toString().equals(Object.class.getName()) && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.type.isEqualToDefined = true;
            return;
        }
        if (name.contentEquals(HASH_CODE_METHOD) && parameters.isEmpty() && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.type.isHashCodeDefined = true;
            return;
        }
        if (name.contentEquals(TO_STRING_METHOD) && parameters.isEmpty() && !attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.type.isToStringDefined = true;
            return;
        }
        if ($CheckMirror.isPresent(attributeMethodCandidate)) {
            if (!(attributeMethodCandidate.getReturnType().getKind() != TypeKind.VOID || !attributeMethodCandidate.getParameters().isEmpty() || attributeMethodCandidate.getModifiers().contains((Object)Modifier.PRIVATE) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.STATIC) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.NATIVE))) {
                this.type.validationMethodName = attributeMethodCandidate.getSimpleName().toString();
            } else {
                this.report(attributeMethodCandidate).error("Method '%s' annotated with @%s must be non-private parameter-less method and have void return type.", attributeMethodCandidate.getSimpleName(), $CheckMirror.simpleName());
            }
        }
        if ($AccessorAttributesCollector.isDiscoveredAttribute(attributeMethodCandidate)) {
            TypeMirror returnType = this.resolveReturnType(attributeMethodCandidate);
            $ValueAttribute attribute = new $ValueAttribute();
            boolean isFinal = $AccessorAttributesCollector.isFinal(attributeMethodCandidate);
            boolean isAbstract = $AccessorAttributesCollector.isAbstract(attributeMethodCandidate);
            boolean defaultAnnotationPresent = $DefaultMirror.isPresent(attributeMethodCandidate);
            boolean derivedAnnotationPresent = $DerivedMirror.isPresent(attributeMethodCandidate);
            if (isAbstract) {
                attribute.isGenerateAbstract = true;
                if (attributeMethodCandidate.getDefaultValue() != null) {
                    attribute.isGenerateDefault = true;
                } else if (defaultAnnotationPresent) {
                    this.report(attributeMethodCandidate).annotationNamed($DefaultMirror.simpleName()).error("@Value.Default should have initializer body", name);
                } else if (derivedAnnotationPresent) {
                    this.report(attributeMethodCandidate).annotationNamed($DerivedMirror.simpleName()).error("@Value.Derived should have initializer body", name);
                }
            } else if (defaultAnnotationPresent && derivedAnnotationPresent) {
                this.report(attributeMethodCandidate).annotationNamed($DerivedMirror.simpleName()).error("Attribute '%s' cannot be both @Value.Default and @Value.Derived", name);
                attribute.isGenerateDefault = true;
                attribute.isGenerateDerived = false;
            } else if ((defaultAnnotationPresent || derivedAnnotationPresent) && isFinal) {
                this.report(attributeMethodCandidate).error("Annotated attribute '%s' will be overriden and cannot be final", name);
            } else if (defaultAnnotationPresent) {
                attribute.isGenerateDefault = true;
            } else if (derivedAnnotationPresent) {
                attribute.isGenerateDerived = true;
            }
            if ($LazyMirror.isPresent(attributeMethodCandidate)) {
                if (isAbstract || isFinal) {
                    this.report(attributeMethodCandidate).error("@Value.Lazy attribute '%s' must be non abstract and non-final", name);
                } else if (defaultAnnotationPresent || derivedAnnotationPresent) {
                    this.report(attributeMethodCandidate).error("@Value.Lazy attribute '%s' cannot be @Value.Derived or @Value.Default", name);
                } else {
                    attribute.isGenerateLazy = true;
                }
            }
            attribute.reporter = this.reporter;
            attribute.returnTypeName = this.computeReturnTypeString(returnType);
            attribute.returnType = returnType;
            attribute.names = this.styles.forAccessor(name.toString());
            attribute.element = attributeMethodCandidate;
            attribute.containingType = this.type;
            this.attributes.add(attribute);
        }
    }

    private TypeMirror resolveReturnType(ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        if (returnType.getKind() == TypeKind.TYPEVAR) {
            TypeElement typeElement = this.getTypeElement();
            ExecutableType asMethodOfType = (ExecutableType)this.processing.getTypeUtils().asMemberOf((DeclaredType)typeElement.asType(), method);
            return asMethodOfType.getReturnType();
        }
        return returnType;
    }

    private String computeReturnTypeString(TypeMirror returnType) {
        String returnTypeString = returnType.toString();
        if (returnTypeString.startsWith("(")) {
            int index = returnTypeString.indexOf(" :: ");
            String typeAnnotations = returnTypeString.substring(1, index);
            String type = returnTypeString.substring(index + 4, returnTypeString.length() - 1);
            return typeAnnotations.replace(',', ' ') + ' ' + type;
        }
        return returnType.toString();
    }

    private static boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isDiscoveredAttribute(ExecutableElement attributeMethodCandidate) {
        return attributeMethodCandidate.getParameters().isEmpty() && attributeMethodCandidate.getReturnType().getKind() != TypeKind.VOID && ($AccessorAttributesCollector.isAbstract(attributeMethodCandidate) || $AccessorAttributesCollector.hasGenerateAnnotation(attributeMethodCandidate));
    }

    private static boolean hasGenerateAnnotation(ExecutableElement attributeMethodCandidate) {
        return $DefaultMirror.isPresent(attributeMethodCandidate) || $DerivedMirror.isPresent(attributeMethodCandidate) || $LazyMirror.isPresent(attributeMethodCandidate);
    }

    private $Reporter report(Element type) {
        return $Reporter.from(this.protoclass.processing()).withElement(type);
    }
}

