/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableMultimap;
import org.immutables.value.internal.$guava$.collect.$Interner;
import org.immutables.value.internal.$guava$.collect.$Interners;
import org.immutables.value.internal.$guava$.collect.$Maps;
import org.immutables.value.internal.$guava$.collect.$Multimap;
import org.immutables.value.internal.$guava$.collect.$Sets;
import org.immutables.value.internal.$processor$.meta.$ImmutableProto;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$ValueType;
import org.immutables.value.internal.$processor$.meta.$ValueTypeComposer;
import org.immutables.value.internal.$processor$.meta.$ValueUmbrellaMirror;

public abstract class $Round {
    public abstract ProcessingEnvironment processing();

    public abstract RoundEnvironment round();

    public abstract Set<TypeElement> annotations();

    public $Interner<$Proto.Protoclass> protoclassInterner() {
        return $Interners.newStrongInterner();
    }

    public $Interner<$Proto.DeclaringPackage> packageInterner() {
        return $Interners.newStrongInterner();
    }

    public $Interner<$Proto.DeclaringType> typeInterner() {
        return $Interners.newStrongInterner();
    }

    $ValueTypeComposer composer() {
        return new $ValueTypeComposer(this);
    }

    $Proto.Environment environment() {
        return $ImmutableProto.Environment.of(this.processing(), this);
    }

    public $Multimap<$Proto.DeclaringPackage, $ValueType> collectValues() {
        $ImmutableList<$Proto.Protoclass> protoclasses = this.collectProtoclasses();
        HashMap<$Proto.DeclaringType, $ValueType> enclosingTypes = $Maps.newHashMap();
        $ImmutableMultimap.Builder<$Proto.DeclaringPackage, $ValueType> builder = $ImmutableMultimap.builder();
        for ($Proto.Protoclass protoclass : protoclasses) {
            if (!protoclass.kind().isEnclosing()) continue;
            $ValueType type = this.composer().compose(protoclass);
            enclosingTypes.put(protoclass.declaringType().get(), type);
        }
        for ($Proto.Protoclass protoclass : protoclasses) {
            $ValueType enclosing;
            $ValueType current = null;
            if (protoclass.kind().isNested() && (enclosing = ($ValueType)enclosingTypes.get(protoclass.enclosingOf().get())) != null) {
                current = this.composer().compose(protoclass);
                enclosing.addNested(current);
            }
            if (current == null && protoclass.kind().isEnclosing()) {
                current = ($ValueType)enclosingTypes.get(protoclass.declaringType().get());
            }
            if (current == null) {
                current = this.composer().compose(protoclass);
            }
            builder.put(protoclass.packageOf(), current);
        }
        return builder.build();
    }

    public $Optional<$Proto.Protoclass> definedValueProtoclassFor(TypeElement element) {
        ProtoclassCollecter collecter = new ProtoclassCollecter();
        collecter.collect(element);
        for ($Proto.Protoclass protoclass : collecter.builder.build()) {
            if (!protoclass.kind().isDefinedValue()) continue;
            return $Optional.of(protoclass);
        }
        return $Optional.absent();
    }

    public $ImmutableList<$Proto.Protoclass> collectProtoclasses() {
        ProtoclassCollecter collecter = new ProtoclassCollecter();
        for (Element element : this.allAnnotatedElements()) {
            collecter.collect(element);
        }
        return collecter.builder.build();
    }

    private Set<Element> allAnnotatedElements() {
        HashSet<Element> elements = $Sets.newHashSetWithExpectedSize(100);
        for (TypeElement annotation : this.annotations()) {
            Set<? extends Element> annotatedElements = this.round().getElementsAnnotatedWith(annotation);
            this.checkAnnotation(annotation, annotatedElements);
            elements.addAll(annotatedElements);
        }
        return elements;
    }

    private void checkAnnotation(TypeElement annotation, Set<? extends Element> annotatedElements) {
        if (annotation.getQualifiedName().contentEquals($ValueUmbrellaMirror.qualifiedName())) {
            for (Element element : annotatedElements) {
                $Reporter.from(this.processing()).withElement(element).annotationNamed($ValueUmbrellaMirror.simpleName()).warning("@Value annotation have no effect, use nested annotations instead, like @Value.Immutable", new Object[0]);
            }
        }
    }

    private class ProtoclassCollecter {
        final $ImmutableList.Builder<$Proto.Protoclass> builder = $ImmutableList.builder();

        private ProtoclassCollecter() {
        }

        void collect(Element element) {
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case INTERFACE: 
                case CLASS: 
                case ENUM: {
                    this.collectIncludedAndDefinedBy((TypeElement)element);
                    break;
                }
                case METHOD: {
                    this.collectDefinedBy((ExecutableElement)element);
                    break;
                }
                case PACKAGE: {
                    this.collectIncludedBy((PackageElement)element);
                    break;
                }
                default: {
                    $Reporter.from($Round.this.processing()).withElement(element).warning("Unmatched annotation will be skipped for annotation processing", new Object[0]);
                }
            }
        }

        void collectDefinedBy(ExecutableElement element) {
            $Proto.DeclaringType declaringType = $Round.this.typeInterner().intern($ImmutableProto.DeclaringType.builder().environment($Round.this.environment()).element((TypeElement)element.getEnclosingElement()).build());
            if (declaringType.verifiedFactory(element)) {
                this.builder.add((Object)$Round.this.protoclassInterner().intern($ImmutableProto.Protoclass.builder().environment($Round.this.environment()).packageOf(declaringType.packageOf()).sourceElement(element).declaringType(declaringType).kind($Proto.Protoclass.Kind.DEFINED_FACTORY).build()));
            }
        }

        void collectIncludedBy(PackageElement element) {
            $Proto.DeclaringPackage declaringPackage = $Round.this.packageInterner().intern($ImmutableProto.DeclaringPackage.builder().environment($Round.this.environment()).element(element).build());
            if (declaringPackage.hasInclude()) {
                for (TypeElement sourceElement : declaringPackage.includedTypes()) {
                    this.builder.add((Object)$Round.this.protoclassInterner().intern($ImmutableProto.Protoclass.builder().environment($Round.this.environment()).packageOf(declaringPackage).sourceElement(sourceElement).kind($Proto.Protoclass.Kind.INCLUDED_IN_PACKAGE).build()));
                }
            }
        }

        void collectIncludedAndDefinedBy(TypeElement element) {
            $Proto.Protoclass.Kind kind;
            $Proto.DeclaringType declaringType = $Round.this.typeInterner().intern($ImmutableProto.DeclaringType.builder().environment($Round.this.environment()).element(element).build());
            if (declaringType.hasInclude()) {
                kind = declaringType.isEnclosing() ? $Proto.Protoclass.Kind.INCLUDED_IN_TYPE : $Proto.Protoclass.Kind.INCLUDED_ON_TYPE;
                for (TypeElement sourceElement : declaringType.includedTypes()) {
                    this.builder.add((Object)$Round.this.protoclassInterner().intern($ImmutableProto.Protoclass.builder().environment($Round.this.environment()).packageOf(declaringType.packageOf()).sourceElement(sourceElement).declaringType(declaringType).kind(kind).build()));
                }
            }
            if (declaringType.isImmutable() || declaringType.isEnclosing()) {
                kind = this.kindOfDefinedBy(declaringType);
                this.builder.add((Object)$Round.this.protoclassInterner().intern($ImmutableProto.Protoclass.builder().environment($Round.this.environment()).packageOf(declaringType.packageOf()).sourceElement(element).declaringType(declaringType).kind(kind).build()));
            }
        }

        private $Proto.Protoclass.Kind kindOfDefinedBy($Proto.DeclaringType declaringType) {
            if (declaringType.isImmutable()) {
                if (declaringType.isEnclosing()) {
                    return $Proto.Protoclass.Kind.DEFINED_AND_ENCLOSING_TYPE;
                }
                if (declaringType.enclosingOf().isPresent()) {
                    return $Proto.Protoclass.Kind.DEFINED_NESTED_TYPE;
                }
                return $Proto.Protoclass.Kind.DEFINED_TYPE;
            }
            assert (declaringType.isEnclosing());
            return $Proto.Protoclass.Kind.DEFINED_ENCLOSING_TYPE;
        }
    }
}

