/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$processor$.meta.$AnnotationPrinting;
import org.immutables.value.internal.$processor$.meta.$AttributeTypeKind;
import org.immutables.value.internal.$processor$.meta.$AuxiliaryMirror;
import org.immutables.value.internal.$processor$.meta.$DefaultMirror;
import org.immutables.value.internal.$processor$.meta.$ExpectedSubtypesMirror;
import org.immutables.value.internal.$processor$.meta.$FParameterMirror;
import org.immutables.value.internal.$processor$.meta.$IdMirror;
import org.immutables.value.internal.$processor$.meta.$IgnoreMirror;
import org.immutables.value.internal.$processor$.meta.$ImmutableNullabilityAnnotationInfo;
import org.immutables.value.internal.$processor$.meta.$JsonPropertyMirror;
import org.immutables.value.internal.$processor$.meta.$NamedMirror;
import org.immutables.value.internal.$processor$.meta.$NaturalOrderMirror;
import org.immutables.value.internal.$processor$.meta.$ParameterMirror;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$ReverseOrderMirror;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$SwitchMirror;
import org.immutables.value.internal.$processor$.meta.$SwitcherModel;
import org.immutables.value.internal.$processor$.meta.$TypeIntrospectionBase;
import org.immutables.value.internal.$processor$.meta.$TypeStringProvider;
import org.immutables.value.internal.$processor$.meta.$UnshadeGuava;
import org.immutables.value.internal.$processor$.meta.$ValueType;

public final class $ValueAttribute
extends $TypeIntrospectionBase {
    private static final String GUAVA_IMMUTABLE_PREFIX = $UnshadeGuava.typeString("collect.Immutable");
    private static final String NULLABLE_SIMPLE_NAME = "Nullable";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private static final String ID_ATTRIBUTE_NAME = "_id";
    public $Styles.UsingName.AttributeNames names;
    public boolean isGenerateDefault;
    public boolean isGenerateDerived;
    public boolean isGenerateAbstract;
    public boolean isGenerateLazy;
    public $ImmutableList<String> typeParameters = $ImmutableList.of();
    public $Reporter reporter;
    public $ValueType containingType;
    TypeMirror returnType;
    Element element;
    String returnTypeName;
    private boolean hasEnumFirstTypeParameter;
    @Nullable
    private TypeElement containedTypeElement;
    @Nullable
    private TypeElement containedSecondaryTypeElement;
    private boolean generateOrdinalValueSet;
    private TypeMirror arrayComponent;
    @Nullable
    private NullabilityAnnotationInfo nullability;
    @Nullable
    private String rawTypeName;
    @Nullable
    private String serializedName;
    private OrderKind orderKind = OrderKind.NONE;
    @Nullable
    private CharSequence defaultInterface;
    @Nullable
    private List<String> expectedSubtypes;
    private int constructorOrder = Integer.MIN_VALUE;
    private $AttributeTypeKind typeKind;
    @Nullable
    public $SwitcherModel builderSwitcherModel;
    public boolean isBuilderParameter;
    boolean hasSomeUnresolvedTypes;

    public String name() {
        return this.names.raw;
    }

    public boolean isBoolean() {
        return this.returnType.getKind() == TypeKind.BOOLEAN;
    }

    public boolean isInt() {
        return this.returnType.getKind() == TypeKind.INT;
    }

    public boolean isLong() {
        return this.returnType.getKind() == TypeKind.LONG;
    }

    public boolean isStringType() {
        return this.returnTypeName.equals(String.class.getName());
    }

    public boolean charType() {
        return this.returnType.getKind() == TypeKind.CHAR;
    }

    public String atNullability() {
        return this.isNullable() ? this.nullability.asPrefix() : "";
    }

    public String atNullabilityLocal() {
        return this.isNullable() ? this.nullability.asLocalPrefix() : "";
    }

    public boolean isSimpleLiteralType() {
        return this.isPrimitive() || this.isStringType() || this.isEnumType();
    }

    public boolean requiresAlternativeStrictConstructor() {
        return this.typeKind.isCollectionKind() || this.typeKind.isMappingKind() && !this.typeKind.isPlainMapKind() && !this.typeKind.isMultimap();
    }

    public boolean isMandatory() {
        return this.isGenerateAbstract && !this.isGenerateDefault && !this.isContainerType() && !this.isNullable() && !this.hasBuilderSwitcherDefault();
    }

    public boolean isNullable() {
        return this.nullability != null;
    }

    @Override
    public boolean isComparable() {
        return this.isNumberType() || this.isStringType() || super.isComparable();
    }

    public String getSerializedName() {
        if (this.serializedName == null) {
            this.serializedName = this.readSerializedName();
        }
        return this.serializedName;
    }

    public String getMarshaledName() {
        String serializedName = this.getSerializedName();
        if (!serializedName.isEmpty()) {
            return serializedName;
        }
        return this.name();
    }

    private String readSerializedName() {
        String value;
        String value2;
        $Optional<$NamedMirror> namedAnnotation = $NamedMirror.find(this.element);
        if (namedAnnotation.isPresent() && !(value2 = namedAnnotation.get().value()).isEmpty()) {
            return value2;
        }
        $Optional<$JsonPropertyMirror> jsonProperty = $JsonPropertyMirror.find(this.element);
        if (jsonProperty.isPresent() && !(value = jsonProperty.get().value()).isEmpty()) {
            return value;
        }
        if (this.isMarkedAsMongoId()) {
            return ID_ATTRIBUTE_NAME;
        }
        return "";
    }

    public boolean isForcedEmpty() {
        return !this.containingType.gsonTypeAdapters().emptyAsNulls();
    }

    @Override
    protected TypeMirror internalTypeMirror() {
        return this.returnType;
    }

    public String getType() {
        return this.returnTypeName;
    }

    public List<CharSequence> getAnnotations() {
        return $AnnotationPrinting.getAnnotationLines(this.element);
    }

    public boolean isGsonIgnore() {
        return $IgnoreMirror.isPresent(this.element);
    }

    public List<String> typeParameters() {
        this.ensureTypeIntrospected();
        return this.arrayComponent != null ? $ImmutableList.of(this.arrayComponent.toString()) : this.typeParameters;
    }

    public boolean isMapType() {
        return this.typeKind.isMappingKind();
    }

    public boolean isMultimapType() {
        return this.typeKind.isMultimapKind();
    }

    public boolean isListType() {
        return this.typeKind.isList();
    }

    public boolean isSetType() {
        return this.typeKind.isSet();
    }

    public boolean hasNaturalOrder() {
        return this.orderKind == OrderKind.NATURAL;
    }

    public boolean hasReverseOrder() {
        return this.orderKind == OrderKind.REVERSE;
    }

    public boolean isSortedSetType() {
        return this.typeKind.isSortedSet();
    }

    public boolean isSortedMapType() {
        return this.typeKind.isSortedMap();
    }

    public boolean isGenerateSortedSet() {
        return this.typeKind.isSortedSet();
    }

    public boolean isGenerateSortedMap() {
        return this.typeKind.isSortedMap();
    }

    private void checkOrderAnnotations() {
        $Optional<$NaturalOrderMirror> naturalOrderAnnotation = $NaturalOrderMirror.find(this.element);
        $Optional<$ReverseOrderMirror> reverseOrderAnnotation = $ReverseOrderMirror.find(this.element);
        if (naturalOrderAnnotation.isPresent() && reverseOrderAnnotation.isPresent()) {
            this.report().error("@Value.Natural and @Value.Reverse annotations could not be used on the same attribute", new Object[0]);
        } else if (naturalOrderAnnotation.isPresent()) {
            if (this.typeKind.isSortedKind()) {
                if (this.isComparable()) {
                    this.orderKind = OrderKind.NATURAL;
                } else {
                    this.report().annotationNamed($NaturalOrderMirror.simpleName()).error("@Value.Natural should used on a set of Comparable elements (map keys)", new Object[0]);
                }
            } else {
                this.report().annotationNamed($NaturalOrderMirror.simpleName()).error("@Value.Natural should specify order for SortedSet, SortedMap, NavigableSet or NavigableMap attributes", new Object[0]);
            }
        } else if (reverseOrderAnnotation.isPresent()) {
            if (this.typeKind.isSortedKind()) {
                if (this.isComparable()) {
                    this.orderKind = OrderKind.REVERSE;
                } else {
                    this.report().annotationNamed($ReverseOrderMirror.simpleName()).error("@Value.Reverse should used with a set of Comparable elements", new Object[0]);
                }
            } else {
                this.report().annotationNamed($ReverseOrderMirror.simpleName()).error("@Value.Reverse should specify order for SortedSet, SortedMap, NavigableSet or NavigableMap attributes", new Object[0]);
            }
        }
    }

    public boolean isJdkOptional() {
        return this.typeKind.isOptionalKind() && this.typeKind.isJdkOnlyContainerKind();
    }

    public boolean isJdkSpecializedOptional() {
        return this.typeKind.isOptionalSpecializedJdk();
    }

    public boolean isOptionalType() {
        return this.typeKind.isOptionalKind();
    }

    public boolean isCollectionType() {
        return this.typeKind.isCollectionKind();
    }

    public boolean isGenerateEnumSet() {
        return this.typeKind.isEnumSet();
    }

    public boolean isGuavaImmutableDeclared() {
        return this.typeKind.isContainerKind() && this.rawTypeName.startsWith(GUAVA_IMMUTABLE_PREFIX);
    }

    public CharSequence defaultInterface() {
        if (this.defaultInterface == null) {
            this.defaultInterface = this.inferDefaultInterface();
        }
        return this.defaultInterface;
    }

    private CharSequence inferDefaultInterface() {
        if (this.element.getEnclosingElement().getKind() == ElementKind.INTERFACE && !this.element.getModifiers().contains((Object)Modifier.ABSTRACT) && this.containingType.element.getKind() == ElementKind.INTERFACE) {
            return this.containingType.typeAbstract().relative();
        }
        return "";
    }

    public boolean isGenerateEnumMap() {
        return this.typeKind.isEnumMap();
    }

    public String getUnwrappedElementType() {
        return this.isContainerType() ? $ValueAttribute.unwrapType(this.containmentTypeName()) : this.getElementType();
    }

    public String getWrappedElementType() {
        return $ValueAttribute.wrapType(this.containmentTypeName());
    }

    private String containmentTypeName() {
        return this.isArrayType() || this.isContainerType() ? this.firstTypeParameter() : this.returnTypeName;
    }

    public String getRawType() {
        return this.rawTypeName;
    }

    public String getConsumedElementType() {
        return this.isUnwrappedElementPrimitiveType() || String.class.getName().equals(this.containmentTypeName()) || this.hasEnumFirstTypeParameter ? this.getWrappedElementType() : "? extends " + this.getWrappedElementType();
    }

    private String extractRawType(String className) {
        int endOfTypeAnnotations;
        String rawType = className;
        int indexOfGenerics = rawType.indexOf(60);
        if (indexOfGenerics > 0) {
            rawType = rawType.substring(0, indexOfGenerics);
        }
        if ((endOfTypeAnnotations = rawType.lastIndexOf(32)) > 0) {
            rawType = rawType.substring(endOfTypeAnnotations + 1);
        }
        return rawType;
    }

    public boolean isUnwrappedElementPrimitiveType() {
        return $ValueAttribute.isPrimitiveType(this.getUnwrappedElementType());
    }

    public boolean isUnwrappedSecondaryElementPrimitiveType() {
        return $ValueAttribute.isPrimitiveType(this.getUnwrappedSecondaryElementType());
    }

    public String firstTypeParameter() {
        return $Iterables.getFirst(this.typeParameters(), "");
    }

    public String secondTypeParameter() {
        return $Iterables.get(this.typeParameters(), 1);
    }

    public String getElementType() {
        return this.containmentTypeName();
    }

    public List<String> getExpectedSubtypes() {
        if (this.expectedSubtypes == null) {
            this.ensureTypeIntrospected();
            if (this.containedTypeElement != null || this.containedSecondaryTypeElement != null) {
                TypeElement supertypeElement = $MoreObjects.firstNonNull(this.containedSecondaryTypeElement, this.containedTypeElement);
                $Optional<$ExpectedSubtypesMirror> annotationOnAttribute = $ExpectedSubtypesMirror.find(this.element);
                if (annotationOnAttribute.isPresent()) {
                    this.expectedSubtypes = $ImmutableList.copyOf(annotationOnAttribute.get().valueName());
                    if (this.expectedSubtypes.isEmpty()) {
                        this.expectedSubtypes = this.tryFindSubtypes(supertypeElement);
                    }
                } else {
                    $Optional<$ExpectedSubtypesMirror> annotationOnType = $ExpectedSubtypesMirror.find(supertypeElement);
                    if (annotationOnType.isPresent()) {
                        this.expectedSubtypes = $ImmutableList.copyOf(annotationOnType.get().valueName());
                        if (this.expectedSubtypes.isEmpty()) {
                            this.expectedSubtypes = this.tryFindSubtypes(supertypeElement);
                        }
                    }
                }
            }
            if (this.expectedSubtypes == null) {
                this.expectedSubtypes = $ImmutableList.of();
            }
        }
        return this.expectedSubtypes;
    }

    private $ImmutableList<String> tryFindSubtypes(TypeElement supertypeElement) {
        $ValueType surroundingType = $MoreObjects.firstNonNull(this.containingType.enclosingValue, this.containingType);
        Set<$ValueType> subtypes = surroundingType.getCases().knownSubtypesOf(supertypeElement.getQualifiedName().toString());
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for ($ValueType valueType : subtypes) {
            builder.add(valueType.typeAbstract().toString());
        }
        return builder.build();
    }

    public boolean isGenerateJdkOnly() {
        return this.containingType.isGenerateJdkOnly() && !this.typeKind.isGuavaContainerKind() && !this.isGuavaImmutableDeclared();
    }

    public boolean isGenerateOrdinalValueSet() {
        if (!this.isSetType()) {
            return false;
        }
        this.ensureTypeIntrospected();
        return this.generateOrdinalValueSet;
    }

    public boolean isArrayType() {
        return this.typeKind.isArray();
    }

    @Override
    protected void introspectType() {
        TypeMirror typeMirror = this.returnType;
        if (this.typeKind.isOptionalSpecializedJdk()) {
            this.typeParameters = $ImmutableList.of(this.optionalSpecializedType());
            return;
        }
        if (this.isContainerType()) {
            DeclaredType declaredType;
            List<? extends TypeMirror> typeArguments;
            if (!(typeMirror.getKind() != TypeKind.DECLARED && typeMirror.getKind() != TypeKind.ERROR || (typeArguments = (declaredType = (DeclaredType)typeMirror).getTypeArguments()).isEmpty())) {
                TypeMirror typeSecondArgument;
                final TypeMirror typeArgument = typeArguments.get(0);
                $TypeIntrospectionBase firstTypeParameterIntrospection = new $TypeIntrospectionBase(){

                    @Override
                    protected TypeMirror internalTypeMirror() {
                        return typeArgument;
                    }
                };
                if (this.isSetType()) {
                    this.generateOrdinalValueSet = firstTypeParameterIntrospection.isOrdinalValue();
                }
                if (this.isSetType() || this.isMapType()) {
                    this.hasEnumFirstTypeParameter = firstTypeParameterIntrospection.isEnumType();
                }
                if (this.isMapType() && (typeSecondArgument = typeArguments.get(1)).getKind() == TypeKind.DECLARED) {
                    TypeElement typeElement;
                    this.containedSecondaryTypeElement = typeElement = (TypeElement)((DeclaredType)typeSecondArgument).asElement();
                }
                typeMirror = typeArgument;
            }
        } else if (this.isArrayType()) {
            typeMirror = this.arrayComponent = ((ArrayType)typeMirror).getComponentType();
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            TypeElement typeElement;
            this.containedTypeElement = typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
        }
        this.intospectTypeMirror(typeMirror);
    }

    private String optionalSpecializedType() {
        switch (this.typeKind) {
            case OPTIONAL_INT_JDK: {
                return Integer.TYPE.getName();
            }
            case OPTIONAL_LONG_JDK: {
                return Long.TYPE.getName();
            }
            case OPTIONAL_DOUBLE_JDK: {
                return Double.TYPE.getName();
            }
        }
        throw new AssertionError();
    }

    public $AttributeTypeKind typeKind() {
        return this.typeKind;
    }

    private static boolean isRegularMarshalableType(String name, boolean couldBeWrapped) {
        return String.class.getName().equals(name) || (couldBeWrapped ? $ValueAttribute.isPrimitiveOrWrapped(name) : $ValueAttribute.isPrimitiveType(name));
    }

    public boolean isRequiresMarshalingAdapter() {
        return !$ValueAttribute.isRegularMarshalableType(this.getElementType(), this.isContainerType());
    }

    public boolean isRequiresMarshalingSecondaryAdapter() {
        return this.isMapType() && !$ValueAttribute.isRegularMarshalableType(this.getSecondaryElementType(), true);
    }

    public boolean wrapArrayToIterable() {
        return this.containingType.isGenerateJdkOnly() || this.isUnwrappedElementPrimitiveType() || !this.typeKind.isList() && !this.typeKind.isSet() && !this.typeKind.isMultiset();
    }

    public String getRawCollectionType() {
        return this.typeKind.rawSimpleName();
    }

    public boolean isMultisetType() {
        return this.typeKind.isMultiset();
    }

    public String getRawMapType() {
        return this.typeKind.rawSimpleName();
    }

    public String getSecondaryElementType() {
        return this.secondTypeParameter();
    }

    public String getUnwrappedSecondaryElementType() {
        return $ValueAttribute.unwrapType(this.secondTypeParameter());
    }

    public String getWrappedSecondaryElementType() {
        return $ValueAttribute.wrapType(this.secondTypeParameter());
    }

    public String getUnwrapperOrRawSecondaryElementType() {
        return this.extractRawType(this.getWrappedSecondaryElementType());
    }

    public String getUnwrapperOrRawElementType() {
        return this.extractRawType(this.getWrappedElementType());
    }

    public boolean isNumberType() {
        TypeKind kind = this.returnType.getKind();
        return kind.isPrimitive() && kind != TypeKind.CHAR && kind != TypeKind.BOOLEAN;
    }

    public boolean isFloatType() {
        return this.isFloat() || this.isDouble();
    }

    public boolean isFloat() {
        return this.returnType.getKind() == TypeKind.FLOAT;
    }

    public boolean isDouble() {
        return this.returnType.getKind() == TypeKind.DOUBLE;
    }

    public boolean isNonRawElemementType() {
        return this.getElementType().indexOf(60) > 0;
    }

    public boolean isContainerType() {
        return this.isCollectionType() || this.isOptionalType() || this.isMapType();
    }

    public String getWrapperType() {
        return this.isPrimitive() ? $ValueAttribute.wrapType(this.rawTypeName) : this.returnTypeName;
    }

    public boolean isPrimitive() {
        return this.returnType.getKind().isPrimitive();
    }

    int getConstructorParameterOrder() {
        if (this.constructorOrder < -1) {
            $Optional<$ParameterMirror> parameter = $ParameterMirror.find(this.element);
            int n = this.constructorOrder = parameter.isPresent() ? parameter.get().order() : -1;
            if (this.containingType.isAnnotationType() && this.names.get.equals(VALUE_ATTRIBUTE_NAME)) {
                this.constructorOrder = this.thereNoOtherMandatoryAttributes() ? 0 : -1;
            }
        }
        return this.constructorOrder;
    }

    private boolean thereNoOtherMandatoryAttributes() {
        List<$ValueAttribute> mandatories = this.containingType.getMandatoryAttributes();
        for ($ValueAttribute m : mandatories) {
            if (m == this) continue;
            return false;
        }
        return true;
    }

    public boolean isConstructorParameter() {
        return this.getConstructorParameterOrder() >= 0;
    }

    public boolean isPrimitiveElement() {
        return $ValueAttribute.isPrimitiveType(this.getUnwrappedElementType());
    }

    public boolean isAuxiliary() {
        return $AuxiliaryMirror.isPresent(this.element);
    }

    private boolean isMarkedAsMongoId() {
        return $IdMirror.isPresent(this.element);
    }

    boolean isIdAttribute() {
        return this.isMarkedAsMongoId() || ID_ATTRIBUTE_NAME.equals(this.getSerializedName());
    }

    void initAndValidate() {
        this.initTypeName();
        this.initTypeKind();
        this.initOrderKind();
        this.initFactoryParamsIfApplicable();
        this.makeRegularAndNullableWithValidation();
        this.makeRegularIfContainsWildcards();
        this.makeRegularIfDefaultWithValidation();
        this.prohibitAuxiliaryOnAnnotationTypes();
    }

    private void initOrderKind() {
        if (this.typeKind.isSortedKind()) {
            this.checkOrderAnnotations();
            if (this.orderKind == OrderKind.NONE) {
                this.typeKind = $AttributeTypeKind.REGULAR;
            }
        }
    }

    private void prohibitAuxiliaryOnAnnotationTypes() {
        if (this.containingType.isAnnotationType() && this.isAuxiliary()) {
            this.report().annotationNamed($AuxiliaryMirror.simpleName()).error("@Value.Auxiliary cannot be used on annotation attribute to not violate annotation spec", new Object[0]);
        }
    }

    private void initTypeName() {
        $TypeStringProvider provider = new $TypeStringProvider(this.returnType, this.containingType.constitution.protoclass(), this.element);
        provider.process();
        this.hasSomeUnresolvedTypes = provider.hasSomeUnresovedTypes();
        this.rawTypeName = provider.rawTypeName();
        this.returnTypeName = provider.returnTypeName();
        this.typeParameters = provider.typeParameters();
    }

    private void initTypeKind() {
        if (this.returnType.getKind() == TypeKind.ARRAY) {
            this.typeKind = $AttributeTypeKind.ARRAY;
            this.ensureTypeIntrospected();
        } else {
            this.typeKind = $AttributeTypeKind.forRawType(this.rawTypeName);
            this.ensureTypeIntrospected();
            this.typeKind = this.typeKind.havingEnumFirstTypeParameter(this.hasEnumFirstTypeParameter);
        }
    }

    private void makeRegularIfDefaultWithValidation() {
        if (this.isGenerateDefault && this.isContainerType()) {
            this.typeKind = $AttributeTypeKind.REGULAR;
            this.report().annotationNamed($DefaultMirror.simpleName()).warning("@Value.Default on a container attribute make it lose it's special treatment", new Object[0]);
        }
    }

    private void makeRegularIfContainsWildcards() {
        if (this.returnTypeName.indexOf(63) >= 0 && this.typeKind != $AttributeTypeKind.ARRAY) {
            this.typeKind = $AttributeTypeKind.REGULAR;
        }
    }

    private void makeRegularAndNullableWithValidation() {
        for (AnnotationMirror annotationMirror : this.element.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getSimpleName().contentEquals(NULLABLE_SIMPLE_NAME)) continue;
            if (this.isPrimitive()) {
                this.report().annotationNamed(NULLABLE_SIMPLE_NAME).error("@Nullable could not be used with primitive type attibutes", new Object[0]);
                continue;
            }
            this.nullability = $ImmutableNullabilityAnnotationInfo.of(annotationElement);
            this.nullability.eagerize();
            if (!this.isNullable()) continue;
            this.typeKind = $AttributeTypeKind.REGULAR;
        }
        if (this.containingType.isAnnotationType() && this.isNullable()) {
            this.report().annotationNamed(NULLABLE_SIMPLE_NAME).error("@Nullable could not be used with annotation attribute, use default value", new Object[0]);
        }
    }

    private void initFactoryParamsIfApplicable() {
        if (!this.containingType.kind().isFactory()) {
            return;
        }
        this.isBuilderParameter = $FParameterMirror.isPresent(this.element);
        $Optional<$SwitchMirror> switcher = $SwitchMirror.find(this.element);
        if (switcher.isPresent()) {
            if (this.isBuilderParameter) {
                this.report().annotationNamed($FParameterMirror.simpleName()).error("@%s and @%s annotations cannot be used on a same factory parameter", $FParameterMirror.simpleName(), $SwitchMirror.simpleName());
                this.isBuilderParameter = false;
            }
            if (!this.isEnumType()) {
                this.report().annotationNamed($SwitchMirror.simpleName()).error("@%s annotation applicable only to enum parameters", $SwitchMirror.simpleName());
            } else {
                this.builderSwitcherModel = new $SwitcherModel(switcher.get(), this.name(), this.containedTypeElement);
            }
        }
    }

    $Reporter report() {
        return this.reporter.withElement(this.element);
    }

    public boolean hasBuilderSwitcherDefault() {
        return this.isBuilderSwitcher() && this.builderSwitcherModel.hasDefault();
    }

    public boolean isBuilderSwitcher() {
        return this.builderSwitcherModel != null;
    }

    public boolean hasForwardOnlyInitializer() {
        return this.isCollectionType() || this.isMapType();
    }

    public boolean requiresTrackIsSet() {
        return this.containingType.isUseStrictBuilder() && !this.isMandatory() && !this.hasForwardOnlyInitializer() || this.isPrimitive() && this.isGenerateDefault;
    }

    public String toString() {
        return "Attribute[" + this.name() + "]";
    }

    static abstract class NullabilityAnnotationInfo {
        NullabilityAnnotationInfo() {
        }

        abstract TypeElement element();

        String qualifiedName() {
            return this.element().getQualifiedName().toString();
        }

        String asPrefix() {
            return "@" + this.qualifiedName() + " ";
        }

        String asLocalPrefix() {
            return this.localsSupported() ? this.asPrefix() : "";
        }

        void eagerize() {
            this.asPrefix();
            this.asLocalPrefix();
        }

        private boolean localsSupported() {
            Target target = this.element().getAnnotation(Target.class);
            if (target == null) {
                return true;
            }
            for (ElementType type : target.value()) {
                if (type != ElementType.LOCAL_VARIABLE) continue;
                return true;
            }
            return false;
        }
    }

    private static enum OrderKind {
        NONE,
        NATURAL,
        REVERSE;

    }
}

