/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import com.sun.tools.javac.code.Symbol;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.immutables.value.internal.$generator$.$PostprocessingMachine;
import org.immutables.value.internal.$generator$.$SourceTypes;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Maps;

public final class $SourceExtraction {
    private static final SourceExtractor DEFAULT_EXTRACTOR = new SourceExtractor(){

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement element) throws IOException {
            FileObject resource = environment.getFiler().getResource(StandardLocation.SOURCE_PATH, "", this.toFilename(element));
            return resource.getCharContent(true);
        }

        private String toFilename(TypeElement element) {
            return element.getQualifiedName().toString().replace('.', '/') + ".java";
        }

        @Override
        public CharSequence extractReturnType(ExecutableElement executableElement) {
            return UNABLE_TO_EXTRACT;
        }
    };
    private static final SourceExtractor EXTRACTOR = $SourceExtraction.createExtractor();

    private $SourceExtraction() {
    }

    public static Imports readImports(ProcessingEnvironment environment, TypeElement element) {
        try {
            return $PostprocessingMachine.collectImports($SourceExtraction.extract(environment, element));
        }
        catch (IOException cannotReadSourceFile) {
            environment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, String.format("Could not read source files to collect imports for %s[%s.class]: %s", element, element.getClass().getName(), cannotReadSourceFile));
            return Imports.empty();
        }
    }

    public static CharSequence extract(ProcessingEnvironment environment, TypeElement element) throws IOException {
        return EXTRACTOR.extract(environment, element);
    }

    private static SourceExtractor createExtractor() {
        ArrayList<SourceExtractor> extractors = $Lists.newArrayListWithCapacity(2);
        try {
            extractors.add(new JavacSourceExtractor());
        }
        catch (Throwable javacClassesNotAwailable) {
            // empty catch block
        }
        try {
            extractors.add(new EclipseSourceExtractor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new CompositeExtractor(extractors);
    }

    public static CharSequence getReturnTypeString(ExecutableElement method) {
        return EXTRACTOR.extractReturnType(method);
    }

    private static final class CompositeExtractor
    implements SourceExtractor {
        private final SourceExtractor[] extractors;

        CompositeExtractor(List<SourceExtractor> extractors) {
            this.extractors = extractors.toArray(new SourceExtractor[extractors.size()]);
        }

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement typeElement) throws IOException {
            for (SourceExtractor extractor : this.extractors) {
                CharSequence source = extractor.extract(environment, typeElement);
                if (source.equals(UNABLE_TO_EXTRACT)) continue;
                return source;
            }
            return DEFAULT_EXTRACTOR.extract(environment, typeElement);
        }

        @Override
        public CharSequence extractReturnType(ExecutableElement executableElement) {
            for (SourceExtractor extractor : this.extractors) {
                CharSequence source = extractor.extractReturnType(executableElement);
                if (source.equals(UNABLE_TO_EXTRACT)) continue;
                return source;
            }
            return DEFAULT_EXTRACTOR.extractReturnType(executableElement);
        }
    }

    private static final class EclipseSourceExtractor
    implements SourceExtractor {
        private EclipseSourceExtractor() {
        }

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement typeElement) throws IOException {
            Binding binding;
            if (typeElement instanceof ElementImpl && (binding = ((ElementImpl)typeElement)._binding) instanceof SourceTypeBinding) {
                CompilationUnitDeclaration unit = ((SourceTypeBinding)binding).scope.referenceCompilationUnit();
                char[] contents = unit.compilationResult.compilationUnit.getContents();
                return CharBuffer.wrap(contents);
            }
            return UNABLE_TO_EXTRACT;
        }

        @Override
        public CharSequence extractReturnType(ExecutableElement executableElement) {
            MethodBinding methodBinding;
            AbstractMethodDeclaration sourceMethod;
            Binding binding;
            if (executableElement instanceof ExecutableElementImpl && (binding = ((ExecutableElementImpl)executableElement)._binding) instanceof MethodBinding && (sourceMethod = (methodBinding = (MethodBinding)binding).sourceMethod()) != null) {
                CharSequence rawType = this.getRawType(methodBinding);
                char[] content = sourceMethod.compilationResult.compilationUnit.getContents();
                int sourceEnd = methodBinding.sourceStart();
                int sourceStart = this.scanForTheSourceStart(content, sourceEnd);
                char[] methodTest = Arrays.copyOfRange(content, sourceStart, sourceEnd);
                Map.Entry<String, List<String>> extracted = $SourceTypes.extract(String.valueOf(methodTest));
                return $SourceTypes.stringify($Maps.immutableEntry(rawType.toString(), extracted.getValue()));
            }
            return UNABLE_TO_EXTRACT;
        }

        private int scanForTheSourceStart(char[] content, int sourceEnd) {
            int i;
            for (i = sourceEnd; i >= 0; --i) {
                char c = content[i];
                if (c != '\n') continue;
                return i;
            }
            return i;
        }

        private CharSequence getRawType(MethodBinding methodBinding) {
            TypeBinding returnType = methodBinding.returnType;
            char[] sourceName = returnType.sourceName();
            if (sourceName == null) {
                sourceName = new char[]{};
            }
            return CharBuffer.wrap(sourceName);
        }

        static {
            ElementImpl.class.getCanonicalName();
        }
    }

    private static final class JavacSourceExtractor
    implements SourceExtractor {
        private JavacSourceExtractor() {
        }

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement typeElement) throws IOException {
            if (typeElement instanceof Symbol.ClassSymbol) {
                JavaFileObject sourceFile = ((Symbol.ClassSymbol)typeElement).sourcefile;
                return sourceFile.getCharContent(true);
            }
            return UNABLE_TO_EXTRACT;
        }

        @Override
        public CharSequence extractReturnType(ExecutableElement executableElement) {
            return UNABLE_TO_EXTRACT;
        }

        static {
            Symbol.ClassSymbol.class.getCanonicalName();
        }
    }

    static interface SourceExtractor {
        public static final CharSequence UNABLE_TO_EXTRACT = "";

        public CharSequence extract(ProcessingEnvironment var1, TypeElement var2) throws IOException;

        public CharSequence extractReturnType(ExecutableElement var1);
    }

    public static final class Imports {
        private static final Imports EMPTY = new Imports($ImmutableSet.of(), $ImmutableMap.of());
        public final $ImmutableSet<String> all;
        public final $ImmutableMap<String, String> classes;

        private Imports(Set<String> all, Map<String, String> classes) {
            this.all = $ImmutableSet.copyOf(all);
            this.classes = $ImmutableMap.copyOf(classes);
        }

        public static Imports of(Set<String> all, Map<String, String> classes) {
            if (all.isEmpty() && classes.isEmpty()) {
                return EMPTY;
            }
            if (!all.containsAll(classes.values())) {
                // empty if block
            }
            return new Imports(all, classes);
        }

        public static Imports empty() {
            return EMPTY;
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        public String toString() {
            return $MoreObjects.toStringHelper(this).add("all", this.all).add("classes", this.classes).toString();
        }
    }
}

