/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.$generator$.$AnnotationMirrors;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.collect.$Lists;

final class $Annotations {
    private static final String PREFIX_JAVA_LANG = "java.lang.";
    private static final String PREFIX_ORG_IMMUTABLES = "org.immutables.";
    static final String NULLABLE_SIMPLE_NAME = "Nullable";

    private $Annotations() {
    }

    static List<CharSequence> getAnnotationLines(Element element, $Optional<Set<String>> includeAnnotations, ElementType elementType) {
        ArrayList<CharSequence> lines = $Lists.newArrayList();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!$Annotations.annotationMatchesName(annotationElement, includeAnnotations) || !$Annotations.annotationMatchesTarget(annotationElement, elementType)) continue;
            lines.add($AnnotationMirrors.toCharSequence(annotationMirror));
        }
        return lines;
    }

    private static boolean annotationMatchesName(TypeElement annotationElement, $Optional<Set<String>> includeAnnotations) {
        String qualifiedName = annotationElement.getQualifiedName().toString();
        if (includeAnnotations.isPresent()) {
            return includeAnnotations.get().contains(qualifiedName);
        }
        if (qualifiedName.startsWith(PREFIX_ORG_IMMUTABLES) || qualifiedName.startsWith(PREFIX_JAVA_LANG) || qualifiedName.equals("com.fasterxml.jackson.annotation.JsonProperty")) {
            return false;
        }
        return !annotationElement.getSimpleName().contentEquals(NULLABLE_SIMPLE_NAME);
    }

    static boolean annotationMatchesTarget(Element annotationElement, ElementType elementType) {
        Target target = annotationElement.getAnnotation(Target.class);
        if (target != null) {
            ElementType[] targetTypes = target.value();
            if (targetTypes.length == 0) {
                return false;
            }
            boolean found = false;
            for (ElementType t : targetTypes) {
                if (t != elementType) continue;
                found = true;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }
}

