/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.$generator$.$AnnotationMirrors;
import org.immutables.value.internal.$guava$.collect.$Lists;

final class $Annotations {
    private static final String PREFIX_JAVA_LANG = "java.lang.";
    private static final String PREFIX_IMMUTABLES = "org.immutables.";
    private static final String PREFIX_JACKSON = "com.fasterxml.jackson.annotation.";
    private static final String PREFIX_JACKSON_DATABIND = "com.fasterxml.jackson.databind.annotation.";
    static final String NULLABLE_SIMPLE_NAME = "Nullable";

    private $Annotations() {
    }

    static List<CharSequence> getAnnotationLines(Element element, Set<String> includeAnnotations, boolean includeJacksonAnnotations, ElementType elementType) {
        ArrayList<CharSequence> lines = $Lists.newArrayList();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!$Annotations.annotationTypeMatches(annotationElement, includeAnnotations, includeJacksonAnnotations) || !$Annotations.annotationMatchesTarget(annotationElement, elementType)) continue;
            lines.add($AnnotationMirrors.toCharSequence(annotationMirror));
        }
        return lines;
    }

    private static boolean annotationTypeMatches(TypeElement annotationElement, Set<String> includeAnnotations, boolean includeJacksonAnnotations) {
        String qualifiedName = annotationElement.getQualifiedName().toString();
        if (qualifiedName.startsWith(PREFIX_IMMUTABLES) || qualifiedName.startsWith(PREFIX_JAVA_LANG)) {
            return false;
        }
        if (annotationElement.getSimpleName().contentEquals(NULLABLE_SIMPLE_NAME)) {
            return false;
        }
        if (includeJacksonAnnotations && (qualifiedName.startsWith(PREFIX_JACKSON) || qualifiedName.startsWith(PREFIX_JACKSON_DATABIND))) {
            return true;
        }
        return includeAnnotations.contains(qualifiedName);
    }

    static boolean annotationMatchesTarget(Element annotationElement, ElementType elementType) {
        Target target = annotationElement.getAnnotation(Target.class);
        if (target != null) {
            ElementType[] targetTypes = target.value();
            if (targetTypes.length == 0) {
                return false;
            }
            boolean found = false;
            for (ElementType t : targetTypes) {
                if (t != elementType) continue;
                found = true;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }
}

