/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;

public class $TransformMirror
implements .processor..TreesMirrors.Transform {
    public static final String QUALIFIED_NAME = "org.immutables.trees.Trees.Transform";
    private final AnnotationMirror annotationMirror;
    private final TypeMirror[] include;
    private final String[] includeName;

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Transform";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$TransformMirror> find(Element element) {
        return $TransformMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$TransformMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $TransformMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$TransformMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $TransformMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $TransformMirror from(TypeElement element) {
        return new $TransformMirror(element);
    }

    public static $Optional<$TransformMirror> from(AnnotationMirror mirror) {
        return $TransformMirror.find(Collections.singleton(mirror));
    }

    private $TransformMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME));
        this.annotationMirror = null;
        TypeMirror[] include = null;
        String[] includeName = null;
        for (ExecutableElement attributeElement : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name = attributeElement.getSimpleName().toString();
            if (!"include".equals(name)) continue;
            AnnotationValue annotationValue = attributeElement.getDefaultValue();
            if (annotationValue == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Transform");
            }
            IncludeExtractor includeExtractor = new IncludeExtractor();
            annotationValue.accept(includeExtractor, null);
            include = includeExtractor.get();
            includeName = includeExtractor.name();
        }
        this.include = $Preconditions.checkNotNull(include);
        this.includeName = $Preconditions.checkNotNull(includeName);
    }

    private $TransformMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        TypeMirror[] include = null;
        String[] includeName = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name = attributeElement.getSimpleName().toString();
            if (!"include".equals(name)) continue;
            AnnotationValue annotationValue = attributeValues.get(attributeElement);
            if (annotationValue == null) {
                annotationValue = attributeElement.getDefaultValue();
            }
            if (annotationValue == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'include' attribute of @Transform");
            }
            IncludeExtractor includeExtractor = new IncludeExtractor();
            annotationValue.accept(includeExtractor, null);
            include = includeExtractor.get();
            includeName = includeExtractor.name();
        }
        this.include = $Preconditions.checkNotNull(include);
        this.includeName = $Preconditions.checkNotNull(includeName);
    }

    public String[] includeName() {
        return (String[])this.includeName.clone();
    }

    public TypeMirror[] includeMirror() {
        return (TypeMirror[])this.include.clone();
    }

    @Override
    @Deprecated
    public Class<?>[] include() {
        throw new UnsupportedOperationException("Use 'includeMirror()' or 'includeName()'");
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return .processor..TreesMirrors.Transform.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "include".hashCode() ^ Arrays.hashCode(this.includeName);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $TransformMirror) {
            $TransformMirror otherMirror = ($TransformMirror)other;
            return Arrays.equals(this.includeName, otherMirror.includeName);
        }
        return false;
    }

    @Override
    public String toString() {
        return "TransformMirror:" + this.annotationMirror;
    }

    private static class IncludeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private IncludeExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'include' in @org.immutables.trees.Trees.Transform");
        }
    }
}

