/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$guava$.collect.$ImmutableSortedMap;
import org.immutables.value.internal.$guava$.collect.$Maps;
import org.immutables.value.internal.$guava$.collect.$Multimaps;

public final class $LongBits
implements $Function<Iterable<? extends Object>, LongPositions> {
    private static final int BITS_IN_LONG = 64;

    @Override
    public LongPositions apply(Iterable<? extends Object> input) {
        return this.forIterable(input, 64);
    }

    public LongPositions forIterable(Iterable<? extends Object> input, int bitPerLong) {
        return new LongPositions(input, bitPerLong);
    }

    public static final class BitPosition {
        public final int index;
        public final int bit;
        public final long mask;

        BitPosition(int index, int bit) {
            this.index = index;
            this.bit = bit;
            this.mask = 1 << bit;
        }
    }

    static enum ToLongIndex implements $Function<BitPosition, Integer>
    {
        FUNCTION;


        @Override
        public Integer apply(BitPosition input) {
            return input.index;
        }
    }

    public static final class LongSet {
        public final int index;
        public final int occupation;
        public final Iterable<BitPosition> positions;

        LongSet(int index, Iterable<BitPosition> positions) {
            this.index = index;
            this.positions = $ImmutableList.copyOf(positions);
            this.occupation = this.computeOccupation();
        }

        private int computeOccupation() {
            int occupation = 0;
            for (BitPosition position : this.positions) {
                occupation = (int)((long)occupation | position.mask);
            }
            return occupation;
        }
    }

    public static final class LongPositions
    implements $Function<Object, BitPosition> {
        private final IdentityHashMap<Object, BitPosition> positions = $Maps.newIdentityHashMap();
        private final $ImmutableList<Object> elements;
        private final $ImmutableMap<Integer, LongSet> longPositions;

        LongPositions(Iterable<? extends Object> elements, int bitPerLong) {
            this.elements = $ImmutableList.copyOf(elements);
            $Preconditions.checkArgument(bitPerLong <= 64, bitPerLong);
            for (int i = 0; i < this.elements.size(); ++i) {
                this.positions.put(this.elements.get(i), new BitPosition(i / bitPerLong, i % bitPerLong));
            }
            this.longPositions = $ImmutableSortedMap.copyOf($Maps.transformEntries($Multimaps.index(this.positions.values(), ToLongIndex.FUNCTION).asMap(), new $Maps.EntryTransformer<Integer, Collection<BitPosition>, LongSet>(){

                @Override
                public LongSet transformEntry(Integer key, Collection<BitPosition> position) {
                    return new LongSet(key, position);
                }
            }));
        }

        public Set<Integer> longsIndeces() {
            return this.longPositions.keySet();
        }

        public Collection<LongSet> longs() {
            return this.longPositions.values();
        }

        @Override
        public BitPosition apply(Object input) {
            return this.positions.get(input);
        }
    }
}

