/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.primitives.$Booleans;
import org.immutables.value.internal.$processor$.meta.$ImmutableMirror;

public class $StyleMirror
implements .processor..ValueMirrors.Style {
    public static final String QUALIFIED_NAME = "org.immutables.value.Value.Style";
    private final AnnotationMirror annotationMirror;
    private final String[] get;
    private final String init;
    private final String with;
    private final String add;
    private final String addAll;
    private final String put;
    private final String putAll;
    private final String copyOf;
    private final String of;
    private final String instance;
    private final String builder;
    private final String newBuilder;
    private final String from;
    private final String build;
    private final String typeBuilder;
    private final String[] typeAbstract;
    private final String typeImmutable;
    private final String typeImmutableEnclosing;
    private final String typeImmutableNested;
    private final AnnotationMirror defaults;
    private final $ImmutableMirror defaultsMirror;
    private final boolean strictBuilder;
    private final .processor..ValueMirrors.Style.ImplementationVisibility visibility;
    private final boolean jdkOnly;

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Style";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$StyleMirror> find(Element element) {
        return $StyleMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$StyleMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $StyleMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$StyleMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $StyleMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $StyleMirror from(TypeElement element) {
        return new $StyleMirror(element);
    }

    public static $Optional<$StyleMirror> from(AnnotationMirror mirror) {
        return $StyleMirror.find(Collections.singleton(mirror));
    }

    private $StyleMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME));
        this.annotationMirror = null;
        String[] get = null;
        String init = null;
        String with = null;
        String add = null;
        String addAll = null;
        String put = null;
        String putAll = null;
        String copyOf = null;
        String of = null;
        String instance = null;
        String builder = null;
        String newBuilder = null;
        String from = null;
        String build = null;
        String typeBuilder = null;
        String[] typeAbstract = null;
        String typeImmutable = null;
        String typeImmutableEnclosing = null;
        String typeImmutableNested = null;
        AnnotationMirror defaults = null;
        $ImmutableMirror defaultsMirror = null;
        boolean strictBuilder = false;
        .processor..ValueMirrors.Style.ImplementationVisibility visibility = null;
        boolean jdkOnly = false;
        for (ExecutableElement attributeElement : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue;
            String name = attributeElement.getSimpleName().toString();
            if ("get".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                GetExtractor getExtractor = new GetExtractor();
                annotationValue.accept(getExtractor, null);
                get = getExtractor.get();
                continue;
            }
            if ("init".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                InitExtractor initExtractor = new InitExtractor();
                annotationValue.accept(initExtractor, null);
                init = initExtractor.get();
                continue;
            }
            if ("with".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                WithExtractor withExtractor = new WithExtractor();
                annotationValue.accept(withExtractor, null);
                with = withExtractor.get();
                continue;
            }
            if ("add".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AddExtractor addExtractor = new AddExtractor();
                annotationValue.accept(addExtractor, null);
                add = addExtractor.get();
                continue;
            }
            if ("addAll".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AddAllExtractor addAllExtractor = new AddAllExtractor();
                annotationValue.accept(addAllExtractor, null);
                addAll = addAllExtractor.get();
                continue;
            }
            if ("put".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                PutExtractor putExtractor = new PutExtractor();
                annotationValue.accept(putExtractor, null);
                put = putExtractor.get();
                continue;
            }
            if ("putAll".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                PutAllExtractor putAllExtractor = new PutAllExtractor();
                annotationValue.accept(putAllExtractor, null);
                putAll = putAllExtractor.get();
                continue;
            }
            if ("copyOf".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                CopyOfExtractor copyOfExtractor = new CopyOfExtractor();
                annotationValue.accept(copyOfExtractor, null);
                copyOf = copyOfExtractor.get();
                continue;
            }
            if ("of".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                OfExtractor ofExtractor = new OfExtractor();
                annotationValue.accept(ofExtractor, null);
                of = ofExtractor.get();
                continue;
            }
            if ("instance".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                InstanceExtractor instanceExtractor = new InstanceExtractor();
                annotationValue.accept(instanceExtractor, null);
                instance = instanceExtractor.get();
                continue;
            }
            if ("builder".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                BuilderExtractor builderExtractor = new BuilderExtractor();
                annotationValue.accept(builderExtractor, null);
                builder = builderExtractor.get();
                continue;
            }
            if ("newBuilder".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                NewBuilderExtractor newBuilderExtractor = new NewBuilderExtractor();
                annotationValue.accept(newBuilderExtractor, null);
                newBuilder = newBuilderExtractor.get();
                continue;
            }
            if ("from".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                FromExtractor fromExtractor = new FromExtractor();
                annotationValue.accept(fromExtractor, null);
                from = fromExtractor.get();
                continue;
            }
            if ("build".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                BuildExtractor buildExtractor = new BuildExtractor();
                annotationValue.accept(buildExtractor, null);
                build = buildExtractor.get();
                continue;
            }
            if ("typeBuilder".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeBuilderExtractor typeBuilderExtractor = new TypeBuilderExtractor();
                annotationValue.accept(typeBuilderExtractor, null);
                typeBuilder = typeBuilderExtractor.get();
                continue;
            }
            if ("typeAbstract".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeAbstractExtractor typeAbstractExtractor = new TypeAbstractExtractor();
                annotationValue.accept(typeAbstractExtractor, null);
                typeAbstract = typeAbstractExtractor.get();
                continue;
            }
            if ("typeImmutable".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeImmutableExtractor typeImmutableExtractor = new TypeImmutableExtractor();
                annotationValue.accept(typeImmutableExtractor, null);
                typeImmutable = typeImmutableExtractor.get();
                continue;
            }
            if ("typeImmutableEnclosing".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeImmutableEnclosingExtractor typeImmutableEnclosingExtractor = new TypeImmutableEnclosingExtractor();
                annotationValue.accept(typeImmutableEnclosingExtractor, null);
                typeImmutableEnclosing = typeImmutableEnclosingExtractor.get();
                continue;
            }
            if ("typeImmutableNested".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeImmutableNestedExtractor typeImmutableNestedExtractor = new TypeImmutableNestedExtractor();
                annotationValue.accept(typeImmutableNestedExtractor, null);
                typeImmutableNested = typeImmutableNestedExtractor.get();
                continue;
            }
            if ("defaults".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                DefaultsExtractor defaultsExtractor = new DefaultsExtractor();
                annotationValue.accept(defaultsExtractor, null);
                defaults = defaultsExtractor.get();
                defaultsMirror = defaultsExtractor.mirror();
                continue;
            }
            if ("strictBuilder".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                StrictBuilderExtractor strictBuilderExtractor = new StrictBuilderExtractor();
                annotationValue.accept(strictBuilderExtractor, null);
                strictBuilder = strictBuilderExtractor.get();
                continue;
            }
            if ("visibility".equals(name)) {
                annotationValue = attributeElement.getDefaultValue();
                if (annotationValue == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                VisibilityExtractor visibilityExtractor = new VisibilityExtractor();
                annotationValue.accept(visibilityExtractor, null);
                visibility = visibilityExtractor.get();
                continue;
            }
            if (!"jdkOnly".equals(name)) continue;
            annotationValue = attributeElement.getDefaultValue();
            if (annotationValue == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
            }
            JdkOnlyExtractor jdkOnlyExtractor = new JdkOnlyExtractor();
            annotationValue.accept(jdkOnlyExtractor, null);
            jdkOnly = jdkOnlyExtractor.get();
        }
        this.get = $Preconditions.checkNotNull(get);
        this.init = $Preconditions.checkNotNull(init);
        this.with = $Preconditions.checkNotNull(with);
        this.add = $Preconditions.checkNotNull(add);
        this.addAll = $Preconditions.checkNotNull(addAll);
        this.put = $Preconditions.checkNotNull(put);
        this.putAll = $Preconditions.checkNotNull(putAll);
        this.copyOf = $Preconditions.checkNotNull(copyOf);
        this.of = $Preconditions.checkNotNull(of);
        this.instance = $Preconditions.checkNotNull(instance);
        this.builder = $Preconditions.checkNotNull(builder);
        this.newBuilder = $Preconditions.checkNotNull(newBuilder);
        this.from = $Preconditions.checkNotNull(from);
        this.build = $Preconditions.checkNotNull(build);
        this.typeBuilder = $Preconditions.checkNotNull(typeBuilder);
        this.typeAbstract = $Preconditions.checkNotNull(typeAbstract);
        this.typeImmutable = $Preconditions.checkNotNull(typeImmutable);
        this.typeImmutableEnclosing = $Preconditions.checkNotNull(typeImmutableEnclosing);
        this.typeImmutableNested = $Preconditions.checkNotNull(typeImmutableNested);
        this.defaults = $Preconditions.checkNotNull(defaults);
        this.defaultsMirror = $Preconditions.checkNotNull(defaultsMirror);
        this.strictBuilder = strictBuilder;
        this.visibility = $Preconditions.checkNotNull(visibility);
        this.jdkOnly = jdkOnly;
    }

    private $StyleMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String[] get = null;
        String init = null;
        String with = null;
        String add = null;
        String addAll = null;
        String put = null;
        String putAll = null;
        String copyOf = null;
        String of = null;
        String instance = null;
        String builder = null;
        String newBuilder = null;
        String from = null;
        String build = null;
        String typeBuilder = null;
        String[] typeAbstract = null;
        String typeImmutable = null;
        String typeImmutableEnclosing = null;
        String typeImmutableNested = null;
        AnnotationMirror defaults = null;
        $ImmutableMirror defaultsMirror = null;
        boolean strictBuilder = false;
        .processor..ValueMirrors.Style.ImplementationVisibility visibility = null;
        boolean jdkOnly = false;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue;
            String name = attributeElement.getSimpleName().toString();
            if ("get".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'get' attribute of @Style");
                }
                GetExtractor getExtractor = new GetExtractor();
                annotationValue.accept(getExtractor, null);
                get = getExtractor.get();
                continue;
            }
            if ("init".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'init' attribute of @Style");
                }
                InitExtractor initExtractor = new InitExtractor();
                annotationValue.accept(initExtractor, null);
                init = initExtractor.get();
                continue;
            }
            if ("with".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'with' attribute of @Style");
                }
                WithExtractor withExtractor = new WithExtractor();
                annotationValue.accept(withExtractor, null);
                with = withExtractor.get();
                continue;
            }
            if ("add".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'add' attribute of @Style");
                }
                AddExtractor addExtractor = new AddExtractor();
                annotationValue.accept(addExtractor, null);
                add = addExtractor.get();
                continue;
            }
            if ("addAll".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'addAll' attribute of @Style");
                }
                AddAllExtractor addAllExtractor = new AddAllExtractor();
                annotationValue.accept(addAllExtractor, null);
                addAll = addAllExtractor.get();
                continue;
            }
            if ("put".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'put' attribute of @Style");
                }
                PutExtractor putExtractor = new PutExtractor();
                annotationValue.accept(putExtractor, null);
                put = putExtractor.get();
                continue;
            }
            if ("putAll".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'putAll' attribute of @Style");
                }
                PutAllExtractor putAllExtractor = new PutAllExtractor();
                annotationValue.accept(putAllExtractor, null);
                putAll = putAllExtractor.get();
                continue;
            }
            if ("copyOf".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'copyOf' attribute of @Style");
                }
                CopyOfExtractor copyOfExtractor = new CopyOfExtractor();
                annotationValue.accept(copyOfExtractor, null);
                copyOf = copyOfExtractor.get();
                continue;
            }
            if ("of".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'of' attribute of @Style");
                }
                OfExtractor ofExtractor = new OfExtractor();
                annotationValue.accept(ofExtractor, null);
                of = ofExtractor.get();
                continue;
            }
            if ("instance".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'instance' attribute of @Style");
                }
                InstanceExtractor instanceExtractor = new InstanceExtractor();
                annotationValue.accept(instanceExtractor, null);
                instance = instanceExtractor.get();
                continue;
            }
            if ("builder".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'builder' attribute of @Style");
                }
                BuilderExtractor builderExtractor = new BuilderExtractor();
                annotationValue.accept(builderExtractor, null);
                builder = builderExtractor.get();
                continue;
            }
            if ("newBuilder".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'newBuilder' attribute of @Style");
                }
                NewBuilderExtractor newBuilderExtractor = new NewBuilderExtractor();
                annotationValue.accept(newBuilderExtractor, null);
                newBuilder = newBuilderExtractor.get();
                continue;
            }
            if ("from".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'from' attribute of @Style");
                }
                FromExtractor fromExtractor = new FromExtractor();
                annotationValue.accept(fromExtractor, null);
                from = fromExtractor.get();
                continue;
            }
            if ("build".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'build' attribute of @Style");
                }
                BuildExtractor buildExtractor = new BuildExtractor();
                annotationValue.accept(buildExtractor, null);
                build = buildExtractor.get();
                continue;
            }
            if ("typeBuilder".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeBuilder' attribute of @Style");
                }
                TypeBuilderExtractor typeBuilderExtractor = new TypeBuilderExtractor();
                annotationValue.accept(typeBuilderExtractor, null);
                typeBuilder = typeBuilderExtractor.get();
                continue;
            }
            if ("typeAbstract".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeAbstract' attribute of @Style");
                }
                TypeAbstractExtractor typeAbstractExtractor = new TypeAbstractExtractor();
                annotationValue.accept(typeAbstractExtractor, null);
                typeAbstract = typeAbstractExtractor.get();
                continue;
            }
            if ("typeImmutable".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeImmutable' attribute of @Style");
                }
                TypeImmutableExtractor typeImmutableExtractor = new TypeImmutableExtractor();
                annotationValue.accept(typeImmutableExtractor, null);
                typeImmutable = typeImmutableExtractor.get();
                continue;
            }
            if ("typeImmutableEnclosing".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeImmutableEnclosing' attribute of @Style");
                }
                TypeImmutableEnclosingExtractor typeImmutableEnclosingExtractor = new TypeImmutableEnclosingExtractor();
                annotationValue.accept(typeImmutableEnclosingExtractor, null);
                typeImmutableEnclosing = typeImmutableEnclosingExtractor.get();
                continue;
            }
            if ("typeImmutableNested".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeImmutableNested' attribute of @Style");
                }
                TypeImmutableNestedExtractor typeImmutableNestedExtractor = new TypeImmutableNestedExtractor();
                annotationValue.accept(typeImmutableNestedExtractor, null);
                typeImmutableNested = typeImmutableNestedExtractor.get();
                continue;
            }
            if ("defaults".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'defaults' attribute of @Style");
                }
                DefaultsExtractor defaultsExtractor = new DefaultsExtractor();
                annotationValue.accept(defaultsExtractor, null);
                defaults = defaultsExtractor.get();
                defaultsMirror = defaultsExtractor.mirror();
                continue;
            }
            if ("strictBuilder".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'strictBuilder' attribute of @Style");
                }
                StrictBuilderExtractor strictBuilderExtractor = new StrictBuilderExtractor();
                annotationValue.accept(strictBuilderExtractor, null);
                strictBuilder = strictBuilderExtractor.get();
                continue;
            }
            if ("visibility".equals(name)) {
                annotationValue = attributeValues.get(attributeElement);
                if (annotationValue == null) {
                    annotationValue = attributeElement.getDefaultValue();
                }
                if (annotationValue == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'visibility' attribute of @Style");
                }
                VisibilityExtractor visibilityExtractor = new VisibilityExtractor();
                annotationValue.accept(visibilityExtractor, null);
                visibility = visibilityExtractor.get();
                continue;
            }
            if (!"jdkOnly".equals(name)) continue;
            annotationValue = attributeValues.get(attributeElement);
            if (annotationValue == null) {
                annotationValue = attributeElement.getDefaultValue();
            }
            if (annotationValue == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'jdkOnly' attribute of @Style");
            }
            JdkOnlyExtractor jdkOnlyExtractor = new JdkOnlyExtractor();
            annotationValue.accept(jdkOnlyExtractor, null);
            jdkOnly = jdkOnlyExtractor.get();
        }
        this.get = $Preconditions.checkNotNull(get);
        this.init = $Preconditions.checkNotNull(init);
        this.with = $Preconditions.checkNotNull(with);
        this.add = $Preconditions.checkNotNull(add);
        this.addAll = $Preconditions.checkNotNull(addAll);
        this.put = $Preconditions.checkNotNull(put);
        this.putAll = $Preconditions.checkNotNull(putAll);
        this.copyOf = $Preconditions.checkNotNull(copyOf);
        this.of = $Preconditions.checkNotNull(of);
        this.instance = $Preconditions.checkNotNull(instance);
        this.builder = $Preconditions.checkNotNull(builder);
        this.newBuilder = $Preconditions.checkNotNull(newBuilder);
        this.from = $Preconditions.checkNotNull(from);
        this.build = $Preconditions.checkNotNull(build);
        this.typeBuilder = $Preconditions.checkNotNull(typeBuilder);
        this.typeAbstract = $Preconditions.checkNotNull(typeAbstract);
        this.typeImmutable = $Preconditions.checkNotNull(typeImmutable);
        this.typeImmutableEnclosing = $Preconditions.checkNotNull(typeImmutableEnclosing);
        this.typeImmutableNested = $Preconditions.checkNotNull(typeImmutableNested);
        this.defaults = $Preconditions.checkNotNull(defaults);
        this.defaultsMirror = $Preconditions.checkNotNull(defaultsMirror);
        this.strictBuilder = strictBuilder;
        this.visibility = $Preconditions.checkNotNull(visibility);
        this.jdkOnly = jdkOnly;
    }

    @Override
    public String[] get() {
        return (String[])this.get.clone();
    }

    @Override
    public String init() {
        return this.init;
    }

    @Override
    public String with() {
        return this.with;
    }

    @Override
    public String add() {
        return this.add;
    }

    @Override
    public String addAll() {
        return this.addAll;
    }

    @Override
    public String put() {
        return this.put;
    }

    @Override
    public String putAll() {
        return this.putAll;
    }

    @Override
    public String copyOf() {
        return this.copyOf;
    }

    @Override
    public String of() {
        return this.of;
    }

    @Override
    public String instance() {
        return this.instance;
    }

    @Override
    public String builder() {
        return this.builder;
    }

    @Override
    public String newBuilder() {
        return this.newBuilder;
    }

    @Override
    public String from() {
        return this.from;
    }

    @Override
    public String build() {
        return this.build;
    }

    @Override
    public String typeBuilder() {
        return this.typeBuilder;
    }

    @Override
    public String[] typeAbstract() {
        return (String[])this.typeAbstract.clone();
    }

    @Override
    public String typeImmutable() {
        return this.typeImmutable;
    }

    @Override
    public String typeImmutableEnclosing() {
        return this.typeImmutableEnclosing;
    }

    @Override
    public String typeImmutableNested() {
        return this.typeImmutableNested;
    }

    public AnnotationMirror defaultsMirror() {
        return this.defaults;
    }

    @Override
    public $ImmutableMirror defaults() {
        return this.defaultsMirror;
    }

    @Override
    public boolean strictBuilder() {
        return this.strictBuilder;
    }

    @Override
    public .processor..ValueMirrors.Style.ImplementationVisibility visibility() {
        return this.visibility;
    }

    @Override
    public boolean jdkOnly() {
        return this.jdkOnly;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return .processor..ValueMirrors.Style.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "get".hashCode() ^ Arrays.hashCode(this.get);
        h += 127 * "init".hashCode() ^ this.init.hashCode();
        h += 127 * "with".hashCode() ^ this.with.hashCode();
        h += 127 * "add".hashCode() ^ this.add.hashCode();
        h += 127 * "addAll".hashCode() ^ this.addAll.hashCode();
        h += 127 * "put".hashCode() ^ this.put.hashCode();
        h += 127 * "putAll".hashCode() ^ this.putAll.hashCode();
        h += 127 * "copyOf".hashCode() ^ this.copyOf.hashCode();
        h += 127 * "of".hashCode() ^ this.of.hashCode();
        h += 127 * "instance".hashCode() ^ this.instance.hashCode();
        h += 127 * "builder".hashCode() ^ this.builder.hashCode();
        h += 127 * "newBuilder".hashCode() ^ this.newBuilder.hashCode();
        h += 127 * "from".hashCode() ^ this.from.hashCode();
        h += 127 * "build".hashCode() ^ this.build.hashCode();
        h += 127 * "typeBuilder".hashCode() ^ this.typeBuilder.hashCode();
        h += 127 * "typeAbstract".hashCode() ^ Arrays.hashCode(this.typeAbstract);
        h += 127 * "typeImmutable".hashCode() ^ this.typeImmutable.hashCode();
        h += 127 * "typeImmutableEnclosing".hashCode() ^ this.typeImmutableEnclosing.hashCode();
        h += 127 * "typeImmutableNested".hashCode() ^ this.typeImmutableNested.hashCode();
        h += 127 * "defaults".hashCode() ^ this.defaults.hashCode();
        h += 127 * "strictBuilder".hashCode() ^ $Booleans.hashCode(this.strictBuilder);
        h += 127 * "visibility".hashCode() ^ this.visibility.hashCode();
        return h += 127 * "jdkOnly".hashCode() ^ $Booleans.hashCode(this.jdkOnly);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $StyleMirror) {
            $StyleMirror otherMirror = ($StyleMirror)other;
            return Arrays.equals(this.get, otherMirror.get) && this.init.equals(otherMirror.init) && this.with.equals(otherMirror.with) && this.add.equals(otherMirror.add) && this.addAll.equals(otherMirror.addAll) && this.put.equals(otherMirror.put) && this.putAll.equals(otherMirror.putAll) && this.copyOf.equals(otherMirror.copyOf) && this.of.equals(otherMirror.of) && this.instance.equals(otherMirror.instance) && this.builder.equals(otherMirror.builder) && this.newBuilder.equals(otherMirror.newBuilder) && this.from.equals(otherMirror.from) && this.build.equals(otherMirror.build) && this.typeBuilder.equals(otherMirror.typeBuilder) && Arrays.equals(this.typeAbstract, otherMirror.typeAbstract) && this.typeImmutable.equals(otherMirror.typeImmutable) && this.typeImmutableEnclosing.equals(otherMirror.typeImmutableEnclosing) && this.typeImmutableNested.equals(otherMirror.typeImmutableNested) && this.defaults.equals(otherMirror.defaults) && this.strictBuilder == otherMirror.strictBuilder && this.visibility.equals((Object)otherMirror.visibility) && this.jdkOnly == otherMirror.jdkOnly;
        }
        return false;
    }

    @Override
    public String toString() {
        return "StyleMirror:" + this.annotationMirror;
    }

    private static class JdkOnlyExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private JdkOnlyExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'jdkOnly' in @org.immutables.value.Value.Style");
        }
    }

    private static class VisibilityExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        .processor..ValueMirrors.Style.ImplementationVisibility value;

        private VisibilityExtractor() {
        }

        @Override
        public Void visitEnumConstant(VariableElement value, Void p) {
            this.value = .processor..ValueMirrors.Style.ImplementationVisibility.valueOf(value.getSimpleName().toString());
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        .processor..ValueMirrors.Style.ImplementationVisibility get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'visibility' in @org.immutables.value.Value.Style");
        }
    }

    private static class StrictBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private StrictBuilderExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'strictBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class DefaultsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        AnnotationMirror value;

        private DefaultsExtractor() {
        }

        @Override
        public Void visitAnnotation(AnnotationMirror value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        AnnotationMirror get() {
            return this.value;
        }

        public $ImmutableMirror mirror() {
            return $ImmutableMirror.from(this.value).get();
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'defaults' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeImmutableNestedExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeImmutableNestedExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeImmutableNested' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeImmutableEnclosingExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeImmutableEnclosingExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeImmutableEnclosing' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeImmutableExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeImmutableExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeImmutable' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeAbstractExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private TypeAbstractExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeAbstract' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class BuildExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private BuildExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'build' in @org.immutables.value.Value.Style");
        }
    }

    private static class FromExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private FromExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'from' in @org.immutables.value.Value.Style");
        }
    }

    private static class NewBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NewBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'newBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class BuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private BuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'builder' in @org.immutables.value.Value.Style");
        }
    }

    private static class InstanceExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private InstanceExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'instance' in @org.immutables.value.Value.Style");
        }
    }

    private static class OfExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private OfExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'of' in @org.immutables.value.Value.Style");
        }
    }

    private static class CopyOfExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private CopyOfExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'copyOf' in @org.immutables.value.Value.Style");
        }
    }

    private static class PutAllExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private PutAllExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'putAll' in @org.immutables.value.Value.Style");
        }
    }

    private static class PutExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private PutExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'put' in @org.immutables.value.Value.Style");
        }
    }

    private static class AddAllExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private AddAllExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'addAll' in @org.immutables.value.Value.Style");
        }
    }

    private static class AddExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private AddExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'add' in @org.immutables.value.Value.Style");
        }
    }

    private static class WithExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private WithExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'with' in @org.immutables.value.Value.Style");
        }
    }

    private static class InitExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private InitExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'init' in @org.immutables.value.Value.Style");
        }
    }

    private static class GetExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private GetExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'get' in @org.immutables.value.Value.Style");
        }
    }
}

