/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.immutables.value.internal.$generator$.$AnnotationMirrors;
import org.immutables.value.internal.$generator$.$Naming;
import org.immutables.value.internal.$generator$.$SourceOrdering;
import org.immutables.value.internal.$guava$.base.$Ascii;
import org.immutables.value.internal.$guava$.base.$CaseFormat;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.meta.$AnnotationPrinting;
import org.immutables.value.internal.$processor$.meta.$AttributeTypeKind;
import org.immutables.value.internal.$processor$.meta.$AuxiliaryMirror;
import org.immutables.value.internal.$processor$.meta.$DefaultMirror;
import org.immutables.value.internal.$processor$.meta.$ExpectedSubtypesMirror;
import org.immutables.value.internal.$processor$.meta.$FParameterMirror;
import org.immutables.value.internal.$processor$.meta.$IdMirror;
import org.immutables.value.internal.$processor$.meta.$IgnoreMirror;
import org.immutables.value.internal.$processor$.meta.$JsonPropertyMirror;
import org.immutables.value.internal.$processor$.meta.$NamedMirror;
import org.immutables.value.internal.$processor$.meta.$NaturalOrderMirror;
import org.immutables.value.internal.$processor$.meta.$ParameterMirror;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$ReverseOrderMirror;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$SwitchMirror;
import org.immutables.value.internal.$processor$.meta.$TypeIntrospectionBase;
import org.immutables.value.internal.$processor$.meta.$UnshadeGuava;
import org.immutables.value.internal.$processor$.meta.$ValueType;

public final class $ValueAttribute
extends $TypeIntrospectionBase {
    private static final String GUAVA_IMMUTABLE_PREFIX = $UnshadeGuava.typeString("collect.Immutable");
    private static final String NULLABLE_SIMPLE_NAME = "Nullable";
    private static final String ID_ATTRIBUTE_NAME = "_id";
    public $Styles.UsingName.AttributeNames names;
    public boolean isGenerateDefault;
    public boolean isGenerateDerived;
    public boolean isGenerateAbstract;
    public boolean isGenerateLazy;
    public $ImmutableList<String> typeParameters = $ImmutableList.of();
    public $Reporter reporter;
    public $ValueType containingType;
    TypeMirror returnType;
    Element element;
    String returnTypeName;
    private boolean hasEnumFirstTypeParameter;
    @Nullable
    private TypeElement containedTypeElement;
    @Nullable
    private TypeElement containedSecondaryTypeElement;
    private boolean generateOrdinalValueSet;
    private TypeMirror arrayComponent;
    private boolean nullable;
    private String nullabilityPrefix;
    @Nullable
    private String rawTypeName;
    @Nullable
    private String serializedName;
    private OrderKind orderKind = OrderKind.NONE;
    @Nullable
    private CharSequence defaultInterface;
    @Nullable
    private List<String> expectedSubtypes;
    private int constructorOrder = Integer.MIN_VALUE;
    private $AttributeTypeKind typeKind;
    @Nullable
    public SwitcherModel builderSwitcherModel;
    public boolean isBuilderParameter;
    boolean hasSomeUnresolvedTypes;

    public String name() {
        return this.names.raw;
    }

    public boolean isBoolean() {
        return this.returnType.getKind() == TypeKind.BOOLEAN;
    }

    public boolean isInt() {
        return this.returnType.getKind() == TypeKind.INT;
    }

    public boolean isLong() {
        return this.returnType.getKind() == TypeKind.LONG;
    }

    public boolean isStringType() {
        return this.returnTypeName.equals(String.class.getName());
    }

    public boolean charType() {
        return this.returnType.getKind() == TypeKind.CHAR;
    }

    public String atNullability() {
        return this.isNullable() ? this.nullabilityPrefix : "";
    }

    public boolean isSimpleLiteralType() {
        return this.isPrimitive() || this.isStringType() || this.isEnumType();
    }

    public boolean isMandatory() {
        return this.isGenerateAbstract && !this.isContainerType() && !this.isNullable() && !this.hasBuilderSwitcherDefault();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isComparable() {
        return this.isNumberType() || this.isStringType() || super.isComparable();
    }

    public String getSerializedName() {
        if (this.serializedName == null) {
            this.serializedName = this.readSerializedName();
        }
        return this.serializedName;
    }

    public String getMarshaledName() {
        String serializedName = this.getSerializedName();
        if (!serializedName.isEmpty()) {
            return serializedName;
        }
        return this.name();
    }

    private String readSerializedName() {
        String value;
        String value2;
        $Optional<$NamedMirror> namedAnnotation = $NamedMirror.find(this.element);
        if (namedAnnotation.isPresent() && !(value2 = namedAnnotation.get().value()).isEmpty()) {
            return value2;
        }
        $Optional<$JsonPropertyMirror> jsonProperty = $JsonPropertyMirror.find(this.element);
        if (jsonProperty.isPresent() && !(value = jsonProperty.get().value()).isEmpty()) {
            return value;
        }
        if (this.isMarkedAsMongoId()) {
            return ID_ATTRIBUTE_NAME;
        }
        return "";
    }

    public boolean isForcedEmpty() {
        return !this.containingType.gsonTypeAdapters().emptyAsNulls();
    }

    @Override
    protected TypeMirror internalTypeMirror() {
        return this.returnType;
    }

    public String getType() {
        return this.returnTypeName;
    }

    public List<CharSequence> getAnnotations() {
        return $AnnotationPrinting.getAnnotationLines(this.element);
    }

    public boolean isGsonIgnore() {
        return $IgnoreMirror.isPresent(this.element);
    }

    public List<String> typeParameters() {
        this.ensureTypeIntrospected();
        return this.arrayComponent != null ? $ImmutableList.of(this.arrayComponent.toString()) : this.typeParameters;
    }

    public boolean isMapType() {
        return this.typeKind.isMappingKind();
    }

    public boolean isMultimapType() {
        return this.typeKind.isMultimapKind();
    }

    public boolean isListType() {
        return this.typeKind.isList();
    }

    public boolean isSetType() {
        return this.typeKind.isSet();
    }

    public boolean hasNaturalOrder() {
        return this.orderKind == OrderKind.NATURAL;
    }

    public boolean hasReverseOrder() {
        return this.orderKind == OrderKind.REVERSE;
    }

    public boolean isSortedSetType() {
        return this.typeKind.isSortedSet();
    }

    public boolean isSortedMapType() {
        return this.typeKind.isSortedMap();
    }

    public boolean isGenerateSortedSet() {
        return this.typeKind.isSortedSet();
    }

    public boolean isGenerateSortedMap() {
        return this.typeKind.isSortedMap();
    }

    private void checkOrderAnnotations() {
        $Optional<$NaturalOrderMirror> naturalOrderAnnotation = $NaturalOrderMirror.find(this.element);
        $Optional<$ReverseOrderMirror> reverseOrderAnnotation = $ReverseOrderMirror.find(this.element);
        if (naturalOrderAnnotation.isPresent() && reverseOrderAnnotation.isPresent()) {
            this.report().error("@Value.Natural and @Value.Reverse annotations could not be used on the same attribute", new Object[0]);
        } else if (naturalOrderAnnotation.isPresent()) {
            if (this.typeKind.isSortedKind()) {
                if (this.isComparable()) {
                    this.orderKind = OrderKind.NATURAL;
                } else {
                    this.report().annotationNamed($NaturalOrderMirror.simpleName()).error("@Value.Natural should used on a set of Comparable elements (map keys)", new Object[0]);
                }
            } else {
                this.report().annotationNamed($NaturalOrderMirror.simpleName()).error("@Value.Natural should specify order for SortedSet, SortedMap, NavigableSet or NavigableMap attributes", new Object[0]);
            }
        } else if (reverseOrderAnnotation.isPresent()) {
            if (this.typeKind.isSortedKind()) {
                if (this.isComparable()) {
                    this.orderKind = OrderKind.REVERSE;
                } else {
                    this.report().annotationNamed($ReverseOrderMirror.simpleName()).error("@Value.Reverse should used with a set of Comparable elements", new Object[0]);
                }
            } else {
                this.report().annotationNamed($ReverseOrderMirror.simpleName()).error("@Value.Reverse should specify order for SortedSet, SortedMap, NavigableSet or NavigableMap attributes", new Object[0]);
            }
        }
    }

    public boolean isJdkOptional() {
        return this.typeKind.isOptionalKind() && this.typeKind.isJdkOnlyContainerKind();
    }

    public boolean isJdkSpecializedOptional() {
        return this.typeKind.isOptionalSpecializedJdk();
    }

    public boolean isOptionalType() {
        return this.typeKind.isOptionalKind();
    }

    public boolean isCollectionType() {
        return this.typeKind.isCollectionKind();
    }

    public boolean isGenerateEnumSet() {
        return this.typeKind.isEnumSet();
    }

    public boolean isGuavaImmutableDeclared() {
        return this.typeKind.isContainerKind() && this.rawTypeName.startsWith(GUAVA_IMMUTABLE_PREFIX);
    }

    public CharSequence defaultInterface() {
        if (this.defaultInterface == null) {
            this.defaultInterface = this.inferDefaultInterface();
        }
        return this.defaultInterface;
    }

    private CharSequence inferDefaultInterface() {
        if (this.element.getEnclosingElement().getKind() == ElementKind.INTERFACE && !this.element.getModifiers().contains((Object)Modifier.ABSTRACT) && this.containingType.element.getKind() == ElementKind.INTERFACE) {
            return this.containingType.typeAbstract().relative();
        }
        return "";
    }

    public boolean isGenerateEnumMap() {
        return this.typeKind.isEnumMap();
    }

    public String getUnwrappedElementType() {
        return this.isContainerType() ? $ValueAttribute.unwrapType(this.containmentTypeName()) : this.getElementType();
    }

    public String getWrappedElementType() {
        return $ValueAttribute.wrapType(this.containmentTypeName());
    }

    private String containmentTypeName() {
        return this.isArrayType() || this.isContainerType() ? this.firstTypeParameter() : this.returnTypeName;
    }

    public String getRawType() {
        return this.rawTypeName;
    }

    public String getConsumedElementType() {
        return this.isUnwrappedElementPrimitiveType() || String.class.getName().equals(this.containmentTypeName()) || this.hasEnumFirstTypeParameter ? this.getWrappedElementType() : "? extends " + this.getWrappedElementType();
    }

    private String extractRawType(String className) {
        int endOfTypeAnnotations;
        String rawType = className;
        int indexOfGenerics = rawType.indexOf(60);
        if (indexOfGenerics > 0) {
            rawType = rawType.substring(0, indexOfGenerics);
        }
        if ((endOfTypeAnnotations = rawType.lastIndexOf(32)) > 0) {
            rawType = rawType.substring(endOfTypeAnnotations + 1);
        }
        return rawType;
    }

    public boolean isUnwrappedElementPrimitiveType() {
        return $ValueAttribute.isPrimitiveType(this.getUnwrappedElementType());
    }

    public boolean isUnwrappedSecondaryElementPrimitiveType() {
        return $ValueAttribute.isPrimitiveType(this.getUnwrappedSecondaryElementType());
    }

    public String firstTypeParameter() {
        return $Iterables.getFirst(this.typeParameters(), "");
    }

    public String secondTypeParameter() {
        return $Iterables.get(this.typeParameters(), 1);
    }

    public String getElementType() {
        return this.containmentTypeName();
    }

    public List<String> getExpectedSubtypes() {
        if (this.expectedSubtypes == null) {
            this.ensureTypeIntrospected();
            if (this.containedTypeElement != null || this.containedSecondaryTypeElement != null) {
                TypeElement supertypeElement = $MoreObjects.firstNonNull(this.containedSecondaryTypeElement, this.containedTypeElement);
                $Optional<$ExpectedSubtypesMirror> annotationOnAttribute = $ExpectedSubtypesMirror.find(this.element);
                if (annotationOnAttribute.isPresent()) {
                    this.expectedSubtypes = $ImmutableList.copyOf(annotationOnAttribute.get().valueName());
                    if (this.expectedSubtypes.isEmpty()) {
                        this.expectedSubtypes = this.tryFindSubtypes(supertypeElement);
                    }
                } else {
                    $Optional<$ExpectedSubtypesMirror> annotationOnType = $ExpectedSubtypesMirror.find(supertypeElement);
                    if (annotationOnType.isPresent()) {
                        this.expectedSubtypes = $ImmutableList.copyOf(annotationOnType.get().valueName());
                        if (this.expectedSubtypes.isEmpty()) {
                            this.expectedSubtypes = this.tryFindSubtypes(supertypeElement);
                        }
                    }
                }
            }
            if (this.expectedSubtypes == null) {
                this.expectedSubtypes = $ImmutableList.of();
            }
        }
        return this.expectedSubtypes;
    }

    private $ImmutableList<String> tryFindSubtypes(TypeElement supertypeElement) {
        $ValueType surroundingType = $MoreObjects.firstNonNull(this.containingType.enclosingValue, this.containingType);
        Set<$ValueType> subtypes = surroundingType.getCases().knownSubtypesOf(supertypeElement.getQualifiedName().toString());
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for ($ValueType valueType : subtypes) {
            builder.add(valueType.typeAbstract().toString());
        }
        return builder.build();
    }

    public boolean isGenerateJdkOnly() {
        return this.containingType.isGenerateJdkOnly() && !this.typeKind.isGuavaContainerKind() && !this.isGuavaImmutableDeclared();
    }

    public boolean isGenerateOrdinalValueSet() {
        if (!this.isSetType()) {
            return false;
        }
        this.ensureTypeIntrospected();
        return this.generateOrdinalValueSet;
    }

    public boolean isArrayType() {
        return this.typeKind.isArray();
    }

    @Override
    protected void introspectType() {
        TypeMirror typeMirror = this.returnType;
        if (this.typeKind.isOptionalSpecializedJdk()) {
            this.typeParameters = $ImmutableList.of(this.optionalSpecializedType());
            return;
        }
        if (this.isContainerType()) {
            DeclaredType declaredType;
            List<? extends TypeMirror> typeArguments;
            if (!(typeMirror.getKind() != TypeKind.DECLARED && typeMirror.getKind() != TypeKind.ERROR || (typeArguments = (declaredType = (DeclaredType)typeMirror).getTypeArguments()).isEmpty())) {
                TypeMirror typeSecondArgument;
                final TypeMirror typeArgument = typeArguments.get(0);
                $TypeIntrospectionBase firstTypeParameterIntrospection = new $TypeIntrospectionBase(){

                    @Override
                    protected TypeMirror internalTypeMirror() {
                        return typeArgument;
                    }
                };
                if (this.isSetType()) {
                    this.generateOrdinalValueSet = firstTypeParameterIntrospection.isOrdinalValue();
                }
                if (this.isSetType() || this.isMapType()) {
                    this.hasEnumFirstTypeParameter = firstTypeParameterIntrospection.isEnumType();
                }
                if (this.isMapType() && (typeSecondArgument = typeArguments.get(1)).getKind() == TypeKind.DECLARED) {
                    TypeElement typeElement;
                    this.containedSecondaryTypeElement = typeElement = (TypeElement)((DeclaredType)typeSecondArgument).asElement();
                }
                typeMirror = typeArgument;
            }
        } else if (this.isArrayType()) {
            typeMirror = this.arrayComponent = ((ArrayType)typeMirror).getComponentType();
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            TypeElement typeElement;
            this.containedTypeElement = typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
        }
        this.intospectTypeMirror(typeMirror);
    }

    private String optionalSpecializedType() {
        switch (this.typeKind) {
            case OPTIONAL_INT_JDK: {
                return Integer.TYPE.getName();
            }
            case OPTIONAL_LONG_JDK: {
                return Long.TYPE.getName();
            }
            case OPTIONAL_DOUBLE_JDK: {
                return Double.TYPE.getName();
            }
        }
        throw new AssertionError();
    }

    public $AttributeTypeKind typeKind() {
        return this.typeKind;
    }

    private static boolean isRegularMarshalableType(String name, boolean couldBeWrapped) {
        return String.class.getName().equals(name) || (couldBeWrapped ? $ValueAttribute.isPrimitiveOrWrapped(name) : $ValueAttribute.isPrimitiveType(name));
    }

    public boolean isRequiresMarshalingAdapter() {
        return !$ValueAttribute.isRegularMarshalableType(this.getElementType(), this.isContainerType());
    }

    public boolean isRequiresMarshalingSecondaryAdapter() {
        return this.isMapType() && !$ValueAttribute.isRegularMarshalableType(this.getSecondaryElementType(), true);
    }

    public boolean wrapArrayToIterable() {
        return this.containingType.isGenerateJdkOnly() || this.isUnwrappedElementPrimitiveType() || !this.typeKind.isList() && !this.typeKind.isSet() && !this.typeKind.isMultiset();
    }

    public String getRawCollectionType() {
        return this.typeKind.rawSimpleName();
    }

    public boolean isMultisetType() {
        return this.typeKind.isMultiset();
    }

    public String getRawMapType() {
        return this.typeKind.rawSimpleName();
    }

    public String getSecondaryElementType() {
        return this.secondTypeParameter();
    }

    public String getUnwrappedSecondaryElementType() {
        return $ValueAttribute.unwrapType(this.secondTypeParameter());
    }

    public String getWrappedSecondaryElementType() {
        return $ValueAttribute.wrapType(this.secondTypeParameter());
    }

    public String getUnwrapperOrRawSecondaryElementType() {
        return this.extractRawType(this.getWrappedSecondaryElementType());
    }

    public String getUnwrapperOrRawElementType() {
        return this.extractRawType(this.getWrappedElementType());
    }

    public boolean isNumberType() {
        TypeKind kind = this.returnType.getKind();
        return kind.isPrimitive() && kind != TypeKind.CHAR && kind != TypeKind.BOOLEAN;
    }

    public boolean isFloatType() {
        return this.isFloat() || this.isDouble();
    }

    public boolean isFloat() {
        return this.returnType.getKind() == TypeKind.FLOAT;
    }

    public boolean isDouble() {
        return this.returnType.getKind() == TypeKind.DOUBLE;
    }

    public boolean isNonRawElemementType() {
        return this.getElementType().indexOf(60) > 0;
    }

    public boolean isContainerType() {
        return this.isCollectionType() || this.isOptionalType() || this.isMapType();
    }

    public String getWrapperType() {
        return this.isPrimitive() ? $ValueAttribute.wrapType(this.rawTypeName) : this.returnTypeName;
    }

    public boolean isPrimitive() {
        return this.returnType.getKind().isPrimitive();
    }

    int getConstructorParameterOrder() {
        if (this.constructorOrder < -1) {
            $Optional<$ParameterMirror> parameter = $ParameterMirror.find(this.element);
            this.constructorOrder = parameter.isPresent() ? parameter.get().order() : -1;
        }
        return this.constructorOrder;
    }

    public boolean isConstructorParameter() {
        return this.getConstructorParameterOrder() >= 0;
    }

    public boolean isPrimitiveElement() {
        return $ValueAttribute.isPrimitiveType(this.getUnwrappedElementType());
    }

    public boolean isAuxiliary() {
        return $AuxiliaryMirror.isPresent(this.element);
    }

    private boolean isMarkedAsMongoId() {
        return $IdMirror.isPresent(this.element);
    }

    boolean isIdAttribute() {
        return this.isMarkedAsMongoId() || ID_ATTRIBUTE_NAME.equals(this.getSerializedName());
    }

    void initAndValidate() {
        this.initTypeName();
        this.initTypeKind();
        this.initOrderKind();
        this.initFactoryParamsIfApplicable();
        this.makeRegularAndNullableWithValidation();
        this.makeRegularIfContainsWildcards();
        this.makeRegularIfDefaultWithValidation();
        this.prohibitAuxiliaryOnAnnotationTypes();
    }

    private void initOrderKind() {
        if (this.typeKind.isSortedKind()) {
            this.checkOrderAnnotations();
            if (this.orderKind == OrderKind.NONE) {
                this.typeKind = $AttributeTypeKind.REGULAR;
            }
        }
    }

    private void prohibitAuxiliaryOnAnnotationTypes() {
        if (this.containingType.isAnnotationType() && this.isAuxiliary()) {
            this.report().annotationNamed($AuxiliaryMirror.simpleName()).error("@Value.Auxiliary cannot be used on annotation attribute to not violate annotation spec", new Object[0]);
        }
    }

    private void initTypeName() {
        new TypeStringCollector().processAndAssign();
    }

    private void initTypeKind() {
        if (this.returnType.getKind() == TypeKind.ARRAY) {
            this.typeKind = $AttributeTypeKind.ARRAY;
            this.ensureTypeIntrospected();
        } else {
            this.typeKind = $AttributeTypeKind.forRawType(this.rawTypeName);
            this.ensureTypeIntrospected();
            this.typeKind = this.typeKind.havingEnumFirstTypeParameter(this.hasEnumFirstTypeParameter);
        }
    }

    private void makeRegularIfDefaultWithValidation() {
        if (this.isGenerateDefault && this.isContainerType()) {
            this.typeKind = $AttributeTypeKind.REGULAR;
            this.report().annotationNamed($DefaultMirror.simpleName()).warning("@Value.Default on a container attribute make it lose it's special treatment", new Object[0]);
        }
    }

    private void makeRegularIfContainsWildcards() {
        if (this.returnTypeName.indexOf(63) >= 0) {
            this.typeKind = $AttributeTypeKind.REGULAR;
        }
    }

    private void makeRegularAndNullableWithValidation() {
        for (AnnotationMirror annotationMirror : this.element.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getSimpleName().contentEquals(NULLABLE_SIMPLE_NAME)) continue;
            if (this.isPrimitive()) {
                this.report().annotationNamed(NULLABLE_SIMPLE_NAME).error("@Nullable could not be used with primitive type attibutes", new Object[0]);
                continue;
            }
            this.nullable = true;
            this.nullabilityPrefix = "@" + annotationElement.getQualifiedName() + " ";
            if (!this.nullable) continue;
            this.typeKind = $AttributeTypeKind.REGULAR;
        }
        if (this.containingType.isAnnotationType() && this.nullable) {
            this.report().annotationNamed(NULLABLE_SIMPLE_NAME).error("@Nullable could not be used with annotation attribute, use default value", new Object[0]);
        }
    }

    private void initFactoryParamsIfApplicable() {
        if (!this.containingType.kind().isFactory()) {
            return;
        }
        this.isBuilderParameter = $FParameterMirror.isPresent(this.element);
        $Optional<$SwitchMirror> switcher = $SwitchMirror.find(this.element);
        if (switcher.isPresent()) {
            if (this.isBuilderParameter) {
                this.report().annotationNamed($FParameterMirror.simpleName()).error("@%s and @%s annotations cannot be used on a same factory parameter", $FParameterMirror.simpleName(), $SwitchMirror.simpleName());
                this.isBuilderParameter = false;
            }
            if (!this.isEnumType()) {
                this.report().annotationNamed($SwitchMirror.simpleName()).error("@%s annotation applicable only to enum parameters", $SwitchMirror.simpleName());
            } else {
                this.builderSwitcherModel = new SwitcherModel(switcher.get());
            }
        }
    }

    $Reporter report() {
        return this.reporter.withElement(this.element);
    }

    public String toString() {
        return "Attribute[" + this.name() + "]";
    }

    public boolean hasBuilderSwitcherDefault() {
        return this.isBuilderSwitcher() && this.builderSwitcherModel.hasDefault();
    }

    public boolean isBuilderSwitcher() {
        return this.builderSwitcherModel != null;
    }

    public boolean hasForwardOnlyInitializer() {
        return this.isCollectionType() || this.isMapType();
    }

    public boolean requiresTrackIsSet() {
        return this.containingType.isUseStrictBuilder() && !this.isMandatory() && !this.hasForwardOnlyInitializer() || this.isPrimitive() && this.isGenerateDefault;
    }

    private class TypeStringCollector {
        StringBuilder buffer;
        final List<String> typeParameterStrings = $Lists.newArrayListWithCapacity(2);
        boolean unresolvedTypeHasOccured;
        boolean hasMaybeUnresolvedYetAfter;
        private $ImmutableMap<String, String> sourceClassesImports;
        private final TypeMirror startType;
        private String rawTypeName;

        TypeStringCollector() {
            this.startType = $ValueAttribute.this.returnType;
        }

        void processAndAssign() {
            if (this.startType.getKind().isPrimitive()) {
                String typeName = $Ascii.toLowerCase(this.startType.getKind().name());
                $ValueAttribute.this.rawTypeName = typeName;
                $ValueAttribute.this.returnTypeName = typeName;
                List<? extends AnnotationMirror> annotations = $AnnotationMirrors.from(this.startType);
                if (!annotations.isEmpty()) {
                    $ValueAttribute.this.returnTypeName = this.typeAnnotationsToBuffer(annotations).append(typeName).toString();
                }
            } else {
                this.buffer = new StringBuilder(100);
                this.caseType(this.startType);
                $ValueAttribute.this.hasSomeUnresolvedTypes = this.hasMaybeUnresolvedYetAfter;
                $ValueAttribute.this.returnTypeName = this.buffer.toString();
                $ValueAttribute.this.rawTypeName = this.rawTypeName;
                if (!this.typeParameterStrings.isEmpty()) {
                    $ValueAttribute.this.typeParameters = $ImmutableList.copyOf(this.typeParameterStrings);
                }
            }
        }

        private void appendResolved(DeclaredType type) {
            boolean assumedNotQualified;
            int mark = this.buffer.length();
            TypeElement typeElement = (TypeElement)type.asElement();
            String typeName = typeElement.getQualifiedName().toString();
            if (this.unresolvedTypeHasOccured && (assumedNotQualified = $Ascii.isUpperCase(typeName.charAt(0)))) {
                typeName = this.resolveIfPossible(typeName);
            }
            this.buffer.append(typeName);
            if (this.isStartLevel(type)) {
                this.rawTypeName = typeName;
            }
            if (this.isStartLevel(type)) {
                this.insertTypeAnnotationsIfPresent(type, mark);
            }
        }

        private String resolveIfPossible(String typeName) {
            String resolved;
            String resolvable = typeName;
            int indexOfDot = resolvable.indexOf(46);
            if (indexOfDot > 0) {
                resolvable = resolvable.substring(0, indexOfDot);
            }
            if ((resolved = this.getFromSourceImports(resolvable)) != null) {
                typeName = indexOfDot > 0 ? resolved + '.' + resolvable.substring(indexOfDot + 1) : resolved;
            } else {
                this.hasMaybeUnresolvedYetAfter = true;
            }
            return typeName;
        }

        @Nullable
        private String getFromSourceImports(String resolvable) {
            if (this.sourceClassesImports == null) {
                this.sourceClassesImports = $ValueAttribute.this.containingType.constitution.protoclass().sourceImports().classes;
            }
            return this.sourceClassesImports.get(resolvable);
        }

        private void insertTypeAnnotationsIfPresent(DeclaredType type, int mark) {
            List<? extends AnnotationMirror> annotations = $AnnotationMirrors.from(type);
            if (!annotations.isEmpty()) {
                StringBuilder annotationBuffer = this.typeAnnotationsToBuffer(annotations);
                int insertionIndex = mark + this.buffer.substring(mark).lastIndexOf(".") + 1;
                this.buffer.insert(insertionIndex, annotationBuffer);
            }
        }

        private StringBuilder typeAnnotationsToBuffer(List<? extends AnnotationMirror> annotations) {
            StringBuilder annotationBuffer = new StringBuilder(100);
            for (AnnotationMirror annotationMirror : annotations) {
                annotationBuffer.append($AnnotationMirrors.toCharSequence(annotationMirror)).append(' ');
            }
            return annotationBuffer;
        }

        void caseType(TypeMirror type) {
            switch (type.getKind()) {
                case ERROR: {
                    $Verify.verify(type instanceof DeclaredType);
                    this.unresolvedTypeHasOccured = true;
                }
                case DECLARED: {
                    DeclaredType declaredType = (DeclaredType)type;
                    this.appendResolved(declaredType);
                    this.appendTypeArguments(type, declaredType);
                    break;
                }
                case ARRAY: {
                    TypeMirror componentType = ((ArrayType)type).getComponentType();
                    int mark = this.buffer.length();
                    this.caseType(componentType);
                    this.cutTypeArgument(type, mark);
                    this.buffer.append("[]");
                    break;
                }
                case WILDCARD: {
                    WildcardType wildcard = (WildcardType)type;
                    TypeMirror extendsBound = wildcard.getExtendsBound();
                    TypeMirror superBound = wildcard.getSuperBound();
                    if (extendsBound != null) {
                        this.buffer.append("? extends ");
                        this.caseType(extendsBound);
                        break;
                    }
                    if (superBound != null) {
                        this.buffer.append("? super ");
                        this.caseType(superBound);
                        break;
                    }
                    this.buffer.append("?");
                    break;
                }
                default: {
                    if (type.getKind().isPrimitive()) {
                        List<? extends AnnotationMirror> annotations = $AnnotationMirrors.from(type);
                        if (!annotations.isEmpty()) {
                            this.buffer.append((CharSequence)this.typeAnnotationsToBuffer(annotations)).append(' ');
                        }
                        this.buffer.append(type);
                        break;
                    }
                    this.buffer.append(type);
                }
            }
        }

        private void appendTypeArguments(TypeMirror type, DeclaredType declaredType) {
            List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
            if (!arguments.isEmpty()) {
                this.buffer.append('<');
                boolean notFirst = false;
                for (TypeMirror typeMirror : arguments) {
                    if (notFirst) {
                        this.buffer.append(", ");
                    }
                    notFirst = true;
                    int mark = this.buffer.length();
                    this.caseType(typeMirror);
                    this.cutTypeArgument(type, mark);
                }
                this.buffer.append('>');
            }
        }

        private void cutTypeArgument(TypeMirror type, int mark) {
            if (this.isStartLevel(type)) {
                this.typeParameterStrings.add(this.buffer.substring(mark));
            }
        }

        boolean isStartLevel(TypeMirror type) {
            return this.startType == type;
        }
    }

    public final class SwitcherModel {
        private final $Naming switcherNaming;
        public final $ImmutableList<SwitchOption> options;
        private final String defaultName;

        SwitcherModel($SwitchMirror mirror) {
            this.switcherNaming = $Naming.from($ValueAttribute.this.name()).requireNonConstant($Naming.Preference.SUFFIX);
            this.defaultName = mirror.defaultName();
            this.options = this.constructOptions();
        }

        private $ImmutableList<SwitchOption> constructOptions() {
            $ImmutableList.Builder builder = $ImmutableList.builder();
            for (Element v : $SourceOrdering.getEnclosedElements($ValueAttribute.this.containedTypeElement)) {
                if (v.getKind() != ElementKind.ENUM_CONSTANT) continue;
                String name = v.getSimpleName().toString();
                builder.add(new SwitchOption(name, this.defaultName.equals(name)));
            }
            return builder.build();
        }

        public boolean hasDefault() {
            return !this.defaultName.isEmpty();
        }

        public final class SwitchOption {
            public final boolean isDefault;
            public final String constantName;
            public final String switcherName;

            public SwitchOption(String constantName, boolean isDefault) {
                this.constantName = constantName;
                this.switcherName = this.deriveSwitcherName(constantName);
                this.isDefault = isDefault;
            }

            private String deriveSwitcherName(String constantName) {
                return SwitcherModel.this.switcherNaming.apply($CaseFormat.UPPER_UNDERSCORE.to($CaseFormat.LOWER_CAMEL, constantName));
            }
        }
    }

    private static enum OrderKind {
        NONE,
        NATURAL,
        REVERSE;

    }
}

