/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.immutables.value.internal.$generator$.$PostprocessingMachine;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.io.$CharStreams;

public final class $SourceExtraction {
    private static final SourceExtractor DEFAULT_EXTRACTOR = new SourceExtractor(){

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement element) throws IOException {
            FileObject resource = environment.getFiler().getResource(StandardLocation.SOURCE_PATH, "", this.toFilename(element));
            try (Reader reader = resource.openReader(true);){
                String string = $CharStreams.toString(reader);
                return string;
            }
        }

        private String toFilename(TypeElement element) {
            return element.getQualifiedName().toString().replace('.', '/') + ".java";
        }
    };
    private static final SourceExtractor EXTRACTOR = $SourceExtraction.createExtractor();

    private $SourceExtraction() {
    }

    public static Imports readImports(ProcessingEnvironment environment, TypeElement element) {
        try {
            Imports imports = $PostprocessingMachine.collectImports($SourceExtraction.extract(environment, element));
            return imports;
        }
        catch (IOException ex) {
            return Imports.empty();
        }
    }

    public static CharSequence extract(ProcessingEnvironment environment, TypeElement element) throws IOException {
        return EXTRACTOR.extract(environment, element);
    }

    private static SourceExtractor createExtractor() {
        try {
            return new EclipseSourceExtractor();
        }
        catch (Throwable throwable) {
            return DEFAULT_EXTRACTOR;
        }
    }

    private static final class EclipseSourceExtractor
    implements SourceExtractor {
        private EclipseSourceExtractor() {
        }

        @Override
        public CharSequence extract(ProcessingEnvironment environment, TypeElement typeElement) throws IOException {
            Binding binding;
            if (typeElement instanceof ElementImpl && (binding = ((ElementImpl)typeElement)._binding) instanceof SourceTypeBinding) {
                CompilationUnitDeclaration unit = ((SourceTypeBinding)binding).scope.referenceCompilationUnit();
                char[] contents = unit.compilationResult.compilationUnit.getContents();
                return CharBuffer.wrap(contents);
            }
            return DEFAULT_EXTRACTOR.extract(environment, typeElement);
        }

        static {
            ElementImpl.class.getCanonicalName();
        }
    }

    static interface SourceExtractor {
        public CharSequence extract(ProcessingEnvironment var1, TypeElement var2) throws IOException;
    }

    public static final class Imports {
        private static final Imports EMPTY = new Imports($ImmutableSet.of(), $ImmutableMap.of());
        public final $ImmutableSet<String> all;
        public final $ImmutableMap<String, String> classes;

        private Imports(Set<String> all, Map<String, String> classes) {
            $Preconditions.checkState(all.size() >= classes.size());
            this.all = $ImmutableSet.copyOf(all);
            this.classes = $ImmutableMap.copyOf(classes);
        }

        public static Imports of(Set<String> all, Map<String, String> classes) {
            if (all.isEmpty()) {
                return EMPTY;
            }
            return new Imports(all, classes);
        }

        public static Imports empty() {
            return EMPTY;
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }
    }
}

