/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.immutables.value.internal.$guava$.base.$Joiner;
import org.immutables.value.internal.$guava$.collect.$HashMultiset;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Multiset;
import org.immutables.value.internal.$processor$.meta.$AccessorAttributesCollector;
import org.immutables.value.internal.$processor$.meta.$CachingElements;
import org.immutables.value.internal.$processor$.meta.$FactoryMethodAttributesCollector;
import org.immutables.value.internal.$processor$.meta.$ImmutableMirror;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$Round;
import org.immutables.value.internal.$processor$.meta.$UnshadeGuava;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;
import org.immutables.value.internal.$processor$.meta.$ValueType;

public final class $ValueTypeComposer {
    private final ProcessingEnvironment processing;
    private final $Round round;
    @Nullable
    private final String typeMoreObjects;

    $ValueTypeComposer($Round round) {
        this.round = round;
        this.processing = round.processing();
        this.typeMoreObjects = this.inferTypeMoreObjects();
    }

    @Nullable
    String inferTypeMoreObjects() {
        String typeMoreObjects = $UnshadeGuava.typeString("base.MoreObjects");
        String typeObjects = $UnshadeGuava.typeString("base.Objects");
        TypeElement typeElement = this.processing.getElementUtils().getTypeElement(typeMoreObjects);
        if (typeElement != null) {
            return typeMoreObjects;
        }
        typeElement = this.processing.getElementUtils().getTypeElement(typeObjects);
        if (typeElement != null) {
            return typeObjects;
        }
        return null;
    }

    $ValueType compose($Proto.Protoclass protoclass) {
        $ValueType type = new $ValueType();
        type.round = this.round;
        type.typeMoreObjects = this.typeMoreObjects;
        type.element = protoclass.sourceElement();
        type.immutableFeatures = protoclass.features();
        type.constitution = protoclass.constitution();
        if (protoclass.kind().isFactory()) {
            new $FactoryMethodAttributesCollector(protoclass, type).collect();
        } else if (protoclass.kind().isValue()) {
            ArrayList<String> violations = $Lists.newArrayList();
            if ($ValueTypeComposer.checkAbstractValueType(type.element, violations)) {
                this.checkForMutableFields(protoclass, (TypeElement)type.element);
                this.checkForTypeHierarchy(protoclass, type);
                new $AccessorAttributesCollector(protoclass, type).collect();
            } else {
                protoclass.report().error("Value type '%s' %s", protoclass.sourceElement().getSimpleName(), $Joiner.on(", ").join(violations));
            }
        }
        this.checkAttributeNamesForDuplicates(type, protoclass);
        return type;
    }

    private void checkForTypeHierarchy($Proto.Protoclass protoclass, $ValueType type) {
        $ValueTypeComposer.scanAndReportInvalidInheritance(protoclass, type.element, type.extendedClasses());
        $ValueTypeComposer.scanAndReportInvalidInheritance(protoclass, type.element, type.implementedInterfaces());
    }

    private static void scanAndReportInvalidInheritance($Proto.Protoclass protoclass, Element element, Iterable<DeclaredType> supertypes) {
        for (TypeElement supertype : $Iterables.transform(supertypes, $Proto.DeclatedTypeToElement.FUNCTION)) {
            if ($CachingElements.equals(element, supertype) || !$ImmutableMirror.isPresent(supertype)) continue;
            protoclass.report().error("Should not inherit %s which is a value type itself. Avoid extending from another abstract value type. Better to share common abstract class or interface which are not carrying @%s annotation", supertype, $ImmutableMirror.simpleName());
        }
    }

    private void checkForMutableFields($Proto.Protoclass protoclass, TypeElement element) {
        for (VariableElement field : ElementFilter.fieldsIn(this.processing.getElementUtils().getAllMembers($CachingElements.getDelegate(element)))) {
            if (field.getModifiers().contains((Object)Modifier.FINAL)) continue;
            $Reporter report = protoclass.report();
            boolean ownField = $CachingElements.equals(element, field.getEnclosingElement());
            if (ownField) {
                report.withElement(field).warning("Avoid introduction of fields (except constants) in abstract value types", new Object[0]);
                continue;
            }
            report.warning("Abstract value type inherits mutable fields", new Object[0]);
        }
    }

    private void checkAttributeNamesForDuplicates($ValueType type, $Proto.Protoclass protoclass) {
        if (!type.attributes.isEmpty()) {
            $HashMultiset<String> attributeNames = $HashMultiset.create(type.attributes.size());
            for ($ValueAttribute attribute : type.attributes) {
                attributeNames.add(attribute.name());
            }
            ArrayList duplicates = $Lists.newArrayList();
            for ($Multiset.Entry entry : attributeNames.entrySet()) {
                if (entry.getCount() <= 1) continue;
                duplicates.add(entry.getElement());
            }
            if (!duplicates.isEmpty()) {
                protoclass.report().error("Duplicate attribute names %s. You should check if correct @Value.Style applied", duplicates);
            }
        }
    }

    static boolean checkAbstractValueType(Element element, Collection<String> violations) {
        boolean publicOrPackageVisible;
        boolean ofSupportedKind = element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ANNOTATION_TYPE || element.getKind() == ElementKind.CLASS;
        boolean staticOrTopLevel = element.getEnclosingElement().getKind() == ElementKind.PACKAGE || element.getModifiers().contains((Object)Modifier.STATIC);
        boolean nonFinal = !element.getModifiers().contains((Object)Modifier.FINAL);
        boolean hasNoTypeParameters = ((TypeElement)element).getTypeParameters().isEmpty();
        boolean bl = publicOrPackageVisible = !element.getModifiers().contains((Object)Modifier.PRIVATE) && !element.getModifiers().contains((Object)Modifier.PROTECTED);
        if (!ofSupportedKind) {
            violations.add("must be class or interface or annotation type");
        }
        if (!nonFinal) {
            violations.add("must be non-final");
        }
        if (!hasNoTypeParameters) {
            violations.add("should have no type parameters");
        }
        if (!publicOrPackageVisible) {
            violations.add("should be public or package-visible");
        }
        if (!staticOrTopLevel) {
            violations.add("should be top-level or static inner class");
        }
        return violations.isEmpty();
    }
}

