/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.primitives.$Booleans;
import org.immutables.value.internal.$processor$.meta.$GsonMirrors;

public class $TypeAdaptersMirror
implements $GsonMirrors.TypeAdapters {
    public static final String QUALIFIED_NAME = "org.immutables.gson.Gson.TypeAdapters";
    private final AnnotationMirror annotationMirror;
    private final boolean fieldNamingStrategy;
    private final boolean emptyAsNulls;

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "TypeAdapters";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$TypeAdaptersMirror> find(Element element) {
        return $TypeAdaptersMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$TypeAdaptersMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $TypeAdaptersMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$TypeAdaptersMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $TypeAdaptersMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $TypeAdaptersMirror from(TypeElement element) {
        return new $TypeAdaptersMirror(element);
    }

    public static $Optional<$TypeAdaptersMirror> from(AnnotationMirror mirror) {
        return $TypeAdaptersMirror.find(Collections.singleton(mirror));
    }

    private $TypeAdaptersMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME));
        this.annotationMirror = null;
        boolean fieldNamingStrategy = false;
        boolean emptyAsNulls = false;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("fieldNamingStrategy".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @TypeAdapters");
                }
                FieldNamingStrategyExtractor fieldNamingStrategyExtractor$ = new FieldNamingStrategyExtractor();
                annotationValue$.accept(fieldNamingStrategyExtractor$, null);
                fieldNamingStrategy = fieldNamingStrategyExtractor$.get();
                continue;
            }
            if (!"emptyAsNulls".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @TypeAdapters");
            }
            EmptyAsNullsExtractor emptyAsNullsExtractor$ = new EmptyAsNullsExtractor();
            annotationValue$.accept(emptyAsNullsExtractor$, null);
            emptyAsNulls = emptyAsNullsExtractor$.get();
        }
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.emptyAsNulls = emptyAsNulls;
    }

    private $TypeAdaptersMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        boolean fieldNamingStrategy = false;
        boolean emptyAsNulls = false;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("fieldNamingStrategy".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'fieldNamingStrategy' attribute of @TypeAdapters");
                }
                FieldNamingStrategyExtractor fieldNamingStrategyExtractor$ = new FieldNamingStrategyExtractor();
                annotationValue$.accept(fieldNamingStrategyExtractor$, null);
                fieldNamingStrategy = fieldNamingStrategyExtractor$.get();
                continue;
            }
            if (!"emptyAsNulls".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'emptyAsNulls' attribute of @TypeAdapters");
            }
            EmptyAsNullsExtractor emptyAsNullsExtractor$ = new EmptyAsNullsExtractor();
            annotationValue$.accept(emptyAsNullsExtractor$, null);
            emptyAsNulls = emptyAsNullsExtractor$.get();
        }
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.emptyAsNulls = emptyAsNulls;
    }

    @Override
    public boolean fieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    @Override
    public boolean emptyAsNulls() {
        return this.emptyAsNulls;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return $GsonMirrors.TypeAdapters.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "fieldNamingStrategy".hashCode() ^ $Booleans.hashCode(this.fieldNamingStrategy);
        return h += 127 * "emptyAsNulls".hashCode() ^ $Booleans.hashCode(this.emptyAsNulls);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $TypeAdaptersMirror) {
            $TypeAdaptersMirror otherMirror = ($TypeAdaptersMirror)other;
            return this.fieldNamingStrategy == otherMirror.fieldNamingStrategy && this.emptyAsNulls == otherMirror.emptyAsNulls;
        }
        return false;
    }

    @Override
    public String toString() {
        return "TypeAdaptersMirror:" + this.annotationMirror;
    }

    private static class EmptyAsNullsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private EmptyAsNullsExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'emptyAsNulls' in @org.immutables.gson.Gson.TypeAdapters");
        }
    }

    private static class FieldNamingStrategyExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private FieldNamingStrategyExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'fieldNamingStrategy' in @org.immutables.gson.Gson.TypeAdapters");
        }
    }
}

