/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import org.immutables.value.internal.$generator$.$SourceExtraction;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Predicate;
import org.immutables.value.internal.$guava$.collect.$FluentIterable;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$processor$.meta.$AstMirror;
import org.immutables.value.internal.$processor$.meta.$CachingElements;
import org.immutables.value.internal.$processor$.meta.$Constitution;
import org.immutables.value.internal.$processor$.meta.$EnclosingMirror;
import org.immutables.value.internal.$processor$.meta.$FactoryMirror;
import org.immutables.value.internal.$processor$.meta.$FunctionalMirror;
import org.immutables.value.internal.$processor$.meta.$ImmutableConstitution;
import org.immutables.value.internal.$processor$.meta.$ImmutableMirror;
import org.immutables.value.internal.$processor$.meta.$ImmutableProto;
import org.immutables.value.internal.$processor$.meta.$ImmutableStyleInfo;
import org.immutables.value.internal.$processor$.meta.$ImmutableValueImmutableInfo;
import org.immutables.value.internal.$processor$.meta.$IncludeMirror;
import org.immutables.value.internal.$processor$.meta.$ModifiableMirror;
import org.immutables.value.internal.$processor$.meta.$OkTypeAdaptersMirror;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$RepositoryMirror;
import org.immutables.value.internal.$processor$.meta.$Round;
import org.immutables.value.internal.$processor$.meta.$SourceNames;
import org.immutables.value.internal.$processor$.meta.$StructuralMirror;
import org.immutables.value.internal.$processor$.meta.$StyleInfo;
import org.immutables.value.internal.$processor$.meta.$StyleMirror;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$TransformMirror;
import org.immutables.value.internal.$processor$.meta.$TypeAdaptersMirror;
import org.immutables.value.internal.$processor$.meta.$ValueImmutableInfo;
import org.immutables.value.internal.$processor$.meta.$ValueType;
import org.immutables.value.internal.$processor$.meta.$VersionMirror;
import org.immutables.value.internal.$processor$.meta.$Visibility;

public class $Proto {
    private static final $ImmutableSet<String> JACKSON_MAPPING_ANNOTATION_CLASSES = $ImmutableSet.of("com.fasterxml.jackson.databind.annotation.JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonDeserialize");

    private $Proto() {
    }

    static boolean isJacksonSerializedAnnotated(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!JACKSON_MAPPING_ANNOTATION_CLASSES.contains(annotationElement.getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    static boolean isJacksonDeserializedAnnotated(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!"com.fasterxml.jackson.databind.annotation.JsonDeserialize".equals(annotationElement.getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    static boolean isJacksonJsonTypeInfoAnnotated(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!"com.fasterxml.jackson.annotation.JsonTypeInfo".equals(annotationElement.getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    static enum ToStyleInfo implements $Function<$StyleMirror, $StyleInfo>
    {
        FUNCTION;


        @Override
        public $StyleInfo apply($StyleMirror input) {
            return $ImmutableStyleInfo.of(input.get(), input.init(), input.with(), input.add(), input.addAll(), input.put(), input.putAll(), input.copyOf(), input.of(), input.instance(), input.builder(), input.newBuilder(), input.from(), input.build(), input.buildOrThrow(), input.isInitialized(), input.isSet(), input.set(), input.unset(), input.clear(), input.create(), input.toImmutable(), input.typeBuilder(), input.typeInnerBuilder(), input.typeAbstract(), input.typeImmutable(), input.typeImmutableEnclosing(), input.typeImmutableNested(), input.typeModifiable(), input.typeWith(), ToImmutableInfo.FUNCTION.apply(input.defaults()), input.strictBuilder(), input.allParameters(), input.defaultAsDefault(), input.headerComments(), input.jdkOnly(), $ImmutableSet.copyOf(input.passAnnotationsName()), $ImmutableSet.copyOf(input.additionalJsonAnnotationsName()), input.visibility(), input.optionalAcceptNullable(), input.generateSuppressAllWarnings(), input.privateNoargConstructor(), input.attributelessSingleton(), input.unsafeDefaultAndDerived(), input.clearBuilder(), input.deepImmutablesDetection(), input.overshadowImplementation(), input.implementationNestedInBuilder(), input.builderVisibility(), input.throwForInvalidImmutableStateName());
        }
    }

    static enum ToImmutableInfo implements $Function<$ImmutableMirror, $ValueImmutableInfo>
    {
        FUNCTION;


        @Override
        public $ValueImmutableInfo apply($ImmutableMirror input) {
            return $ImmutableValueImmutableInfo.theOf(input.builder(), input.copy(), input.intern(), input.prehash(), input.singleton()).withIsDefault(input.getAnnotationMirror().getElementValues().isEmpty());
        }
    }

    static enum IsPublic implements $Predicate<Element>
    {
        PREDICATE;


        @Override
        public boolean apply(Element input) {
            return input.getModifiers().contains((Object)Modifier.PUBLIC);
        }
    }

    static enum DeclatedTypeToElement implements $Function<DeclaredType, TypeElement>
    {
        FUNCTION;


        @Override
        public TypeElement apply(DeclaredType input) {
            return (TypeElement)input.asElement();
        }
    }

    static enum ElementToName implements $Function<TypeElement, String>
    {
        FUNCTION;


        @Override
        public String apply(TypeElement input) {
            return input.getQualifiedName().toString();
        }
    }

    public static abstract class Protoclass
    extends Diagnosable {
        public String name() {
            return $SourceNames.sourceQualifiedNameFor(this.sourceElement());
        }

        public abstract Element sourceElement();

        public abstract DeclaringPackage packageOf();

        public abstract $Optional<DeclaringType> declaringType();

        public $Optional<$RepositoryMirror> repository() {
            $Optional<Object> repositoryMirror;
            if (!this.declaringType().isPresent()) {
                return $Optional.absent();
            }
            $Optional<Object> $Optional = repositoryMirror = this.kind().isIncluded() || this.kind().isDefinedValue() ? this.declaringType().get().repository() : $Optional.absent();
            if (repositoryMirror.isPresent() && !this.typeAdaptersProvider().isPresent()) {
                if (this.kind().isNested()) {
                    this.report().annotationNamed($RepositoryMirror.simpleName()).error("@Mongo.%s should also have associated @Gson.%s on a top level type.", $RepositoryMirror.simpleName(), $TypeAdaptersMirror.simpleName());
                } else {
                    this.report().annotationNamed($RepositoryMirror.simpleName()).warning("@Mongo.%s types better have explicit @Gson.%s annotation be placed on the class or enclosing package. It is also common to forget to generate type adapters for nested document classes, which will fallback to reflective Gson adapter otherwise.", $RepositoryMirror.simpleName(), $TypeAdaptersMirror.simpleName());
                }
            }
            return repositoryMirror;
        }

        public $Optional<$TypeAdaptersMirror> gsonTypeAdapters() {
            $Optional<AbstractDeclaring> typeAdaptersProvider = this.typeAdaptersProvider();
            if (typeAdaptersProvider.isPresent()) {
                return typeAdaptersProvider.get().typeAdapters();
            }
            if ((this.kind().isDefinedValue() || this.kind().isIncluded()) && !this.kind().isNested() && this.repository().isPresent()) {
                return $Optional.of(this.environment().defaultTypeAdapters());
            }
            return $Optional.absent();
        }

        public $Optional<AbstractDeclaring> typeAdaptersProvider() {
            $Optional typeDefining = this.declaringType().isPresent() ? $Optional.of(this.declaringType().get().associatedTopLevel()) : $Optional.absent();
            $Optional typeDefined = typeDefining.isPresent() ? ((DeclaringType)typeDefining.get()).typeAdapters() : $Optional.absent();
            $Optional<$TypeAdaptersMirror> packageDefined = this.packageOf().typeAdapters();
            if (packageDefined.isPresent()) {
                if (typeDefined.isPresent()) {
                    this.report().withElement(((DeclaringType)typeDefining.get()).element()).annotationNamed($TypeAdaptersMirror.simpleName()).warning("@%s is also used on the package, this type level annotation is ignored", $TypeAdaptersMirror.simpleName());
                }
                return $Optional.of(this.packageOf());
            }
            return typeDefined.isPresent() ? $Optional.of(typeDefining.get()) : $Optional.absent();
        }

        public $Optional<$OkTypeAdaptersMirror> okJsonTypeAdapters() {
            $Optional<AbstractDeclaring> typeAdaptersProvider = this.okTypeAdaptersProvider();
            if (typeAdaptersProvider.isPresent()) {
                return typeAdaptersProvider.get().okTypeAdapters();
            }
            return $Optional.absent();
        }

        public $Optional<AbstractDeclaring> okTypeAdaptersProvider() {
            $Optional typeDefining = this.declaringType().isPresent() ? $Optional.of(this.declaringType().get().associatedTopLevel()) : $Optional.absent();
            $Optional typeDefined = typeDefining.isPresent() ? ((DeclaringType)typeDefining.get()).okTypeAdapters() : $Optional.absent();
            $Optional<$OkTypeAdaptersMirror> packageDefined = this.packageOf().okTypeAdapters();
            if (packageDefined.isPresent()) {
                if (typeDefined.isPresent()) {
                    this.report().withElement(((DeclaringType)typeDefining.get()).element()).annotationNamed($OkTypeAdaptersMirror.simpleName()).warning("@%s is also used on the package, this type level annotation is ignored", $OkTypeAdaptersMirror.simpleName());
                }
                return $Optional.of(this.packageOf());
            }
            return typeDefined.isPresent() ? $Optional.of(typeDefining.get()) : $Optional.absent();
        }

        public abstract Kind kind();

        public $Visibility visibility() {
            return $Visibility.of(this.sourceElement());
        }

        public $Visibility declaringVisibility() {
            if (this.declaringType().isPresent()) {
                return $Visibility.of(this.declaringType().get().element());
            }
            return $Visibility.PUBLIC;
        }

        @Override
        public Element element() {
            if (this.kind().isFactory()) {
                return this.sourceElement();
            }
            if (this.declaringType().isPresent()) {
                return this.declaringType().get().element();
            }
            return this.packageOf().element();
        }

        public $Optional<Long> serialVersion() {
            if (this.declaringType().isPresent()) {
                DeclaringType t = this.declaringType().get();
                if (t.serialVersion().isPresent()) {
                    return t.serialVersion();
                }
                if (t.enclosingTopLevel().isPresent() && t.enclosingTopLevel().get().serialVersion().isPresent()) {
                    return t.enclosingTopLevel().get().serialVersion();
                }
            }
            return this.packageOf().serialVersion();
        }

        public boolean isSerialStructural() {
            if (this.declaringType().isPresent()) {
                DeclaringType t = this.declaringType().get();
                if (t.isSerialStructural()) {
                    return true;
                }
                if (t.enclosingTopLevel().isPresent() && t.enclosingTopLevel().get().isSerialStructural()) {
                    return true;
                }
            }
            return this.packageOf().isSerialStructural();
        }

        public $ValueImmutableInfo features() {
            $Optional<$ValueImmutableInfo> features;
            if (this.declaringType().isPresent() && !this.declaringType().get().useImmutableDefaults() && (features = this.declaringType().get().features()).isPresent()) {
                return features.get();
            }
            return this.styles().defaults();
        }

        public $Styles styles() {
            return this.determineStyle().or(this.environment().defaultStyles()).getStyles();
        }

        private $Optional<$StyleInfo> determineStyle() {
            if (this.declaringType().isPresent()) {
                DeclaringType type = this.declaringType().get();
                $Optional<DeclaringType> enclosing = type.enclosingOf();
                if (enclosing.isPresent()) {
                    $Optional<$StyleInfo> enclosingStyle;
                    $Optional<$StyleInfo> style;
                    if (enclosing.get() != type && (style = type.style()).isPresent()) {
                        this.warnAboutIncompatibleStyles();
                    }
                    if ((enclosingStyle = enclosing.get().style()).isPresent()) {
                        return enclosingStyle;
                    }
                } else {
                    $Optional<$StyleInfo> style = type.style();
                    if (style.isPresent()) {
                        return style;
                    }
                    $Optional<DeclaringType> topLevel = type.enclosingTopLevel();
                    if (topLevel.isPresent() && topLevel.get().style().isPresent()) {
                        return topLevel.get().style();
                    }
                }
            }
            return this.packageOf().style();
        }

        private void warnAboutIncompatibleStyles() {
            this.report().annotationNamed($StyleMirror.simpleName()).warning("Use styles only on enclosing types. All nested styles will inherit it. Nested immutables cannot deviate in style from enclosing type, so generated stucture will be consistent", new Object[0]);
        }

        public $Optional<DeclaringType> enclosingOf() {
            if (this.declaringType().isPresent()) {
                if (this.kind().isFactory()) {
                    return this.declaringType();
                }
                if (this.kind().isNested()) {
                    if (this.kind().isIncluded()) {
                        return this.declaringType();
                    }
                    return this.declaringType().get().enclosingOf();
                }
            }
            return $Optional.absent();
        }

        $Styles.UsingName.TypeNames createTypeNames() {
            return this.styles().forType(this.sourceElement().getSimpleName().toString());
        }

        public boolean isJacksonSerialized() {
            DeclaringType type;
            if (this.declaringType().isPresent() && (type = this.declaringType().get()).isJacksonSerialized()) {
                return true;
            }
            return this.packageOf().isJacksonSerialized();
        }

        public boolean isJacksonDeserialized() {
            DeclaringType type;
            if (this.declaringType().isPresent() && (type = this.declaringType().get()).isJacksonDeserialized()) {
                return true;
            }
            return this.packageOf().isJacksonDeserialized();
        }

        public boolean isJacksonJsonTypeInfo() {
            DeclaringType type;
            if (this.declaringType().isPresent() && (type = this.declaringType().get()).isJacksonJsonTypeInfo()) {
                return true;
            }
            return this.packageOf().isJacksonJsonTypeInfo();
        }

        public boolean isAst() {
            return this.declaringType().isPresent() && this.declaringType().get().isAst();
        }

        public boolean isTransformer() {
            return this.declaringType().isPresent() && this.declaringType().get().isTransformer();
        }

        public $Optional<$TransformMirror> getTransform() {
            return this.declaringType().isPresent() ? this.declaringType().get().getTransform() : $Optional.absent();
        }

        public $Constitution constitution() {
            return $ImmutableConstitution.builder().protoclass(this).build();
        }

        public boolean hasFunctionalModule() {
            return this.environment().hasFunctionalModule();
        }

        public static enum Kind {
            INCLUDED_IN_PACKAGE,
            INCLUDED_ON_TYPE,
            INCLUDED_IN_TYPE,
            DEFINED_FACTORY,
            DEFINED_TYPE,
            DEFINED_TYPE_AND_COMPANION,
            DEFINED_COMPANION,
            DEFINED_AND_ENCLOSING_TYPE,
            DEFINED_ENCLOSING_TYPE,
            DEFINED_NESTED_TYPE;


            public boolean isNested() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case DEFINED_NESTED_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isIncluded() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case INCLUDED_IN_PACKAGE: 
                    case INCLUDED_ON_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isEnclosing() {
                switch (this) {
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_ENCLOSING_TYPE: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isValue() {
                switch (this) {
                    case INCLUDED_IN_TYPE: 
                    case DEFINED_NESTED_TYPE: 
                    case INCLUDED_IN_PACKAGE: 
                    case INCLUDED_ON_TYPE: 
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_TYPE: 
                    case DEFINED_TYPE_AND_COMPANION: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isDefinedValue() {
                switch (this) {
                    case DEFINED_NESTED_TYPE: 
                    case DEFINED_AND_ENCLOSING_TYPE: 
                    case DEFINED_TYPE: 
                    case DEFINED_TYPE_AND_COMPANION: {
                        return true;
                    }
                }
                return false;
            }

            public boolean isModifiable() {
                return this == DEFINED_TYPE_AND_COMPANION || this == DEFINED_COMPANION;
            }

            public boolean isFactory() {
                return this == DEFINED_FACTORY;
            }

            public boolean isEnclosingOnly() {
                return this == DEFINED_ENCLOSING_TYPE;
            }
        }
    }

    public static abstract class DeclaringType
    extends AbstractDeclaring {
        @Override
        public abstract TypeElement element();

        @Override
        public String name() {
            return this.element().getQualifiedName().toString();
        }

        public DeclaringType associatedTopLevel() {
            return this.enclosingTopLevel().or(this);
        }

        public $Optional<DeclaringType> enclosingTopLevel() {
            TypeElement top;
            Element e = top = this.element();
            while (e.getKind() != ElementKind.PACKAGE) {
                top = e;
                e = e.getEnclosingElement();
            }
            if (top == this.element()) {
                return $Optional.absent();
            }
            return $Optional.of(this.interner().forType($ImmutableProto.DeclaringType.builder().environment(this.environment()).interner(this.interner()).element(top).build()));
        }

        public $Optional<$RepositoryMirror> repository() {
            return $RepositoryMirror.find(this.element());
        }

        public $Optional<DeclaringType> enclosingOf() {
            $Optional<DeclaringType> topLevel = this.enclosingTopLevel();
            if (topLevel.isPresent() && topLevel.get().isEnclosing()) {
                return topLevel;
            }
            return $Optional.absent();
        }

        @Override
        public DeclaringPackage packageOf() {
            Element e = this.element();
            while (e.getKind() != ElementKind.PACKAGE) {
                e = e.getEnclosingElement();
            }
            return this.interner().forPackage($ImmutableProto.DeclaringPackage.builder().environment(this.environment()).interner(this.interner()).element((PackageElement)e).build());
        }

        public $Optional<$ValueImmutableInfo> features() {
            return $ImmutableMirror.find(this.element()).transform(ToImmutableInfo.FUNCTION);
        }

        public boolean useImmutableDefaults() {
            $Optional<$ValueImmutableInfo> immutables = this.features();
            if (immutables.isPresent()) {
                return immutables.get().isDefault();
            }
            return true;
        }

        public boolean isEnclosing() {
            return $EnclosingMirror.isPresent(this.element());
        }

        public boolean isModifiable() {
            return $ModifiableMirror.isPresent(this.element());
        }

        public boolean isTopLevel() {
            return this.element().getNestingKind() == NestingKind.TOP_LEVEL;
        }

        public boolean isImmutable() {
            return this.features().isPresent();
        }

        boolean verifiedFactory(ExecutableElement element) {
            if (!$FactoryMirror.isPresent(element)) {
                return false;
            }
            if (!this.isTopLevel() || element.getReturnType().getKind() == TypeKind.VOID || element.getModifiers().contains((Object)Modifier.PRIVATE) || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getTypeParameters().isEmpty()) {
                this.report().withElement(element).annotationNamed($FactoryMirror.simpleName()).error("@%s method '%s' should be static, non-private, non-void with no type parameters and enclosed in top level type", $FactoryMirror.simpleName(), element.getSimpleName());
                return false;
            }
            return true;
        }

        protected void validate() {
            if (this.hasInclude() && !this.isTopLevel()) {
                this.report().annotationNamed($IncludeMirror.simpleName()).error("@%s could not be used on nested types.", $IncludeMirror.simpleName());
            }
            if (this.isEnclosing() && !this.isTopLevel()) {
                this.report().annotationNamed($EnclosingMirror.simpleName()).error("@%s should only be used on a top-level types.", $EnclosingMirror.simpleName());
            }
            if (this.isImmutable() && this.element().getKind() == ElementKind.ENUM) {
                this.report().annotationNamed($ImmutableMirror.simpleName()).error("@%s is not supported on enums", $ImmutableMirror.simpleName());
            }
            if (this.isModifiable() && (this.isEnclosed() || this.isEnclosing())) {
                this.report().annotationNamed($ModifiableMirror.simpleName()).error("@%s could not be used with or within @%s", $ModifiableMirror.simpleName(), $EnclosingMirror.simpleName());
            }
        }

        public CharSequence headerComments() {
            return $SourceExtraction.extractSourceHeader(this.processing(), $CachingElements.getDelegate(this.element()));
        }

        public $SourceExtraction.Imports sourceImports() {
            return $SourceExtraction.readImports(this.processing(), $CachingElements.getDelegate(this.element()));
        }

        public boolean isTransformer() {
            return this.getTransform().isPresent();
        }

        public $Optional<$TransformMirror> getTransform() {
            return this.environment().hasTreesModule() ? $TransformMirror.find(this.element()) : $Optional.absent();
        }

        public boolean isAst() {
            return this.environment().hasTreesModule() && $AstMirror.isPresent(this.element());
        }

        public boolean isEnclosed() {
            return this.enclosingOf().isPresent();
        }
    }

    public static abstract class DeclaringPackage
    extends AbstractDeclaring {
        @Override
        public abstract PackageElement element();

        @Override
        public DeclaringPackage packageOf() {
            return this;
        }

        @Override
        public String simpleName() {
            return this.element().isUnnamed() ? "" : this.element().getSimpleName().toString();
        }

        @Override
        public String name() {
            return this.element().isUnnamed() ? "" : this.element().getQualifiedName().toString();
        }

        public String asPrefix() {
            return this.element().isUnnamed() ? "" : this.name() + ".";
        }

        $Optional<DeclaringPackage> namedParentPackage() {
            PackageElement parentPackage;
            String parentPackageName = $SourceNames.parentPackageName(this.element());
            if (!parentPackageName.isEmpty() && (parentPackage = this.environment().processing().getElementUtils().getPackageElement(parentPackageName)) != null) {
                return $Optional.of(this.interner().forPackage($ImmutableProto.DeclaringPackage.builder().environment(this.environment()).interner(this.interner()).element(parentPackage).build()));
            }
            return $Optional.absent();
        }

        @Override
        public boolean isJacksonSerialized() {
            boolean isJacksonSerialized = super.isJacksonSerialized();
            if (isJacksonSerialized) {
                return isJacksonSerialized;
            }
            $Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return parent.get().isJacksonSerialized();
            }
            return false;
        }

        @Override
        public boolean isJacksonDeserialized() {
            if (super.isJacksonDeserialized()) {
                return true;
            }
            $Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return parent.get().isJacksonDeserialized();
            }
            return false;
        }

        @Override
        public boolean isJacksonJsonTypeInfo() {
            if (super.isJacksonJsonTypeInfo()) {
                return true;
            }
            $Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return parent.get().isJacksonJsonTypeInfo();
            }
            return false;
        }

        @Override
        public boolean isSerialStructural() {
            boolean isSerialStructural = super.isSerialStructural();
            if (isSerialStructural) {
                return isSerialStructural;
            }
            $Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return parent.get().isSerialStructural();
            }
            return false;
        }

        @Override
        public $Optional<Long> serialVersion() {
            $Optional<Long> serialVersion = super.serialVersion();
            if (serialVersion.isPresent()) {
                return serialVersion;
            }
            $Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return parent.get().serialVersion();
            }
            return $Optional.absent();
        }

        @Override
        public $Optional<$StyleInfo> style() {
            $Optional<$StyleInfo> style = super.style();
            if (style.isPresent()) {
                return style;
            }
            $Optional<DeclaringPackage> parent = this.namedParentPackage();
            if (parent.isPresent()) {
                return parent.get().style();
            }
            return $Optional.absent();
        }
    }

    public static abstract class AbstractDeclaring
    extends Diagnosable {
        public abstract String name();

        public abstract DeclaringPackage packageOf();

        protected $Optional<$IncludeMirror> include() {
            return $IncludeMirror.find(this.element());
        }

        public boolean hasInclude() {
            return this.include().isPresent();
        }

        public $Optional<DeclaringType> asType() {
            return this instanceof DeclaringType ? $Optional.of((DeclaringType)this) : $Optional.absent();
        }

        abstract $Round.Interning interner();

        public $Optional<$TypeAdaptersMirror> typeAdapters() {
            return $TypeAdaptersMirror.find(this.element());
        }

        public $Optional<$OkTypeAdaptersMirror> okTypeAdapters() {
            return $OkTypeAdaptersMirror.find(this.element());
        }

        public List<TypeElement> includedTypes() {
            $Optional<$IncludeMirror> includes = this.include();
            $ImmutableList<Object> typeMirrors = includes.isPresent() ? $ImmutableList.copyOf(includes.get().valueMirror()) : $ImmutableList.of();
            $FluentIterable<TypeElement> typeElements = $FluentIterable.from(typeMirrors).filter(DeclaredType.class).transform(DeclatedTypeToElement.FUNCTION);
            $ImmutableSet<String> uniqueTypeNames = typeElements.filter(IsPublic.PREDICATE).transform(ElementToName.FUNCTION).toSet();
            if (uniqueTypeNames.size() != typeMirrors.size()) {
                this.report().annotationNamed($IncludeMirror.simpleName()).warning("Some types were ignored, non-supported for inclusion: duplicates, non declared reference types, non-public", new Object[0]);
            }
            return typeElements.toList();
        }

        public $Optional<$StyleInfo> style() {
            $Optional<$StyleInfo> style = $StyleMirror.find(this.element()).transform(ToStyleInfo.FUNCTION);
            if (style.isPresent()) {
                return style;
            }
            for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                MetaAnnotated metaAnnotated = MetaAnnotated.from(annotationMirror);
                $Optional<$StyleInfo> metaStyle = metaAnnotated.style();
                if (!metaStyle.isPresent()) continue;
                return metaStyle;
            }
            return $Optional.absent();
        }

        public $Optional<Long> serialVersion() {
            $Optional<$VersionMirror> version = $VersionMirror.find(this.element());
            if (version.isPresent()) {
                return $Optional.of(version.get().value());
            }
            for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                MetaAnnotated metaAnnotated = MetaAnnotated.from(annotationMirror);
                $Optional<Long> serialVersion = metaAnnotated.serialVersion();
                if (!serialVersion.isPresent()) continue;
                return serialVersion;
            }
            return $Optional.absent();
        }

        public boolean isSerialStructural() {
            return $StructuralMirror.isPresent(this.element());
        }

        public boolean isJacksonSerialized() {
            if ($Proto.isJacksonSerializedAnnotated(this.element())) {
                return true;
            }
            for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                MetaAnnotated metaAnnotated = MetaAnnotated.from(annotationMirror);
                if (!metaAnnotated.isJacksonSerialized()) continue;
                return true;
            }
            return false;
        }

        public boolean isJacksonDeserialized() {
            if (this.isJacksonDeserializedAnnotated()) {
                return true;
            }
            for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                MetaAnnotated metaAnnotated = MetaAnnotated.from(annotationMirror);
                if (!metaAnnotated.isJacksonDeserialized()) continue;
                return true;
            }
            return false;
        }

        public boolean isJacksonDeserializedAnnotated() {
            return $Proto.isJacksonDeserializedAnnotated(this.element());
        }

        public boolean isJacksonJsonTypeInfo() {
            if ($Proto.isJacksonJsonTypeInfoAnnotated(this.element())) {
                return true;
            }
            for (AnnotationMirror annotationMirror : this.element().getAnnotationMirrors()) {
                MetaAnnotated metaAnnotated = MetaAnnotated.from(annotationMirror);
                if (!metaAnnotated.isJacksonJsonTypeInfo()) continue;
                return true;
            }
            return false;
        }
    }

    static abstract class Environment {
        Environment() {
        }

        abstract ProcessingEnvironment processing();

        abstract $Round round();

        $StyleInfo defaultStyles() {
            TypeElement typeElement = this.processing().getElementUtils().getTypeElement($StyleMirror.qualifiedName());
            return ToStyleInfo.FUNCTION.apply($StyleMirror.from(typeElement));
        }

        public boolean hasTreesModule() {
            TypeElement annotationTypeElement = this.processing().getElementUtils().getTypeElement($TransformMirror.qualifiedName());
            return annotationTypeElement != null;
        }

        public boolean hasFunctionalModule() {
            TypeElement annotationTypeElement = this.processing().getElementUtils().getTypeElement($FunctionalMirror.qualifiedName());
            return annotationTypeElement != null;
        }

        $TypeAdaptersMirror defaultTypeAdapters() {
            TypeElement typeElement = this.processing().getElementUtils().getTypeElement($TypeAdaptersMirror.qualifiedName());
            $Preconditions.checkState(typeElement != null, "Processor internal error, @%s is not know to be on the classpath", $TypeAdaptersMirror.qualifiedName());
            return $TypeAdaptersMirror.from(typeElement);
        }

        $ValueType composeValue(Protoclass protoclass) {
            return this.round().composer().compose(protoclass);
        }

        $ImmutableList<Protoclass> protoclassesFrom(Iterable<? extends Element> elements) {
            return this.round().protoclassesFrom(elements);
        }
    }

    static abstract class Diagnosable {
        Diagnosable() {
        }

        abstract Element element();

        abstract Environment environment();

        ProcessingEnvironment processing() {
            return this.environment().processing();
        }

        public String simpleName() {
            return this.element().getSimpleName().toString();
        }

        protected $Reporter report() {
            return $Reporter.from(this.processing()).withElement(this.element());
        }
    }

    public static abstract class MetaAnnotated {
        private static final ConcurrentMap<String, MetaAnnotated> cache = new ConcurrentHashMap<String, MetaAnnotated>(16, 0.7f, 1);

        public abstract Element element();

        public $Optional<$StyleInfo> style() {
            return $StyleMirror.find(this.element()).transform(ToStyleInfo.FUNCTION);
        }

        public $Optional<Long> serialVersion() {
            $Optional<$VersionMirror> version = $VersionMirror.find(this.element());
            return version.isPresent() ? $Optional.of(version.get().value()) : $Optional.absent();
        }

        public boolean isSerialStructural() {
            return $StructuralMirror.isPresent(this.element());
        }

        public boolean isJacksonSerialized() {
            return $Proto.isJacksonSerializedAnnotated(this.element());
        }

        public boolean isJacksonDeserialized() {
            return $Proto.isJacksonDeserializedAnnotated(this.element());
        }

        public boolean isJacksonJsonTypeInfo() {
            return $Proto.isJacksonJsonTypeInfoAnnotated(this.element());
        }

        public static MetaAnnotated from(AnnotationMirror mirror) {
            MetaAnnotated existing;
            TypeElement element = (TypeElement)mirror.getAnnotationType().asElement();
            String name = element.getQualifiedName().toString();
            MetaAnnotated metaAnnotated = (MetaAnnotated)cache.get(element);
            if (metaAnnotated == null && (existing = cache.putIfAbsent(name, metaAnnotated = $ImmutableProto.MetaAnnotated.of(element))) != null) {
                metaAnnotated = existing;
            }
            return metaAnnotated;
        }
    }
}

