package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AttributeBuilderDescriptor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAttributeBuilderDescriptor.builder()}.
 */
@Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAttributeBuilderDescriptor
    extends AttributeBuilderDescriptor {
  private final AttributeBuilderDescriptor.ValueToBuilderTarget valueToBuilderTarget;
  private final String valueToBuilderMethod;
  private final String buildMethod;
  private final String qualifiedValueTypeName;
  private final String qualifiedBuilderTypeName;
  private final String qualifiedBuilderConstructorMethod;

  private ImmutableAttributeBuilderDescriptor(
      AttributeBuilderDescriptor.ValueToBuilderTarget valueToBuilderTarget,
      String valueToBuilderMethod,
      String buildMethod,
      String qualifiedValueTypeName,
      String qualifiedBuilderTypeName,
      String qualifiedBuilderConstructorMethod) {
    this.valueToBuilderTarget = valueToBuilderTarget;
    this.valueToBuilderMethod = valueToBuilderMethod;
    this.buildMethod = buildMethod;
    this.qualifiedValueTypeName = qualifiedValueTypeName;
    this.qualifiedBuilderTypeName = qualifiedBuilderTypeName;
    this.qualifiedBuilderConstructorMethod = qualifiedBuilderConstructorMethod;
  }

  /**
   * @return The value of the {@code valueToBuilderTarget} attribute
   */
  @Override
  public AttributeBuilderDescriptor.ValueToBuilderTarget getValueToBuilderTarget() {
    return valueToBuilderTarget;
  }

  /**
   * A method name which when invoked will return a builder with all the properties set from
   * the value object.  This method will be invoked based on {@link #getValueToBuilderTarget()}
   * @return method to create a value instance. No () included.
   */
  @Override
  protected String getValueToBuilderMethod() {
    return valueToBuilderMethod;
  }

  /**
   * A method to be invoked on the builder instance which returns a new value instance.
   * @return a method which constructs a new value instance.
   */
  @Override
  public String getBuildMethod() {
    return buildMethod;
  }

  /**
   * A fully qualified type for the value object.
   * @return fully qualified name of the value type.
   */
  @Override
  public String getQualifiedValueTypeName() {
    return qualifiedValueTypeName;
  }

  /**
   * A fully qualified type for the builder object.
   * @return fully qualified name of the builder type.
   */
  @Override
  public String getQualifiedBuilderTypeName() {
    return qualifiedBuilderTypeName;
  }

  /**
   * A fully qualified path and method which creates a new instance of a builder.
   * If the builder is constructed from a no-arg constructor, the {@code new} keyword
   * should be prepended with a space.
   * @return static path which invoked will create a new empty builder. No () included.
   */
  @Override
  public String getQualifiedBuilderConstructorMethod() {
    return qualifiedBuilderConstructorMethod;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderDescriptor#getValueToBuilderTarget() valueToBuilderTarget} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueToBuilderTarget
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderDescriptor withValueToBuilderTarget(AttributeBuilderDescriptor.ValueToBuilderTarget value) {
    if (this.valueToBuilderTarget == value) return this;
    AttributeBuilderDescriptor.ValueToBuilderTarget newValue = Objects.requireNonNull(value, "valueToBuilderTarget");
    if (this.valueToBuilderTarget.equals(newValue)) return this;
    return new ImmutableAttributeBuilderDescriptor(
        newValue,
        this.valueToBuilderMethod,
        this.buildMethod,
        this.qualifiedValueTypeName,
        this.qualifiedBuilderTypeName,
        this.qualifiedBuilderConstructorMethod);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderDescriptor#getValueToBuilderMethod() valueToBuilderMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueToBuilderMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderDescriptor withValueToBuilderMethod(String value) {
    String newValue = Objects.requireNonNull(value, "valueToBuilderMethod");
    if (this.valueToBuilderMethod.equals(newValue)) return this;
    return new ImmutableAttributeBuilderDescriptor(
        this.valueToBuilderTarget,
        newValue,
        this.buildMethod,
        this.qualifiedValueTypeName,
        this.qualifiedBuilderTypeName,
        this.qualifiedBuilderConstructorMethod);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderDescriptor#getBuildMethod() buildMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buildMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderDescriptor withBuildMethod(String value) {
    String newValue = Objects.requireNonNull(value, "buildMethod");
    if (this.buildMethod.equals(newValue)) return this;
    return new ImmutableAttributeBuilderDescriptor(
        this.valueToBuilderTarget,
        this.valueToBuilderMethod,
        newValue,
        this.qualifiedValueTypeName,
        this.qualifiedBuilderTypeName,
        this.qualifiedBuilderConstructorMethod);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderDescriptor#getQualifiedValueTypeName() qualifiedValueTypeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qualifiedValueTypeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderDescriptor withQualifiedValueTypeName(String value) {
    String newValue = Objects.requireNonNull(value, "qualifiedValueTypeName");
    if (this.qualifiedValueTypeName.equals(newValue)) return this;
    return new ImmutableAttributeBuilderDescriptor(
        this.valueToBuilderTarget,
        this.valueToBuilderMethod,
        this.buildMethod,
        newValue,
        this.qualifiedBuilderTypeName,
        this.qualifiedBuilderConstructorMethod);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderDescriptor#getQualifiedBuilderTypeName() qualifiedBuilderTypeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qualifiedBuilderTypeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderDescriptor withQualifiedBuilderTypeName(String value) {
    String newValue = Objects.requireNonNull(value, "qualifiedBuilderTypeName");
    if (this.qualifiedBuilderTypeName.equals(newValue)) return this;
    return new ImmutableAttributeBuilderDescriptor(
        this.valueToBuilderTarget,
        this.valueToBuilderMethod,
        this.buildMethod,
        this.qualifiedValueTypeName,
        newValue,
        this.qualifiedBuilderConstructorMethod);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderDescriptor#getQualifiedBuilderConstructorMethod() qualifiedBuilderConstructorMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qualifiedBuilderConstructorMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderDescriptor withQualifiedBuilderConstructorMethod(String value) {
    String newValue = Objects.requireNonNull(value, "qualifiedBuilderConstructorMethod");
    if (this.qualifiedBuilderConstructorMethod.equals(newValue)) return this;
    return new ImmutableAttributeBuilderDescriptor(
        this.valueToBuilderTarget,
        this.valueToBuilderMethod,
        this.buildMethod,
        this.qualifiedValueTypeName,
        this.qualifiedBuilderTypeName,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAttributeBuilderDescriptor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAttributeBuilderDescriptor
        && equalTo((ImmutableAttributeBuilderDescriptor) another);
  }

  private boolean equalTo(ImmutableAttributeBuilderDescriptor another) {
    return valueToBuilderTarget.equals(another.valueToBuilderTarget)
        && valueToBuilderMethod.equals(another.valueToBuilderMethod)
        && buildMethod.equals(another.buildMethod)
        && qualifiedValueTypeName.equals(another.qualifiedValueTypeName)
        && qualifiedBuilderTypeName.equals(another.qualifiedBuilderTypeName)
        && qualifiedBuilderConstructorMethod.equals(another.qualifiedBuilderConstructorMethod);
  }

  /**
   * Computes a hash code from attributes: {@code valueToBuilderTarget}, {@code valueToBuilderMethod}, {@code buildMethod}, {@code qualifiedValueTypeName}, {@code qualifiedBuilderTypeName}, {@code qualifiedBuilderConstructorMethod}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + valueToBuilderTarget.hashCode();
    h += (h << 5) + valueToBuilderMethod.hashCode();
    h += (h << 5) + buildMethod.hashCode();
    h += (h << 5) + qualifiedValueTypeName.hashCode();
    h += (h << 5) + qualifiedBuilderTypeName.hashCode();
    h += (h << 5) + qualifiedBuilderConstructorMethod.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AttributeBuilderDescriptor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AttributeBuilderDescriptor")
        .omitNullValues()
        .add("valueToBuilderTarget", valueToBuilderTarget)
        .add("valueToBuilderMethod", valueToBuilderMethod)
        .add("buildMethod", buildMethod)
        .add("qualifiedValueTypeName", qualifiedValueTypeName)
        .add("qualifiedBuilderTypeName", qualifiedBuilderTypeName)
        .add("qualifiedBuilderConstructorMethod", qualifiedBuilderConstructorMethod)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AttributeBuilderDescriptor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AttributeBuilderDescriptor instance
   */
  public static ImmutableAttributeBuilderDescriptor copyOf(AttributeBuilderDescriptor instance) {
    if (instance instanceof ImmutableAttributeBuilderDescriptor) {
      return (ImmutableAttributeBuilderDescriptor) instance;
    }
    return ((ImmutableAttributeBuilderDescriptor.Builder) ImmutableAttributeBuilderDescriptor.builder())
        .valueToBuilderTarget(instance.getValueToBuilderTarget())
        .valueToBuilderMethod(instance.getValueToBuilderMethod())
        .buildMethod(instance.getBuildMethod())
        .qualifiedValueTypeName(instance.getQualifiedValueTypeName())
        .qualifiedBuilderTypeName(instance.getQualifiedBuilderTypeName())
        .qualifiedBuilderConstructorMethod(instance.getQualifiedBuilderConstructorMethod())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAttributeBuilderDescriptor ImmutableAttributeBuilderDescriptor}.
   * <pre>
   * ImmutableAttributeBuilderDescriptor.builder()
   *    .valueToBuilderTarget(org.immutables.value.processor.meta.AttributeBuilderDescriptor.ValueToBuilderTarget) // required {@link AttributeBuilderDescriptor#getValueToBuilderTarget() valueToBuilderTarget}
   *    .valueToBuilderMethod(String) // required {@link AttributeBuilderDescriptor#getValueToBuilderMethod() valueToBuilderMethod}
   *    .buildMethod(String) // required {@link AttributeBuilderDescriptor#getBuildMethod() buildMethod}
   *    .qualifiedValueTypeName(String) // required {@link AttributeBuilderDescriptor#getQualifiedValueTypeName() qualifiedValueTypeName}
   *    .qualifiedBuilderTypeName(String) // required {@link AttributeBuilderDescriptor#getQualifiedBuilderTypeName() qualifiedBuilderTypeName}
   *    .qualifiedBuilderConstructorMethod(String) // required {@link AttributeBuilderDescriptor#getQualifiedBuilderConstructorMethod() qualifiedBuilderConstructorMethod}
   *    .build();
   * </pre>
   * @return A new ImmutableAttributeBuilderDescriptor builder
   */
  public static ValueToBuilderTargetBuildStage builder() {
    return new ImmutableAttributeBuilderDescriptor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAttributeBuilderDescriptor ImmutableAttributeBuilderDescriptor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
  @NotThreadSafe
  static final class Builder
      implements ValueToBuilderTargetBuildStage, ValueToBuilderMethodBuildStage, BuildMethodBuildStage, QualifiedValueTypeNameBuildStage, QualifiedBuilderTypeNameBuildStage, QualifiedBuilderConstructorMethodBuildStage, BuildFinal {
    private static final long INIT_BIT_VALUE_TO_BUILDER_TARGET = 0x1L;
    private static final long INIT_BIT_VALUE_TO_BUILDER_METHOD = 0x2L;
    private static final long INIT_BIT_BUILD_METHOD = 0x4L;
    private static final long INIT_BIT_QUALIFIED_VALUE_TYPE_NAME = 0x8L;
    private static final long INIT_BIT_QUALIFIED_BUILDER_TYPE_NAME = 0x10L;
    private static final long INIT_BIT_QUALIFIED_BUILDER_CONSTRUCTOR_METHOD = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable AttributeBuilderDescriptor.ValueToBuilderTarget valueToBuilderTarget;
    private @Nullable String valueToBuilderMethod;
    private @Nullable String buildMethod;
    private @Nullable String qualifiedValueTypeName;
    private @Nullable String qualifiedBuilderTypeName;
    private @Nullable String qualifiedBuilderConstructorMethod;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getValueToBuilderTarget() valueToBuilderTarget} attribute.
     * @param valueToBuilderTarget The value for valueToBuilderTarget 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueToBuilderTarget(AttributeBuilderDescriptor.ValueToBuilderTarget valueToBuilderTarget) {
      checkNotIsSet(valueToBuilderTargetIsSet(), "valueToBuilderTarget");
      this.valueToBuilderTarget = Objects.requireNonNull(valueToBuilderTarget, "valueToBuilderTarget");
      initBits &= ~INIT_BIT_VALUE_TO_BUILDER_TARGET;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getValueToBuilderMethod() valueToBuilderMethod} attribute.
     * @param valueToBuilderMethod The value for valueToBuilderMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder valueToBuilderMethod(String valueToBuilderMethod) {
      checkNotIsSet(valueToBuilderMethodIsSet(), "valueToBuilderMethod");
      this.valueToBuilderMethod = Objects.requireNonNull(valueToBuilderMethod, "valueToBuilderMethod");
      initBits &= ~INIT_BIT_VALUE_TO_BUILDER_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getBuildMethod() buildMethod} attribute.
     * @param buildMethod The value for buildMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder buildMethod(String buildMethod) {
      checkNotIsSet(buildMethodIsSet(), "buildMethod");
      this.buildMethod = Objects.requireNonNull(buildMethod, "buildMethod");
      initBits &= ~INIT_BIT_BUILD_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getQualifiedValueTypeName() qualifiedValueTypeName} attribute.
     * @param qualifiedValueTypeName The value for qualifiedValueTypeName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder qualifiedValueTypeName(String qualifiedValueTypeName) {
      checkNotIsSet(qualifiedValueTypeNameIsSet(), "qualifiedValueTypeName");
      this.qualifiedValueTypeName = Objects.requireNonNull(qualifiedValueTypeName, "qualifiedValueTypeName");
      initBits &= ~INIT_BIT_QUALIFIED_VALUE_TYPE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getQualifiedBuilderTypeName() qualifiedBuilderTypeName} attribute.
     * @param qualifiedBuilderTypeName The value for qualifiedBuilderTypeName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder qualifiedBuilderTypeName(String qualifiedBuilderTypeName) {
      checkNotIsSet(qualifiedBuilderTypeNameIsSet(), "qualifiedBuilderTypeName");
      this.qualifiedBuilderTypeName = Objects.requireNonNull(qualifiedBuilderTypeName, "qualifiedBuilderTypeName");
      initBits &= ~INIT_BIT_QUALIFIED_BUILDER_TYPE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getQualifiedBuilderConstructorMethod() qualifiedBuilderConstructorMethod} attribute.
     * @param qualifiedBuilderConstructorMethod The value for qualifiedBuilderConstructorMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder qualifiedBuilderConstructorMethod(String qualifiedBuilderConstructorMethod) {
      checkNotIsSet(qualifiedBuilderConstructorMethodIsSet(), "qualifiedBuilderConstructorMethod");
      this.qualifiedBuilderConstructorMethod = Objects.requireNonNull(qualifiedBuilderConstructorMethod, "qualifiedBuilderConstructorMethod");
      initBits &= ~INIT_BIT_QUALIFIED_BUILDER_CONSTRUCTOR_METHOD;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAttributeBuilderDescriptor ImmutableAttributeBuilderDescriptor}.
     * @return An immutable instance of AttributeBuilderDescriptor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAttributeBuilderDescriptor build() {
      checkRequiredAttributes();
      return new ImmutableAttributeBuilderDescriptor(
          valueToBuilderTarget,
          valueToBuilderMethod,
          buildMethod,
          qualifiedValueTypeName,
          qualifiedBuilderTypeName,
          qualifiedBuilderConstructorMethod);
    }

    private boolean valueToBuilderTargetIsSet() {
      return (initBits & INIT_BIT_VALUE_TO_BUILDER_TARGET) == 0;
    }

    private boolean valueToBuilderMethodIsSet() {
      return (initBits & INIT_BIT_VALUE_TO_BUILDER_METHOD) == 0;
    }

    private boolean buildMethodIsSet() {
      return (initBits & INIT_BIT_BUILD_METHOD) == 0;
    }

    private boolean qualifiedValueTypeNameIsSet() {
      return (initBits & INIT_BIT_QUALIFIED_VALUE_TYPE_NAME) == 0;
    }

    private boolean qualifiedBuilderTypeNameIsSet() {
      return (initBits & INIT_BIT_QUALIFIED_BUILDER_TYPE_NAME) == 0;
    }

    private boolean qualifiedBuilderConstructorMethodIsSet() {
      return (initBits & INIT_BIT_QUALIFIED_BUILDER_CONSTRUCTOR_METHOD) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of AttributeBuilderDescriptor is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!valueToBuilderTargetIsSet()) attributes.add("valueToBuilderTarget");
      if (!valueToBuilderMethodIsSet()) attributes.add("valueToBuilderMethod");
      if (!buildMethodIsSet()) attributes.add("buildMethod");
      if (!qualifiedValueTypeNameIsSet()) attributes.add("qualifiedValueTypeName");
      if (!qualifiedBuilderTypeNameIsSet()) attributes.add("qualifiedBuilderTypeName");
      if (!qualifiedBuilderConstructorMethodIsSet()) attributes.add("qualifiedBuilderConstructorMethod");
      return "Cannot build AttributeBuilderDescriptor, some of required attributes are not set " + attributes;
    }
  }

  @Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
  public interface ValueToBuilderTargetBuildStage {
    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getValueToBuilderTarget() valueToBuilderTarget} attribute.
     * @param valueToBuilderTarget The value for valueToBuilderTarget 
     * @return {@code this} builder for use in a chained invocation
     */
    ValueToBuilderMethodBuildStage valueToBuilderTarget(AttributeBuilderDescriptor.ValueToBuilderTarget valueToBuilderTarget);
  }

  @Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
  public interface ValueToBuilderMethodBuildStage {
    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getValueToBuilderMethod() valueToBuilderMethod} attribute.
     * @param valueToBuilderMethod The value for valueToBuilderMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildMethodBuildStage valueToBuilderMethod(String valueToBuilderMethod);
  }

  @Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
  public interface BuildMethodBuildStage {
    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getBuildMethod() buildMethod} attribute.
     * @param buildMethod The value for buildMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    QualifiedValueTypeNameBuildStage buildMethod(String buildMethod);
  }

  @Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
  public interface QualifiedValueTypeNameBuildStage {
    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getQualifiedValueTypeName() qualifiedValueTypeName} attribute.
     * @param qualifiedValueTypeName The value for qualifiedValueTypeName 
     * @return {@code this} builder for use in a chained invocation
     */
    QualifiedBuilderTypeNameBuildStage qualifiedValueTypeName(String qualifiedValueTypeName);
  }

  @Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
  public interface QualifiedBuilderTypeNameBuildStage {
    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getQualifiedBuilderTypeName() qualifiedBuilderTypeName} attribute.
     * @param qualifiedBuilderTypeName The value for qualifiedBuilderTypeName 
     * @return {@code this} builder for use in a chained invocation
     */
    QualifiedBuilderConstructorMethodBuildStage qualifiedBuilderTypeName(String qualifiedBuilderTypeName);
  }

  @Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
  public interface QualifiedBuilderConstructorMethodBuildStage {
    /**
     * Initializes the value for the {@link AttributeBuilderDescriptor#getQualifiedBuilderConstructorMethod() qualifiedBuilderConstructorMethod} attribute.
     * @param qualifiedBuilderConstructorMethod The value for qualifiedBuilderConstructorMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal qualifiedBuilderConstructorMethod(String qualifiedBuilderConstructorMethod);
  }

  @Generated(from = "AttributeBuilderDescriptor", generator = "Immutables")
  public interface BuildFinal {

    /**
     * Builds a new {@link ImmutableAttributeBuilderDescriptor ImmutableAttributeBuilderDescriptor}.
     * @return An immutable instance of AttributeBuilderDescriptor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    ImmutableAttributeBuilderDescriptor build();
  }
}
