package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link AttributeBuilderThirdPartyModel.Creator Creator} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableCreator is not thread-safe</em>
 */
@Generated(from = "AttributeBuilderThirdPartyModel.Creator", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "AttributeBuilderThirdPartyModel.Creator"})
@NotThreadSafe
final class ModifiableCreator
    extends AttributeBuilderThirdPartyModel.Creator {
  private @Nullable ExecutableElement buildMethod;
  private @Nullable ExecutableElement copyMethod;
  private @Nullable ExecutableElement builderMethod;
  private @Nullable TypeElement builderType;

  private ModifiableCreator() {}

  /**
   * Construct a modifiable instance of {@code Creator}.
   * @return A new modifiable instance
   */
  public static ModifiableCreator create() {
    return new ModifiableCreator();
  }

  /**
   * @return value of {@code buildMethod} attribute, may be {@code null}
   */
  @Override
  protected final @Nullable ExecutableElement buildMethod() {
    return buildMethod;
  }

  /**
   * @return value of {@code copyMethod} attribute, may be {@code null}
   */
  @Override
  protected final @Nullable ExecutableElement copyMethod() {
    return copyMethod;
  }

  /**
   * @return value of {@code builderMethod} attribute, may be {@code null}
   */
  @Override
  protected final @Nullable ExecutableElement builderMethod() {
    return builderMethod;
  }

  /**
   * @return value of {@code builderType} attribute, may be {@code null}
   */
  @Override
  protected final @Nullable TypeElement builderType() {
    return builderType;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCreator clear() {
    buildMethod = null;
    copyMethod = null;
    builderMethod = null;
    builderType = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.value.processor.meta.AttributeBuilderThirdPartyModel} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCreator from(AttributeBuilderThirdPartyModel instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.value.processor.meta.AttributeBuilderThirdPartyModel.Creator} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCreator from(AttributeBuilderThirdPartyModel.Creator instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link AttributeBuilderThirdPartyModel.Creator} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableCreator from(ModifiableCreator instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof ModifiableCreator) {
      ModifiableCreator instance = (ModifiableCreator) object;
      @Nullable ExecutableElement buildMethodValue = instance.buildMethod();
      if (buildMethodValue != null) {
        buildMethod(buildMethodValue);
      }
      @Nullable ExecutableElement copyMethodValue = instance.copyMethod();
      if (copyMethodValue != null) {
        copyMethod(copyMethodValue);
      }
      @Nullable ExecutableElement builderMethodValue = instance.builderMethod();
      if (builderMethodValue != null) {
        builderMethod(builderMethodValue);
      }
      @Nullable TypeElement builderTypeValue = instance.builderType();
      if (builderTypeValue != null) {
        builderType(builderTypeValue);
      }
      return;
    }
    long bits = 0;
    if (object instanceof AttributeBuilderThirdPartyModel) {
      AttributeBuilderThirdPartyModel instance = (AttributeBuilderThirdPartyModel) object;
      if ((bits & 0x4L) == 0) {
        @Nullable ExecutableElement buildMethodValue = instance.buildMethod();
        if (buildMethodValue != null) {
          buildMethod(buildMethodValue);
        }
        bits |= 0x4L;
      }
      if ((bits & 0x1L) == 0) {
        @Nullable TypeElement builderTypeValue = instance.builderType();
        if (builderTypeValue != null) {
          builderType(builderTypeValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x8L) == 0) {
        @Nullable ExecutableElement builderMethodValue = instance.builderMethod();
        if (builderMethodValue != null) {
          builderMethod(builderMethodValue);
        }
        bits |= 0x8L;
      }
      if ((bits & 0x2L) == 0) {
        @Nullable ExecutableElement copyMethodValue = instance.copyMethod();
        if (copyMethodValue != null) {
          copyMethod(copyMethodValue);
        }
        bits |= 0x2L;
      }
    }
    if (object instanceof AttributeBuilderThirdPartyModel.Creator) {
      AttributeBuilderThirdPartyModel.Creator instance = (AttributeBuilderThirdPartyModel.Creator) object;
      if ((bits & 0x4L) == 0) {
        @Nullable ExecutableElement buildMethodValue = instance.buildMethod();
        if (buildMethodValue != null) {
          buildMethod(buildMethodValue);
        }
        bits |= 0x4L;
      }
      if ((bits & 0x1L) == 0) {
        @Nullable TypeElement builderTypeValue = instance.builderType();
        if (builderTypeValue != null) {
          builderType(builderTypeValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x8L) == 0) {
        @Nullable ExecutableElement builderMethodValue = instance.builderMethod();
        if (builderMethodValue != null) {
          builderMethod(builderMethodValue);
        }
        bits |= 0x8L;
      }
      if ((bits & 0x2L) == 0) {
        @Nullable ExecutableElement copyMethodValue = instance.copyMethod();
        if (copyMethodValue != null) {
          copyMethod(copyMethodValue);
        }
        bits |= 0x2L;
      }
    }
  }

  /**
   * Assigns a value to the {@code buildMethod} attribute.
   * @param buildMethod The value for buildMethod, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCreator buildMethod(@Nullable ExecutableElement buildMethod) {
    this.buildMethod = buildMethod;
    return this;
  }

  /**
   * Assigns a value to the {@code copyMethod} attribute.
   * @param copyMethod The value for copyMethod, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCreator copyMethod(@Nullable ExecutableElement copyMethod) {
    this.copyMethod = copyMethod;
    return this;
  }

  /**
   * Assigns a value to the {@code builderMethod} attribute.
   * @param builderMethod The value for builderMethod, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCreator builderMethod(@Nullable ExecutableElement builderMethod) {
    this.builderMethod = builderMethod;
    return this;
  }

  /**
   * Assigns a value to the {@code builderType} attribute.
   * @param builderType The value for builderType, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCreator builderType(@Nullable TypeElement builderType) {
    this.builderType = builderType;
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * This instance is equal to all instances of {@code ModifiableCreator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableCreator)) return false;
    ModifiableCreator other = (ModifiableCreator) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableCreator another) {
    return Objects.equals(buildMethod, another.buildMethod)
        && Objects.equals(copyMethod, another.copyMethod)
        && Objects.equals(builderMethod, another.builderMethod)
        && Objects.equals(builderType, another.builderType);
  }

  /**
   * Computes a hash code from attributes: {@code buildMethod}, {@code copyMethod}, {@code builderMethod}, {@code builderType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildMethod);
    h += (h << 5) + Objects.hashCode(copyMethod);
    h += (h << 5) + Objects.hashCode(builderMethod);
    h += (h << 5) + Objects.hashCode(builderType);
    return h;
  }

  /**
   * Generates a string representation of this {@code Creator}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableCreator")
        .add("buildMethod", buildMethod())
        .add("copyMethod", copyMethod())
        .add("builderMethod", builderMethod())
        .add("builderType", builderType())
        .toString();
  }
}
