/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.immutables.value.internal.$generator$.$SourceOrdering;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableListMultimap;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.encode.$Instantiator;
import org.immutables.value.internal.$processor$.meta.$CachingElements;
import org.immutables.value.internal.$processor$.meta.$CheckMirror;
import org.immutables.value.internal.$processor$.meta.$DefaultAnnotations;
import org.immutables.value.internal.$processor$.meta.$DefaultMirror;
import org.immutables.value.internal.$processor$.meta.$DerivedMirror;
import org.immutables.value.internal.$processor$.meta.$ImportsTypeStringResolver;
import org.immutables.value.internal.$processor$.meta.$LazyMirror;
import org.immutables.value.internal.$processor$.meta.$NonAttributeMirror;
import org.immutables.value.internal.$processor$.meta.$ProcessingEnvironments;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$TypeStringProvider;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;
import org.immutables.value.internal.$processor$.meta.$ValueType;

final class $AccessorAttributesCollector {
    private static final String ORDINAL_ORDINAL_ATTRIBUTE_NAME = "ordinal";
    private static final String ORDINAL_DOMAIN_ATTRIBUTE_NAME = "domain";
    private static final String PARCELABLE_DESCRIBE_CONTENTS_METHOD = "describeContents";
    @Nullable
    private static final Modifier DEFAULT_MODIFIER;
    private static final String ORG_ECLIPSE = "org.eclipse";
    static final String EQUALS_METHOD = "equals";
    static final String TO_STRING_METHOD = "toString";
    static final String HASH_CODE_METHOD = "hashCode";
    private final $Proto.Protoclass protoclass;
    private final $ValueType type;
    private final ProcessingEnvironment processing;
    private final List<$ValueAttribute> attributes = $Lists.newArrayList();
    private final $Styles styles;
    private final $Reporter reporter;
    private $ImmutableListMultimap<String, TypeElement> accessorMapping = $ImmutableListMultimap.of();
    private final boolean isEclipseImplementation;
    private boolean hasNonInheritedAttributes;

    $AccessorAttributesCollector($Proto.Protoclass protoclass, $ValueType type) {
        this.protoclass = protoclass;
        this.processing = protoclass.processing();
        this.styles = protoclass.styles();
        this.type = type;
        this.reporter = protoclass.report();
        this.isEclipseImplementation = $ProcessingEnvironments.isEclipseImplementation(this.processing);
    }

    void collect() {
        this.collectGeneratedCandidateMethods(this.getTypeElement());
        $Instantiator encodingInstantiator = this.protoclass.encodingInstantiator();
        $Instantiator.InstantiationCreator instantiationCreator = encodingInstantiator.creatorFor((Parameterizable)this.type.element);
        for ($ValueAttribute attribute : this.attributes) {
            attribute.initAndValidate(instantiationCreator);
        }
        if (instantiationCreator != null) {
            this.type.additionalImports(instantiationCreator.imports);
        }
        this.type.attributes.addAll(this.attributes);
        this.type.accessorMapping = this.accessorMapping;
    }

    private TypeElement getTypeElement() {
        return (TypeElement)this.type.element;
    }

    private void collectGeneratedCandidateMethods(TypeElement type) {
        $ImmutableList<Element> accessorsInSourceOrder;
        TypeElement originalType = $CachingElements.getDelegate(type);
        if (originalType.getKind() == ElementKind.ANNOTATION_TYPE) {
            accessorsInSourceOrder = $SourceOrdering.getEnclosedElements(originalType);
        } else {
            $SourceOrdering.AccessorProvider provider = $SourceOrdering.getAllAccessorsProvider(this.processing.getElementUtils(), this.processing.getTypeUtils(), originalType);
            accessorsInSourceOrder = provider.get();
            this.accessorMapping = provider.accessorMapping();
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(accessorsInSourceOrder)) {
            if (!this.isElegibleAccessorMethod(executableElement)) continue;
            this.processGenerationCandidateMethod(executableElement, originalType);
        }
        block9: for (Element element : this.processing.getElementUtils().getAllMembers(originalType)) {
            String simpleName;
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement e = (ExecutableElement)element;
            switch (simpleName = element.getSimpleName().toString()) {
                case "hashCode": 
                case "toString": 
                case "equals": {
                    this.processUtilityCandidateMethod(e, originalType);
                    continue block9;
                }
            }
            if (!e.getTypeParameters().isEmpty()) continue;
            boolean hasDefaultModifier = element.getModifiers().contains((Object)DEFAULT_MODIFIER);
            boolean hasStaticModifier = element.getModifiers().contains((Object)Modifier.STATIC);
            boolean hasAbstractModifier = element.getModifiers().contains((Object)Modifier.ABSTRACT);
            if (!hasStaticModifier && !hasDefaultModifier && hasAbstractModifier) continue;
            String definedIn = element.getEnclosingElement().toString();
            if (!this.styles.style().underrideEquals().isEmpty() && this.styles.style().underrideEquals().equals(simpleName)) {
                if (hasStaticModifier) {
                    if (e.getParameters().size() != 2) continue;
                    this.type.underrideEquals = new $ValueType.UnderrideMethod(simpleName, true, definedIn);
                    this.type.isEqualToDefined = true;
                    continue;
                }
                if (e.getParameters().size() != 1) continue;
                this.type.underrideEquals = new $ValueType.UnderrideMethod(simpleName, false, definedIn);
                this.type.isEqualToDefined = true;
                continue;
            }
            if (!this.styles.style().underrideHashCode().isEmpty() && this.styles.style().underrideHashCode().equals(simpleName)) {
                if (hasStaticModifier) {
                    if (e.getParameters().size() != 1) continue;
                    this.type.underrideHashCode = new $ValueType.UnderrideMethod(simpleName, true, definedIn);
                    this.type.isHashCodeDefined = true;
                    continue;
                }
                if (!e.getParameters().isEmpty()) continue;
                this.type.underrideHashCode = new $ValueType.UnderrideMethod(simpleName, false, definedIn);
                this.type.isHashCodeDefined = true;
                continue;
            }
            if (this.styles.style().underrideToString().isEmpty() || !this.styles.style().underrideToString().equals(simpleName)) continue;
            if (hasStaticModifier) {
                if (e.getParameters().size() != 1) continue;
                this.type.underrideToString = new $ValueType.UnderrideMethod(simpleName, true, definedIn);
                this.type.isToStringDefined = true;
                continue;
            }
            if (!e.getParameters().isEmpty()) continue;
            this.type.underrideToString = new $ValueType.UnderrideMethod(simpleName, false, definedIn);
            this.type.isToStringDefined = true;
        }
    }

    private boolean isElegibleAccessorMethod(Element element) {
        String simpleName;
        if (element.getKind() != ElementKind.METHOD) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        if ($NonAttributeMirror.isPresent(element)) {
            return false;
        }
        switch (simpleName = element.getSimpleName().toString()) {
            case "hashCode": 
            case "toString": {
                return false;
            }
        }
        if (!this.type.style().toBuilder().isEmpty() && !this.type.style().strictBuilder() && simpleName.equals(this.type.names().toBuilder()) && element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        String definitionType = element.getEnclosingElement().toString();
        return !definitionType.equals(Object.class.getName()) && !definitionType.equals("org.immutables.ordinal.OrdinalValue") && !definitionType.equals("android.os.Parcelable");
    }

    private void processUtilityCandidateMethod(ExecutableElement utilityMethodCandidate, TypeElement originalType) {
        boolean nonAbstract;
        Name name = utilityMethodCandidate.getSimpleName();
        List<? extends VariableElement> parameters = utilityMethodCandidate.getParameters();
        TypeElement definingType = (TypeElement)utilityMethodCandidate.getEnclosingElement();
        boolean nonFinal = !utilityMethodCandidate.getModifiers().contains((Object)Modifier.FINAL);
        boolean bl = nonAbstract = !utilityMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT);
        if (this.isJavaLangObjectType(definingType)) {
            return;
        }
        if (name.contentEquals(EQUALS_METHOD) && parameters.size() == 1 && this.isJavaLangObjectType(parameters.get(0).asType())) {
            if (nonAbstract) {
                this.type.isEqualToDefined = true;
                boolean bl2 = this.type.isEqualToFinal = !nonFinal;
                if (!definingType.equals(originalType) && this.hasNonInheritedAttributes && nonFinal) {
                    this.report(originalType).warning($Reporter.About.INCOMPAT, "Type inherits overridden 'equals' method but have some non-inherited attributes. Please override 'equals' with abstract method to have it generate. Otherwise override with calling super implementation to use custom implementation", new Object[0]);
                }
            }
            return;
        }
        if (name.contentEquals(HASH_CODE_METHOD) && parameters.isEmpty()) {
            if (nonAbstract) {
                this.type.isHashCodeDefined = true;
                boolean bl3 = this.type.isHashCodeFinal = !nonFinal;
                if (!definingType.equals(originalType) && this.hasNonInheritedAttributes && nonFinal) {
                    this.report(originalType).warning($Reporter.About.INCOMPAT, "Type inherits non-default 'hashCode' method but have some non-inherited attributes. Please override 'hashCode' with abstract method to have it generated. Otherwise override with calling super implementation to use custom implementation", new Object[0]);
                }
            }
            return;
        }
        if (name.contentEquals(TO_STRING_METHOD) && parameters.isEmpty()) {
            if (nonAbstract) {
                this.type.isToStringDefined = true;
                if (!definingType.equals(originalType) && this.hasNonInheritedAttributes && nonFinal) {
                    this.report(originalType).warning($Reporter.About.INCOMPAT, "Type inherits non-default 'toString' method but have some non-inherited attributes. Please override 'toString' with abstract method to have generate it. Otherwise override with calling super implementation to use custom implementation", new Object[0]);
                }
            }
            return;
        }
    }

    private boolean isJavaLangObjectType(TypeMirror typeMirror) {
        Element element;
        if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()).getKind().isClass()) {
            return this.isJavaLangObjectType((TypeElement)element);
        }
        return false;
    }

    private boolean isJavaLangObjectType(TypeElement definingType) {
        return definingType.getQualifiedName().contentEquals(Object.class.getName());
    }

    private void processGenerationCandidateMethod(ExecutableElement attributeMethodCandidate, TypeElement originalType) {
        Name name = attributeMethodCandidate.getSimpleName();
        $Reporter reporter = this.report(attributeMethodCandidate);
        if ($CheckMirror.isPresent(attributeMethodCandidate)) {
            if (!attributeMethodCandidate.getParameters().isEmpty() || attributeMethodCandidate.getModifiers().contains((Object)Modifier.PRIVATE) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.STATIC) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.NATIVE) || !attributeMethodCandidate.getTypeParameters().isEmpty()) {
                reporter.error("Method '%s' annotated with @%s must be non-private parameter-less method", name, $CheckMirror.simpleName());
            } else if (attributeMethodCandidate.getReturnType().getKind() == TypeKind.VOID) {
                this.type.addNormalizeMethod(name.toString(), false);
            } else if (this.returnsNormalizedAbstractValueType(attributeMethodCandidate)) {
                this.type.addNormalizeMethod(name.toString(), true);
            } else {
                reporter.error("Method '%s' annotated with @%s must return void or normalized instance of abstract value type", name, $CheckMirror.simpleName());
            }
            return;
        }
        boolean useDefaultAsDefault = this.type.constitution.style().defaultAsDefault();
        if ($AccessorAttributesCollector.isDiscoveredAttribute(attributeMethodCandidate, useDefaultAsDefault)) {
            if (!attributeMethodCandidate.getTypeParameters().isEmpty()) {
                reporter.error("Method '%s' cannot have own generic type parameters. Attribute accessors can only use enclosing type's type variables", name);
                return;
            }
            TypeMirror returnType = this.resolveReturnType(attributeMethodCandidate);
            $ValueAttribute attribute = new $ValueAttribute();
            attribute.reporter = this.reporter;
            attribute.returnType = returnType;
            attribute.names = this.deriveNames(name.toString());
            attribute.element = attributeMethodCandidate;
            attribute.containingType = this.type;
            boolean isFinal = $AccessorAttributesCollector.isFinal(attributeMethodCandidate);
            boolean isAbstract = $AccessorAttributesCollector.isAbstract(attributeMethodCandidate);
            boolean defaultAnnotationPresent = $DefaultMirror.isPresent(attributeMethodCandidate);
            Object constantDefault = $DefaultAnnotations.extractConstantDefault(reporter, attributeMethodCandidate, returnType);
            boolean derivedAnnotationPresent = $DerivedMirror.isPresent(attributeMethodCandidate);
            if (isAbstract) {
                attribute.isGenerateAbstract = true;
                if (attributeMethodCandidate.getDefaultValue() != null) {
                    attribute.isGenerateDefault = true;
                }
                if (constantDefault != null) {
                    attribute.isGenerateDefault = true;
                    attribute.constantDefault = constantDefault;
                }
                if (defaultAnnotationPresent || derivedAnnotationPresent) {
                    if (defaultAnnotationPresent) {
                        if (attribute.isGenerateDefault) {
                            reporter.annotationNamed($DefaultMirror.simpleName()).warning($Reporter.About.INCOMPAT, "@Value.Default annotation is superfluous for default annotation attribute", new Object[0]);
                        } else {
                            reporter.annotationNamed($DefaultMirror.simpleName()).error("@Value.Default attribute should have initializer body", name);
                        }
                    }
                    if (derivedAnnotationPresent) {
                        if (attribute.isGenerateDefault) {
                            reporter.annotationNamed($DerivedMirror.simpleName()).error("@Value.Derived cannot be used with default annotation attribute", new Object[0]);
                        } else {
                            reporter.annotationNamed($DerivedMirror.simpleName()).error("@Value.Derived attribute should have initializer body", name);
                        }
                    }
                }
            } else if (defaultAnnotationPresent && derivedAnnotationPresent) {
                reporter.annotationNamed($DerivedMirror.simpleName()).error("Attribute '%s' cannot be both @Value.Default and @Value.Derived", name);
                attribute.isGenerateDefault = true;
            } else if ((defaultAnnotationPresent || derivedAnnotationPresent) && isFinal) {
                reporter.error("Annotated attribute '%s' will be overriden and cannot be final", name);
            } else if (defaultAnnotationPresent) {
                attribute.isGenerateDefault = true;
                if (useDefaultAsDefault && attribute.isInterfaceDefaultMethod()) {
                    reporter.annotationNamed($DefaultMirror.simpleName()).warning($Reporter.About.INCOMPAT, "@Value.Default annotation is superfluous for default annotation attribute when 'defaultAsDefault' style is enabled", new Object[0]);
                }
            } else if (derivedAnnotationPresent) {
                attribute.isGenerateDerived = true;
            } else if (useDefaultAsDefault) {
                attribute.isGenerateDefault = attribute.isInterfaceDefaultMethod();
            }
            if ($LazyMirror.isPresent(attributeMethodCandidate)) {
                if (isAbstract || isFinal) {
                    reporter.error("@Value.Lazy attribute '%s' must be non abstract and non-final", name);
                } else if (defaultAnnotationPresent || derivedAnnotationPresent) {
                    reporter.error("@Value.Lazy attribute '%s' cannot be @Value.Derived or @Value.Default", name);
                } else {
                    attribute.isGenerateLazy = true;
                    attribute.isGenerateDefault = false;
                }
            }
            this.attributes.add(attribute);
            if (attribute.isGenerateDefault) {
                ++this.type.defaultAttributesCount;
            }
            if (attribute.isGenerateDerived) {
                ++this.type.derivedAttributesCount;
            }
            if (attributeMethodCandidate.getEnclosingElement().equals(originalType)) {
                this.hasNonInheritedAttributes = true;
            }
        }
    }

    private boolean returnsNormalizedAbstractValueType(ExecutableElement validationMethodCandidate) {
        boolean isCompatibleReturnType;
        $Optional<$Proto.DeclaringType> declaringType = this.protoclass.declaringType();
        if (!declaringType.isPresent()) {
            return false;
        }
        $TypeStringProvider provider = new $TypeStringProvider(this.reporter, validationMethodCandidate, this.resolveReturnType(validationMethodCandidate), new $ImportsTypeStringResolver(declaringType.orNull(), declaringType.orNull()), this.protoclass.constitution().generics().vars(), null);
        provider.process();
        String returnTypeName = provider.returnTypeName();
        boolean bl = isCompatibleReturnType = this.protoclass.constitution().typeAbstract().toString().equals(returnTypeName) || this.protoclass.constitution().typeImmutable().toString().equals(returnTypeName);
        if (!isCompatibleReturnType) {
            this.report(validationMethodCandidate).error("Method '%s' annotated with @%s should have compatible return type to be used as normalization method. It should return abstract value type itself or immutable generated type (i.e. %s or %s)", validationMethodCandidate.getSimpleName(), $CheckMirror.simpleName(), this.protoclass.constitution().typeAbstract(), this.protoclass.constitution().typeImmutable());
            return false;
        }
        return true;
    }

    private $Styles.UsingName.AttributeNames deriveNames(String accessorName) {
        $Styles.UsingName.AttributeNames names = this.styles.forAccessor(accessorName);
        switch (names.raw) {
            case "hashCode": 
            case "toString": {
                return this.styles.forAccessorWithRaw(accessorName, accessorName);
            }
            case "ordinal": 
            case "domain": {
                if (!this.type.isOrdinalValue()) break;
                return this.styles.forAccessorWithRaw(accessorName, accessorName);
            }
            case "describeContents": {
                if (!this.type.isParcelable()) break;
                return this.styles.forAccessorWithRaw(accessorName, accessorName);
            }
        }
        return names;
    }

    private TypeMirror resolveReturnType(ExecutableElement method) {
        TypeElement typeElement = this.getTypeElement();
        if (this.isEclipseImplementation) {
            return method.getReturnType();
        }
        return $AccessorAttributesCollector.resolveReturnType(this.processing, method, typeElement);
    }

    static TypeMirror resolveReturnType(ProcessingEnvironment processing, ExecutableElement method, TypeElement typeElement) {
        TypeMirror returnType = (method = $CachingElements.getDelegate(method)).getReturnType();
        if (returnType.getKind() == TypeKind.TYPEVAR) {
            return $AccessorAttributesCollector.asInheritedMemberReturnType(processing, typeElement, method);
        }
        if (!(returnType.getKind() != TypeKind.DECLARED && returnType.getKind() != TypeKind.ERROR || ((DeclaredType)returnType).getTypeArguments().isEmpty())) {
            return $AccessorAttributesCollector.asInheritedMemberReturnType(processing, typeElement, method);
        }
        return returnType;
    }

    static TypeMirror asInheritedMemberReturnType(ProcessingEnvironment processing, TypeElement typeElement, ExecutableElement method) {
        ExecutableType asMethodOfType = (ExecutableType)processing.getTypeUtils().asMemberOf((DeclaredType)typeElement.asType(), method);
        return asMethodOfType.getReturnType();
    }

    private static boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isDiscoveredAttribute(ExecutableElement attributeMethodCandidate, boolean isDefaultAsDefault) {
        return attributeMethodCandidate.getParameters().isEmpty() && attributeMethodCandidate.getReturnType().getKind() != TypeKind.VOID && ($AccessorAttributesCollector.isAbstract(attributeMethodCandidate) || $AccessorAttributesCollector.hasGenerateAnnotation(attributeMethodCandidate) || isDefaultAsDefault);
    }

    private static boolean hasGenerateAnnotation(ExecutableElement attributeMethodCandidate) {
        return $DefaultMirror.isPresent(attributeMethodCandidate) || $DerivedMirror.isPresent(attributeMethodCandidate) || $LazyMirror.isPresent(attributeMethodCandidate);
    }

    private $Reporter report(Element type) {
        return $Reporter.from(this.protoclass.processing()).withElement(type);
    }

    static {
        Modifier def = null;
        for (Modifier m : Modifier.values()) {
            if (!m.name().equals("DEFAULT")) continue;
            def = m;
        }
        DEFAULT_MODIFIER = def;
    }
}

