package org.immutables.value.processor.encode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generator.Naming;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EncodedElement}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new EncodedElement.Builder()}.
 */
@Generated(from = "EncodedElement", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableEncodedElement extends EncodedElement {
  private final String name;
  private final Type type;
  private final Naming naming;
  private final ImmutableList<EncodedElement.Param> params;
  private final ImmutableList<Code.Term> code;
  private final ImmutableList<Type> thrown;
  private final ImmutableSet<EncodedElement.Tag> tags;
  private final Type.Parameters typeParameters;
  private final ImmutableList<EncodedElement.TypeParam> typeParams;
  private final ImmutableList<String> doc;
  private final ImmutableList<String> annotations;
  private final StandardNaming standardNaming;
  private transient final Code.Binding asBinding;
  private transient final boolean isToString;
  private transient final boolean isHashCode;
  private transient final boolean isEquals;
  private transient final boolean isFrom;
  private transient final boolean isBuild;
  private transient final boolean isInit;
  private transient final boolean isWasInit;
  private transient final boolean isCopy;
  private transient final boolean isBuilderCopy;
  private transient final boolean isExpose;
  private transient final boolean inBuilder;
  private transient final boolean isStatic;
  private transient final boolean isFinal;
  private transient final boolean isPrivate;
  private transient final boolean isSynthetic;
  private transient final boolean isImplField;
  private transient final boolean isValueField;
  private transient final boolean isStaticField;
  private transient final boolean isField;
  private transient final boolean isBuilderField;
  private transient final boolean isStaticMethod;
  private transient final boolean isValueMethod;
  private transient final boolean isBuilderMethod;
  private transient final boolean isBuilderStaticField;
  private transient final ImmutableList<Code.Term> oneLiner;
  private transient final boolean usesThis;
  private transient final boolean isInlinable;

  private ImmutableEncodedElement(ImmutableEncodedElement.Builder builder) {
    this.name = builder.name;
    this.type = builder.type;
    this.naming = builder.naming;
    this.params = builder.params.build();
    this.code = builder.code.build();
    this.thrown = builder.thrown.build();
    this.tags = Sets.immutableEnumSet(builder.tags.build());
    this.typeParameters = builder.typeParameters;
    this.typeParams = builder.typeParams.build();
    this.doc = builder.doc.build();
    this.annotations = builder.annotations.build();
    if (builder.standardNamingIsSet()) {
      initShim.standardNaming(builder.standardNaming);
    }
    this.standardNaming = initShim.standardNaming();
    this.asBinding = initShim.asBinding();
    this.isToString = initShim.isToString();
    this.isHashCode = initShim.isHashCode();
    this.isEquals = initShim.isEquals();
    this.isFrom = initShim.isFrom();
    this.isBuild = initShim.isBuild();
    this.isInit = initShim.isInit();
    this.isWasInit = initShim.isWasInit();
    this.isCopy = initShim.isCopy();
    this.isBuilderCopy = initShim.isBuilderCopy();
    this.isExpose = initShim.isExpose();
    this.inBuilder = initShim.inBuilder();
    this.isStatic = initShim.isStatic();
    this.isFinal = initShim.isFinal();
    this.isPrivate = initShim.isPrivate();
    this.isSynthetic = initShim.isSynthetic();
    this.isImplField = initShim.isImplField();
    this.isValueField = initShim.isValueField();
    this.isStaticField = initShim.isStaticField();
    this.isField = initShim.isField();
    this.isBuilderField = initShim.isBuilderField();
    this.isStaticMethod = initShim.isStaticMethod();
    this.isValueMethod = initShim.isValueMethod();
    this.isBuilderMethod = initShim.isBuilderMethod();
    this.isBuilderStaticField = initShim.isBuilderStaticField();
    this.oneLiner = initShim.oneLiner();
    this.usesThis = initShim.usesThis();
    this.isInlinable = initShim.isInlinable();
    this.initShim = null;
  }

  private ImmutableEncodedElement(
      String name,
      Type type,
      Naming naming,
      ImmutableList<EncodedElement.Param> params,
      ImmutableList<Code.Term> code,
      ImmutableList<Type> thrown,
      ImmutableSet<EncodedElement.Tag> tags,
      Type.Parameters typeParameters,
      ImmutableList<EncodedElement.TypeParam> typeParams,
      ImmutableList<String> doc,
      ImmutableList<String> annotations,
      StandardNaming standardNaming) {
    this.name = name;
    this.type = type;
    this.naming = naming;
    this.params = params;
    this.code = code;
    this.thrown = thrown;
    this.tags = tags;
    this.typeParameters = typeParameters;
    this.typeParams = typeParams;
    this.doc = doc;
    this.annotations = annotations;
    initShim.standardNaming(standardNaming);
    this.standardNaming = initShim.standardNaming();
    this.asBinding = initShim.asBinding();
    this.isToString = initShim.isToString();
    this.isHashCode = initShim.isHashCode();
    this.isEquals = initShim.isEquals();
    this.isFrom = initShim.isFrom();
    this.isBuild = initShim.isBuild();
    this.isInit = initShim.isInit();
    this.isWasInit = initShim.isWasInit();
    this.isCopy = initShim.isCopy();
    this.isBuilderCopy = initShim.isBuilderCopy();
    this.isExpose = initShim.isExpose();
    this.inBuilder = initShim.inBuilder();
    this.isStatic = initShim.isStatic();
    this.isFinal = initShim.isFinal();
    this.isPrivate = initShim.isPrivate();
    this.isSynthetic = initShim.isSynthetic();
    this.isImplField = initShim.isImplField();
    this.isValueField = initShim.isValueField();
    this.isStaticField = initShim.isStaticField();
    this.isField = initShim.isField();
    this.isBuilderField = initShim.isBuilderField();
    this.isStaticMethod = initShim.isStaticMethod();
    this.isValueMethod = initShim.isValueMethod();
    this.isBuilderMethod = initShim.isBuilderMethod();
    this.isBuilderStaticField = initShim.isBuilderStaticField();
    this.oneLiner = initShim.oneLiner();
    this.usesThis = initShim.usesThis();
    this.isInlinable = initShim.isInlinable();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "EncodedElement", generator = "Immutables")
  private final class InitShim {
    private byte standardNamingBuildStage = STAGE_UNINITIALIZED;
    private StandardNaming standardNaming;

    StandardNaming standardNaming() {
      if (standardNamingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (standardNamingBuildStage == STAGE_UNINITIALIZED) {
        standardNamingBuildStage = STAGE_INITIALIZING;
        this.standardNaming = Objects.requireNonNull(ImmutableEncodedElement.super.standardNaming(), "standardNaming");
        standardNamingBuildStage = STAGE_INITIALIZED;
      }
      return this.standardNaming;
    }

    void standardNaming(StandardNaming standardNaming) {
      this.standardNaming = standardNaming;
      standardNamingBuildStage = STAGE_INITIALIZED;
    }

    private byte asBindingBuildStage = STAGE_UNINITIALIZED;
    private Code.Binding asBinding;

    Code.Binding asBinding() {
      if (asBindingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (asBindingBuildStage == STAGE_UNINITIALIZED) {
        asBindingBuildStage = STAGE_INITIALIZING;
        this.asBinding = Objects.requireNonNull(ImmutableEncodedElement.super.asBinding(), "asBinding");
        asBindingBuildStage = STAGE_INITIALIZED;
      }
      return this.asBinding;
    }

    private byte isToStringBuildStage = STAGE_UNINITIALIZED;
    private boolean isToString;

    boolean isToString() {
      if (isToStringBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isToStringBuildStage == STAGE_UNINITIALIZED) {
        isToStringBuildStage = STAGE_INITIALIZING;
        this.isToString = ImmutableEncodedElement.super.isToString();
        isToStringBuildStage = STAGE_INITIALIZED;
      }
      return this.isToString;
    }

    private byte isHashCodeBuildStage = STAGE_UNINITIALIZED;
    private boolean isHashCode;

    boolean isHashCode() {
      if (isHashCodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isHashCodeBuildStage == STAGE_UNINITIALIZED) {
        isHashCodeBuildStage = STAGE_INITIALIZING;
        this.isHashCode = ImmutableEncodedElement.super.isHashCode();
        isHashCodeBuildStage = STAGE_INITIALIZED;
      }
      return this.isHashCode;
    }

    private byte isEqualsBuildStage = STAGE_UNINITIALIZED;
    private boolean isEquals;

    boolean isEquals() {
      if (isEqualsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isEqualsBuildStage == STAGE_UNINITIALIZED) {
        isEqualsBuildStage = STAGE_INITIALIZING;
        this.isEquals = ImmutableEncodedElement.super.isEquals();
        isEqualsBuildStage = STAGE_INITIALIZED;
      }
      return this.isEquals;
    }

    private byte isFromBuildStage = STAGE_UNINITIALIZED;
    private boolean isFrom;

    boolean isFrom() {
      if (isFromBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isFromBuildStage == STAGE_UNINITIALIZED) {
        isFromBuildStage = STAGE_INITIALIZING;
        this.isFrom = ImmutableEncodedElement.super.isFrom();
        isFromBuildStage = STAGE_INITIALIZED;
      }
      return this.isFrom;
    }

    private byte isBuildBuildStage = STAGE_UNINITIALIZED;
    private boolean isBuild;

    boolean isBuild() {
      if (isBuildBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBuildBuildStage == STAGE_UNINITIALIZED) {
        isBuildBuildStage = STAGE_INITIALIZING;
        this.isBuild = ImmutableEncodedElement.super.isBuild();
        isBuildBuildStage = STAGE_INITIALIZED;
      }
      return this.isBuild;
    }

    private byte isInitBuildStage = STAGE_UNINITIALIZED;
    private boolean isInit;

    boolean isInit() {
      if (isInitBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isInitBuildStage == STAGE_UNINITIALIZED) {
        isInitBuildStage = STAGE_INITIALIZING;
        this.isInit = ImmutableEncodedElement.super.isInit();
        isInitBuildStage = STAGE_INITIALIZED;
      }
      return this.isInit;
    }

    private byte isWasInitBuildStage = STAGE_UNINITIALIZED;
    private boolean isWasInit;

    boolean isWasInit() {
      if (isWasInitBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isWasInitBuildStage == STAGE_UNINITIALIZED) {
        isWasInitBuildStage = STAGE_INITIALIZING;
        this.isWasInit = ImmutableEncodedElement.super.isWasInit();
        isWasInitBuildStage = STAGE_INITIALIZED;
      }
      return this.isWasInit;
    }

    private byte isCopyBuildStage = STAGE_UNINITIALIZED;
    private boolean isCopy;

    boolean isCopy() {
      if (isCopyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isCopyBuildStage == STAGE_UNINITIALIZED) {
        isCopyBuildStage = STAGE_INITIALIZING;
        this.isCopy = ImmutableEncodedElement.super.isCopy();
        isCopyBuildStage = STAGE_INITIALIZED;
      }
      return this.isCopy;
    }

    private byte isBuilderCopyBuildStage = STAGE_UNINITIALIZED;
    private boolean isBuilderCopy;

    boolean isBuilderCopy() {
      if (isBuilderCopyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBuilderCopyBuildStage == STAGE_UNINITIALIZED) {
        isBuilderCopyBuildStage = STAGE_INITIALIZING;
        this.isBuilderCopy = ImmutableEncodedElement.super.isBuilderCopy();
        isBuilderCopyBuildStage = STAGE_INITIALIZED;
      }
      return this.isBuilderCopy;
    }

    private byte isExposeBuildStage = STAGE_UNINITIALIZED;
    private boolean isExpose;

    boolean isExpose() {
      if (isExposeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isExposeBuildStage == STAGE_UNINITIALIZED) {
        isExposeBuildStage = STAGE_INITIALIZING;
        this.isExpose = ImmutableEncodedElement.super.isExpose();
        isExposeBuildStage = STAGE_INITIALIZED;
      }
      return this.isExpose;
    }

    private byte inBuilderBuildStage = STAGE_UNINITIALIZED;
    private boolean inBuilder;

    boolean inBuilder() {
      if (inBuilderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (inBuilderBuildStage == STAGE_UNINITIALIZED) {
        inBuilderBuildStage = STAGE_INITIALIZING;
        this.inBuilder = ImmutableEncodedElement.super.inBuilder();
        inBuilderBuildStage = STAGE_INITIALIZED;
      }
      return this.inBuilder;
    }

    private byte isStaticBuildStage = STAGE_UNINITIALIZED;
    private boolean isStatic;

    boolean isStatic() {
      if (isStaticBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isStaticBuildStage == STAGE_UNINITIALIZED) {
        isStaticBuildStage = STAGE_INITIALIZING;
        this.isStatic = ImmutableEncodedElement.super.isStatic();
        isStaticBuildStage = STAGE_INITIALIZED;
      }
      return this.isStatic;
    }

    private byte isFinalBuildStage = STAGE_UNINITIALIZED;
    private boolean isFinal;

    boolean isFinal() {
      if (isFinalBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isFinalBuildStage == STAGE_UNINITIALIZED) {
        isFinalBuildStage = STAGE_INITIALIZING;
        this.isFinal = ImmutableEncodedElement.super.isFinal();
        isFinalBuildStage = STAGE_INITIALIZED;
      }
      return this.isFinal;
    }

    private byte isPrivateBuildStage = STAGE_UNINITIALIZED;
    private boolean isPrivate;

    boolean isPrivate() {
      if (isPrivateBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isPrivateBuildStage == STAGE_UNINITIALIZED) {
        isPrivateBuildStage = STAGE_INITIALIZING;
        this.isPrivate = ImmutableEncodedElement.super.isPrivate();
        isPrivateBuildStage = STAGE_INITIALIZED;
      }
      return this.isPrivate;
    }

    private byte isSyntheticBuildStage = STAGE_UNINITIALIZED;
    private boolean isSynthetic;

    boolean isSynthetic() {
      if (isSyntheticBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isSyntheticBuildStage == STAGE_UNINITIALIZED) {
        isSyntheticBuildStage = STAGE_INITIALIZING;
        this.isSynthetic = ImmutableEncodedElement.super.isSynthetic();
        isSyntheticBuildStage = STAGE_INITIALIZED;
      }
      return this.isSynthetic;
    }

    private byte isImplFieldBuildStage = STAGE_UNINITIALIZED;
    private boolean isImplField;

    boolean isImplField() {
      if (isImplFieldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isImplFieldBuildStage == STAGE_UNINITIALIZED) {
        isImplFieldBuildStage = STAGE_INITIALIZING;
        this.isImplField = ImmutableEncodedElement.super.isImplField();
        isImplFieldBuildStage = STAGE_INITIALIZED;
      }
      return this.isImplField;
    }

    private byte isValueFieldBuildStage = STAGE_UNINITIALIZED;
    private boolean isValueField;

    boolean isValueField() {
      if (isValueFieldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isValueFieldBuildStage == STAGE_UNINITIALIZED) {
        isValueFieldBuildStage = STAGE_INITIALIZING;
        this.isValueField = ImmutableEncodedElement.super.isValueField();
        isValueFieldBuildStage = STAGE_INITIALIZED;
      }
      return this.isValueField;
    }

    private byte isStaticFieldBuildStage = STAGE_UNINITIALIZED;
    private boolean isStaticField;

    boolean isStaticField() {
      if (isStaticFieldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isStaticFieldBuildStage == STAGE_UNINITIALIZED) {
        isStaticFieldBuildStage = STAGE_INITIALIZING;
        this.isStaticField = ImmutableEncodedElement.super.isStaticField();
        isStaticFieldBuildStage = STAGE_INITIALIZED;
      }
      return this.isStaticField;
    }

    private byte isFieldBuildStage = STAGE_UNINITIALIZED;
    private boolean isField;

    boolean isField() {
      if (isFieldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isFieldBuildStage == STAGE_UNINITIALIZED) {
        isFieldBuildStage = STAGE_INITIALIZING;
        this.isField = ImmutableEncodedElement.super.isField();
        isFieldBuildStage = STAGE_INITIALIZED;
      }
      return this.isField;
    }

    private byte isBuilderFieldBuildStage = STAGE_UNINITIALIZED;
    private boolean isBuilderField;

    boolean isBuilderField() {
      if (isBuilderFieldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBuilderFieldBuildStage == STAGE_UNINITIALIZED) {
        isBuilderFieldBuildStage = STAGE_INITIALIZING;
        this.isBuilderField = ImmutableEncodedElement.super.isBuilderField();
        isBuilderFieldBuildStage = STAGE_INITIALIZED;
      }
      return this.isBuilderField;
    }

    private byte isStaticMethodBuildStage = STAGE_UNINITIALIZED;
    private boolean isStaticMethod;

    boolean isStaticMethod() {
      if (isStaticMethodBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isStaticMethodBuildStage == STAGE_UNINITIALIZED) {
        isStaticMethodBuildStage = STAGE_INITIALIZING;
        this.isStaticMethod = ImmutableEncodedElement.super.isStaticMethod();
        isStaticMethodBuildStage = STAGE_INITIALIZED;
      }
      return this.isStaticMethod;
    }

    private byte isValueMethodBuildStage = STAGE_UNINITIALIZED;
    private boolean isValueMethod;

    boolean isValueMethod() {
      if (isValueMethodBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isValueMethodBuildStage == STAGE_UNINITIALIZED) {
        isValueMethodBuildStage = STAGE_INITIALIZING;
        this.isValueMethod = ImmutableEncodedElement.super.isValueMethod();
        isValueMethodBuildStage = STAGE_INITIALIZED;
      }
      return this.isValueMethod;
    }

    private byte isBuilderMethodBuildStage = STAGE_UNINITIALIZED;
    private boolean isBuilderMethod;

    boolean isBuilderMethod() {
      if (isBuilderMethodBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBuilderMethodBuildStage == STAGE_UNINITIALIZED) {
        isBuilderMethodBuildStage = STAGE_INITIALIZING;
        this.isBuilderMethod = ImmutableEncodedElement.super.isBuilderMethod();
        isBuilderMethodBuildStage = STAGE_INITIALIZED;
      }
      return this.isBuilderMethod;
    }

    private byte isBuilderStaticFieldBuildStage = STAGE_UNINITIALIZED;
    private boolean isBuilderStaticField;

    boolean isBuilderStaticField() {
      if (isBuilderStaticFieldBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBuilderStaticFieldBuildStage == STAGE_UNINITIALIZED) {
        isBuilderStaticFieldBuildStage = STAGE_INITIALIZING;
        this.isBuilderStaticField = ImmutableEncodedElement.super.isBuilderStaticField();
        isBuilderStaticFieldBuildStage = STAGE_INITIALIZED;
      }
      return this.isBuilderStaticField;
    }

    private byte oneLinerBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<Code.Term> oneLiner;

    ImmutableList<Code.Term> oneLiner() {
      if (oneLinerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (oneLinerBuildStage == STAGE_UNINITIALIZED) {
        oneLinerBuildStage = STAGE_INITIALIZING;
        this.oneLiner = Objects.requireNonNull(ImmutableEncodedElement.super.oneLiner(), "oneLiner");
        oneLinerBuildStage = STAGE_INITIALIZED;
      }
      return this.oneLiner;
    }

    private byte usesThisBuildStage = STAGE_UNINITIALIZED;
    private boolean usesThis;

    boolean usesThis() {
      if (usesThisBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usesThisBuildStage == STAGE_UNINITIALIZED) {
        usesThisBuildStage = STAGE_INITIALIZING;
        this.usesThis = ImmutableEncodedElement.super.usesThis();
        usesThisBuildStage = STAGE_INITIALIZED;
      }
      return this.usesThis;
    }

    private byte isInlinableBuildStage = STAGE_UNINITIALIZED;
    private boolean isInlinable;

    boolean isInlinable() {
      if (isInlinableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isInlinableBuildStage == STAGE_UNINITIALIZED) {
        isInlinableBuildStage = STAGE_INITIALIZING;
        this.isInlinable = ImmutableEncodedElement.super.isInlinable();
        isInlinableBuildStage = STAGE_INITIALIZED;
      }
      return this.isInlinable;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (standardNamingBuildStage == STAGE_INITIALIZING) attributes.add("standardNaming");
      if (asBindingBuildStage == STAGE_INITIALIZING) attributes.add("asBinding");
      if (isToStringBuildStage == STAGE_INITIALIZING) attributes.add("isToString");
      if (isHashCodeBuildStage == STAGE_INITIALIZING) attributes.add("isHashCode");
      if (isEqualsBuildStage == STAGE_INITIALIZING) attributes.add("isEquals");
      if (isFromBuildStage == STAGE_INITIALIZING) attributes.add("isFrom");
      if (isBuildBuildStage == STAGE_INITIALIZING) attributes.add("isBuild");
      if (isInitBuildStage == STAGE_INITIALIZING) attributes.add("isInit");
      if (isWasInitBuildStage == STAGE_INITIALIZING) attributes.add("isWasInit");
      if (isCopyBuildStage == STAGE_INITIALIZING) attributes.add("isCopy");
      if (isBuilderCopyBuildStage == STAGE_INITIALIZING) attributes.add("isBuilderCopy");
      if (isExposeBuildStage == STAGE_INITIALIZING) attributes.add("isExpose");
      if (inBuilderBuildStage == STAGE_INITIALIZING) attributes.add("inBuilder");
      if (isStaticBuildStage == STAGE_INITIALIZING) attributes.add("isStatic");
      if (isFinalBuildStage == STAGE_INITIALIZING) attributes.add("isFinal");
      if (isPrivateBuildStage == STAGE_INITIALIZING) attributes.add("isPrivate");
      if (isSyntheticBuildStage == STAGE_INITIALIZING) attributes.add("isSynthetic");
      if (isImplFieldBuildStage == STAGE_INITIALIZING) attributes.add("isImplField");
      if (isValueFieldBuildStage == STAGE_INITIALIZING) attributes.add("isValueField");
      if (isStaticFieldBuildStage == STAGE_INITIALIZING) attributes.add("isStaticField");
      if (isFieldBuildStage == STAGE_INITIALIZING) attributes.add("isField");
      if (isBuilderFieldBuildStage == STAGE_INITIALIZING) attributes.add("isBuilderField");
      if (isStaticMethodBuildStage == STAGE_INITIALIZING) attributes.add("isStaticMethod");
      if (isValueMethodBuildStage == STAGE_INITIALIZING) attributes.add("isValueMethod");
      if (isBuilderMethodBuildStage == STAGE_INITIALIZING) attributes.add("isBuilderMethod");
      if (isBuilderStaticFieldBuildStage == STAGE_INITIALIZING) attributes.add("isBuilderStaticField");
      if (oneLinerBuildStage == STAGE_INITIALIZING) attributes.add("oneLiner");
      if (usesThisBuildStage == STAGE_INITIALIZING) attributes.add("usesThis");
      if (isInlinableBuildStage == STAGE_INITIALIZING) attributes.add("isInlinable");
      return "Cannot build EncodedElement, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  String name() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  Type type() {
    return type;
  }

  /**
   * @return The value of the {@code naming} attribute
   */
  @Override
  Naming naming() {
    return naming;
  }

  /**
   * @return The value of the {@code params} attribute
   */
  @Override
  ImmutableList<EncodedElement.Param> params() {
    return params;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @Override
  ImmutableList<Code.Term> code() {
    return code;
  }

  /**
   * @return The value of the {@code thrown} attribute
   */
  @Override
  ImmutableList<Type> thrown() {
    return thrown;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @Override
  ImmutableSet<EncodedElement.Tag> tags() {
    return tags;
  }

  /**
   * @return The value of the {@code typeParameters} attribute
   */
  @Override
  Type.Parameters typeParameters() {
    return typeParameters;
  }

  /**
   * @return The value of the {@code typeParams} attribute
   */
  @Override
  ImmutableList<EncodedElement.TypeParam> typeParams() {
    return typeParams;
  }

  /**
   * @return The value of the {@code doc} attribute
   */
  @Override
  ImmutableList<String> doc() {
    return doc;
  }

  /**
   * @return The value of the {@code annotations} attribute
   */
  @Override
  ImmutableList<String> annotations() {
    return annotations;
  }

  /**
   * @return The value of the {@code standardNaming} attribute
   */
  @Override
  StandardNaming standardNaming() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.standardNaming()
        : this.standardNaming;
  }

  /**
   * @return The computed-at-construction value of the {@code asBinding} attribute
   */
  @Override
  Code.Binding asBinding() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.asBinding()
        : this.asBinding;
  }

  /**
   * @return The computed-at-construction value of the {@code isToString} attribute
   */
  @Override
  boolean isToString() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isToString()
        : this.isToString;
  }

  /**
   * @return The computed-at-construction value of the {@code isHashCode} attribute
   */
  @Override
  boolean isHashCode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isHashCode()
        : this.isHashCode;
  }

  /**
   * @return The computed-at-construction value of the {@code isEquals} attribute
   */
  @Override
  boolean isEquals() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isEquals()
        : this.isEquals;
  }

  /**
   * @return The computed-at-construction value of the {@code isFrom} attribute
   */
  @Override
  boolean isFrom() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFrom()
        : this.isFrom;
  }

  /**
   * @return The computed-at-construction value of the {@code isBuild} attribute
   */
  @Override
  boolean isBuild() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBuild()
        : this.isBuild;
  }

  /**
   * @return The computed-at-construction value of the {@code isInit} attribute
   */
  @Override
  boolean isInit() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isInit()
        : this.isInit;
  }

  /**
   * @return The computed-at-construction value of the {@code isWasInit} attribute
   */
  @Override
  boolean isWasInit() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isWasInit()
        : this.isWasInit;
  }

  /**
   * @return The computed-at-construction value of the {@code isCopy} attribute
   */
  @Override
  boolean isCopy() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isCopy()
        : this.isCopy;
  }

  /**
   * @return The computed-at-construction value of the {@code isBuilderCopy} attribute
   */
  @Override
  boolean isBuilderCopy() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBuilderCopy()
        : this.isBuilderCopy;
  }

  /**
   * @return The computed-at-construction value of the {@code isExpose} attribute
   */
  @Override
  boolean isExpose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isExpose()
        : this.isExpose;
  }

  /**
   * @return The computed-at-construction value of the {@code inBuilder} attribute
   */
  @Override
  boolean inBuilder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.inBuilder()
        : this.inBuilder;
  }

  /**
   * @return The computed-at-construction value of the {@code isStatic} attribute
   */
  @Override
  boolean isStatic() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isStatic()
        : this.isStatic;
  }

  /**
   * @return The computed-at-construction value of the {@code isFinal} attribute
   */
  @Override
  boolean isFinal() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isFinal()
        : this.isFinal;
  }

  /**
   * @return The computed-at-construction value of the {@code isPrivate} attribute
   */
  @Override
  boolean isPrivate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isPrivate()
        : this.isPrivate;
  }

  /**
   * @return The computed-at-construction value of the {@code isSynthetic} attribute
   */
  @Override
  boolean isSynthetic() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSynthetic()
        : this.isSynthetic;
  }

  /**
   * @return The computed-at-construction value of the {@code isImplField} attribute
   */
  @Override
  boolean isImplField() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isImplField()
        : this.isImplField;
  }

  /**
   * @return The computed-at-construction value of the {@code isValueField} attribute
   */
  @Override
  boolean isValueField() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isValueField()
        : this.isValueField;
  }

  /**
   * @return The computed-at-construction value of the {@code isStaticField} attribute
   */
  @Override
  boolean isStaticField() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isStaticField()
        : this.isStaticField;
  }

  /**
   * @return The computed-at-construction value of the {@code isField} attribute
   */
  @Override
  boolean isField() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isField()
        : this.isField;
  }

  /**
   * @return The computed-at-construction value of the {@code isBuilderField} attribute
   */
  @Override
  boolean isBuilderField() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBuilderField()
        : this.isBuilderField;
  }

  /**
   * @return The computed-at-construction value of the {@code isStaticMethod} attribute
   */
  @Override
  boolean isStaticMethod() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isStaticMethod()
        : this.isStaticMethod;
  }

  /**
   * @return The computed-at-construction value of the {@code isValueMethod} attribute
   */
  @Override
  boolean isValueMethod() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isValueMethod()
        : this.isValueMethod;
  }

  /**
   * @return The computed-at-construction value of the {@code isBuilderMethod} attribute
   */
  @Override
  boolean isBuilderMethod() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBuilderMethod()
        : this.isBuilderMethod;
  }

  /**
   * @return The computed-at-construction value of the {@code isBuilderStaticField} attribute
   */
  @Override
  boolean isBuilderStaticField() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBuilderStaticField()
        : this.isBuilderStaticField;
  }

  /**
   * @return The computed-at-construction value of the {@code oneLiner} attribute
   */
  @Override
  ImmutableList<Code.Term> oneLiner() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.oneLiner()
        : this.oneLiner;
  }

  /**
   * @return The computed-at-construction value of the {@code usesThis} attribute
   */
  @Override
  boolean usesThis() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.usesThis()
        : this.usesThis;
  }

  /**
   * @return The computed-at-construction value of the {@code isInlinable} attribute
   */
  @Override
  boolean isInlinable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isInlinable()
        : this.isInlinable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncodedElement#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEncodedElement withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableEncodedElement(
        newValue,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncodedElement#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEncodedElement withType(Type value) {
    if (this.type == value) return this;
    Type newValue = Objects.requireNonNull(value, "type");
    return new ImmutableEncodedElement(
        this.name,
        newValue,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncodedElement#naming() naming} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for naming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEncodedElement withNaming(Naming value) {
    if (this.naming == value) return this;
    Naming newValue = Objects.requireNonNull(value, "naming");
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        newValue,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#params() params}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withParams(EncodedElement.Param... elements) {
    ImmutableList<EncodedElement.Param> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        newValue,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#params() params}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of params elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withParams(Iterable<? extends EncodedElement.Param> elements) {
    if (this.params == elements) return this;
    ImmutableList<EncodedElement.Param> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        newValue,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#code() code}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withCode(Code.Term... elements) {
    ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        newValue,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#code() code}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of code elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withCode(Iterable<? extends Code.Term> elements) {
    if (this.code == elements) return this;
    ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        newValue,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#thrown() thrown}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withThrown(Type... elements) {
    ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        newValue,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#thrown() thrown}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of thrown elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withThrown(Iterable<? extends Type> elements) {
    if (this.thrown == elements) return this;
    ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        newValue,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#tags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withTags(EncodedElement.Tag... elements) {
    ImmutableSet<EncodedElement.Tag> newValue = Sets.immutableEnumSet(Arrays.asList(elements));
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        newValue,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#tags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withTags(Iterable<EncodedElement.Tag> elements) {
    if (this.tags == elements) return this;
    ImmutableSet<EncodedElement.Tag> newValue = Sets.immutableEnumSet(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        newValue,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncodedElement#typeParameters() typeParameters} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeParameters
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEncodedElement withTypeParameters(Type.Parameters value) {
    if (this.typeParameters == value) return this;
    Type.Parameters newValue = Objects.requireNonNull(value, "typeParameters");
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        newValue,
        this.typeParams,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#typeParams() typeParams}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withTypeParams(EncodedElement.TypeParam... elements) {
    ImmutableList<EncodedElement.TypeParam> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        newValue,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#typeParams() typeParams}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of typeParams elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withTypeParams(Iterable<? extends EncodedElement.TypeParam> elements) {
    if (this.typeParams == elements) return this;
    ImmutableList<EncodedElement.TypeParam> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        newValue,
        this.doc,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#doc() doc}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withDoc(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        newValue,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#doc() doc}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of doc elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withDoc(Iterable<String> elements) {
    if (this.doc == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        newValue,
        this.annotations,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#annotations() annotations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withAnnotations(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        newValue,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EncodedElement#annotations() annotations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of annotations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEncodedElement withAnnotations(Iterable<String> elements) {
    if (this.annotations == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        newValue,
        this.standardNaming);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncodedElement#standardNaming() standardNaming} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for standardNaming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEncodedElement withStandardNaming(StandardNaming value) {
    if (this.standardNaming == value) return this;
    StandardNaming newValue = Objects.requireNonNull(value, "standardNaming");
    if (this.standardNaming.equals(newValue)) return this;
    return new ImmutableEncodedElement(
        this.name,
        this.type,
        this.naming,
        this.params,
        this.code,
        this.thrown,
        this.tags,
        this.typeParameters,
        this.typeParams,
        this.doc,
        this.annotations,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEncodedElement} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEncodedElement
        && equalTo((ImmutableEncodedElement) another);
  }

  private boolean equalTo(ImmutableEncodedElement another) {
    return name.equals(another.name)
        && type.equals(another.type)
        && naming.equals(another.naming)
        && params.equals(another.params)
        && code.equals(another.code)
        && thrown.equals(another.thrown)
        && tags.equals(another.tags)
        && typeParameters.equals(another.typeParameters)
        && typeParams.equals(another.typeParams)
        && doc.equals(another.doc)
        && annotations.equals(another.annotations)
        && standardNaming.equals(another.standardNaming)
        && asBinding.equals(another.asBinding)
        && isToString == another.isToString
        && isHashCode == another.isHashCode
        && isEquals == another.isEquals
        && isFrom == another.isFrom
        && isBuild == another.isBuild
        && isInit == another.isInit
        && isWasInit == another.isWasInit
        && isCopy == another.isCopy
        && isBuilderCopy == another.isBuilderCopy
        && isExpose == another.isExpose
        && inBuilder == another.inBuilder
        && isStatic == another.isStatic
        && isFinal == another.isFinal
        && isPrivate == another.isPrivate
        && isSynthetic == another.isSynthetic
        && isImplField == another.isImplField
        && isValueField == another.isValueField
        && isStaticField == another.isStaticField
        && isField == another.isField
        && isBuilderField == another.isBuilderField
        && isStaticMethod == another.isStaticMethod
        && isValueMethod == another.isValueMethod
        && isBuilderMethod == another.isBuilderMethod
        && isBuilderStaticField == another.isBuilderStaticField
        && oneLiner.equals(another.oneLiner)
        && usesThis == another.usesThis
        && isInlinable == another.isInlinable;
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}, {@code naming}, {@code params}, {@code code}, {@code thrown}, {@code tags}, {@code typeParameters}, {@code typeParams}, {@code doc}, {@code annotations}, {@code standardNaming}, {@code asBinding}, {@code isToString}, {@code isHashCode}, {@code isEquals}, {@code isFrom}, {@code isBuild}, {@code isInit}, {@code isWasInit}, {@code isCopy}, {@code isBuilderCopy}, {@code isExpose}, {@code inBuilder}, {@code isStatic}, {@code isFinal}, {@code isPrivate}, {@code isSynthetic}, {@code isImplField}, {@code isValueField}, {@code isStaticField}, {@code isField}, {@code isBuilderField}, {@code isStaticMethod}, {@code isValueMethod}, {@code isBuilderMethod}, {@code isBuilderStaticField}, {@code oneLiner}, {@code usesThis}, {@code isInlinable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + naming.hashCode();
    h += (h << 5) + params.hashCode();
    h += (h << 5) + code.hashCode();
    h += (h << 5) + thrown.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + typeParameters.hashCode();
    h += (h << 5) + typeParams.hashCode();
    h += (h << 5) + doc.hashCode();
    h += (h << 5) + annotations.hashCode();
    h += (h << 5) + standardNaming.hashCode();
    h += (h << 5) + asBinding.hashCode();
    h += (h << 5) + Booleans.hashCode(isToString);
    h += (h << 5) + Booleans.hashCode(isHashCode);
    h += (h << 5) + Booleans.hashCode(isEquals);
    h += (h << 5) + Booleans.hashCode(isFrom);
    h += (h << 5) + Booleans.hashCode(isBuild);
    h += (h << 5) + Booleans.hashCode(isInit);
    h += (h << 5) + Booleans.hashCode(isWasInit);
    h += (h << 5) + Booleans.hashCode(isCopy);
    h += (h << 5) + Booleans.hashCode(isBuilderCopy);
    h += (h << 5) + Booleans.hashCode(isExpose);
    h += (h << 5) + Booleans.hashCode(inBuilder);
    h += (h << 5) + Booleans.hashCode(isStatic);
    h += (h << 5) + Booleans.hashCode(isFinal);
    h += (h << 5) + Booleans.hashCode(isPrivate);
    h += (h << 5) + Booleans.hashCode(isSynthetic);
    h += (h << 5) + Booleans.hashCode(isImplField);
    h += (h << 5) + Booleans.hashCode(isValueField);
    h += (h << 5) + Booleans.hashCode(isStaticField);
    h += (h << 5) + Booleans.hashCode(isField);
    h += (h << 5) + Booleans.hashCode(isBuilderField);
    h += (h << 5) + Booleans.hashCode(isStaticMethod);
    h += (h << 5) + Booleans.hashCode(isValueMethod);
    h += (h << 5) + Booleans.hashCode(isBuilderMethod);
    h += (h << 5) + Booleans.hashCode(isBuilderStaticField);
    h += (h << 5) + oneLiner.hashCode();
    h += (h << 5) + Booleans.hashCode(usesThis);
    h += (h << 5) + Booleans.hashCode(isInlinable);
    return h;
  }

  /**
   * Prints the immutable value {@code EncodedElement} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EncodedElement")
        .omitNullValues()
        .add("name", name)
        .add("type", type)
        .add("naming", naming)
        .add("params", params)
        .add("code", code)
        .add("thrown", thrown)
        .add("tags", tags)
        .add("typeParameters", typeParameters)
        .add("typeParams", typeParams)
        .add("doc", doc)
        .add("annotations", annotations)
        .add("standardNaming", standardNaming)
        .add("asBinding", asBinding)
        .add("isToString", isToString)
        .add("isHashCode", isHashCode)
        .add("isEquals", isEquals)
        .add("isFrom", isFrom)
        .add("isBuild", isBuild)
        .add("isInit", isInit)
        .add("isWasInit", isWasInit)
        .add("isCopy", isCopy)
        .add("isBuilderCopy", isBuilderCopy)
        .add("isExpose", isExpose)
        .add("inBuilder", inBuilder)
        .add("isStatic", isStatic)
        .add("isFinal", isFinal)
        .add("isPrivate", isPrivate)
        .add("isSynthetic", isSynthetic)
        .add("isImplField", isImplField)
        .add("isValueField", isValueField)
        .add("isStaticField", isStaticField)
        .add("isField", isField)
        .add("isBuilderField", isBuilderField)
        .add("isStaticMethod", isStaticMethod)
        .add("isValueMethod", isValueMethod)
        .add("isBuilderMethod", isBuilderMethod)
        .add("isBuilderStaticField", isBuilderStaticField)
        .add("oneLiner", oneLiner)
        .add("usesThis", usesThis)
        .add("isInlinable", isInlinable)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link EncodedElement} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EncodedElement instance
   */
  public static EncodedElement copyOf(EncodedElement instance) {
    if (instance instanceof ImmutableEncodedElement) {
      return (ImmutableEncodedElement) instance;
    }
    return new EncodedElement.Builder()
        .name(instance.name())
        .type(instance.type())
        .naming(instance.naming())
        .addAllParams(instance.params())
        .addAllCode(instance.code())
        .addAllThrown(instance.thrown())
        .addAllTags(instance.tags())
        .typeParameters(instance.typeParameters())
        .addAllTypeParams(instance.typeParams())
        .addAllDoc(instance.doc())
        .addAllAnnotations(instance.annotations())
        .standardNaming(instance.standardNaming())
        .build();
  }

  /**
   * Builds instances of type {@link EncodedElement EncodedElement}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EncodedElement", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_NAMING = 0x4L;
    private static final long INIT_BIT_TYPE_PARAMETERS = 0x8L;
    private static final long OPT_BIT_STANDARD_NAMING = 0x1L;
    private long initBits = 0xfL;
    private long optBits;

    private @Nullable String name;
    private @Nullable Type type;
    private @Nullable Naming naming;
    private final ImmutableList.Builder<EncodedElement.Param> params = ImmutableList.builder();
    private final ImmutableList.Builder<Code.Term> code = ImmutableList.builder();
    private final ImmutableList.Builder<Type> thrown = ImmutableList.builder();
    private final ImmutableSet.Builder<EncodedElement.Tag> tags = ImmutableSet.builder();
    private @Nullable Type.Parameters typeParameters;
    private final ImmutableList.Builder<EncodedElement.TypeParam> typeParams = ImmutableList.builder();
    private final ImmutableList.Builder<String> doc = ImmutableList.builder();
    private final ImmutableList.Builder<String> annotations = ImmutableList.builder();
    private @Nullable StandardNaming standardNaming;

    /**
     * Creates a builder for {@link EncodedElement EncodedElement} instances.
     * <pre>
     * new EncodedElement.Builder()
     *    .name(String) // required {@link EncodedElement#name() name}
     *    .type(org.immutables.value.processor.encode.Type) // required {@link EncodedElement#type() type}
     *    .naming(org.immutables.generator.Naming) // required {@link EncodedElement#naming() naming}
     *    .addParams|addAllParams(org.immutables.value.processor.encode.EncodedElement.Param) // {@link EncodedElement#params() params} elements
     *    .addCode|addAllCode(org.immutables.value.processor.encode.Code.Term) // {@link EncodedElement#code() code} elements
     *    .addThrown|addAllThrown(org.immutables.value.processor.encode.Type) // {@link EncodedElement#thrown() thrown} elements
     *    .addTags|addAllTags(org.immutables.value.processor.encode.EncodedElement.Tag) // {@link EncodedElement#tags() tags} elements
     *    .typeParameters(org.immutables.value.processor.encode.Type.Parameters) // required {@link EncodedElement#typeParameters() typeParameters}
     *    .addTypeParams|addAllTypeParams(org.immutables.value.processor.encode.EncodedElement.TypeParam) // {@link EncodedElement#typeParams() typeParams} elements
     *    .addDoc|addAllDoc(String) // {@link EncodedElement#doc() doc} elements
     *    .addAnnotations|addAllAnnotations(String) // {@link EncodedElement#annotations() annotations} elements
     *    .standardNaming(org.immutables.value.processor.encode.StandardNaming) // optional {@link EncodedElement#standardNaming() standardNaming}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof EncodedElement.Builder)) {
        throw new UnsupportedOperationException("Use: new EncodedElement.Builder()");
      }
    }

    /**
     * Initializes the value for the {@link EncodedElement#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return (EncodedElement.Builder) this;
    }

    /**
     * Initializes the value for the {@link EncodedElement#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder type(Type type) {
      checkNotIsSet(typeIsSet(), "type");
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return (EncodedElement.Builder) this;
    }

    /**
     * Initializes the value for the {@link EncodedElement#naming() naming} attribute.
     * @param naming The value for naming 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder naming(Naming naming) {
      checkNotIsSet(namingIsSet(), "naming");
      this.naming = Objects.requireNonNull(naming, "naming");
      initBits &= ~INIT_BIT_NAMING;
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds one element to {@link EncodedElement#params() params} list.
     * @param element A params element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addParams(EncodedElement.Param element) {
      this.params.add(element);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds elements to {@link EncodedElement#params() params} list.
     * @param elements An array of params elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addParams(EncodedElement.Param... elements) {
      this.params.add(elements);
      return (EncodedElement.Builder) this;
    }


    /**
     * Adds elements to {@link EncodedElement#params() params} list.
     * @param elements An iterable of params elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAllParams(Iterable<? extends EncodedElement.Param> elements) {
      this.params.addAll(elements);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds one element to {@link EncodedElement#code() code} list.
     * @param element A code element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addCode(Code.Term element) {
      this.code.add(element);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds elements to {@link EncodedElement#code() code} list.
     * @param elements An array of code elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addCode(Code.Term... elements) {
      this.code.add(elements);
      return (EncodedElement.Builder) this;
    }


    /**
     * Adds elements to {@link EncodedElement#code() code} list.
     * @param elements An iterable of code elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAllCode(Iterable<? extends Code.Term> elements) {
      this.code.addAll(elements);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds one element to {@link EncodedElement#thrown() thrown} list.
     * @param element A thrown element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addThrown(Type element) {
      this.thrown.add(element);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds elements to {@link EncodedElement#thrown() thrown} list.
     * @param elements An array of thrown elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addThrown(Type... elements) {
      this.thrown.add(elements);
      return (EncodedElement.Builder) this;
    }


    /**
     * Adds elements to {@link EncodedElement#thrown() thrown} list.
     * @param elements An iterable of thrown elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAllThrown(Iterable<? extends Type> elements) {
      this.thrown.addAll(elements);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds one element to {@link EncodedElement#tags() tags} set.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addTags(EncodedElement.Tag element) {
      this.tags.add(element);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds elements to {@link EncodedElement#tags() tags} set.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addTags(EncodedElement.Tag... elements) {
      this.tags.addAll(Arrays.asList(elements));
      return (EncodedElement.Builder) this;
    }


    /**
     * Adds elements to {@link EncodedElement#tags() tags} set.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAllTags(Iterable<EncodedElement.Tag> elements) {
      this.tags.addAll(elements);
      return (EncodedElement.Builder) this;
    }

    /**
     * Initializes the value for the {@link EncodedElement#typeParameters() typeParameters} attribute.
     * @param typeParameters The value for typeParameters 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder typeParameters(Type.Parameters typeParameters) {
      checkNotIsSet(typeParametersIsSet(), "typeParameters");
      this.typeParameters = Objects.requireNonNull(typeParameters, "typeParameters");
      initBits &= ~INIT_BIT_TYPE_PARAMETERS;
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds one element to {@link EncodedElement#typeParams() typeParams} list.
     * @param element A typeParams element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addTypeParams(EncodedElement.TypeParam element) {
      this.typeParams.add(element);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds elements to {@link EncodedElement#typeParams() typeParams} list.
     * @param elements An array of typeParams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addTypeParams(EncodedElement.TypeParam... elements) {
      this.typeParams.add(elements);
      return (EncodedElement.Builder) this;
    }


    /**
     * Adds elements to {@link EncodedElement#typeParams() typeParams} list.
     * @param elements An iterable of typeParams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAllTypeParams(Iterable<? extends EncodedElement.TypeParam> elements) {
      this.typeParams.addAll(elements);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds one element to {@link EncodedElement#doc() doc} list.
     * @param element A doc element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addDoc(String element) {
      this.doc.add(element);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds elements to {@link EncodedElement#doc() doc} list.
     * @param elements An array of doc elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addDoc(String... elements) {
      this.doc.add(elements);
      return (EncodedElement.Builder) this;
    }


    /**
     * Adds elements to {@link EncodedElement#doc() doc} list.
     * @param elements An iterable of doc elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAllDoc(Iterable<String> elements) {
      this.doc.addAll(elements);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds one element to {@link EncodedElement#annotations() annotations} list.
     * @param element A annotations element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAnnotations(String element) {
      this.annotations.add(element);
      return (EncodedElement.Builder) this;
    }

    /**
     * Adds elements to {@link EncodedElement#annotations() annotations} list.
     * @param elements An array of annotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAnnotations(String... elements) {
      this.annotations.add(elements);
      return (EncodedElement.Builder) this;
    }


    /**
     * Adds elements to {@link EncodedElement#annotations() annotations} list.
     * @param elements An iterable of annotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder addAllAnnotations(Iterable<String> elements) {
      this.annotations.addAll(elements);
      return (EncodedElement.Builder) this;
    }

    /**
     * Initializes the value for the {@link EncodedElement#standardNaming() standardNaming} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link EncodedElement#standardNaming() standardNaming}.</em>
     * @param standardNaming The value for standardNaming 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final EncodedElement.Builder standardNaming(StandardNaming standardNaming) {
      checkNotIsSet(standardNamingIsSet(), "standardNaming");
      this.standardNaming = Objects.requireNonNull(standardNaming, "standardNaming");
      optBits |= OPT_BIT_STANDARD_NAMING;
      return (EncodedElement.Builder) this;
    }

    /**
     * Builds a new {@link EncodedElement EncodedElement}.
     * @return An immutable instance of EncodedElement
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EncodedElement build() {
      checkRequiredAttributes();
      return new ImmutableEncodedElement(this);
    }

    private boolean standardNamingIsSet() {
      return (optBits & OPT_BIT_STANDARD_NAMING) != 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean namingIsSet() {
      return (initBits & INIT_BIT_NAMING) == 0;
    }

    private boolean typeParametersIsSet() {
      return (initBits & INIT_BIT_TYPE_PARAMETERS) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of EncodedElement is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!nameIsSet()) attributes.add("name");
      if (!typeIsSet()) attributes.add("type");
      if (!namingIsSet()) attributes.add("naming");
      if (!typeParametersIsSet()) attributes.add("typeParameters");
      return "Cannot build EncodedElement, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link EncodedElement.Param}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEncodedElement.Param.of()}.
   */
  @Generated(from = "EncodedElement.Param", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class Param extends EncodedElement.Param {
    private final String name;
    private final Type type;
    private final ImmutableList<String> annotations;

    private Param(
        String name,
        Type type,
        Iterable<String> annotations) {
      this.name = Objects.requireNonNull(name, "name");
      this.type = Objects.requireNonNull(type, "type");
      this.annotations = ImmutableList.copyOf(annotations);
    }

    private Param(
        ImmutableEncodedElement.Param original,
        String name,
        Type type,
        ImmutableList<String> annotations) {
      this.name = name;
      this.type = type;
      this.annotations = annotations;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    String name() {
      return name;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @Override
    Type type() {
      return type;
    }

    /**
     * @return The value of the {@code annotations} attribute
     */
    @Override
    ImmutableList<String> annotations() {
      return annotations;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EncodedElement.Param#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEncodedElement.Param withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableEncodedElement.Param(this, newValue, this.type, this.annotations);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EncodedElement.Param#type() type} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for type
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEncodedElement.Param withType(Type value) {
      if (this.type == value) return this;
      Type newValue = Objects.requireNonNull(value, "type");
      return new ImmutableEncodedElement.Param(this, this.name, newValue, this.annotations);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link EncodedElement.Param#annotations() annotations}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEncodedElement.Param withAnnotations(String... elements) {
      ImmutableList<String> newValue = ImmutableList.copyOf(elements);
      return new ImmutableEncodedElement.Param(this, this.name, this.type, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link EncodedElement.Param#annotations() annotations}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of annotations elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEncodedElement.Param withAnnotations(Iterable<String> elements) {
      if (this.annotations == elements) return this;
      ImmutableList<String> newValue = ImmutableList.copyOf(elements);
      return new ImmutableEncodedElement.Param(this, this.name, this.type, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Param} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEncodedElement.Param
          && equalTo((ImmutableEncodedElement.Param) another);
    }

    private boolean equalTo(ImmutableEncodedElement.Param another) {
      return name.equals(another.name)
          && type.equals(another.type)
          && annotations.equals(another.annotations);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code type}, {@code annotations}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + type.hashCode();
      h += (h << 5) + annotations.hashCode();
      return h;
    }

    /**
     * Construct a new immutable {@code Param} instance.
     * @param name The value for the {@code name} attribute
     * @param type The value for the {@code type} attribute
     * @param annotations The value for the {@code annotations} attribute
     * @return An immutable Param instance
     */
    public static EncodedElement.Param of(String name, Type type, List<String> annotations) {
      return of(name, type, (Iterable<String>) annotations);
    }

    /**
     * Construct a new immutable {@code Param} instance.
     * @param name The value for the {@code name} attribute
     * @param type The value for the {@code type} attribute
     * @param annotations The value for the {@code annotations} attribute
     * @return An immutable Param instance
     */
    public static EncodedElement.Param of(String name, Type type, Iterable<String> annotations) {
      return new ImmutableEncodedElement.Param(name, type, annotations);
    }

    /**
     * Creates an immutable copy of a {@link EncodedElement.Param} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Param instance
     */
    public static EncodedElement.Param copyOf(EncodedElement.Param instance) {
      if (instance instanceof ImmutableEncodedElement.Param) {
        return (ImmutableEncodedElement.Param) instance;
      }
      return ImmutableEncodedElement.Param.of(instance.name(), instance.type(), instance.annotations());
    }
  }

  /**
   * Immutable implementation of {@link EncodedElement.TypeParam}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new EncodedElement.TypeParam.Builder()}.
   */
  @Generated(from = "EncodedElement.TypeParam", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class TypeParam extends EncodedElement.TypeParam {
    private final String name;
    private final ImmutableList<Type.Defined> bounds;

    private TypeParam(
        String name,
        ImmutableList<Type.Defined> bounds) {
      this.name = name;
      this.bounds = bounds;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    String name() {
      return name;
    }

    /**
     * @return The value of the {@code bounds} attribute
     */
    @Override
    ImmutableList<Type.Defined> bounds() {
      return bounds;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EncodedElement.TypeParam#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEncodedElement.TypeParam withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableEncodedElement.TypeParam(newValue, this.bounds);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link EncodedElement.TypeParam#bounds() bounds}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEncodedElement.TypeParam withBounds(Type.Defined... elements) {
      ImmutableList<Type.Defined> newValue = ImmutableList.copyOf(elements);
      return new ImmutableEncodedElement.TypeParam(this.name, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link EncodedElement.TypeParam#bounds() bounds}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of bounds elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEncodedElement.TypeParam withBounds(Iterable<? extends Type.Defined> elements) {
      if (this.bounds == elements) return this;
      ImmutableList<Type.Defined> newValue = ImmutableList.copyOf(elements);
      return new ImmutableEncodedElement.TypeParam(this.name, newValue);
    }

    /**
     * This instance is equal to all instances of {@code TypeParam} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEncodedElement.TypeParam
          && equalTo((ImmutableEncodedElement.TypeParam) another);
    }

    private boolean equalTo(ImmutableEncodedElement.TypeParam another) {
      return name.equals(another.name)
          && bounds.equals(another.bounds);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code bounds}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + bounds.hashCode();
      return h;
    }

    /**
     * Creates an immutable copy of a {@link EncodedElement.TypeParam} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TypeParam instance
     */
    public static EncodedElement.TypeParam copyOf(EncodedElement.TypeParam instance) {
      if (instance instanceof ImmutableEncodedElement.TypeParam) {
        return (ImmutableEncodedElement.TypeParam) instance;
      }
      return new EncodedElement.TypeParam.Builder()
          .name(instance.name())
          .addAllBounds(instance.bounds())
          .build();
    }

    /**
     * Builds instances of type {@link EncodedElement.TypeParam TypeParam}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EncodedElement.TypeParam", generator = "Immutables")
    @NotThreadSafe
    public static class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private long initBits = 0x1L;

      private @Nullable String name;
      private final ImmutableList.Builder<Type.Defined> bounds = ImmutableList.builder();

      /**
       * Creates a builder for {@link EncodedElement.TypeParam TypeParam} instances.
       * <pre>
       * new EncodedElement.TypeParam.Builder()
       *    .name(String) // required {@link EncodedElement.TypeParam#name() name}
       *    .addBounds|addAllBounds(org.immutables.value.processor.encode.Type.Defined) // {@link EncodedElement.TypeParam#bounds() bounds} elements
       *    .build();
       * </pre>
       */
      public Builder() {
        if (!(this instanceof EncodedElement.TypeParam.Builder)) {
          throw new UnsupportedOperationException("Use: new EncodedElement.TypeParam.Builder()");
        }
      }

      /**
       * Initializes the value for the {@link EncodedElement.TypeParam#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final EncodedElement.TypeParam.Builder name(String name) {
        checkNotIsSet(nameIsSet(), "name");
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return (EncodedElement.TypeParam.Builder) this;
      }

      /**
       * Adds one element to {@link EncodedElement.TypeParam#bounds() bounds} list.
       * @param element A bounds element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final EncodedElement.TypeParam.Builder addBounds(Type.Defined element) {
        this.bounds.add(element);
        return (EncodedElement.TypeParam.Builder) this;
      }

      /**
       * Adds elements to {@link EncodedElement.TypeParam#bounds() bounds} list.
       * @param elements An array of bounds elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final EncodedElement.TypeParam.Builder addBounds(Type.Defined... elements) {
        this.bounds.add(elements);
        return (EncodedElement.TypeParam.Builder) this;
      }


      /**
       * Adds elements to {@link EncodedElement.TypeParam#bounds() bounds} list.
       * @param elements An iterable of bounds elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final EncodedElement.TypeParam.Builder addAllBounds(Iterable<? extends Type.Defined> elements) {
        this.bounds.addAll(elements);
        return (EncodedElement.TypeParam.Builder) this;
      }

      /**
       * Builds a new {@link EncodedElement.TypeParam TypeParam}.
       * @return An immutable instance of TypeParam
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public EncodedElement.TypeParam build() {
        checkRequiredAttributes();
        return new ImmutableEncodedElement.TypeParam(name, bounds.build());
      }

      private boolean nameIsSet() {
        return (initBits & INIT_BIT_NAME) == 0;
      }

      private static void checkNotIsSet(boolean isSet, String name) {
        if (isSet) throw new IllegalStateException("Builder of TypeParam is strict, attribute is already set: ".concat(name));
      }

      private void checkRequiredAttributes() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if (!nameIsSet()) attributes.add("name");
        return "Cannot build TypeParam, some of required attributes are not set " + attributes;
      }
    }
  }
}
