package org.immutables.value.processor.encode;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableStructurizer} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link Structurizer}.
 * @see Structurizer.Statement
 */
@Generated(from = "Structurizer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableStructurizer {
  private ImmutableStructurizer() {}

  /**
   * Immutable implementation of {@link Structurizer.Statement}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new Structurizer.Statement.Builder()}.
   */
  @Generated(from = "Structurizer.Statement", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class Statement extends Structurizer.Statement {
    private final ImmutableList<Code.Term> annotations;
    private final ImmutableList<Code.Term> signature;
    private final ImmutableList<Code.Term> parameters;
    private final ImmutableList<Code.Term> expression;
    private final ImmutableList<Code.Term> block;
    private final ImmutableList<Structurizer.Statement> definitions;
    private transient final boolean isClassOrInterface;
    private final Optional<String> name;

    private Statement(ImmutableStructurizer.Statement.Builder builder) {
      this.annotations = builder.annotations.build();
      this.signature = builder.signature.build();
      this.parameters = builder.parameters.build();
      this.expression = builder.expression.build();
      this.block = builder.block.build();
      this.definitions = builder.definitions.build();
      if (builder.nameIsSet()) {
        initShim.name(builder.name);
      }
      this.isClassOrInterface = initShim.isClassOrInterface();
      this.name = initShim.name();
      this.initShim = null;
    }

    private Statement(
        ImmutableList<Code.Term> annotations,
        ImmutableList<Code.Term> signature,
        ImmutableList<Code.Term> parameters,
        ImmutableList<Code.Term> expression,
        ImmutableList<Code.Term> block,
        ImmutableList<Structurizer.Statement> definitions,
        Optional<String> name) {
      this.annotations = annotations;
      this.signature = signature;
      this.parameters = parameters;
      this.expression = expression;
      this.block = block;
      this.definitions = definitions;
      initShim.name(name);
      this.isClassOrInterface = initShim.isClassOrInterface();
      this.name = initShim.name();
      this.initShim = null;
    }

    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    @SuppressWarnings("Immutable")
    private transient volatile InitShim initShim = new InitShim();

    @Generated(from = "Structurizer.Statement", generator = "Immutables")
    private final class InitShim {
      private byte isClassOrInterfaceBuildStage = STAGE_UNINITIALIZED;
      private boolean isClassOrInterface;

      boolean isClassOrInterface() {
        if (isClassOrInterfaceBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isClassOrInterfaceBuildStage == STAGE_UNINITIALIZED) {
          isClassOrInterfaceBuildStage = STAGE_INITIALIZING;
          this.isClassOrInterface = Statement.super.isClassOrInterface();
          isClassOrInterfaceBuildStage = STAGE_INITIALIZED;
        }
        return this.isClassOrInterface;
      }

      private byte nameBuildStage = STAGE_UNINITIALIZED;
      private Optional<String> name;

      Optional<String> name() {
        if (nameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (nameBuildStage == STAGE_UNINITIALIZED) {
          nameBuildStage = STAGE_INITIALIZING;
          this.name = Objects.requireNonNull(Statement.super.name(), "name");
          nameBuildStage = STAGE_INITIALIZED;
        }
        return this.name;
      }

      void name(Optional<String> name) {
        this.name = name;
        nameBuildStage = STAGE_INITIALIZED;
      }

      private String formatInitCycleMessage() {
        List<String> attributes = new ArrayList<>();
        if (isClassOrInterfaceBuildStage == STAGE_INITIALIZING) attributes.add("isClassOrInterface");
        if (nameBuildStage == STAGE_INITIALIZING) attributes.add("name");
        return "Cannot build Statement, attribute initializers form cycle " + attributes;
      }
    }

    /**
     * @return The value of the {@code annotations} attribute
     */
    @Override
    ImmutableList<Code.Term> annotations() {
      return annotations;
    }

    /**
     * @return The value of the {@code signature} attribute
     */
    @Override
    ImmutableList<Code.Term> signature() {
      return signature;
    }

    /**
     * @return The value of the {@code parameters} attribute
     */
    @Override
    ImmutableList<Code.Term> parameters() {
      return parameters;
    }

    /**
     * @return The value of the {@code expression} attribute
     */
    @Override
    ImmutableList<Code.Term> expression() {
      return expression;
    }

    /**
     * @return The value of the {@code block} attribute
     */
    @Override
    ImmutableList<Code.Term> block() {
      return block;
    }

    /**
     * @return The value of the {@code definitions} attribute
     */
    @Override
    ImmutableList<Structurizer.Statement> definitions() {
      return definitions;
    }

    /**
     * @return The computed-at-construction value of the {@code isClassOrInterface} attribute
     */
    @Override
    boolean isClassOrInterface() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isClassOrInterface()
          : this.isClassOrInterface;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    Optional<String> name() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.name()
          : this.name;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#annotations() annotations}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withAnnotations(Code.Term... elements) {
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          newValue,
          this.signature,
          this.parameters,
          this.expression,
          this.block,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#annotations() annotations}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of annotations elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withAnnotations(Iterable<? extends Code.Term> elements) {
      if (this.annotations == elements) return this;
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          newValue,
          this.signature,
          this.parameters,
          this.expression,
          this.block,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#signature() signature}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withSignature(Code.Term... elements) {
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          newValue,
          this.parameters,
          this.expression,
          this.block,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#signature() signature}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of signature elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withSignature(Iterable<? extends Code.Term> elements) {
      if (this.signature == elements) return this;
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          newValue,
          this.parameters,
          this.expression,
          this.block,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#parameters() parameters}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withParameters(Code.Term... elements) {
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          newValue,
          this.expression,
          this.block,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#parameters() parameters}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parameters elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withParameters(Iterable<? extends Code.Term> elements) {
      if (this.parameters == elements) return this;
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          newValue,
          this.expression,
          this.block,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#expression() expression}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withExpression(Code.Term... elements) {
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          this.parameters,
          newValue,
          this.block,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#expression() expression}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of expression elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withExpression(Iterable<? extends Code.Term> elements) {
      if (this.expression == elements) return this;
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          this.parameters,
          newValue,
          this.block,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#block() block}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withBlock(Code.Term... elements) {
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          this.parameters,
          this.expression,
          newValue,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#block() block}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of block elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withBlock(Iterable<? extends Code.Term> elements) {
      if (this.block == elements) return this;
      ImmutableList<Code.Term> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          this.parameters,
          this.expression,
          newValue,
          this.definitions,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#definitions() definitions}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withDefinitions(Structurizer.Statement... elements) {
      ImmutableList<Structurizer.Statement> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          this.parameters,
          this.expression,
          this.block,
          newValue,
          this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Structurizer.Statement#definitions() definitions}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of definitions elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableStructurizer.Statement withDefinitions(Iterable<? extends Structurizer.Statement> elements) {
      if (this.definitions == elements) return this;
      ImmutableList<Structurizer.Statement> newValue = ImmutableList.copyOf(elements);
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          this.parameters,
          this.expression,
          this.block,
          newValue,
          this.name);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Structurizer.Statement#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableStructurizer.Statement withName(Optional<String> value) {
      Optional<String> newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableStructurizer.Statement(
          this.annotations,
          this.signature,
          this.parameters,
          this.expression,
          this.block,
          this.definitions,
          newValue);
    }

    /**
     * This instance is equal to all instances of {@code Statement} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableStructurizer.Statement
          && equalTo((ImmutableStructurizer.Statement) another);
    }

    private boolean equalTo(ImmutableStructurizer.Statement another) {
      return annotations.equals(another.annotations)
          && signature.equals(another.signature)
          && parameters.equals(another.parameters)
          && expression.equals(another.expression)
          && block.equals(another.block)
          && definitions.equals(another.definitions)
          && isClassOrInterface == another.isClassOrInterface
          && name.equals(another.name);
    }

    /**
     * Computes a hash code from attributes: {@code annotations}, {@code signature}, {@code parameters}, {@code expression}, {@code block}, {@code definitions}, {@code isClassOrInterface}, {@code name}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + annotations.hashCode();
      h += (h << 5) + signature.hashCode();
      h += (h << 5) + parameters.hashCode();
      h += (h << 5) + expression.hashCode();
      h += (h << 5) + block.hashCode();
      h += (h << 5) + definitions.hashCode();
      h += (h << 5) + Booleans.hashCode(isClassOrInterface);
      h += (h << 5) + name.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Statement} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Statement")
          .omitNullValues()
          .add("annotations", annotations)
          .add("signature", signature)
          .add("parameters", parameters)
          .add("expression", expression)
          .add("block", block)
          .add("definitions", definitions)
          .add("isClassOrInterface", isClassOrInterface)
          .add("name", name)
          .toString();
    }

    @SuppressWarnings("Immutable")
    private transient volatile long lazyInitBitmap;

    private static final long RETURN_TYPE_LAZY_INIT_BIT = 0x1L;

    @SuppressWarnings("Immutable")
    private transient List<Code.Term> returnType;

    /**
     * {@inheritDoc}
     * <p>
     * Returns a lazily initialized value of the {@link Structurizer.Statement#returnType() returnType} attribute.
     * Initialized once and only once and stored for subsequent access with proper synchronization.
     * In case of any exception or error thrown by the lazy value initializer,
     * the result will not be memoised (i.e. remembered) and on next call computation
     * will be attempted again.
     * @return A lazily initialized value of the {@code returnType} attribute
     */
    @Override
    List<Code.Term> returnType() {
      if ((lazyInitBitmap & RETURN_TYPE_LAZY_INIT_BIT) == 0) {
        synchronized (this) {
          if ((lazyInitBitmap & RETURN_TYPE_LAZY_INIT_BIT) == 0) {
            this.returnType = Objects.requireNonNull(super.returnType(), "returnType");
            lazyInitBitmap |= RETURN_TYPE_LAZY_INIT_BIT;
          }
        }
      }
      return returnType;
    }

    /**
     * Creates an immutable copy of a {@link Structurizer.Statement} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Statement instance
     */
    public static Structurizer.Statement copyOf(Structurizer.Statement instance) {
      if (instance instanceof ImmutableStructurizer.Statement) {
        return (ImmutableStructurizer.Statement) instance;
      }
      return new Structurizer.Statement.Builder()
          .addAllAnnotations(instance.annotations())
          .addAllSignature(instance.signature())
          .addAllParameters(instance.parameters())
          .addAllExpression(instance.expression())
          .addAllBlock(instance.block())
          .addAllDefinitions(instance.definitions())
          .name(instance.name())
          .build();
    }

    /**
     * Builds instances of type {@link Structurizer.Statement Statement}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Structurizer.Statement", generator = "Immutables")
    @NotThreadSafe
    public static class Builder {
      private static final long OPT_BIT_NAME = 0x1L;
      private long optBits;

      private final ImmutableList.Builder<Code.Term> annotations = ImmutableList.builder();
      private final ImmutableList.Builder<Code.Term> signature = ImmutableList.builder();
      private final ImmutableList.Builder<Code.Term> parameters = ImmutableList.builder();
      private final ImmutableList.Builder<Code.Term> expression = ImmutableList.builder();
      private final ImmutableList.Builder<Code.Term> block = ImmutableList.builder();
      private final ImmutableList.Builder<Structurizer.Statement> definitions = ImmutableList.builder();
      private @Nullable Optional<String> name;

      /**
       * Creates a builder for {@link Structurizer.Statement Statement} instances.
       * <pre>
       * new Structurizer.Statement.Builder()
       *    .addAnnotations|addAllAnnotations(org.immutables.value.processor.encode.Code.Term) // {@link Structurizer.Statement#annotations() annotations} elements
       *    .addSignature|addAllSignature(org.immutables.value.processor.encode.Code.Term) // {@link Structurizer.Statement#signature() signature} elements
       *    .addParameters|addAllParameters(org.immutables.value.processor.encode.Code.Term) // {@link Structurizer.Statement#parameters() parameters} elements
       *    .addExpression|addAllExpression(org.immutables.value.processor.encode.Code.Term) // {@link Structurizer.Statement#expression() expression} elements
       *    .addBlock|addAllBlock(org.immutables.value.processor.encode.Code.Term) // {@link Structurizer.Statement#block() block} elements
       *    .addDefinitions|addAllDefinitions(org.immutables.value.processor.encode.Structurizer.Statement) // {@link Structurizer.Statement#definitions() definitions} elements
       *    .name(com.google.common.base.Optional&amp;lt;String&amp;gt;) // optional {@link Structurizer.Statement#name() name}
       *    .build();
       * </pre>
       */
      public Builder() {
        if (!(this instanceof Structurizer.Statement.Builder)) {
          throw new UnsupportedOperationException("Use: new Structurizer.Statement.Builder()");
        }
      }

      /**
       * Adds one element to {@link Structurizer.Statement#annotations() annotations} list.
       * @param element A annotations element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addAnnotations(Code.Term element) {
        this.annotations.add(element);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds elements to {@link Structurizer.Statement#annotations() annotations} list.
       * @param elements An array of annotations elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addAnnotations(Code.Term... elements) {
        this.annotations.add(elements);
        return (Structurizer.Statement.Builder) this;
      }


      /**
       * Adds elements to {@link Structurizer.Statement#annotations() annotations} list.
       * @param elements An iterable of annotations elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addAllAnnotations(Iterable<? extends Code.Term> elements) {
        this.annotations.addAll(elements);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds one element to {@link Structurizer.Statement#signature() signature} list.
       * @param element A signature element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addSignature(Code.Term element) {
        this.signature.add(element);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds elements to {@link Structurizer.Statement#signature() signature} list.
       * @param elements An array of signature elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addSignature(Code.Term... elements) {
        this.signature.add(elements);
        return (Structurizer.Statement.Builder) this;
      }


      /**
       * Adds elements to {@link Structurizer.Statement#signature() signature} list.
       * @param elements An iterable of signature elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addAllSignature(Iterable<? extends Code.Term> elements) {
        this.signature.addAll(elements);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds one element to {@link Structurizer.Statement#parameters() parameters} list.
       * @param element A parameters element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addParameters(Code.Term element) {
        this.parameters.add(element);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds elements to {@link Structurizer.Statement#parameters() parameters} list.
       * @param elements An array of parameters elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addParameters(Code.Term... elements) {
        this.parameters.add(elements);
        return (Structurizer.Statement.Builder) this;
      }


      /**
       * Adds elements to {@link Structurizer.Statement#parameters() parameters} list.
       * @param elements An iterable of parameters elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addAllParameters(Iterable<? extends Code.Term> elements) {
        this.parameters.addAll(elements);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds one element to {@link Structurizer.Statement#expression() expression} list.
       * @param element A expression element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addExpression(Code.Term element) {
        this.expression.add(element);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds elements to {@link Structurizer.Statement#expression() expression} list.
       * @param elements An array of expression elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addExpression(Code.Term... elements) {
        this.expression.add(elements);
        return (Structurizer.Statement.Builder) this;
      }


      /**
       * Adds elements to {@link Structurizer.Statement#expression() expression} list.
       * @param elements An iterable of expression elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addAllExpression(Iterable<? extends Code.Term> elements) {
        this.expression.addAll(elements);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds one element to {@link Structurizer.Statement#block() block} list.
       * @param element A block element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addBlock(Code.Term element) {
        this.block.add(element);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds elements to {@link Structurizer.Statement#block() block} list.
       * @param elements An array of block elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addBlock(Code.Term... elements) {
        this.block.add(elements);
        return (Structurizer.Statement.Builder) this;
      }


      /**
       * Adds elements to {@link Structurizer.Statement#block() block} list.
       * @param elements An iterable of block elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addAllBlock(Iterable<? extends Code.Term> elements) {
        this.block.addAll(elements);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds one element to {@link Structurizer.Statement#definitions() definitions} list.
       * @param element A definitions element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addDefinitions(Structurizer.Statement element) {
        this.definitions.add(element);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Adds elements to {@link Structurizer.Statement#definitions() definitions} list.
       * @param elements An array of definitions elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addDefinitions(Structurizer.Statement... elements) {
        this.definitions.add(elements);
        return (Structurizer.Statement.Builder) this;
      }


      /**
       * Adds elements to {@link Structurizer.Statement#definitions() definitions} list.
       * @param elements An iterable of definitions elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder addAllDefinitions(Iterable<? extends Structurizer.Statement> elements) {
        this.definitions.addAll(elements);
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Initializes the value for the {@link Structurizer.Statement#name() name} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Structurizer.Statement#name() name}.</em>
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Structurizer.Statement.Builder name(Optional<String> name) {
        checkNotIsSet(nameIsSet(), "name");
        this.name = Objects.requireNonNull(name, "name");
        optBits |= OPT_BIT_NAME;
        return (Structurizer.Statement.Builder) this;
      }

      /**
       * Builds a new {@link Structurizer.Statement Statement}.
       * @return An immutable instance of Statement
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public Structurizer.Statement build() {
        return new ImmutableStructurizer.Statement(this);
      }

      private boolean nameIsSet() {
        return (optBits & OPT_BIT_NAME) != 0;
      }

      private static void checkNotIsSet(boolean isSet, String name) {
        if (isSet) throw new IllegalStateException("Builder of Statement is strict, attribute is already set: ".concat(name));
      }
    }
  }
}
