/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.immutables.value.internal.;
import org.immutables.value.internal.$generator$.$Delegated;
import org.immutables.value.internal.$generator$.$EnvironmentState;
import org.immutables.value.internal.$generator$.$ImportRewriter;
import org.immutables.value.internal.$guava$.base.$CharMatcher;
import org.immutables.value.internal.$guava$.base.$Joiner;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Predicates;
import org.immutables.value.internal.$guava$.base.$Splitter;
import org.immutables.value.internal.$guava$.base.$Strings;
import org.immutables.value.internal.$guava$.base.$Supplier;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Iterators;
import org.immutables.value.internal.$guava$.collect.$Sets;
import org.immutables.value.internal.$guava$.io.$CharStreams;

public final class $Output {
    public static final String NO_IMPORTS = "//-no-import-rewrite";
    public final .generator..Templates.Invokable error = new .generator..Templates.Invokable(){

        @Override
        @Nullable
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            Messager messager = $EnvironmentState.processing().getMessager();
            String message = $CharMatcher.whitespace().trimFrom(parameters[parameters.length - 1].toString());
            Element element = $Iterators.find($Iterators.forArray(parameters), $Predicates.instanceOf(Element.class), null);
            if (element != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, message, $Delegated.unwrap(element));
            } else {
                messager.printMessage(Diagnostic.Kind.ERROR, message);
            }
            return null;
        }
    };
    public final .generator..Templates.Invokable system = new .generator..Templates.Invokable(){

        @Override
        @Nullable
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            String message = $CharMatcher.whitespace().trimFrom(parameters[0].toString());
            System.out.println(message);
            return null;
        }
    };
    public final .generator..Templates.Invokable length = new .generator..Templates.Invokable(){

        @Override
        @Nullable
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            invokation.out((Object)parameters[0].toString().length());
            return null;
        }
    };
    public final .generator..Templates.Invokable trim = new OutputFilter(){

        @Override
        void apply(.generator..Templates.Invokation invokation, CharSequence content, @Nullable .generator..Templates.Invokable original) {
            invokation.out($CharMatcher.whitespace().trimFrom(content));
        }
    };
    public final .generator..Templates.Invokable linesShortable = new OutputFilter(){
        private static final int LIMIT = 100;

        @Override
        void apply(.generator..Templates.Invokation invokation, CharSequence content, @Nullable .generator..Templates.Invokable original) {
            String collapsed = $CharMatcher.whitespace().trimAndCollapseFrom(content, ' ');
            int estimatedLimitOnThisLine = 100 - invokation.consumer.getCurrentIndentation().length();
            if (collapsed.length() < estimatedLimitOnThisLine) {
                invokation.out(collapsed);
            } else if (original != null) {
                original.invoke(invokation, new Object[0]);
            } else {
                invokation.out(content);
            }
        }
    };
    public final .generator..Templates.Invokable collapsible = new OutputFilter(){

        @Override
        void apply(.generator..Templates.Invokation invokation, CharSequence content, @Nullable .generator..Templates.Invokable original) {
            boolean hasNonWhitespace;
            boolean bl = hasNonWhitespace = !$CharMatcher.whitespace().matchesAllOf(content);
            if (hasNonWhitespace) {
                if (original != null) {
                    original.invoke(invokation, new Object[0]);
                } else {
                    invokation.out(content);
                }
            }
        }
    };
    public final .generator..Templates.Invokable java = new .generator..Templates.Invokable(){

        @Override
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            String packageName = parameters[0].toString();
            String simpleName = parameters[1].toString();
            Element originatingElement = (Element)parameters[2];
            .generator..Templates.Invokable body = (.generator..Templates.Invokable)parameters[3];
            ResourceKey key = new ResourceKey(packageName, simpleName, originatingElement);
            SourceFile javaFile = $Output.getFiles().sourceFiles.get(key);
            body.invoke(new .generator..Templates.Invokation(javaFile.consumer, new Object[0]), new Object[0]);
            javaFile.complete();
            return null;
        }
    };
    public final .generator..Templates.Invokable service = new .generator..Templates.Invokable(){
        private static final String META_INF_SERVICES = "META-INF/services/";

        @Override
        public .generator..Templates.Invokable invoke(.generator..Templates.Invokation invokation, Object ... parameters) {
            String interfaceName = parameters[0].toString();
            .generator..Templates.Invokable body = (.generator..Templates.Invokable)parameters[1];
            ResourceKey key = new ResourceKey("", META_INF_SERVICES + interfaceName);
            AppendServiceFile servicesFile = $Output.getServiceFiles().appendResourceFiles.get(key);
            body.invoke(new .generator..Templates.Invokation(servicesFile.consumer, new Object[0]), new Object[0]);
            return null;
        }
    };

    private static Filer getFiler() {
        return $EnvironmentState.processing().getFiler();
    }

    private static Messager getMessager() {
        return $EnvironmentState.processing().getMessager();
    }

    private static Files getFiles() {
        return $EnvironmentState.getPerRound(Files.class, FilesSupplier.INSTANCE);
    }

    private static ServiceFiles getServiceFiles() {
        return $EnvironmentState.getPerProcessing(ServiceFiles.class, ServiceFilesSupplier.INSTANCE);
    }

    private static class ServiceFiles
    implements Runnable {
        final Cache<ResourceKey, AppendServiceFile> appendResourceFiles = new Cache<ResourceKey, AppendServiceFile>(){

            @Override
            public AppendServiceFile load(ResourceKey key) throws Exception {
                return new AppendServiceFile(key);
            }
        };

        private ServiceFiles() {
        }

        @Override
        public void run() {
            for (AppendServiceFile f : this.appendResourceFiles.asMap().values()) {
                f.complete();
            }
            this.appendResourceFiles.clear();
        }
    }

    private static class Files
    implements Runnable {
        final Cache<ResourceKey, SourceFile> sourceFiles = new Cache<ResourceKey, SourceFile>(){

            @Override
            public SourceFile load(ResourceKey key) throws Exception {
                return new SourceFile(key);
            }
        };

        private Files() {
        }

        @Override
        public void run() {
            this.sourceFiles.clear();
        }
    }

    @NotThreadSafe
    private static abstract class Cache<K, V> {
        private final Map<K, V> map = new HashMap();

        private Cache() {
        }

        protected abstract V load(K var1) throws Exception;

        final V get(K key) {
            V value = this.map.get(key);
            if (value == null) {
                try {
                    value = this.load(key);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this.map.put(key, value);
            }
            return value;
        }

        public Map<K, V> asMap() {
            return this.map;
        }

        void clear() {
            this.map.clear();
        }
    }

    private static enum ServiceFilesSupplier implements $Supplier<ServiceFiles>
    {
        INSTANCE;


        @Override
        public ServiceFiles get() {
            return new ServiceFiles();
        }
    }

    private static enum FilesSupplier implements $Supplier<Files>
    {
        INSTANCE;


        @Override
        public Files get() {
            return new Files();
        }
    }

    private static class SourceFile {
        final ResourceKey key;
        final .generator..Templates.CharConsumer consumer = new .generator..Templates.CharConsumer();
        boolean completed = false;

        SourceFile(ResourceKey key) {
            this.key = key;
        }

        void complete() {
            if (this.completed) {
                return;
            }
            this.completed = true;
            CharSequence sourceCode = this.extractSourceCode();
            try {
                JavaFileObject sourceFile = this.key.originatingElement != null ? $Output.getFiler().createSourceFile(this.key.toString(), $Delegated.unwrap(this.key.originatingElement)) : $Output.getFiler().createSourceFile(this.key.toString(), new Element[0]);
                try (Writer writer = sourceFile.openWriter();){
                    writer.append(sourceCode);
                    writer.flush();
                }
            }
            catch (FilerException ex) {
                if (this.identicalFileIsAlreadyGenerated(sourceCode)) {
                    $Output.getMessager().printMessage(Diagnostic.Kind.NOTE, "Regenerated file with the same content: " + this.key);
                } else {
                    $Output.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, String.format("Generated source file name collision. Attempt to overwrite already generated file: %s, %s. If this happens when using @Value.Immutable on same-named nested classes in the same package, use can use @Value.Enclosing annotation to provide some sort of namespacing", this.key, ex));
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            finally {
                this.key.originatingElement = null;
            }
        }

        private boolean identicalFileIsAlreadyGenerated(CharSequence sourceCode) {
            try {
                String existingContent;
                String packagePath = !this.key.packageName.isEmpty() ? this.key.packageName.replace('.', '/') + '/' : "";
                String filename = this.key.relativeName + ".java";
                FileObject resource = $Output.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", packagePath + filename);
                try (Reader r = resource.openReader(true);){
                    existingContent = $CharStreams.toString(r);
                }
                if (existingContent.contentEquals(sourceCode)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private CharSequence extractSourceCode() {
            CharSequence charSequence = this.consumer.asCharSequence();
            if ($Strings.commonPrefix(charSequence, $Output.NO_IMPORTS).startsWith($Output.NO_IMPORTS)) {
                return charSequence;
            }
            return $ImportRewriter.rewrite(charSequence);
        }
    }

    private static class AppendServiceFile {
        private static final Pattern SERVICE_FILE_COMMENT_LINE = Pattern.compile("^\\#.*");
        final ResourceKey key;
        final .generator..Templates.CharConsumer consumer = new .generator..Templates.CharConsumer();

        AppendServiceFile(ResourceKey key) {
            this.key = key;
        }

        void complete() {
            try {
                this.writeFile();
            }
            catch (Exception ex) {
                $EnvironmentState.processing().getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Cannot write service files: " + this.key + ex);
            }
        }

        private void writeFile() throws IOException {
            LinkedHashSet<String> services = $Sets.newLinkedHashSet();
            this.readExistingEntriesInto(services);
            this.copyNewMetaservicesInto(services);
            this.removeBlankLinesIn(services);
            this.writeLinesFrom(services);
        }

        private void readExistingEntriesInto(Collection<String> services) {
            try {
                FileObject existing = $Output.getFiler().getResource(StandardLocation.CLASS_OUTPUT, this.key.packageName, this.key.relativeName);
                try (Reader r = existing.openReader(true);){
                    for (String line : $CharStreams.readLines(r)) {
                        if (SERVICE_FILE_COMMENT_LINE.matcher(line).find()) continue;
                        services.add(line.trim());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void writeLinesFrom(Iterable<String> services) throws IOException {
            FileObject resource = $Output.getFiler().createResource(StandardLocation.CLASS_OUTPUT, this.key.packageName, this.key.relativeName, new Element[0]);
            try (Writer w = resource.openWriter();){
                for (String line : services) {
                    w.write(line);
                    w.write(10);
                }
            }
        }

        private void removeBlankLinesIn(Iterable<String> services) {
            $Iterables.removeIf(services, $Predicates.equalTo(""));
        }

        private void copyNewMetaservicesInto(Collection<String> services) {
            for (String line : $Splitter.on("\n").split(this.consumer.asCharSequence())) {
                services.add(line);
            }
        }
    }

    private static final class ResourceKey {
        private static final $Joiner PACKAGE_RESOURCE_JOINER = $Joiner.on('.').skipNulls();
        final String packageName;
        final String relativeName;
        @Nullable
        Element originatingElement;

        ResourceKey(String packageName, String simpleName) {
            this(packageName, simpleName, null);
        }

        ResourceKey(String packageName, String simpleName, @Nullable Element originatingElement) {
            this.packageName = $Preconditions.checkNotNull(packageName);
            this.relativeName = $Preconditions.checkNotNull(simpleName);
            this.originatingElement = originatingElement;
        }

        public String toString() {
            return PACKAGE_RESOURCE_JOINER.join($Strings.emptyToNull(this.packageName), this.relativeName, new Object[0]);
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.relativeName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceKey) {
                ResourceKey other = (ResourceKey)obj;
                return this.packageName.equals(other.packageName) || this.relativeName.equals(other.relativeName);
            }
            return false;
        }
    }

    private static abstract class OutputFilter
    extends .generator..Templates.Fragment {
        public OutputFilter() {
            super(1);
        }

        abstract void apply(.generator..Templates.Invokation var1, CharSequence var2, @Nullable .generator..Templates.Invokable var3);

        @Override
        public final void run(.generator..Templates.Invokation invokation) {
            Object param = invokation.param(0);
            .generator..Templates.Invokable original = param instanceof .generator..Templates.Invokable ? (.generator..Templates.Invokable)param : null;
            this.apply(invokation, this.toCharSequence(param), original);
        }

        private CharSequence toCharSequence(Object param) {
            $Preconditions.checkNotNull(param);
            if (param instanceof .generator..Templates.Fragment) {
                return ((.generator..Templates.Fragment)param).toCharSequence();
            }
            return param.toString();
        }
    }
}

