/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$processor$.meta.$UnshadeGuava;

public enum $AttributeTypeKind {
    REGULAR("", new String[0]),
    ARRAY("", new String[0]),
    LIST("List", List.class.getName(), $UnshadeGuava.typeString("collect.ImmutableList")),
    SET("Set", Set.class.getName(), $UnshadeGuava.typeString("collect.ImmutableSet")),
    ENUM_SET("Set", new String[0]),
    SORTED_SET("SortedSet", SortedSet.class.getName(), NavigableSet.class.getName(), $UnshadeGuava.typeString("collect.ImmutableSortedSet")),
    MAP("Map", Map.class.getName(), $UnshadeGuava.typeString("collect.ImmutableMap")),
    ENUM_MAP("Map", new String[0]),
    SORTED_MAP("SortedMap", SortedMap.class.getName(), NavigableMap.class.getName(), $UnshadeGuava.typeString("collect.ImmutableSortedMap")),
    MULTISET("Multiset", $UnshadeGuava.typeString("collect.Multiset"), $UnshadeGuava.typeString("collect.ImmutableMultiset")),
    MULTIMAP("Multimap", $UnshadeGuava.typeString("collect.Multimap"), $UnshadeGuava.typeString("collect.ImmutableMultimap")),
    LIST_MULTIMAP("ListMultimap", $UnshadeGuava.typeString("collect.ListMultimap"), $UnshadeGuava.typeString("collect.ImmutableListMultimap")),
    SET_MULTIMAP("SetMultimap", $UnshadeGuava.typeString("collect.SetMultimap"), $UnshadeGuava.typeString("collect.ImmutableSetMultimap")),
    BI_MAP("BiMap", $UnshadeGuava.typeString("collect.BiMap"), $UnshadeGuava.typeString("collect.ImmutableBiMap")),
    OPTIONAL_JDK("Optional", "java.util.Optional"),
    OPTIONAL_INT_JDK("OptionalInt", "java.util.OptionalInt"),
    OPTIONAL_LONG_JDK("OptionalLong", "java.util.OptionalLong"),
    OPTIONAL_DOUBLE_JDK("OptionalDouble", "java.util.OptionalDouble"),
    OPTIONAL_GUAVA("Optional", $UnshadeGuava.typeString("base.Optional")),
    OPTION_FUGUE("Option", "com.atlassian.fugue.Option", "io.atlassian.fugue.Option"),
    OPTION_JAVASLANG("Option", "javaslang.control.Option");

    private final String[] rawTypes;
    private final String rawSimpleName;
    private static final $ImmutableMap<String, $AttributeTypeKind> rawTypeMapping;

    private $AttributeTypeKind(String rawSimpleName, String ... rawTypes) {
        this.rawSimpleName = rawSimpleName;
        this.rawTypes = rawTypes;
    }

    public String rawSimpleName() {
        return this.rawSimpleName;
    }

    static $AttributeTypeKind forRawType(String rawType) {
        return $MoreObjects.firstNonNull(rawTypeMapping.get(rawType), REGULAR);
    }

    $AttributeTypeKind havingEnumFirstTypeParameter(boolean isEnum) {
        if (isEnum) {
            switch (this) {
                case SET: {
                    return ENUM_SET;
                }
                case MAP: {
                    return ENUM_MAP;
                }
            }
        }
        return this;
    }

    public boolean isSortedKind() {
        switch (this) {
            case SORTED_MAP: 
            case SORTED_SET: {
                return true;
            }
        }
        return false;
    }

    public boolean isSetKind() {
        switch (this) {
            case SET: 
            case SORTED_SET: 
            case ENUM_SET: {
                return true;
            }
        }
        return false;
    }

    public boolean isContainerKind() {
        switch (this) {
            case REGULAR: 
            case ARRAY: {
                return false;
            }
        }
        return true;
    }

    public boolean isCollectionKind() {
        switch (this) {
            case SET: 
            case SORTED_SET: 
            case ENUM_SET: 
            case LIST: 
            case MULTISET: {
                return true;
            }
        }
        return false;
    }

    public boolean isMapKind() {
        switch (this) {
            case MAP: 
            case SORTED_MAP: 
            case ENUM_MAP: 
            case BI_MAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isMappingKind() {
        switch (this) {
            case MAP: 
            case SORTED_MAP: 
            case ENUM_MAP: 
            case BI_MAP: 
            case MULTIMAP: 
            case LIST_MULTIMAP: 
            case SET_MULTIMAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isJdkOnlyContainerKind() {
        switch (this) {
            case OPTIONAL_JDK: 
            case OPTIONAL_INT_JDK: 
            case OPTIONAL_LONG_JDK: 
            case OPTIONAL_DOUBLE_JDK: {
                return true;
            }
        }
        return false;
    }

    public boolean isGuavaContainerKind() {
        switch (this) {
            case MULTISET: 
            case BI_MAP: 
            case MULTIMAP: 
            case LIST_MULTIMAP: 
            case SET_MULTIMAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isOptionalJdk() {
        return this == OPTIONAL_JDK;
    }

    public boolean isOptionalSpecializedJdk() {
        switch (this) {
            case OPTIONAL_INT_JDK: 
            case OPTIONAL_LONG_JDK: 
            case OPTIONAL_DOUBLE_JDK: {
                return true;
            }
        }
        return false;
    }

    public boolean isOptionalGuava() {
        return this == OPTIONAL_GUAVA;
    }

    public boolean isOptionFugue() {
        return this == OPTION_FUGUE;
    }

    public boolean isOptionJavaslang() {
        return this == OPTION_JAVASLANG;
    }

    public boolean isOptionalKind() {
        switch (this) {
            case OPTIONAL_JDK: 
            case OPTIONAL_INT_JDK: 
            case OPTIONAL_LONG_JDK: 
            case OPTIONAL_DOUBLE_JDK: 
            case OPTIONAL_GUAVA: 
            case OPTION_FUGUE: 
            case OPTION_JAVASLANG: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnumKeyed() {
        switch (this) {
            case ENUM_SET: 
            case ENUM_MAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isMultimapKind() {
        switch (this) {
            case MULTIMAP: 
            case LIST_MULTIMAP: 
            case SET_MULTIMAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isSet() {
        return this == SET;
    }

    public boolean isEnumSet() {
        return this == ENUM_SET;
    }

    public boolean isSortedSet() {
        return this == SORTED_SET;
    }

    public boolean isList() {
        return this == LIST;
    }

    public boolean isMap() {
        return this == MAP;
    }

    public boolean isPlainMapKind() {
        return this == MAP || this == ENUM_MAP;
    }

    public boolean isBiMap() {
        return this == BI_MAP;
    }

    public boolean isSortedMap() {
        return this == SORTED_MAP;
    }

    public boolean isArray() {
        return this == ARRAY;
    }

    public boolean isRegular() {
        return this == REGULAR;
    }

    public boolean isMultiset() {
        return this == MULTISET;
    }

    public boolean isMultimap() {
        return this == MULTIMAP;
    }

    public boolean isSetMultimap() {
        return this == SET_MULTIMAP;
    }

    public boolean isListMultimap() {
        return this == SET_MULTIMAP;
    }

    public boolean isEnumMap() {
        return this == ENUM_MAP;
    }

    static {
        $ImmutableMap.Builder<String, $AttributeTypeKind> builder = $ImmutableMap.builder();
        for ($AttributeTypeKind k : $AttributeTypeKind.values()) {
            for (String r : k.rawTypes) {
                builder.put(r, k);
            }
        }
        rawTypeMapping = builder.build();
    }
}

