/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.immutables.value.internal.;
import org.immutables.value.internal.$generator$.$SourceOrdering;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableListMultimap;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.encode.$Instantiator;
import org.immutables.value.internal.$processor$.meta.$CachingElements;
import org.immutables.value.internal.$processor$.meta.$CheckMirror;
import org.immutables.value.internal.$processor$.meta.$DefaultMirror;
import org.immutables.value.internal.$processor$.meta.$DerivedMirror;
import org.immutables.value.internal.$processor$.meta.$ImportsTypeStringResolver;
import org.immutables.value.internal.$processor$.meta.$LazyMirror;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$TypeStringProvider;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;
import org.immutables.value.internal.$processor$.meta.$ValueType;

final class $AccessorAttributesCollector {
    private static final String ORDINAL_ORDINAL_ATTRIBUTE_NAME = "ordinal";
    private static final String ORDINAL_DOMAIN_ATTRIBUTE_NAME = "domain";
    private static final String ORG_ECLIPSE = "org.eclipse";
    private static final int USEFUL_PARAMETER_COUNT_LIMIT = 120;
    static final String EQUALS_METHOD = "equals";
    static final String TO_STRING_METHOD = "toString";
    static final String HASH_CODE_METHOD = "hashCode";
    private final .processor..Proto.Protoclass protoclass;
    private final $ValueType type;
    private final ProcessingEnvironment processing;
    private final List<$ValueAttribute> attributes = $Lists.newArrayList();
    private final $Styles styles;
    private final $Reporter reporter;
    private $ImmutableListMultimap<String, TypeElement> accessorMapping = $ImmutableListMultimap.of();
    private final boolean isEclipseImplementation;
    private boolean hasNonInheritedAttributes;

    $AccessorAttributesCollector(.processor..Proto.Protoclass protoclass, $ValueType type) {
        this.protoclass = protoclass;
        this.processing = protoclass.processing();
        this.styles = protoclass.styles();
        this.type = type;
        this.reporter = protoclass.report();
        this.isEclipseImplementation = $AccessorAttributesCollector.isEclipseImplementation(type.element);
    }

    void collect() {
        this.collectGeneratedCandidateMethods(this.getTypeElement());
        if (this.attributes.size() > 120) {
            ArrayList<$ValueAttribute> list = $Lists.newArrayListWithCapacity(120);
            list.addAll(this.attributes.subList(0, 120));
            this.attributes.clear();
            this.attributes.addAll(list);
            this.protoclass.report().error("Value objects with more than %d attributes (including inherited) are not supported. You can decompose '%s' class into a smaller ones", 120, this.protoclass.name());
        }
        $Instantiator encodingInstantiator = this.protoclass.encodingInstantiator();
        $Instantiator.InstantiationCreator instantiationCreator = encodingInstantiator.creatorFor((Parameterizable)this.type.element);
        for ($ValueAttribute attribute : this.attributes) {
            attribute.initAndValidate(instantiationCreator);
        }
        if (instantiationCreator != null) {
            this.type.additionalImports(instantiationCreator.imports);
        }
        this.type.attributes.addAll(this.attributes);
        this.type.accessorMapping = this.accessorMapping;
    }

    private TypeElement getTypeElement() {
        return (TypeElement)this.type.element;
    }

    private void collectGeneratedCandidateMethods(TypeElement type) {
        $ImmutableList<Element> accessorsInSourceOrder;
        TypeElement originalType = $CachingElements.getDelegate(type);
        if (originalType.getKind() == ElementKind.ANNOTATION_TYPE) {
            accessorsInSourceOrder = $SourceOrdering.getEnclosedElements(originalType);
        } else {
            $SourceOrdering.AccessorProvider provider = $SourceOrdering.getAllAccessorsProvider(this.processing.getElementUtils(), this.processing.getTypeUtils(), originalType);
            accessorsInSourceOrder = provider.get();
            this.accessorMapping = provider.accessorMapping();
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(accessorsInSourceOrder)) {
            if (!$AccessorAttributesCollector.isElegibleAccessorMethod(executableElement)) continue;
            this.processGenerationCandidateMethod(executableElement, originalType);
        }
        for (Element element : this.processing.getElementUtils().getAllMembers(originalType)) {
            if (element.getKind() != ElementKind.METHOD) continue;
            switch (element.getSimpleName().toString()) {
                case "hashCode": 
                case "toString": 
                case "equals": {
                    this.processUtilityCandidateMethod((ExecutableElement)element, originalType);
                    break;
                }
            }
        }
    }

    private static boolean isElegibleAccessorMethod(Element element) {
        if (element.getKind() != ElementKind.METHOD) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        switch (element.getSimpleName().toString()) {
            case "hashCode": 
            case "toString": {
                return false;
            }
        }
        String definitionType = element.getEnclosingElement().toString();
        if (definitionType.equals(Object.class.getName())) {
            return false;
        }
        return !definitionType.equals("org.immutables.ordinal.OrdinalValue");
    }

    private void processUtilityCandidateMethod(ExecutableElement utilityMethodCandidate, TypeElement originalType) {
        Name name = utilityMethodCandidate.getSimpleName();
        List<? extends VariableElement> parameters = utilityMethodCandidate.getParameters();
        TypeElement definingType = (TypeElement)utilityMethodCandidate.getEnclosingElement();
        if (definingType.getQualifiedName().contentEquals(Object.class.getName())) {
            return;
        }
        if (name.contentEquals(EQUALS_METHOD) && parameters.size() == 1 && parameters.get(0).asType().toString().equals(Object.class.getName())) {
            if (!utilityMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.type.isEqualToDefined = true;
                if (!definingType.equals(originalType) && this.hasNonInheritedAttributes) {
                    this.report(originalType).warning("Type inherits non-default 'equals' method but have some non-inherited attributes. Please override 'equals' with abstract method to have it generate. Otherwise override with calling super implemtation to use custom implementation", new Object[0]);
                }
            }
            return;
        }
        if (name.contentEquals(HASH_CODE_METHOD) && parameters.isEmpty()) {
            if (!utilityMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.type.isHashCodeDefined = true;
                if (!definingType.equals(originalType) && this.hasNonInheritedAttributes) {
                    this.report(originalType).warning("Type inherits non-default 'hashCode' method but have some non-inherited attributes. Please override 'hashCode' with abstract method to have it generated. Otherwise override with calling super implemtation to use custom implementation", new Object[0]);
                }
            }
            return;
        }
        if (name.contentEquals(TO_STRING_METHOD) && parameters.isEmpty()) {
            if (!utilityMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.type.isToStringDefined = true;
                if (!definingType.equals(originalType) && this.hasNonInheritedAttributes) {
                    this.report(originalType).warning("Type inherits non-default 'toString' method but have some non-inherited attributes. Please override 'toString' with abstract method to have generate it. Otherwise override with calling super implementation to use custom implementation", new Object[0]);
                }
            }
            return;
        }
    }

    private void processGenerationCandidateMethod(ExecutableElement attributeMethodCandidate, TypeElement originalType) {
        Name name = attributeMethodCandidate.getSimpleName();
        if ($CheckMirror.isPresent(attributeMethodCandidate)) {
            if (!attributeMethodCandidate.getParameters().isEmpty() || attributeMethodCandidate.getModifiers().contains((Object)Modifier.PRIVATE) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.ABSTRACT) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.STATIC) || attributeMethodCandidate.getModifiers().contains((Object)Modifier.NATIVE)) {
                this.report(attributeMethodCandidate).error("Method '%s' annotated with @%s must be non-private parameter-less method", name, $CheckMirror.simpleName());
            } else if (attributeMethodCandidate.getReturnType().getKind() == TypeKind.VOID) {
                this.type.addNormalizeMethod(name.toString(), false);
            } else if (this.returnsNormalizedAbstractValueType(attributeMethodCandidate)) {
                this.type.addNormalizeMethod(name.toString(), true);
            } else {
                this.report(attributeMethodCandidate).error("Method '%s' annotated with @%s must return void or normalized instance of abstract value type", name, $CheckMirror.simpleName());
            }
            return;
        }
        boolean useDefaultAsDefault = this.type.constitution.style().defaultAsDefault();
        if ($AccessorAttributesCollector.isDiscoveredAttribute(attributeMethodCandidate, useDefaultAsDefault)) {
            TypeMirror returnType = this.resolveReturnType(attributeMethodCandidate);
            $ValueAttribute attribute = new $ValueAttribute();
            attribute.reporter = this.reporter;
            attribute.returnType = returnType;
            attribute.names = this.deriveNames(name.toString());
            attribute.element = attributeMethodCandidate;
            attribute.containingType = this.type;
            boolean isFinal = $AccessorAttributesCollector.isFinal(attributeMethodCandidate);
            boolean isAbstract = $AccessorAttributesCollector.isAbstract(attributeMethodCandidate);
            boolean defaultAnnotationPresent = $DefaultMirror.isPresent(attributeMethodCandidate);
            boolean derivedAnnotationPresent = $DerivedMirror.isPresent(attributeMethodCandidate);
            if (isAbstract) {
                attribute.isGenerateAbstract = true;
                if (attributeMethodCandidate.getDefaultValue() != null) {
                    attribute.isGenerateDefault = true;
                }
                if (defaultAnnotationPresent || derivedAnnotationPresent) {
                    if (defaultAnnotationPresent) {
                        if (attribute.isGenerateDefault) {
                            this.report(attributeMethodCandidate).annotationNamed($DefaultMirror.simpleName()).warning("@Value.Default annotation is superflous for default annotation attribute", new Object[0]);
                        } else {
                            this.report(attributeMethodCandidate).annotationNamed($DefaultMirror.simpleName()).error("@Value.Default attribute should have initializer body", name);
                        }
                    }
                    if (derivedAnnotationPresent) {
                        if (attribute.isGenerateDefault) {
                            this.report(attributeMethodCandidate).annotationNamed($DerivedMirror.simpleName()).error("@Value.Derived cannot be used with default annotation attribute", new Object[0]);
                        } else {
                            this.report(attributeMethodCandidate).annotationNamed($DerivedMirror.simpleName()).error("@Value.Derived attribute should have initializer body", name);
                        }
                    }
                }
            } else if (defaultAnnotationPresent && derivedAnnotationPresent) {
                this.report(attributeMethodCandidate).annotationNamed($DerivedMirror.simpleName()).error("Attribute '%s' cannot be both @Value.Default and @Value.Derived", name);
                attribute.isGenerateDefault = true;
            } else if ((defaultAnnotationPresent || derivedAnnotationPresent) && isFinal) {
                this.report(attributeMethodCandidate).error("Annotated attribute '%s' will be overriden and cannot be final", name);
            } else if (defaultAnnotationPresent) {
                attribute.isGenerateDefault = true;
                if (useDefaultAsDefault && attribute.isInterfaceDefaultMethod()) {
                    this.report(attributeMethodCandidate).annotationNamed($DefaultMirror.simpleName()).warning("@Value.Default annotation is superflous for default annotation attribute when 'defaultAsDefault' style is enabled", new Object[0]);
                }
            } else if (derivedAnnotationPresent) {
                attribute.isGenerateDerived = true;
            } else if (useDefaultAsDefault) {
                attribute.isGenerateDefault = attribute.isInterfaceDefaultMethod();
            }
            if ($LazyMirror.isPresent(attributeMethodCandidate)) {
                if (isAbstract || isFinal) {
                    this.report(attributeMethodCandidate).error("@Value.Lazy attribute '%s' must be non abstract and non-final", name);
                } else if (defaultAnnotationPresent || derivedAnnotationPresent) {
                    this.report(attributeMethodCandidate).error("@Value.Lazy attribute '%s' cannot be @Value.Derived or @Value.Default", name);
                } else {
                    attribute.isGenerateLazy = true;
                    attribute.isGenerateDefault = false;
                }
            }
            this.attributes.add(attribute);
            if (attribute.isGenerateDefault) {
                ++this.type.defaultAttributesCount;
            }
            if (attribute.isGenerateDerived) {
                ++this.type.derivedAttributesCount;
            }
            if (attributeMethodCandidate.getEnclosingElement().equals(originalType)) {
                this.hasNonInheritedAttributes = true;
            }
        }
    }

    private boolean returnsNormalizedAbstractValueType(ExecutableElement validationMethodCandidate) {
        $Optional<.processor..Proto.DeclaringType> declaringType = this.protoclass.declaringType();
        if (declaringType.isPresent()) {
            $TypeStringProvider provider = new $TypeStringProvider(this.reporter, validationMethodCandidate, validationMethodCandidate.getReturnType(), new $ImportsTypeStringResolver(declaringType.orNull(), declaringType.orNull()), this.protoclass.constitution().generics().vars(), null);
            provider.process();
            String returnTypeName = provider.returnTypeName();
            return this.protoclass.constitution().typeAbstract().toString().equals(returnTypeName);
        }
        return false;
    }

    private $Styles.UsingName.AttributeNames deriveNames(String accessorName) {
        $Styles.UsingName.AttributeNames names = this.styles.forAccessor(accessorName);
        if (names.raw.equals(HASH_CODE_METHOD) || names.raw.equals(TO_STRING_METHOD)) {
            return this.styles.forAccessorWithRaw(accessorName, accessorName);
        }
        if ((names.raw.equals(ORDINAL_ORDINAL_ATTRIBUTE_NAME) || names.raw.equals(ORDINAL_DOMAIN_ATTRIBUTE_NAME)) && this.type.isOrdinalValue()) {
            return this.styles.forAccessorWithRaw(accessorName, accessorName);
        }
        return names;
    }

    private TypeMirror resolveReturnType(ExecutableElement method) {
        TypeElement typeElement = this.getTypeElement();
        if (this.isEclipseImplementation) {
            return method.getReturnType();
        }
        return $AccessorAttributesCollector.resolveReturnType(this.processing, method, typeElement);
    }

    static TypeMirror resolveReturnType(ProcessingEnvironment processing, ExecutableElement method, TypeElement typeElement) {
        TypeMirror returnType = (method = $CachingElements.getDelegate(method)).getReturnType();
        if (returnType.getKind() == TypeKind.TYPEVAR) {
            return $AccessorAttributesCollector.asInheritedMemberReturnType(processing, typeElement, method);
        }
        if (!(returnType.getKind() != TypeKind.DECLARED && returnType.getKind() != TypeKind.ERROR || ((DeclaredType)returnType).getTypeArguments().isEmpty())) {
            return $AccessorAttributesCollector.asInheritedMemberReturnType(processing, typeElement, method);
        }
        return returnType;
    }

    static TypeMirror asInheritedMemberReturnType(ProcessingEnvironment processing, TypeElement typeElement, ExecutableElement method) {
        ExecutableType asMethodOfType = (ExecutableType)processing.getTypeUtils().asMemberOf((DeclaredType)typeElement.asType(), method);
        return asMethodOfType.getReturnType();
    }

    private static boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isDiscoveredAttribute(ExecutableElement attributeMethodCandidate, boolean isDefaultAsDefault) {
        return attributeMethodCandidate.getParameters().isEmpty() && attributeMethodCandidate.getReturnType().getKind() != TypeKind.VOID && ($AccessorAttributesCollector.isAbstract(attributeMethodCandidate) || $AccessorAttributesCollector.hasGenerateAnnotation(attributeMethodCandidate) || isDefaultAsDefault);
    }

    private static boolean hasGenerateAnnotation(ExecutableElement attributeMethodCandidate) {
        return $DefaultMirror.isPresent(attributeMethodCandidate) || $DerivedMirror.isPresent(attributeMethodCandidate) || $LazyMirror.isPresent(attributeMethodCandidate);
    }

    private $Reporter report(Element type) {
        return $Reporter.from(this.protoclass.processing()).withElement(type);
    }

    static boolean isEclipseImplementation(Element element) {
        return $CachingElements.getDelegate(element).getClass().getCanonicalName().startsWith(ORG_ECLIPSE);
    }
}

