/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.encode;

import java.util.ArrayList;
import java.util.List;
import org.immutables.value.Value;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Predicate;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Iterators;
import org.immutables.value.internal.$guava$.collect.$PeekingIterator;
import org.immutables.value.internal.$processor$.encode.$Code;

@Value.Enclosing
final class $Structurizer {
    private final $PeekingIterator<$Code.Term> terms;
    private final WhitespaceEnabler whitespaces = new WhitespaceEnabler();

    $Structurizer(Iterable<$Code.Term> terms) {
        this.terms = $Iterators.peekingIterator($Iterators.filter(terms.iterator(), this.whitespaces));
    }

    List<Statement> structurize() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        while (this.terms.hasNext()) {
            result.add(this.statement());
        }
        return result;
    }

    private Statement statement() {
        Statement.Builder builder = new Statement.Builder();
        boolean classDecl = false;
        boolean wasParameters = false;
        while (true) {
            $Code.Term t;
            if ((t = this.terms.peek()).is("=")) {
                this.terms.next();
                this.expressionUpToSemicolon(builder);
                return builder.build();
            }
            if (t.is("(") && !wasParameters) {
                builder.addAllParameters(this.collectUntilMatching(")"));
                wasParameters = true;
                continue;
            }
            if (t.is("{")) {
                this.block(builder, classDecl);
                return builder.build();
            }
            if (t.is(";")) {
                this.terms.next();
                return builder.build();
            }
            if (wasParameters) {
                this.terms.next();
                continue;
            }
            if (!this.signature(builder)) continue;
            classDecl = true;
            builder.name($Optional.of(this.terms.peek().toString()));
        }
    }

    private List<$Code.Term> collectUntilMatching(String end) {
        ArrayList<$Code.Term> result = new ArrayList<$Code.Term>();
        this.doCollectMatching(result, this.terms.peek().toString(), end);
        return result;
    }

    private void doCollectMatching(List<$Code.Term> accumulator, String start, String end) {
        this.whitespaces.on();
        try {
            accumulator.add(this.terms.next());
            while (true) {
                $Code.Term t;
                if ((t = this.terms.peek()).is(start)) {
                    this.doCollectMatching(accumulator, start, end);
                    continue;
                }
                if (t.is(end)) {
                    accumulator.add(this.terms.next());
                    return;
                }
                accumulator.add(this.terms.next());
            }
        }
        finally {
            this.whitespaces.off();
        }
    }

    private void expressionUpToSemicolon(Statement.Builder builder) {
        this.terms.peek();
        this.whitespaces.on();
        try {
            ArrayList<$Code.Term> result = new ArrayList<$Code.Term>();
            while (true) {
                $Code.Term t;
                if ((t = this.terms.peek()).is("(")) {
                    this.doCollectMatching(result, "(", ")");
                    continue;
                }
                if (t.is("{")) {
                    this.doCollectMatching(result, "{", "}");
                    continue;
                }
                if (t.is("[")) {
                    this.doCollectMatching(result, "[", "]");
                    continue;
                }
                if (t.is(";")) {
                    builder.addAllExpression(result);
                    return;
                }
                result.add(this.terms.next());
            }
        }
        finally {
            this.whitespaces.off();
        }
    }

    private void block(Statement.Builder builder, boolean classDecl) {
        if (classDecl) {
            $Verify.verify(this.terms.peek().is("{"));
            this.terms.next();
            while (this.terms.hasNext() && !this.terms.peek().is("}")) {
                builder.addDefinitions(this.statement());
            }
            $Verify.verify(this.terms.next().is("}"));
        } else {
            builder.addAllBlock(this.collectUntilMatching("}"));
        }
    }

    private boolean signature(Statement.Builder builder) {
        $Code.Term t = this.terms.peek();
        if (t.is("@")) {
            do {
                builder.addAnnotations(this.terms.next());
                $Verify.verify(this.terms.peek().isWordOrNumber());
                builder.addAnnotations(this.terms.next());
            } while (this.terms.peek().is("."));
            if (this.terms.peek().is("(")) {
                builder.addAllAnnotations(this.collectUntilMatching(")"));
            }
            return false;
        }
        if (t.is("<")) {
            builder.addAllSignature(this.collectUntilMatching(">"));
            return false;
        }
        if (t.is("class")) {
            builder.addSignature(this.terms.next());
            return true;
        }
        builder.addSignature(this.terms.next());
        return false;
    }

    @Value.Immutable
    static abstract class Statement {
        Statement() {
        }

        abstract List<$Code.Term> annotations();

        abstract List<$Code.Term> signature();

        abstract List<$Code.Term> parameters();

        abstract List<$Code.Term> expression();

        abstract List<$Code.Term> block();

        abstract List<Statement> definitions();

        @Value.Derived
        boolean isClass() {
            for ($Code.Term t : this.signature()) {
                if (!t.is("class")) continue;
                return true;
            }
            return false;
        }

        @Value.Default
        $Optional<String> name() {
            if (this.signature().isEmpty()) {
                return $Optional.absent();
            }
            $Code.Term last = $Iterables.getLast(this.signature());
            if (last.isWordOrNumber() && !last.is("static")) {
                return $Optional.of(last.toString());
            }
            return $Optional.absent();
        }

        static class Builder
        extends .processor..ImmutableStructurizer.Statement.Builder {
            Builder() {
            }
        }
    }

    private final class WhitespaceEnabler
    implements $Predicate<$Code.Term> {
        private int count;

        private WhitespaceEnabler() {
        }

        void on() {
            ++this.count;
        }

        void off() {
            if (--this.count < 0) {
                throw new IllegalStateException("unmatched off");
            }
        }

        @Override
        public boolean apply($Code.Term input) {
            return this.count > 0 || !input.isWhitespace() && !input.isComment();
        }
    }
}

