/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.value.internal.$guava$.base.$Ascii;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Joiner;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableMap;
import org.immutables.value.internal.$processor$.encode.$Code;
import org.immutables.value.internal.$processor$.encode.$Eq;

public interface $Type {
    public static final Reference OBJECT = Reference.OBJECT;

    public <V> V accept(Visitor<V> var1);

    public static class Template {
        public final $Type template;

        public Template($Type template) {
            this.template = template;
        }

        public $Optional<VariableResolver> match($Type type) {
            VariableResolver[] holder = new VariableResolver[]{VariableResolver.empty()};
            class Decomposer
            implements Visitor<Boolean> {
                final $Type type;
                final /* synthetic */ VariableResolver[] val$holder;

                Decomposer($Type type) {
                    this.val$holder = variableResolverArray;
                    this.type = type;
                }

                @Override
                public Boolean primitive(Primitive primitive) {
                    return this.type == primitive;
                }

                @Override
                public Boolean reference(Reference reference) {
                    return this.type.equals(reference);
                }

                @Override
                public Boolean parameterized(Parameterized template) {
                    if (this.type instanceof Parameterized) {
                        Parameterized ps = (Parameterized)this.type;
                        if (template.reference.equals(ps.reference) && ps.arguments.size() == template.arguments.size()) {
                            for (int i = 0; i < template.arguments.size(); ++i) {
                                Decomposer visitor = new Decomposer(ps.arguments.get(i));
                                boolean matched = template.arguments.get(i).accept(visitor);
                                if (matched) continue;
                                return false;
                            }
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Boolean variable(Variable variable) {
                    if (variable.equals(this.type)) {
                        return true;
                    }
                    if (this.type instanceof Nonprimitive) {
                        this.val$holder[0] = this.val$holder[0].bind(variable, (Nonprimitive)this.type);
                        return true;
                    }
                    return false;
                }

                @Override
                public Boolean array(Array array) {
                    if (this.type instanceof Array) {
                        return array.element.accept(new Decomposer(((Array)this.type).element));
                    }
                    return false;
                }

                @Override
                public Boolean superWildcard(Wildcard.Super wildcard) {
                    if (this.type instanceof Wildcard.Super) {
                        return wildcard.lowerBound.accept(new Decomposer(((Wildcard.Super)this.type).lowerBound));
                    }
                    return false;
                }

                @Override
                public Boolean extendsWildcard(Wildcard.Extends wildcard) {
                    if (this.type instanceof Wildcard.Extends) {
                        return wildcard.upperBound.accept(new Decomposer(((Wildcard.Extends)this.type).upperBound));
                    }
                    return false;
                }
            }
            if (this.template.accept(new Decomposer(type)).booleanValue()) {
                return $Optional.of(holder[0]);
            }
            return $Optional.absent();
        }
    }

    public static class Parser {
        private static final $Joiner JOINER = $Joiner.on('.');
        private boolean unresolve;
        private final Factory factory;
        private final Parameters parameters;

        public Parser(Factory factory, Parameters parameters) {
            this.factory = factory;
            this.parameters = parameters;
        }

        public Parser unresolving() {
            this.unresolve = false;
            return this;
        }

        private $Type forName(String name) {
            if (Producer.PRIMITIVE_TYPES.containsKey(name)) {
                return this.factory.primitive(name);
            }
            if (this.parameters.names().contains(name)) {
                return this.parameters.variable(name);
            }
            return this.unresolve ? this.factory.unresolved(name) : this.factory.reference(name);
        }

        public $Type parse(String input) {
            try {
                return this.doParse(input);
            }
            catch (RuntimeException ex) {
                IllegalArgumentException exception = new IllegalArgumentException("Cannot parse type from input string '" + input + "'. " + ex.getMessage());
                exception.setStackTrace(ex.getStackTrace());
                throw exception;
            }
        }

        private $Type doParse(String input) {
            final LinkedList<$Code.Term> terms = new LinkedList<$Code.Term>();
            for ($Code.Term t : $Code.termsFrom(input)) {
                if (t.isWhitespace()) continue;
                terms.add(t);
            }
            class Reader {
                Reader() {
                }

                $Type type() {
                    $Code.Term t = ($Code.Term)terms.peek();
                    if (t.isWordOrNumber()) {
                        $Type type = this.named();
                        t = ($Code.Term)terms.peek();
                        if (t != null) {
                            if (t.is("<")) {
                                type = this.arguments(type);
                            }
                            while (!terms.isEmpty() && (t = ($Code.Term)terms.peek()).is("[")) {
                                type = this.array(type);
                            }
                            if (t.is(".")) {
                                type = this.varargs(type);
                            }
                        }
                        return type;
                    }
                    if (t.is("@")) {
                        terms.poll();
                        this.named();
                        this.consumeErraticTrailingComma();
                        return this.type();
                    }
                    throw new IllegalStateException("unexpected term '" + t + "'");
                }

                Wildcard wildcard() {
                    this.expect(($Code.Term)terms.poll(), "?");
                    $Code.Term t = ($Code.Term)terms.peek();
                    if (t.is("super")) {
                        terms.poll();
                        Defined lowerBound = (Defined)this.type();
                        return Parser.this.factory.superWildcard(lowerBound);
                    }
                    if (t.is("extends")) {
                        terms.poll();
                        Defined upperBound = (Defined)this.type();
                        return Parser.this.factory.extendsWildcard(upperBound);
                    }
                    return Parser.this.factory.extendsWildcard(OBJECT);
                }

                $Type array($Type element) {
                    this.expect(($Code.Term)terms.poll(), "[");
                    this.expect(($Code.Term)terms.poll(), "]");
                    return Parser.this.factory.array(element);
                }

                $Type varargs($Type element) {
                    this.expect(($Code.Term)terms.poll(), ".");
                    this.expect(($Code.Term)terms.poll(), ".");
                    this.expect(($Code.Term)terms.poll(), ".");
                    return Parser.this.factory.varargs(element);
                }

                $Type arguments($Type reference) {
                    this.expect(($Code.Term)terms.poll(), "<");
                    ArrayList<Nonprimitive> arguments = new ArrayList<Nonprimitive>();
                    while (true) {
                        if ((($Code.Term)terms.peek()).is("?")) {
                            arguments.add(this.wildcard());
                        } else {
                            arguments.add((Nonprimitive)this.type());
                        }
                        if (terms.isEmpty() || !(($Code.Term)terms.peek()).is(",")) break;
                        terms.poll();
                    }
                    this.expect(($Code.Term)terms.poll(), ">");
                    return Parser.this.factory.parameterized((Reference)reference, arguments);
                }

                $Type named() {
                    ArrayList<String> segments = new ArrayList<String>();
                    while (true) {
                        Iterator it;
                        $Code.Term t;
                        if (!(t = ($Code.Term)terms.poll()).isWordOrNumber()) {
                            if (!t.is("@")) break;
                            this.named();
                            this.consumeErraticTrailingComma();
                            continue;
                        }
                        segments.add(t.toString());
                        if (terms.isEmpty() || !(($Code.Term)terms.peek()).is(".") || terms.size() >= 2 && (($Code.Term)(it = terms.iterator()).next()).is(".") && (($Code.Term)it.next()).is(".")) break;
                        terms.poll();
                    }
                    return Parser.this.forName(JOINER.join(segments));
                }

                private void consumeErraticTrailingComma() {
                    if (!terms.isEmpty() && (($Code.Term)terms.peek()).is(",")) {
                        terms.poll();
                    }
                }

                void expect($Code.Term t, String is) {
                    if (t == null || !t.is(is)) {
                        throw new IllegalStateException("expected '" + is + "' but got '" + t + "'");
                    }
                }
            }
            $Type type = new Reader().type();
            if (!terms.isEmpty()) {
                throw new IllegalStateException("unexpected trailing terms '" + $Joiner.on("").join(terms) + "'");
            }
            return type;
        }
    }

    public static class VariableResolver
    extends Transformer
    implements $Function<$Type, $Type> {
        private static final VariableResolver EMPTY = new VariableResolver(new Variable[0], new Nonprimitive[0]);
        private final Variable[] variables;
        private final Nonprimitive[] substitutions;

        public static VariableResolver empty() {
            return EMPTY;
        }

        public boolean isEmpty() {
            return this.variables.length == 0;
        }

        private VariableResolver(Variable[] variables, Nonprimitive[] substitutions) {
            assert (variables.length == substitutions.length);
            this.variables = variables;
            this.substitutions = substitutions;
        }

        public Variable[] variables() {
            return (Variable[])this.variables.clone();
        }

        @Override
        public $Type variable(Variable variable) {
            for (int i = 0; i < this.variables.length; ++i) {
                if (this.variables[i] != variable) continue;
                return this.substitutions[i];
            }
            return variable;
        }

        @Nullable
        public Variable byName(String named) {
            for (int i = 0; i < this.variables.length; ++i) {
                if (!this.variables[i].name.equals(named)) continue;
                return this.variables[i];
            }
            return null;
        }

        @Override
        public $Type apply($Type type) {
            return type.accept(this);
        }

        public String toString() {
            StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append("{");
            for (Variable v : this.variables) {
                b.append("\n  ").append(v).append(" -> ").append(this.variable(v));
            }
            return b.append("\n}").toString();
        }

        public VariableResolver bind(Variable variable, Nonprimitive substitution) {
            Variable[] variables = Arrays.copyOf(this.variables, this.variables.length + 1);
            variables[variables.length - 1] = variable;
            Nonprimitive[] substitutions = Arrays.copyOf(this.substitutions, this.substitutions.length + 1);
            substitutions[substitutions.length - 1] = substitution;
            return new VariableResolver(variables, substitutions);
        }
    }

    public static abstract class Transformer
    implements Visitor<$Type> {
        protected $Type defaults($Type type) {
            return type;
        }

        @Override
        public $Type primitive(Primitive primitive) {
            return this.defaults(primitive);
        }

        @Override
        public $Type reference(Reference reference) {
            return this.defaults(reference);
        }

        @Override
        public $Type variable(Variable variable) {
            return this.defaults(variable);
        }

        @Override
        public $Type parameterized(Parameterized parameterized) {
            $ImmutableList.Builder builder = $ImmutableList.builder();
            for (Nonprimitive a : parameterized.arguments) {
                builder.add((Nonprimitive)a.accept(this));
            }
            return new Parameterized((Reference)parameterized.reference.accept(this), (List<Nonprimitive>)((Object)builder.build()));
        }

        @Override
        public $Type array(Array array) {
            return new Array(array.element.accept(this), array.varargs);
        }

        @Override
        public $Type superWildcard(Wildcard.Super wildcard) {
            return new Wildcard.Super((Defined)wildcard.lowerBound.accept(this));
        }

        @Override
        public $Type extendsWildcard(Wildcard.Extends wildcard) {
            return new Wildcard.Extends((Defined)wildcard.upperBound.accept(this));
        }
    }

    @ThreadSafe
    public static class Producer
    implements Factory {
        static final Map<String, Primitive> PRIMITIVE_TYPES;
        private static final Parameters EMPTY_PARAMETERS;
        private final Map<String, Reference> resolvedTypes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Producer() {
            Map<String, Reference> map = this.resolvedTypes = new HashMap<String, Reference>(64);
            synchronized (map) {
                this.resolvedTypes.put(Reference.OBJECT.name, Reference.OBJECT);
                this.resolvedTypes.put(Reference.STRING.name, Reference.STRING);
                this.resolvedTypes.put(Reference.BYTE.name, Reference.BYTE);
                this.resolvedTypes.put(Reference.SHORT.name, Reference.SHORT);
                this.resolvedTypes.put(Reference.INTEGER.name, Reference.INTEGER);
                this.resolvedTypes.put(Reference.LONG.name, Reference.LONG);
                this.resolvedTypes.put(Reference.DOUBLE.name, Reference.DOUBLE);
                this.resolvedTypes.put(Reference.FLOAT.name, Reference.FLOAT);
                this.resolvedTypes.put(Reference.CHARACTER.name, Reference.CHARACTER);
                this.resolvedTypes.put(Reference.BOOLEAN.name, Reference.BOOLEAN);
                this.resolvedTypes.put(Reference.VOID.name, Reference.VOID);
            }
        }

        static Parameters emptyParameters() {
            return EMPTY_PARAMETERS;
        }

        @Override
        public Primitive primitive(String name) {
            Primitive type = PRIMITIVE_TYPES.get(name);
            $Preconditions.checkArgument(type != null, "wrong primitive type name %s", name);
            return type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Reference reference(String name) {
            Map<String, Reference> map = this.resolvedTypes;
            synchronized (map) {
                Reference type = this.resolvedTypes.get(name);
                if (type == null) {
                    type = new Reference(name, true);
                    this.resolvedTypes.put(name, type);
                }
                return type;
            }
        }

        @Override
        public Reference unresolved(String name) {
            return new Reference(name, false);
        }

        @Override
        public Parameterized parameterized(Reference raw, Iterable<? extends Nonprimitive> arguments) {
            return new Parameterized(raw, $ImmutableList.copyOf(arguments));
        }

        @Override
        public Array array($Type element) {
            return new Array(element, false);
        }

        @Override
        public Array varargs($Type element) {
            return new Array(element, true);
        }

        @Override
        public Wildcard.Super superWildcard(Defined lowerBound) {
            return new Wildcard.Super(lowerBound);
        }

        @Override
        public Wildcard.Extends extendsWildcard(Defined upperBound) {
            return new Wildcard.Extends(upperBound);
        }

        @Override
        public Parameters parameters() {
            return EMPTY_PARAMETERS;
        }

        static {
            $ImmutableMap.Builder<String, Primitive> primitives = $ImmutableMap.builder();
            for (Primitive p : Primitive.values()) {
                primitives.put(p.typename, p);
            }
            PRIMITIVE_TYPES = primitives.build();
            EMPTY_PARAMETERS = new Parameters(){

                @Override
                public Variable variable(String name) {
                    throw new IllegalArgumentException("no such type parameter '" + name + "' defined in " + this);
                }

                @Override
                public Parameters introduce(String name, Iterable<? extends Defined> upperBounds) {
                    return new DefinedParameters(null, name, $ImmutableList.copyOf(upperBounds), false);
                }

                @Override
                public Parameters recursive(String name) {
                    return new DefinedParameters(null, name, $ImmutableList.of(), true);
                }

                @Override
                public List<String> names() {
                    return $ImmutableList.of();
                }

                public String toString() {
                    return "";
                }
            };
        }

        static final class DefinedParameters
        implements Parameters {
            @Nullable
            private final DefinedParameters parent;
            private final Variable variable;
            private final List<String> names;

            DefinedParameters(@Nullable DefinedParameters parent, String name, List<Defined> bounds, boolean recursive) {
                this.parent = parent;
                this.variable = new Variable(name, bounds, recursive);
                this.names = this.unwindNames();
            }

            private $ImmutableList<String> unwindNames() {
                $ImmutableList.Builder builder = $ImmutableList.builder();
                DefinedParameters p = this;
                while (p != null) {
                    builder.add(p.variable.name);
                    p = p.parent;
                }
                return (($ImmutableList)builder.build()).reverse();
            }

            @Override
            public Parameters introduce(String name, Iterable<? extends Defined> upperBounds) {
                return new DefinedParameters(this, name, $ImmutableList.copyOf(upperBounds), false);
            }

            @Override
            public Parameters recursive(String name) {
                return new DefinedParameters(this, name, $ImmutableList.of(), true);
            }

            @Override
            public Variable variable(String name) {
                if (this.variable.name.equals(name)) {
                    return this.variable;
                }
                if (this.parent != null) {
                    return this.parent.variable(name);
                }
                throw new IllegalArgumentException("no such variable: " + name);
            }

            @Override
            public List<String> names() {
                return this.names;
            }

            public String toString() {
                String parameters = "";
                DefinedParameters p = this;
                while (p != null) {
                    parameters = !parameters.isEmpty() ? p.parameterString() + ", " + parameters : p.parameterString();
                    p = p.parent;
                }
                return "<" + parameters + ">";
            }

            private String parameterString() {
                if (this.variable.upperBounds.isEmpty()) {
                    return this.variable.name;
                }
                if (this.variable.upperBounds.size() == 1 && this.variable.upperBounds.get(0) == OBJECT) {
                    return this.variable.name;
                }
                return this.variable.name + " extends " + $Joiner.on(" & ").join(this.variable.upperBounds);
            }
        }
    }

    public static class Print
    implements Visitor<StringBuilder> {
        private final StringBuilder builder;

        Print() {
            this(new StringBuilder());
        }

        Print(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public StringBuilder primitive(Primitive primitive) {
            return this.builder.append(primitive);
        }

        @Override
        public StringBuilder reference(Reference reference) {
            return this.builder.append(reference.name);
        }

        @Override
        public StringBuilder parameterized(Parameterized parameterized) {
            parameterized.reference.accept(this);
            this.builder.append('<');
            this.printSeparated(parameterized.arguments, ", ");
            return this.builder.append('>');
        }

        @Override
        public StringBuilder variable(Variable variable) {
            return this.builder.append(variable.name);
        }

        @Override
        public StringBuilder array(Array array) {
            array.element.accept(this);
            return this.builder.append(array.varargs ? "..." : "[]");
        }

        @Override
        public StringBuilder superWildcard(Wildcard.Super wildcard) {
            this.builder.append("? super ");
            return wildcard.lowerBound.accept(this);
        }

        @Override
        public StringBuilder extendsWildcard(Wildcard.Extends wildcard) {
            if (wildcard.upperBound == OBJECT) {
                return this.builder.append("?");
            }
            this.builder.append("? extends ");
            return wildcard.upperBound.accept(this);
        }

        public String toString() {
            return this.builder.toString();
        }

        private void printSeparated(Iterable<? extends $Type> types, String separator) {
            boolean notFirst = false;
            for ($Type $Type : types) {
                if (notFirst) {
                    this.builder.append(separator);
                }
                notFirst = true;
                $Type.accept(this);
            }
        }
    }

    public static interface Factory {
        public Primitive primitive(String var1);

        public Reference reference(String var1);

        public Reference unresolved(String var1);

        public Parameterized parameterized(Reference var1, Iterable<? extends Nonprimitive> var2);

        public Array array($Type var1);

        public Array varargs($Type var1);

        public Wildcard.Super superWildcard(Defined var1);

        public Wildcard.Extends extendsWildcard(Defined var1);

        public Parameters parameters();
    }

    public static interface Parameters {
        public Parameters introduce(String var1, Iterable<? extends Defined> var2);

        public Parameters recursive(String var1);

        public List<String> names();

        public Variable variable(String var1);
    }

    public static enum Primitive implements $Type
    {
        BOOLEAN(Reference.BOOLEAN, "false"),
        BYTE(Reference.BYTE, "0"),
        SHORT(Reference.SHORT, "0"),
        INT(Reference.INTEGER, "0"),
        LONG(Reference.LONG, "0L"),
        CHAR(Reference.CHARACTER, "'\u0000'"),
        FLOAT(Reference.FLOAT, "0F"),
        DOUBLE(Reference.DOUBLE, "0D"),
        VOID(Reference.VOID, "");

        final String typename;
        final Reference wrapper;
        final String defaultValue;

        private Primitive(Reference wrapper, String defaultValue) {
            this.wrapper = wrapper;
            this.typename = $Ascii.toLowerCase(this.name());
            this.defaultValue = defaultValue;
        }

        @Override
        public <V> V accept(Visitor<V> visitor) {
            return visitor.primitive(this);
        }

        public String toString() {
            return this.typename;
        }

        public static Nonprimitive asNonprimitive($Type type) {
            if (type instanceof Primitive) {
                return ((Primitive)type).wrapper;
            }
            return (Nonprimitive)type;
        }
    }

    public static interface Wildcard
    extends Nonprimitive {

        public static class Extends
        extends $Eq<Extends>
        implements Wildcard {
            public final Defined upperBound;

            Extends(Defined upperBound) {
                super(upperBound);
                this.upperBound = upperBound;
            }

            @Override
            protected boolean eq(Extends other) {
                return this.upperBound.equals(other.upperBound);
            }

            @Override
            public <V> V accept(Visitor<V> visitor) {
                return visitor.extendsWildcard(this);
            }

            public String toString() {
                return this.accept(new Print()).toString();
            }
        }

        public static class Super
        extends $Eq<Super>
        implements Wildcard {
            public final Defined lowerBound;

            Super(Defined lowerBound) {
                super(lowerBound);
                this.lowerBound = lowerBound;
            }

            @Override
            protected boolean eq(Super other) {
                return this.lowerBound.equals(other.lowerBound);
            }

            @Override
            public <V> V accept(Visitor<V> visitor) {
                return visitor.superWildcard(this);
            }

            public String toString() {
                return this.accept(new Print()).toString();
            }
        }
    }

    public static class Parameterized
    extends $Eq<Parameterized>
    implements Defined {
        public final Reference reference;
        public final List<Nonprimitive> arguments;

        Parameterized(Reference reference, List<Nonprimitive> arguments) {
            super(reference, arguments);
            this.reference = reference;
            this.arguments = arguments;
        }

        @Override
        protected boolean eq(Parameterized other) {
            return this.reference.equals(other.reference) && this.arguments.equals(other.arguments);
        }

        @Override
        public <V> V accept(Visitor<V> visitor) {
            return visitor.parameterized(this);
        }

        public String toString() {
            return this.accept(new Print()).toString();
        }
    }

    public static class Variable
    implements Defined {
        public final String name;
        public final List<Defined> upperBounds;
        public final boolean recursive;

        Variable(String name, List<Defined> upperBounds, boolean recursive) {
            this.name = name;
            this.upperBounds = upperBounds;
            this.recursive = recursive;
        }

        boolean isUnbounded() {
            return this.upperBounds.isEmpty() || this.upperBounds.equals($ImmutableList.of(OBJECT));
        }

        @Override
        public <V> V accept(Visitor<V> visitor) {
            return visitor.variable(this);
        }

        public String toString() {
            return this.accept(new Print()).toString();
        }
    }

    public static class Array
    extends $Eq<Array>
    implements Nonprimitive {
        public final $Type element;
        public final boolean varargs;

        Array($Type element, boolean varargs) {
            super(element, varargs);
            if (element instanceof Wildcard) {
                throw new IllegalArgumentException("Wildcard as array element is not allowed: " + element);
            }
            this.element = element;
            this.varargs = varargs;
        }

        @Override
        protected boolean eq(Array other) {
            return this.element.equals(other.element) && this.varargs == other.varargs;
        }

        @Override
        public <V> V accept(Visitor<V> visitor) {
            return visitor.array(this);
        }

        public String toString() {
            return this.accept(new Print()).toString();
        }
    }

    public static class Reference
    implements Defined {
        public static final Reference OBJECT = new Reference(Object.class.getName(), true);
        public static final Reference STRING = new Reference(String.class.getName(), true);
        public static final Reference BYTE = new Reference(Short.class.getName(), true);
        public static final Reference SHORT = new Reference(Short.class.getName(), true);
        public static final Reference INTEGER = new Reference(Integer.class.getName(), true);
        public static final Reference LONG = new Reference(Long.class.getName(), true);
        public static final Reference DOUBLE = new Reference(Double.class.getName(), true);
        public static final Reference FLOAT = new Reference(Float.class.getName(), true);
        public static final Reference CHARACTER = new Reference(Character.class.getName(), true);
        public static final Reference BOOLEAN = new Reference(Boolean.class.getName(), true);
        public static final Reference VOID = new Reference(Void.class.getName(), true);
        public final String name;
        public final boolean resolved;

        Reference(String name, boolean resolved) {
            this.name = name;
            this.resolved = resolved;
        }

        @Override
        public <V> V accept(Visitor<V> visitor) {
            return visitor.reference(this);
        }

        public String toString() {
            return this.accept(new Print()).toString();
        }
    }

    public static interface Defined
    extends Nonprimitive {
    }

    public static interface Nonprimitive
    extends $Type {
    }

    public static interface Visitor<V> {
        public V primitive(Primitive var1);

        public V reference(Reference var1);

        public V parameterized(Parameterized var1);

        public V variable(Variable var1);

        public V array(Array var1);

        public V superWildcard(Wildcard.Super var1);

        public V extendsWildcard(Wildcard.Extends var1);
    }
}

