/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import com.sun.tools.javac.code.Attribute;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import javax.lang.model.util.Types;
import org.immutables.value.internal.$generator$.$Compiler;
import org.immutables.value.internal.$generator$.$StringLiterals;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Functions;
import org.immutables.value.internal.$guava$.collect.$ImmutableCollection;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;

public final class $AnnotationMirrors {
    private $AnnotationMirrors() {
    }

    public static List<? extends AnnotationMirror> from(TypeMirror type) {
        return (List)GetTypeAnnotations.get(type);
    }

    public static CharSequence toCharSequence(AnnotationMirror value) {
        PrintVisitor printer = new PrintVisitor();
        printer.visitAnnotation(value, null);
        return printer.builder;
    }

    public static CharSequence toCharSequence(AnnotationMirror value, $Function<String, String> unresovedImportsResolver) {
        PrintVisitor printer = new PrintVisitor(unresovedImportsResolver);
        printer.visitAnnotation(value, null);
        return printer.builder;
    }

    public static $ImmutableList<TypeMirror> getTypesFromMirrors(String annotationQualifiedName, String annotationAttributeName, List<? extends AnnotationMirror> annotationMirrors) {
        $ImmutableList.Builder<TypeMirror> builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(annotationQualifiedName)) continue;
            $AnnotationMirrors.collectTypesFromAnnotationAttribute(annotationAttributeName, builder, annotationMirror);
        }
        return builder.build();
    }

    public static $ImmutableList<TypeMirror> getTypesFromMirrors(Types types, TypeMirror annotationType, String annotationAttributeName, List<? extends AnnotationMirror> annotationMirrors) {
        $ImmutableList.Builder<TypeMirror> builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!types.isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            $AnnotationMirrors.collectTypesFromAnnotationAttribute(annotationAttributeName, builder, annotationMirror);
        }
        return builder.build();
    }

    private static void collectTypesFromAnnotationAttribute(String annotationValueName, final $ImmutableCollection.Builder<TypeMirror> builder, AnnotationMirror annotationMirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
            if (!e.getKey().getSimpleName().contentEquals(annotationValueName)) continue;
            e.getValue().accept(new SimpleAnnotationValueVisitor7<Void, Void>(){

                @Override
                public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                    for (AnnotationValue annotationValue : vals) {
                        annotationValue.accept(this, p);
                    }
                    return null;
                }

                @Override
                public Void visitType(TypeMirror t, Void p) {
                    builder.add(t);
                    return null;
                }
            }, null);
        }
    }

    @Nullable
    public static AnnotationMirror findAnnotation(List<? extends AnnotationMirror> annotationMirrors, Class<? extends Annotation> annotationType) {
        String annotationTypeName = annotationType.getCanonicalName();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotationTypeName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isAnnotationPresent(List<? extends AnnotationMirror> annotationMirrors, Class<? extends Annotation> annotationType) {
        return $AnnotationMirrors.findAnnotation(annotationMirrors, annotationType) != null;
    }

    private static final class PrintVisitor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        private static final String ATTRIBUTE_VALUE = "value";
        private static final String CONSTANT_MAX_VALUE = ".MAX_VALUE";
        private static final String CONSTANT_MIN_VALUE = ".MIN_VALUE";
        private static final String CONSTANT_NAN = ".NaN";
        private static final String CONSTANT_NEGATIVE_INFINITY = ".NEGATIVE_INFINITY";
        private static final String CONSTANT_POSITIVE_INFINITY = ".POSITIVE_INFINITY";
        final StringBuilder builder = new StringBuilder();
        final $Function<String, String> unresovedImportsResolver;

        PrintVisitor() {
            this($Functions.identity());
        }

        PrintVisitor($Function<String, String> unresovedImportsResolver) {
            this.unresovedImportsResolver = unresovedImportsResolver;
        }

        void visitValue(AnnotationValue value) {
            value.accept(this, null);
        }

        @Override
        public Void visitBoolean(boolean b, Void p) {
            this.builder.append(b);
            return null;
        }

        @Override
        public Void visitInt(int i, Void p) {
            this.appendLiteral(i);
            return null;
        }

        @Override
        public Void visitDouble(double d, Void p) {
            this.appendLiteral(d);
            return null;
        }

        @Override
        public Void visitFloat(float f, Void p) {
            this.appendLiteral(f);
            return null;
        }

        @Override
        public Void visitLong(long l, Void p) {
            this.appendLiteral(l);
            return null;
        }

        @Override
        public Void visitShort(short s, Void p) {
            this.appendLiteral(s);
            return null;
        }

        @Override
        public Void visitByte(byte b, Void p) {
            this.appendLiteral(b);
            return null;
        }

        @Override
        public Void visitChar(char c, Void p) {
            this.builder.append($StringLiterals.toLiteral(c));
            return null;
        }

        @Override
        public Void visitString(String s, Void p) {
            this.builder.append($StringLiterals.toLiteral(s));
            return null;
        }

        @Override
        public Void visitType(TypeMirror t, Void p) {
            this.builder.append(t).append(".class");
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
            if (vals.size() == 1) {
                this.visitValue(vals.get(0));
                return null;
            }
            this.builder.append('{');
            boolean notFirst = false;
            for (AnnotationValue annotationValue : vals) {
                if (notFirst) {
                    this.builder.append(", ");
                }
                notFirst = true;
                this.visitValue(annotationValue);
            }
            this.builder.append('}');
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c, Void p) {
            this.builder.append(c.getEnclosingElement()).append('.').append(c.getSimpleName());
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, Void p) {
            this.builder.append('@').append(a.getAnnotationType());
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = a.getElementValues();
            if (!values.isEmpty()) {
                this.builder.append('(');
                boolean notFirst = false;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : values.entrySet()) {
                    boolean onlyValue;
                    if (notFirst) {
                        this.builder.append(", ");
                    }
                    notFirst = true;
                    Name name = e.getKey().getSimpleName();
                    boolean bl = onlyValue = values.size() == 1 && name.contentEquals(ATTRIBUTE_VALUE);
                    if (!onlyValue) {
                        this.builder.append(name).append(" = ");
                    }
                    this.printValue(e.getValue());
                }
                this.builder.append(')');
            }
            return null;
        }

        private void printValue(AnnotationValue value) {
            if ($Compiler.JAVAC.isPresent() && "com.sun.tools.javac.code.Attribute.UnresolvedClass".equals(value.getClass().getCanonicalName())) {
                Attribute.UnresolvedClass unresolved = (Attribute.UnresolvedClass)value;
                String typeString = unresolved.classType.tsym.name.toString();
                this.builder.append(this.unresovedImportsResolver.apply(typeString)).append(".class");
            } else {
                this.visitValue(value);
            }
        }

        private void appendLiteral(float value) {
            if (value == Float.NEGATIVE_INFINITY) {
                this.appendConstant(Float.class, CONSTANT_NEGATIVE_INFINITY);
            } else if (value == Float.POSITIVE_INFINITY) {
                this.appendConstant(Float.class, CONSTANT_POSITIVE_INFINITY);
            } else if (value == Float.MAX_VALUE) {
                this.appendConstant(Float.class, CONSTANT_MAX_VALUE);
            } else if (value == Float.MIN_VALUE) {
                this.appendConstant(Float.class, CONSTANT_MIN_VALUE);
            } else if (Float.isNaN(value)) {
                this.appendConstant(Float.class, CONSTANT_NAN);
            } else {
                this.builder.append(Float.toString(value));
            }
        }

        private void appendConstant(Class<?> type, String accessor) {
            this.builder.append(type.getCanonicalName()).append(accessor);
        }

        private void appendLiteral(double value) {
            if (value == Double.NEGATIVE_INFINITY) {
                this.appendConstant(Double.class, CONSTANT_NEGATIVE_INFINITY);
            } else if (value == Double.POSITIVE_INFINITY) {
                this.appendConstant(Double.class, CONSTANT_POSITIVE_INFINITY);
            } else if (value == Double.MAX_VALUE) {
                this.appendConstant(Double.class, CONSTANT_MAX_VALUE);
            } else if (value == Double.MIN_VALUE) {
                this.appendConstant(Double.class, CONSTANT_MIN_VALUE);
            } else if (Double.isNaN(value)) {
                this.appendConstant(Double.class, CONSTANT_NAN);
            } else {
                this.builder.append(Double.toString(value));
            }
        }

        private void appendLiteral(long value) {
            if (value == Long.MAX_VALUE) {
                this.appendConstant(Long.class, CONSTANT_MAX_VALUE);
            } else if (value == Long.MIN_VALUE) {
                this.appendConstant(Long.class, CONSTANT_MIN_VALUE);
            } else {
                this.builder.append(Long.toString(value));
            }
        }

        private void appendLiteral(int value) {
            if (value == Integer.MAX_VALUE) {
                this.appendConstant(Integer.class, CONSTANT_MAX_VALUE);
            } else if (value == Integer.MIN_VALUE) {
                this.appendConstant(Integer.class, CONSTANT_MIN_VALUE);
            } else {
                this.builder.append(Integer.toString(value));
            }
        }

        private void appendLiteral(short value) {
            if (value == Short.MAX_VALUE) {
                this.appendConstant(Short.class, CONSTANT_MAX_VALUE);
            } else if (value == Integer.MIN_VALUE) {
                this.appendConstant(Short.class, CONSTANT_MIN_VALUE);
            } else {
                this.builder.append(Short.toString(value));
            }
        }

        private void appendLiteral(byte value) {
            if (value == 127) {
                this.appendConstant(Byte.class, CONSTANT_MAX_VALUE);
            } else if (value == -128) {
                this.appendConstant(Byte.class, CONSTANT_MIN_VALUE);
            } else {
                this.builder.append(Integer.toHexString(value));
            }
        }
    }

    private static enum GetTypeAnnotations {

        @Nullable
        private static final Method METHOD;

        static Object get(Object input) {
            if (METHOD != null) {
                try {
                    return METHOD.invoke(input, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return $ImmutableList.of();
        }

        static {
            Method method = null;
            try {
                method = TypeMirror.class.getMethod("getAnnotationMirrors", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            METHOD = method;
        }
    }
}

