/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.immutables.value.internal.$processor$.meta.$InjectAnnotationMirror;

public final class $AnnotationInjections {
    private $AnnotationInjections() {
    }

    private static String emptyIfDefault(String annotationType) {
        if (annotationType.equals("org.immutables.annotate.InjectAnnotation") || annotationType.equals(InjectAnnotation.class.getName())) {
            return "";
        }
        return annotationType;
    }

    public static InjectionInfo infoFrom($InjectAnnotationMirror mirror) {
        return new InjectionInfo(mirror.code(), $AnnotationInjections.emptyIfDefault(mirror.typeName()), mirror.deduplicationKey(), mirror.ifPresent(), mirror.target());
    }

    public static final class InjectionInfo {
        final String code;
        final String annotationType;
        final boolean ifPresent;
        final String deduplicationKey;
        final EnumSet<InjectAnnotation.Where> targets;

        private InjectionInfo(String code, String annotationType, String deduplicationKey, boolean ifPresent, InjectAnnotation.Where[] targets) {
            this.code = code;
            this.annotationType = annotationType;
            this.ifPresent = ifPresent;
            this.targets = targets.length == 0 ? EnumSet.allOf(InjectAnnotation.Where.class) : EnumSet.copyOf(Arrays.asList(targets));
            this.deduplicationKey = this.deduplicationKeyFor(deduplicationKey, annotationType, code);
        }

        private String deduplicationKeyFor(String deduplicationKey, String annotationType, String code) {
            if (!deduplicationKey.isEmpty()) {
                return deduplicationKey;
            }
            if (!annotationType.isEmpty()) {
                return annotationType;
            }
            return code;
        }

        void collectApplicable(InjectAnnotation.Where target, Map<String, String> annotations) {
            if (annotations.containsKey(this.deduplicationKey) || !this.targets.contains((Object)target)) {
                return;
            }
        }
    }

    public static @interface InjectAnnotation {
        public String code() default "";

        public Class<? extends Annotation> type() default InjectAnnotation.class;

        public boolean ifPresent() default false;

        public Where[] target();

        public String deduplicationKey() default "";

        public static enum Where {
            FIELD,
            ACCESSOR,
            SYNTHETIC_FIELDS,
            CONSTRUCTOR_PARAMETER,
            INITIALIZER,
            ELEMENT_INITIALIZER,
            BUILDER_TYPE,
            IMMUTABLE_TYPE;

        }
    }
}

