/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.primitives.$Booleans;
import org.immutables.value.internal.$processor$.meta.$ValueMirrors;

public class $ImmutableMirror
implements $ValueMirrors.Immutable {
    public static final String QUALIFIED_NAME = "org.immutables.value.Value.Immutable";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.meta.ValueMirrors.$Immutable";
    private final AnnotationMirror annotationMirror;
    private final boolean singleton;
    private final boolean intern;
    private final boolean copy;
    private final boolean prehash;
    private final boolean builder;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Immutable";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$ImmutableMirror> find(Element element) {
        return $ImmutableMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$ImmutableMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $ImmutableMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$ImmutableMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $ImmutableMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $ImmutableMirror from(TypeElement element) {
        return new $ImmutableMirror(element);
    }

    public static $Optional<$ImmutableMirror> from(AnnotationMirror mirror) {
        return $ImmutableMirror.find(Collections.singleton(mirror));
    }

    private $ImmutableMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        boolean singleton = false;
        boolean intern = false;
        boolean copy = false;
        boolean prehash = false;
        boolean builder = false;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("singleton".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Immutable");
                }
                SingletonExtractor singletonExtractor$ = new SingletonExtractor();
                annotationValue$.accept(singletonExtractor$, null);
                singleton = singletonExtractor$.get();
                continue;
            }
            if ("intern".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Immutable");
                }
                InternExtractor internExtractor$ = new InternExtractor();
                annotationValue$.accept(internExtractor$, null);
                intern = internExtractor$.get();
                continue;
            }
            if ("copy".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Immutable");
                }
                CopyExtractor copyExtractor$ = new CopyExtractor();
                annotationValue$.accept(copyExtractor$, null);
                copy = copyExtractor$.get();
                continue;
            }
            if ("prehash".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Immutable");
                }
                PrehashExtractor prehashExtractor$ = new PrehashExtractor();
                annotationValue$.accept(prehashExtractor$, null);
                prehash = prehashExtractor$.get();
                continue;
            }
            if (!"builder".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Immutable");
            }
            BuilderExtractor builderExtractor$ = new BuilderExtractor();
            annotationValue$.accept(builderExtractor$, null);
            builder = builderExtractor$.get();
        }
        this.singleton = singleton;
        this.intern = intern;
        this.copy = copy;
        this.prehash = prehash;
        this.builder = builder;
    }

    private $ImmutableMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        boolean singleton = false;
        boolean intern = false;
        boolean copy = false;
        boolean prehash = false;
        boolean builder = false;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("singleton".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'singleton' attribute of @Immutable");
                }
                SingletonExtractor singletonExtractor$ = new SingletonExtractor();
                annotationValue$.accept(singletonExtractor$, null);
                singleton = singletonExtractor$.get();
                continue;
            }
            if ("intern".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'intern' attribute of @Immutable");
                }
                InternExtractor internExtractor$ = new InternExtractor();
                annotationValue$.accept(internExtractor$, null);
                intern = internExtractor$.get();
                continue;
            }
            if ("copy".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'copy' attribute of @Immutable");
                }
                CopyExtractor copyExtractor$ = new CopyExtractor();
                annotationValue$.accept(copyExtractor$, null);
                copy = copyExtractor$.get();
                continue;
            }
            if ("prehash".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'prehash' attribute of @Immutable");
                }
                PrehashExtractor prehashExtractor$ = new PrehashExtractor();
                annotationValue$.accept(prehashExtractor$, null);
                prehash = prehashExtractor$.get();
                continue;
            }
            if (!"builder".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'builder' attribute of @Immutable");
            }
            BuilderExtractor builderExtractor$ = new BuilderExtractor();
            annotationValue$.accept(builderExtractor$, null);
            builder = builderExtractor$.get();
        }
        this.singleton = singleton;
        this.intern = intern;
        this.copy = copy;
        this.prehash = prehash;
        this.builder = builder;
    }

    @Override
    public boolean singleton() {
        return this.singleton;
    }

    @Override
    public boolean intern() {
        return this.intern;
    }

    @Override
    public boolean copy() {
        return this.copy;
    }

    @Override
    public boolean prehash() {
        return this.prehash;
    }

    @Override
    public boolean builder() {
        return this.builder;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return $ValueMirrors.Immutable.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "singleton".hashCode() ^ $Booleans.hashCode(this.singleton);
        h += 127 * "intern".hashCode() ^ $Booleans.hashCode(this.intern);
        h += 127 * "copy".hashCode() ^ $Booleans.hashCode(this.copy);
        h += 127 * "prehash".hashCode() ^ $Booleans.hashCode(this.prehash);
        return h += 127 * "builder".hashCode() ^ $Booleans.hashCode(this.builder);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $ImmutableMirror) {
            $ImmutableMirror otherMirror = ($ImmutableMirror)other;
            return this.singleton == otherMirror.singleton && this.intern == otherMirror.intern && this.copy == otherMirror.copy && this.prehash == otherMirror.prehash && this.builder == otherMirror.builder;
        }
        return false;
    }

    @Override
    public String toString() {
        return "ImmutableMirror:" + this.annotationMirror;
    }

    private static class BuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private BuilderExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'builder' in @org.immutables.value.Value.Immutable");
        }
    }

    private static class PrehashExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private PrehashExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'prehash' in @org.immutables.value.Value.Immutable");
        }
    }

    private static class CopyExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private CopyExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'copy' in @org.immutables.value.Value.Immutable");
        }
    }

    private static class InternExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private InternExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'intern' in @org.immutables.value.Value.Immutable");
        }
    }

    private static class SingletonExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private SingletonExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'singleton' in @org.immutables.value.Value.Immutable");
        }
    }
}

