/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.immutables.value.internal.$generator$.$SourceTypes;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Functions;
import org.immutables.value.internal.$guava$.collect.$HashMultimap;
import org.immutables.value.internal.$guava$.collect.$ImmutableCollection;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableListMultimap;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Maps;
import org.immutables.value.internal.$guava$.collect.$Multimaps;
import org.immutables.value.internal.$guava$.collect.$SetMultimap;
import org.immutables.value.internal.$processor$.encode.$Type;
import org.immutables.value.internal.$processor$.meta.$LongBits;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;

public final class $FromSupertypesModel {
    private static final AtomicBoolean typeParseExceptionReported = new AtomicBoolean();
    public final $ImmutableList<FromSupertype> supertypes;
    public final $ImmutableList<String> repeating;
    public final $LongBits.LongPositions positions;
    private final $Reporter reporter;

    $FromSupertypesModel($Reporter reporter, String abstractTypeName, Collection<$ValueAttribute> attributes, $ImmutableListMultimap<String, TypeElement> accessorMapping) {
        this.reporter = reporter;
        $HashMultimap<String, String> typesByAttribute = $HashMultimap.create();
        for ($ValueAttribute a : attributes) {
            String name = a.name();
            $ImmutableCollection elements = accessorMapping.get((Object)a.names.get);
            Iterator iterator = (($ImmutableList)elements).iterator();
            while (iterator.hasNext()) {
                TypeElement t = (TypeElement)iterator.next();
                String type = this.isEligibleFromType(t, a) ? t.getQualifiedName().toString() : abstractTypeName;
                typesByAttribute.put(name, type);
            }
        }
        $SetMultimap attributeByType = $Multimaps.invertFrom(typesByAttribute, $HashMultimap.create());
        HashMap<String, $ValueAttribute> attributeMap = $Maps.newHashMapWithExpectedSize(attributes.size());
        for ($ValueAttribute a : attributes) {
            attributeMap.put(a.name(), a);
        }
        $Function getAttribute = $Functions.forMap(attributeMap);
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (Map.Entry e : attributeByType.asMap().entrySet()) {
            builder.add(new FromSupertype((String)e.getKey(), $Iterables.transform(e.getValue(), getAttribute)));
        }
        if (!attributeByType.containsKey(abstractTypeName)) {
            builder.add(new FromSupertype(abstractTypeName, $ImmutableList.of()));
        }
        this.supertypes = builder.build();
        $ImmutableList.Builder repeatingBuilder = $ImmutableList.builder();
        for (Map.Entry e : typesByAttribute.asMap().entrySet()) {
            if (e.getValue().size() <= 1) continue;
            repeatingBuilder.add((String)e.getKey());
        }
        this.repeating = repeatingBuilder.build();
        this.positions = new $LongBits().apply((Iterable<? extends Object>)this.repeating);
    }

    private boolean isEligibleFromType(TypeElement typeElement, $ValueAttribute attr) {
        block5: {
            if (!typeElement.getTypeParameters().isEmpty()) {
                return false;
            }
            ExecutableElement accessor = this.findMethod(typeElement, attr.names.get);
            if (accessor == null) {
                return false;
            }
            try {
                String ownType = accessor.getReturnType().toString();
                String inheritedType = attr.returnType.toString();
                $Type.Producer tf = new $Type.Producer();
                $Type.Parser parser = new $Type.Parser(tf, tf.parameters());
                if (parser.parse(ownType).equals(parser.parse(inheritedType))) {
                    attr.initNullabilitySupertype(accessor);
                    return true;
                }
            }
            catch (Exception typeParseException) {
                if (!typeParseExceptionReported.compareAndSet(false, true)) break block5;
                this.reporter.warning("Type parsing problem in FromSupertypesModel: %s", typeParseException);
            }
        }
        this.reporter.warning($Reporter.About.FROM, "Generated builder '.from' method will not copy from attribute '%s' because it has different return type in supertype (And we cannot handle generic specialization or covariant overrides yet). Sometimes it is possible to avoid this by providing abstract override method in this value object", attr.name());
        return false;
    }

    @Nullable
    private ExecutableElement findMethod(TypeElement typeElement, String getter) {
        for (ExecutableElement m : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!m.getSimpleName().contentEquals(getter) || !m.getParameters().isEmpty()) continue;
            return m;
        }
        return null;
    }

    public boolean hasManySupertypes() {
        return this.supertypes.size() > 1;
    }

    public boolean hasWildcards() {
        for (FromSupertype s : this.supertypes) {
            if (!s.hasGenerics) continue;
            return true;
        }
        return false;
    }

    public static final class FromSupertype {
        public final String type;
        public final String wildcard;
        public final boolean hasGenerics;
        public final $ImmutableList<$ValueAttribute> attributes;
        public final String raw;

        FromSupertype(String type, Iterable<$ValueAttribute> attribute) {
            this.type = type;
            this.hasGenerics = type.indexOf(60) > 0;
            Map.Entry<String, List<String>> withArgs = $SourceTypes.extract(type);
            this.raw = withArgs.getKey();
            this.wildcard = this.hasGenerics ? $SourceTypes.stringify($Maps.immutableEntry(withArgs.getKey(), Collections.nCopies(withArgs.getValue().size(), "?"))) : type;
            this.attributes = $ImmutableList.copyOf(attribute);
        }

        public String toString() {
            return String.valueOf(this.type) + " -> " + this.attributes;
        }
    }
}

