/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.immutables.value.Value;
import org.immutables.value.internal.$guava$.base.$CaseFormat;
import org.immutables.value.internal.$guava$.base.$Joiner;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$processor$.meta.$CriteriaRepositoryMirror;
import org.immutables.value.internal.$processor$.meta.$ImmutableFacet;
import org.immutables.value.internal.$processor$.meta.$MoreElements;
import org.immutables.value.internal.$processor$.meta.$MoreTypes;
import org.immutables.value.internal.$processor$.meta.$ValueType;

public class $RepositoryModel {
    private static final String BACKEND = "org.immutables.criteria.backend.Backend";
    private final $ValueType type;
    private final Element element;
    private final Types types;
    private final Elements elements;
    private List<Facet> cachedFacets;

    $RepositoryModel($ValueType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.element = type.element;
        ProcessingEnvironment env = type.constitution.protoclass().environment().processing();
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
    }

    public List<Facet> facets() {
        if (this.cachedFacets != null) {
            return this.cachedFacets;
        }
        $CriteriaRepositoryMirror mirror = this.annotation();
        ArrayList facets = new ArrayList();
        TypeMirror[] typeMirrorArray = mirror.facetsMirror();
        int n = typeMirrorArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeMirror type = typeMirrorArray[n2];
            Element element = this.types.asElement(type);
            if ($MoreElements.isType(element)) {
                TypeElement typed = $MoreElements.asType(element);
                FacetConsumer facetConsumer = new FacetConsumer(facets, typed);
                for (TypeMirror typeMirror : typed.getInterfaces()) {
                    facetConsumer.consume(typeMirror);
                }
            }
            ++n2;
        }
        this.cachedFacets = $ImmutableList.copyOf(facets);
        return this.cachedFacets;
    }

    private boolean isFacet(TypeMirror mirror) {
        Element element = this.types.asElement(mirror);
        if (element == null || !$MoreElements.isType(element)) {
            return false;
        }
        TypeElement typed = $MoreElements.asType(element);
        TypeMirror facet = this.elements.getTypeElement("org.immutables.criteria.repository.Facet").asType();
        if (this.types.isSubtype(mirror, facet)) {
            return true;
        }
        for (TypeMirror typeMirror : typed.getInterfaces()) {
            if (!this.isFacet(typeMirror)) continue;
            return true;
        }
        return false;
    }

    private $CriteriaRepositoryMirror annotation() {
        return this.type.constitution.protoclass().criteriaRepository().get();
    }

    public boolean isGenerateRepository() {
        return this.type.constitution.protoclass().criteriaRepository().isPresent();
    }

    public static class CodeBlock {
        public final String code;

        private CodeBlock(String code) {
            this.code = Objects.requireNonNull(code, "code");
        }

        public boolean isEmpty() {
            return this.code.isEmpty();
        }
    }

    private static interface Consumer<T> {
        public void consume(T var1);
    }

    public static class DelegateMethod {
        private final ExecutableType type;
        private final ExecutableElement element;
        private final String body;

        private DelegateMethod(ExecutableType type, ExecutableElement element, String delegateName) {
            this.type = Objects.requireNonNull(type, "type");
            this.element = element;
            this.body = String.format("return %s.%s(%s);", delegateName, element.getSimpleName().toString(), $Joiner.on(", ").join(element.getParameters()));
        }

        public String name() {
            return this.element.getSimpleName().toString();
        }

        public String parameters() {
            ArrayList<String> params = new ArrayList<String>();
            int i = 0;
            while (i < this.type.getParameterTypes().size()) {
                TypeMirror paramType = this.type.getParameterTypes().get(i);
                String name = this.element.getParameters().get(i).getSimpleName().toString();
                if (this.element.isVarArgs()) {
                    TypeMirror component = $MoreTypes.asArray(paramType).getComponentType();
                    params.add(component + " ... " + name);
                } else {
                    params.add(paramType + " " + name);
                }
                ++i;
            }
            return $Joiner.on(", ").join(params);
        }

        public TypeMirror returnType() {
            return this.type.getReturnType();
        }

        public String body() {
            return this.body;
        }
    }

    @Value.Immutable
    public static interface Facet {
        public String name();

        public TypeMirror interfaceType();

        public TypeMirror fieldType();

        public CodeBlock constructor();

        public List<DelegateMethod> methods();
    }

    private class FacetConsumer
    implements Consumer<TypeMirror> {
        private final List<Facet> facets;
        private final TypeElement typed;

        private FacetConsumer(List<Facet> facets, TypeElement typed) {
            this.facets = facets;
            this.typed = typed;
        }

        private String nextName(TypeElement element) {
            String ifaceName = element.getQualifiedName().toString();
            String name = ifaceName.contains(".") ? ifaceName.substring(ifaceName.lastIndexOf(46) + 1) : ifaceName;
            name = $CaseFormat.UPPER_CAMEL.converterTo($CaseFormat.LOWER_CAMEL).convert(name);
            return name;
        }

        @Override
        public void consume(TypeMirror iface) {
            CodeBlock block;
            if (!$RepositoryModel.this.isFacet(iface)) {
                return;
            }
            TypeElement ifaceElement = $MoreElements.asType($RepositoryModel.this.types.asElement(iface));
            String name = this.nextName(ifaceElement);
            DeclaredType fieldType = $RepositoryModel.this.types.getDeclaredType(this.typed, $RepositoryModel.this.element.asType());
            List<ExecutableElement> constructors = ElementFilter.constructorsIn($RepositoryModel.this.elements.getAllMembers(this.typed));
            if (!constructors.isEmpty()) {
                ArrayList<String> params = new ArrayList<String>();
                ExecutableElement ctor = constructors.get(0);
                for (VariableElement variableElement : ctor.getParameters()) {
                    TypeMirror varType = variableElement.asType();
                    if ($RepositoryModel.this.types.isSubtype(varType, $RepositoryModel.this.types.erasure($RepositoryModel.this.elements.getTypeElement(Class.class.getCanonicalName()).asType()))) {
                        params.add(String.valueOf($RepositoryModel.this.type.typeDocument().toString()) + ".class");
                        continue;
                    }
                    if (!$RepositoryModel.this.types.isSubtype(varType, $RepositoryModel.this.elements.getTypeElement($RepositoryModel.BACKEND).asType())) continue;
                    params.add("backend");
                }
                block = new CodeBlock(String.format("this.%s = new %s(%s)", name, fieldType, $Joiner.on(", ").join(params)));
            } else {
                block = new CodeBlock("");
            }
            $ImmutableFacet.Builder facet = $ImmutableFacet.builder();
            DeclaredType interfaceType = $RepositoryModel.this.types.getDeclaredType(ifaceElement, $RepositoryModel.this.element.asType());
            List<ExecutableElement> list = ElementFilter.methodsIn($RepositoryModel.this.elements.getAllMembers($MoreElements.asType(interfaceType.asElement())));
            List<ExecutableElement> objectMethods = ElementFilter.methodsIn($RepositoryModel.this.elements.getAllMembers($MoreElements.asType($RepositoryModel.this.elements.getTypeElement(Object.class.getCanonicalName()))));
            list.removeAll(objectMethods);
            for (ExecutableElement exec : list) {
                ExecutableType type1 = $MoreTypes.asExecutable($RepositoryModel.this.types.asMemberOf(interfaceType, exec));
                facet.addMethods(new DelegateMethod(type1, exec, name));
            }
            facet.name(name).interfaceType(interfaceType).fieldType(fieldType).constructor(block).build();
            this.facets.add(facet.build());
        }
    }
}

