/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$processor$.encode.$Type;
import org.immutables.value.internal.$processor$.encode.$TypeExtractor;
import org.immutables.value.internal.$processor$.meta.$CriteriaMirror;
import org.immutables.value.internal.$processor$.meta.$MoreElements;
import org.immutables.value.internal.$processor$.meta.$MoreTypes;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;

public class $CriteriaModel {
    private static final Iterable<$Type.Defined> NO_BOUNDS = Collections.emptyList();
    private final $ValueAttribute attribute;
    private final $Type.Factory factory;
    private final Elements elements;
    private final Types types;
    private final IntrospectedType introspectedType;

    $CriteriaModel($ValueAttribute attribute) {
        this.attribute = $Preconditions.checkNotNull(attribute, "attribute");
        this.factory = new $Type.Producer();
        ProcessingEnvironment env = attribute.containingType.constitution.protoclass().environment().processing();
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.introspectedType = new IntrospectedType(attribute.returnType, attribute.isNullable(), env.getTypeUtils(), env.getElementUtils());
    }

    private $Type toType(TypeMirror mirror) {
        if (mirror.getKind() == TypeKind.ARRAY) {
            return this.factory.array(this.toType($MoreTypes.asArray(mirror).getComponentType()));
        }
        if (mirror.getKind().isPrimitive()) {
            TypeElement boxed = this.types.boxedClass($MoreTypes.asPrimitiveType(mirror));
            return this.factory.reference(boxed.getQualifiedName().toString());
        }
        Element element = this.types.asElement(mirror);
        if (element == null) {
            throw new IllegalArgumentException(String.format("Element for type %s not found (attribute %s %s)", mirror, this.attribute.name(), this.attribute.returnType));
        }
        $TypeExtractor extractor = new $TypeExtractor(this.factory, $MoreElements.asType(element));
        return extractor.get(mirror);
    }

    private $Type.Parameterized matcherType(IntrospectedType introspected) {
        $Type.Parameterized matcherType;
        IntrospectedType param;
        TypeMirror type = introspected.type;
        String name = introspected.useOptional() ? ((param = introspected.optionalParameter()).isString() ? "org.immutables.criteria.matcher.OptionalStringMatcher.Template" : (param.isBoolean() ? "org.immutables.criteria.matcher.OptionalBooleanMatcher.Template" : (param.isNumber() ? "org.immutables.criteria.matcher.OptionalNumberMatcher.Template" : (param.isComparable() ? "org.immutables.criteria.matcher.OptionalComparableMatcher.Template" : "org.immutables.criteria.matcher.OptionalMatcher.Template")))) : (introspected.hasCriteria() ? type.toString() + "CriteriaTemplate" : (introspected.isBoolean() ? "org.immutables.criteria.matcher.BooleanMatcher.Template" : (introspected.isNumber() ? "org.immutables.criteria.matcher.NumberMatcher.Template" : (introspected.isString() ? "org.immutables.criteria.matcher.StringMatcher.Template" : (introspected.isIterable() || introspected.isArray() ? "org.immutables.criteria.matcher.IterableMatcher" : (introspected.isComparable() ? "org.immutables.criteria.matcher.ComparableMatcher.Template" : "org.immutables.criteria.matcher.ObjectMatcher.Template"))))));
        TypeElement element = this.elements.getTypeElement(name);
        if (element == null) {
            $Type.Variable variable = this.factory.parameters().introduce("R", NO_BOUNDS).variable("R");
            matcherType = this.factory.parameterized(this.factory.reference(name), Collections.singleton(variable));
        } else {
            matcherType = ($Type.Parameterized)this.toType(element.asType());
        }
        return matcherType;
    }

    public $Type.Parameterized buildMatcher() {
        return this.buildMatcher(this.introspectedType);
    }

    private $Type.Parameterized buildMatcher(IntrospectedType introspected) {
        $Preconditions.checkNotNull(introspected, introspected);
        TypeMirror type = introspected.type;
        $Type.Parameterized matcher = this.matcherType(introspected);
        if (matcher.arguments.size() > 1) {
            $Type valueType;
            $Type.VariableResolver resolver = $Type.VariableResolver.empty();
            $Type.Variable arg1 = ($Type.Variable)matcher.arguments.get(1);
            if (introspected.useOptional()) {
                IntrospectedType newType = introspected.optionalParameter();
                valueType = this.toType(newType.type());
                resolver = newType.hasOptionalMatcher() ? resolver.bind(arg1, ($Type.Nonprimitive)valueType) : resolver.bind(arg1, this.buildMatcher(newType));
            } else if (introspected.isScalar()) {
                valueType = this.toType(introspected.box());
                resolver = resolver.bind(arg1, ($Type.Nonprimitive)valueType);
            } else if (introspected.isArray()) {
                TypeMirror mirror = $MoreTypes.asArray(type).getComponentType();
                valueType = this.toType(mirror);
                resolver = resolver.bind(arg1, this.buildMatcher(introspected.withType(mirror)));
            } else {
                TypeMirror mirror = $MoreTypes.asDeclared(type).getTypeArguments().get(0);
                valueType = this.toType(mirror);
                resolver = resolver.bind(arg1, this.buildMatcher(introspected.withType(mirror)));
            }
            if (matcher.arguments.size() > 2) {
                resolver = resolver.bind(($Type.Variable)matcher.arguments.get(2), ($Type.Nonprimitive)valueType);
            }
            return ($Type.Parameterized)matcher.accept(resolver);
        }
        return matcher;
    }

    public MatcherDefinition matcher() {
        return new MatcherDefinition(this.attribute, this.buildMatcher());
    }

    public static class MatcherDefinition {
        private final $ValueAttribute attribute;
        private final $Type.Parameterized type;
        private final IntrospectedType introspectedType;

        private MatcherDefinition($ValueAttribute attribute, $Type.Parameterized type) {
            this.attribute = attribute;
            this.type = $Preconditions.checkNotNull(type, "type");
            ProcessingEnvironment env = attribute.containingType.constitution.protoclass().environment().processing();
            this.introspectedType = new IntrospectedType(attribute.returnType, attribute.isNullable(), env.getTypeUtils(), env.getElementUtils());
        }

        public $Type.Parameterized matcherType() {
            return this.type;
        }

        public String creator() {
            String creator;
            boolean hasCriteria;
            String name = this.type.reference.name;
            boolean bl = hasCriteria = this.attribute.hasCriteria() && !this.attribute.isContainerType() && !this.attribute.isNullable();
            if (hasCriteria) {
                creator = String.format("%s.creator().create(%%s)", this.attribute.returnType.toString() + "Criteria");
            } else {
                String newName = name.endsWith(".Template") ? name.substring(0, name.lastIndexOf(46)) : name;
                creator = String.format("%s.creator().create(%%s)", newName);
            }
            String withPath = String.format("newChild(%s.class, \"%s\", %s)", this.attribute.containingType.typeDocument().toString(), this.attribute.name(), this.secondCreator());
            return String.format(creator, new StringBuilder().append("context.").append(withPath));
        }

        private String secondCreator() {
            String name = this.type.reference.name;
            if (this.introspectedType.isScalar() && !this.introspectedType.useOptional()) {
                String newName;
                String string = newName = name.endsWith(".Template") ? name.substring(0, name.lastIndexOf(46)) : name;
                if (this.introspectedType.hasCriteria() && newName.endsWith("Template")) {
                    newName = newName.substring(0, newName.lastIndexOf("Template"));
                }
                return newName + ".creator()";
            }
            if (this.introspectedType.type().getKind() != TypeKind.DECLARED && !this.introspectedType.isOptional() && !this.introspectedType.isIterable()) {
                return this.attribute.containingType.element.getSimpleName() + "Criteria.creator()";
            }
            DeclaredType declaredType = $MoreTypes.asDeclared(this.introspectedType.type());
            if (declaredType.getTypeArguments().isEmpty()) {
                String prefix = this.introspectedType.hasCriteria() ? this.introspectedType.type.toString() : this.attribute.containingType.element.getSimpleName().toString();
                return prefix + "Criteria.creator()";
            }
            if (declaredType.getTypeArguments().size() != 1) {
                return "org.immutables.criteria.matcher.ObjectMatcher.creator()";
            }
            $Preconditions.checkArgument(declaredType.getTypeArguments().size() == 1, "Expected single arg for %s but got %s", declaredType, declaredType.getTypeArguments().size());
            IntrospectedType type2 = this.introspectedType.withType(declaredType.getTypeArguments().get(0));
            if (type2.hasCriteria()) {
                return type2.erasure + "Criteria.creator()";
            }
            if (name.endsWith("Matcher")) {
                return name + ".creator()";
            }
            if (name.endsWith(".Template")) {
                return name.substring(0, name.lastIndexOf(46)) + ".creator()";
            }
            throw new IllegalArgumentException("Can't detect second creator for " + this.introspectedType.type() + " of attribute " + this.attribute.name());
        }
    }

    private static class IntrospectedType {
        private final TypeMirror type;
        private final Types types;
        private final Elements elements;
        private final boolean nullable;
        private final TypeMirror erasure;

        IntrospectedType(TypeMirror type, boolean nullable, Types types, Elements elements) {
            this.types = types;
            this.elements = elements;
            this.type = $Preconditions.checkNotNull(type, "type");
            this.nullable = nullable;
            TypeMirror erasure = types.erasure(type);
            if (erasure.getKind().isPrimitive()) {
                erasure = types.boxedClass($MoreTypes.asPrimitiveType(erasure)).asType();
            }
            this.erasure = erasure;
        }

        public TypeMirror type() {
            return this.type;
        }

        public IntrospectedType withType(TypeMirror type) {
            return new IntrospectedType(type, false, this.types, this.elements);
        }

        private boolean isSubtypeOf(Class<?> maybeSuper) {
            Objects.requireNonNull(maybeSuper, "maybeSuper");
            return this.isSubtypeOf(this.elements.getTypeElement(maybeSuper.getCanonicalName()));
        }

        private boolean isSubtypeOf(Element element) {
            Objects.requireNonNull(element, "element");
            TypeMirror maybeSuperType = element.asType();
            return this.types.isSubtype(this.erasure, this.types.erasure(maybeSuperType));
        }

        public boolean isBoolean() {
            return this.type.getKind() == TypeKind.BOOLEAN || this.isSubtypeOf(Boolean.class);
        }

        public boolean isNumber() {
            return this.type.getKind().isPrimitive() && !this.isBoolean() && this.type.getKind() != TypeKind.CHAR || this.isSubtypeOf(Number.class);
        }

        public boolean isContainer() {
            return this.isIterable() || this.isOptional() || this.isArray() || this.isMap();
        }

        public boolean isScalar() {
            return !this.isContainer();
        }

        public boolean isEnum() {
            return this.types.asElement(this.type).getKind() == ElementKind.ENUM;
        }

        public boolean isIterable() {
            return this.isSubtypeOf(Iterable.class);
        }

        public boolean isArray() {
            return this.type.getKind() == TypeKind.ARRAY;
        }

        public boolean hasOptionalMatcher() {
            return this.isString() || this.isComparable() || this.isBoolean() || this.isNumber();
        }

        public boolean isComparable() {
            return this.isSubtypeOf(Comparable.class);
        }

        public boolean isString() {
            return this.isSubtypeOf(String.class);
        }

        public boolean isMap() {
            return this.isSubtypeOf(Map.class);
        }

        public boolean isMatcher() {
            return this.isSubtypeOf(this.elements.getTypeElement("org.immutables.criteria.matcher.Matcher"));
        }

        public TypeMirror box() {
            return this.type.getKind().isPrimitive() ? this.types.boxedClass($MoreTypes.asPrimitiveType(this.type)).asType() : this.type;
        }

        public boolean hasCriteria() {
            Element element = this.types.asElement(this.type);
            return element != null && $CriteriaMirror.find(element).isPresent();
        }

        private IntrospectedType optionalParameter() {
            TypeMirror newType;
            if (this.isNullable()) {
                return this.withType(this.type);
            }
            String typeName = this.erasure.toString();
            if ("java.util.OptionalInt".equals(typeName)) {
                newType = this.elements.getTypeElement(Integer.class.getName()).asType();
            } else if ("java.util.OptionalLong".equals(typeName)) {
                newType = this.elements.getTypeElement(Long.class.getName()).asType();
            } else if ("java.util.OptionalDouble".equals(typeName)) {
                newType = this.elements.getTypeElement(Double.class.getName()).asType();
            } else if ("java.util.Optional".equals(this.erasure.toString()) || "org.immutables.value.internal.$guava$.base.$Optional".equals(this.erasure.toString())) {
                newType = $MoreTypes.asDeclared(this.type).getTypeArguments().get(0);
            } else {
                throw new IllegalArgumentException(String.format("%s is not an optional type", this.type));
            }
            return this.withType(newType);
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean useOptional() {
            return this.isOptional() || this.isNullable();
        }

        public boolean isOptional() {
            List<String> names = Arrays.asList("java.util.Optional", "java.util.OptionalInt", "java.util.OptionalDouble", "java.util.OptionalLong", $Optional.class.getName());
            for (String name : names) {
                TypeElement element = this.elements.getTypeElement(name);
                if (element == null || !this.isSubtypeOf(element)) continue;
                return true;
            }
            return false;
        }
    }
}

