/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$processor$.meta.$InjectAnnotationMirror;

public class $InjectManyAnnotationsMirror
implements .processor..AnnotationInjections.InjectManyAnnotations {
    public static final String QUALIFIED_NAME = "org.immutables.annotate.InjectManyAnnotations";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.meta.AnnotationInjections.$InjectManyAnnotations";
    private final AnnotationMirror annotationMirror;
    private final AnnotationMirror[] value;
    private final $InjectAnnotationMirror[] valueMirror;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "InjectManyAnnotations";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$InjectManyAnnotationsMirror> find(Element element) {
        return $InjectManyAnnotationsMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$InjectManyAnnotationsMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $InjectManyAnnotationsMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$InjectManyAnnotationsMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $InjectManyAnnotationsMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $InjectManyAnnotationsMirror from(TypeElement element) {
        return new $InjectManyAnnotationsMirror(element);
    }

    public static $Optional<$InjectManyAnnotationsMirror> from(AnnotationMirror mirror) {
        return $InjectManyAnnotationsMirror.find(Collections.singleton(mirror));
    }

    private $InjectManyAnnotationsMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        AnnotationMirror[] value = null;
        $InjectAnnotationMirror[] valueMirror = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @InjectManyAnnotations");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
            valueMirror = valueExtractor$.mirror();
        }
        this.value = $Preconditions.checkNotNull(value, "default attribute 'value'");
        this.valueMirror = $Preconditions.checkNotNull(valueMirror, "default attribute 'value'");
    }

    private $InjectManyAnnotationsMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        AnnotationMirror[] value = null;
        $InjectAnnotationMirror[] valueMirror = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'value' attribute of @InjectManyAnnotations");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
            valueMirror = valueExtractor$.mirror();
        }
        this.value = $Preconditions.checkNotNull(value, "value for 'value'");
        this.valueMirror = $Preconditions.checkNotNull(valueMirror, "value for 'value'");
    }

    public AnnotationMirror[] valueMirror() {
        return (AnnotationMirror[])this.value.clone();
    }

    public $InjectAnnotationMirror[] value() {
        return this.valueMirror;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return .processor..AnnotationInjections.InjectManyAnnotations.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "value".hashCode() ^ Arrays.hashCode(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $InjectManyAnnotationsMirror) {
            $InjectManyAnnotationsMirror otherMirror = ($InjectManyAnnotationsMirror)other;
            return Arrays.equals(this.value, otherMirror.value);
        }
        return false;
    }

    @Override
    public String toString() {
        return "InjectManyAnnotationsMirror:" + this.annotationMirror;
    }

    private static class ValueExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        AnnotationMirror[] values;
        int position;

        private ValueExtractor() {
        }

        @Override
        public Void visitAnnotation(AnnotationMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new AnnotationMirror[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        AnnotationMirror[] get() {
            return this.values;
        }

        public $InjectAnnotationMirror[] mirror() {
            $InjectAnnotationMirror[] mirrors = new $InjectAnnotationMirror[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                mirrors[i] = $InjectAnnotationMirror.from(this.values[i]).get();
            }
            return mirrors;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'value' in @org.immutables.annotate.InjectManyAnnotations");
        }
    }
}

