package org.immutables.vavr.encodings;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.vavr.encodings.VavrLinkedHashMapEncoding",
  imports = {
  },
  typeParams = {"K", "V"},
  elements = {
    @EncodingMetadata.Element(
      name = "field",
      tags = {"IMPL", "PRIVATE", "FINAL", "FIELD"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.collection.LinkedHashMap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "io.vavr.collection.LinkedHashMap.empty()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "vavrLinkedHashMapEncoding_from",
      tags = {"STATIC", "PRIVATE", "FROM", "SYNTH"},
      naming = "*_from",
      stdNaming = "NONE",
      type = "io.vavr.collection.LinkedHashMap<K, V>",
      typeParams = {},
      params = {"value: io.vavr.collection.LinkedHashMap<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nreturn @^value;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING", "SYNTH"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:vavrLinkedHashMapEncoding_get().toString();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE", "SYNTH"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:vavrLinkedHashMapEncoding_get().hashCode();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS", "SYNTH"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {"other: org.immutables.vavr.encodings.VavrLinkedHashMapEncoding<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@:vavrLinkedHashMapEncoding_get().equals(@^other.@:vavrLinkedHashMapEncoding_get())\n;}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "build",
      tags = {"BUILDER", "PRIVATE", "BUILD"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "io.vavr.collection.LinkedHashMap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@@map;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "vavrLinkedHashMapEncoding_get",
      tags = {"EXPOSE", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.collection.LinkedHashMap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@field;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "vavrLinkedHashMapEncoding_copy",
      tags = {"COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.collection.LinkedHashMap<K, V>",
      typeParams = {},
      params = {"value: io.vavr.collection.LinkedHashMap<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nreturn @^value;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "map",
      tags = {"BUILDER", "PRIVATE", "FIELD"},
      naming = "*_map",
      stdNaming = "NONE",
      type = "io.vavr.collection.LinkedHashMap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "io.vavr.collection.LinkedHashMap.empty()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "put",
      tags = {"BUILDER", "INIT"},
      naming = "*",
      stdNaming = "PUT",
      type = "void",
      typeParams = {},
      params = {"key: K", "value: V"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = this.@@map.put(@^key, @^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "putEntry",
      tags = {"BUILDER", "INIT"},
      naming = "*",
      stdNaming = "ADD_ALL",
      type = "void",
      typeParams = {},
      params = {"entry: io.vavr.Tuple2<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = this.@@map.put(@^entry);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "set",
      tags = {"BUILDER", "INIT", "COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"elements: io.vavr.collection.LinkedHashMap<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = @^elements;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setJavaMap",
      tags = {"BUILDER", "INIT"},
      naming = "setJavaMap*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"in_map: java.util.Map<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = io.vavr.collection.LinkedHashMap.ofAll(@^in_map);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setMap",
      tags = {"BUILDER", "INIT"},
      naming = "setMap*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"in_map: io.vavr.collection.Map<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = io.vavr.collection.LinkedHashMap.ofEntries(@^in_map.map(x -> x));\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setEntries",
      tags = {"BUILDER", "INIT"},
      naming = "setEntries*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"entries: java.lang.Iterable<io.vavr.Tuple2<K, V>>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = io.vavr.collection.LinkedHashMap.ofEntries(@^entries);\n}",
      thrown = {}
    )
  }
)
public @interface VavrLinkedHashMapEncodingEnabled {}
