package org.immutables.vavr.encodings;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.vavr.encodings.VavrMultimapEncoding",
  imports = {
  },
  typeParams = {"K", "V"},
  elements = {
    @EncodingMetadata.Element(
      name = "field",
      tags = {"IMPL", "PRIVATE", "FINAL", "FIELD"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.collection.Multimap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "io.vavr.collection.LinkedHashMultimap.withSet().empty()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "vavrMultimapEncoding_from",
      tags = {"STATIC", "PRIVATE", "FROM", "SYNTH"},
      naming = "*_from",
      stdNaming = "NONE",
      type = "io.vavr.collection.Multimap<K, V>",
      typeParams = {},
      params = {"value: io.vavr.collection.Multimap<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nreturn @^value;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING", "SYNTH"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:vavrMultimapEncoding_get().toString();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE", "SYNTH"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:vavrMultimapEncoding_get().hashCode();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS", "SYNTH"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {"other: org.immutables.vavr.encodings.VavrMultimapEncoding<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@:vavrMultimapEncoding_get().equals(@^other.@:vavrMultimapEncoding_get())\n;}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "build",
      tags = {"BUILDER", "PRIVATE", "BUILD"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "io.vavr.collection.Multimap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@@map;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "vavrMultimapEncoding_get",
      tags = {"EXPOSE", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.collection.Multimap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@field;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "vavrMultimapEncoding_copy",
      tags = {"COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.collection.Multimap<K, V>",
      typeParams = {},
      params = {"value: io.vavr.collection.Multimap<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nreturn @^value;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "map",
      tags = {"BUILDER", "PRIVATE", "FIELD"},
      naming = "*_map",
      stdNaming = "NONE",
      type = "io.vavr.collection.Multimap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "io.vavr.collection.HashMultimap.withSet().empty()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "put",
      tags = {"BUILDER", "INIT"},
      naming = "*",
      stdNaming = "PUT",
      type = "void",
      typeParams = {},
      params = {"key: K", "value: V"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = this.@@map.put(@^key, @^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "putEntry",
      tags = {"BUILDER", "INIT", "DEPLURALIZE"},
      naming = "putEntry*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"entry: io.vavr.Tuple2<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = this.@@map.put(@^entry);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "set",
      tags = {"BUILDER", "INIT", "COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"elements: io.vavr.collection.Multimap<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = @^elements;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setJavaMap",
      tags = {"BUILDER", "INIT"},
      naming = "setJavaMultimap*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"in_map: java.util.Map<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = io.vavr.collection.HashMultimap.withSet().ofEntries(io.vavr.collection.HashMap.ofAll(@^in_map));\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setEntries",
      tags = {"BUILDER", "INIT"},
      naming = "setEntries*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"entries: java.lang.Iterable<io.vavr.Tuple2<K, V>>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@map = io.vavr.collection.HashMultimap.withSet().ofEntries(@^entries);\n}",
      thrown = {}
    )
  }
)
public @interface VavrMultimapEncodingEnabled {}
