package org.immutables.vavr.encodings;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.vavr.encodings.VavrOptionEncoding",
  imports = {
  },
  typeParams = {"T"},
  elements = {
    @EncodingMetadata.Element(
      name = "field",
      tags = {"IMPL", "PRIVATE", "FINAL", "FIELD"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.control.Option<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "io.vavr.control.Option.none()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "init",
      tags = {"STATIC", "PRIVATE", "FROM"},
      naming = "*_init",
      stdNaming = "NONE",
      type = "io.vavr.control.Option<T>",
      typeParams = {},
      params = {"value: io.vavr.control.Option<T>"},
      doc = {},
      annotations = {},
      code = "{\nreturn java.util.Objects.requireNonNull(@^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING", "SYNTH"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:vavrOptionEncoding_get().toString();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE", "SYNTH"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:vavrOptionEncoding_get().hashCode();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS", "SYNTH"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {"other: org.immutables.vavr.encodings.VavrOptionEncoding<T>"},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@:vavrOptionEncoding_get().equals(@^other.@:vavrOptionEncoding_get())\n;}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "build",
      tags = {"BUILDER", "PRIVATE", "BUILD"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "io.vavr.control.Option<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@@optional;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "vavrOptionEncoding_get",
      tags = {"EXPOSE", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.control.Option<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@field;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "withOption",
      tags = {"COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.control.Option<T>",
      typeParams = {},
      params = {"value: io.vavr.control.Option<T>"},
      doc = {},
      annotations = {},
      code = "{\nreturn java.util.Objects.requireNonNull(@^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "with",
      tags = {"COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "io.vavr.control.Option<T>",
      typeParams = {},
      params = {"value: T"},
      doc = {},
      annotations = {},
      code = "{\nreturn io.vavr.control.Option.some(java.util.Objects.requireNonNull(@^value));\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "optional",
      tags = {"BUILDER", "PRIVATE", "FIELD"},
      naming = "*_optional",
      stdNaming = "NONE",
      type = "io.vavr.control.Option<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "io.vavr.control.Option.none()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "set",
      tags = {"BUILDER", "INIT", "COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"opt: io.vavr.control.Option<T>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@optional = java.util.Objects.requireNonNull(@^opt);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setValue",
      tags = {"BUILDER", "INIT"},
      naming = "*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"x: T"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@optional = io.vavr.control.Option.some(java.util.Objects.requireNonNull(@^x));\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "unset",
      tags = {"BUILDER", "INIT"},
      naming = "unset*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nthis.@@optional = io.vavr.control.Option.none();\n}",
      thrown = {}
    )
  }
)
public @interface VavrOptionEncodingEnabled {}
