/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.vavr.encodings;

import io.vavr.collection.Queue;
import java.util.Arrays;

class VavrQueueEncoding<T> {
    private Queue<T> field = Queue.empty();

    VavrQueueEncoding() {
    }

    static final class Builder<T> {
        private Queue<T> queue = Queue.empty();

        Builder() {
        }

        void enqueue(T element) {
            this.queue = this.queue.enqueue(element);
        }

        @SafeVarargs
        final void enqueueVarArgs(T ... elements) {
            this.queue = this.queue.appendAll(Arrays.asList(elements));
        }

        void enqueueAll(Iterable<T> element) {
            this.queue = this.queue.enqueueAll(element);
        }

        void set(Queue<T> elements) {
            this.queue = elements;
        }

        void setIterable(Iterable<T> elements) {
            this.queue = Queue.ofAll(elements);
        }

        Queue<T> build() {
            return this.queue;
        }
    }
}

