/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.annotations.assembler;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.annotations.assembler.FlagAssembler;
import org.incendo.cloud.annotations.descriptor.FlagDescriptor;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserRegistry;
import org.incendo.cloud.parser.flag.CommandFlag;
import org.incendo.cloud.permission.Permission;
import org.incendo.cloud.suggestion.SuggestionProvider;

@API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.annotations.*"})
public final class FlagAssemblerImpl
implements FlagAssembler {
    private final CommandManager<?> commandManager;

    public FlagAssemblerImpl(@NonNull CommandManager<?> commandManager) {
        this.commandManager = commandManager;
    }

    @Override
    public @NonNull CommandFlag<?> assembleFlag(@NonNull FlagDescriptor descriptor) {
        Description description = descriptor.description() == null ? Description.empty() : descriptor.description();
        Permission permission = descriptor.permission() == null ? Permission.empty() : descriptor.permission();
        CommandFlag.Builder builder = this.commandManager.flagBuilder(descriptor.name()).withDescription(description).withAliases(descriptor.aliases()).withPermission(permission);
        if (descriptor.repeatable()) {
            builder = builder.asRepeatable();
        }
        if (descriptor.parameter().getType().equals(Boolean.TYPE)) {
            return builder.build();
        }
        TypeToken token = descriptor.repeatable() && Collection.class.isAssignableFrom(descriptor.parameter().getType()) ? TypeToken.get((Type)GenericTypeReflector.getTypeParameter((Type)descriptor.parameter().getParameterizedType(), Collection.class.getTypeParameters()[0])) : TypeToken.get(descriptor.parameter().getType());
        if (token.equals((Object)TypeToken.get(Boolean.TYPE))) {
            return builder.build();
        }
        List<Annotation> annotations = Arrays.asList(descriptor.parameter().getAnnotations());
        ParserRegistry registry = this.commandManager.parserRegistry();
        ArgumentParser parser = descriptor.parserName() == null ? (ArgumentParser)registry.createParser(token, registry.parseAnnotations(token, annotations)).orElse(null) : (ArgumentParser)registry.createParser(descriptor.parserName(), registry.parseAnnotations(token, annotations)).orElse(null);
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Cannot find parser for type '%s' for flag '%s'", descriptor.parameter().getType().getCanonicalName(), descriptor.name()));
        }
        SuggestionProvider suggestionProvider = descriptor.suggestions() != null ? (SuggestionProvider)registry.getSuggestionProvider(descriptor.suggestions()).orElse(null) : null;
        CommandComponent.Builder componentBuilder = CommandComponent.builder();
        componentBuilder.commandManager(this.commandManager).name(descriptor.name()).valueType(descriptor.parameter().getType()).parser(parser);
        if (suggestionProvider != null) {
            componentBuilder.suggestionProvider(suggestionProvider);
        }
        return builder.withComponent(componentBuilder.build()).build();
    }
}

