/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.brigadier.CloudBrigadierManager;

@API(status=API.Status.INTERNAL)
public final class CloudBrigadierCommand<C, S>
implements Command<S> {
    private final CommandManager<C> commandManager;
    private final CloudBrigadierManager<C, S> brigadierManager;
    private final Function<String, String> inputMapper;

    public CloudBrigadierCommand(@NonNull CommandManager<C> commandManager, @NonNull CloudBrigadierManager<C, S> brigadierManager) {
        this.commandManager = commandManager;
        this.brigadierManager = brigadierManager;
        this.inputMapper = Function.identity();
    }

    public CloudBrigadierCommand(@NonNull CommandManager<C> commandManager, @NonNull CloudBrigadierManager<C, S> brigadierManager, @NonNull Function<String, String> inputMapper) {
        this.commandManager = commandManager;
        this.brigadierManager = brigadierManager;
        this.inputMapper = inputMapper;
    }

    public int run(@NonNull CommandContext<S> ctx) {
        Object source = ctx.getSource();
        String input = ctx.getInput().substring(((ParsedCommandNode)ctx.getLastChild().getNodes().get(0)).getRange().getStart());
        Object sender = this.brigadierManager.senderMapper().map(source);
        this.commandManager.commandExecutor().executeCommand(sender, this.inputMapper.apply(input), cloudContext -> cloudContext.store("_cloud_brigadier_native_sender", source));
        return 1;
    }
}

