/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloudbuildlogic.javadoclinks;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\bJ\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocAvailabilityService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "areJavadocsAvailable", "url", "checkAvailability", "attemptNo", "", "close", "", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "primeJavadocIo", "Companion", "cloud-build-logic"})
@SourceDebugExtension(value={"SMAP\nJavadocAvailabilityService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavadocAvailabilityService.kt\norg/incendo/cloudbuildlogic/javadoclinks/JavadocAvailabilityService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1726#2,3:100\n*S KotlinDebug\n*F\n+ 1 JavadocAvailabilityService.kt\norg/incendo/cloudbuildlogic/javadoclinks/JavadocAvailabilityService\n*L\n49#1:100,3\n*E\n"})
public abstract class JavadocAvailabilityService
implements BuildService<BuildServiceParameters.None>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, Boolean> cache = new ConcurrentHashMap();
    private static final Logger logger = Logging.getLogger(JavadocAvailabilityService.class);

    public final boolean areJavadocsAvailable(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Boolean bl = this.cache.computeIfAbsent(url, new Function(this){
            final /* synthetic */ JavadocAvailabilityService this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final Boolean apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = StringsKt.endsWith$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null) ? it : it + '/';
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (it.endsWith('/')) it else \"$it/\"");
                return JavadocAvailabilityService.checkAvailability$default(this.this$0, string, 0, 2, null);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"fun areJavadocsAvailable\u2026')) it else \"$it/\")\n    }");
        return bl;
    }

    private final boolean checkAvailability(String url, int attemptNo) {
        boolean bl;
        Object[] $this$all$iv;
        List results;
        block15: {
            int $i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232;
            List list = CollectionsKt.createListBuilder();
            List $this$checkAvailability_u24lambda_u240 = list;
            boolean bl2 = false;
            $this$checkAvailability_u24lambda_u240.add(url + "element-list");
            $this$checkAvailability_u24lambda_u240.add(url + "package-list/");
            List urls = CollectionsKt.build((List)list);
            if (attemptNo > 2) {
                logger.error("Javadoc at '{}' is still not available after 3 attempts.", (Object)url);
                return false;
            }
            results = new ArrayList();
            for (String hostString : urls) {
                Object $this$checkAvailability_u24lambda_u241;
                URL hostUrl = new URL(hostString);
                JavadocAvailabilityService javadocAvailabilityService = this;
                try {
                    $this$checkAvailability_u24lambda_u241 = javadocAvailabilityService;
                    $i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232 = 0;
                    URLConnection uRLConnection = hostUrl.openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                    HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                    connection.setInstanceFollowRedirects(true);
                    $this$checkAvailability_u24lambda_u241 = Result.constructor-impl((Object)connection.getResponseCode());
                }
                catch (Throwable $i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232) {
                    $this$checkAvailability_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232));
                }
                Object object = $this$checkAvailability_u24lambda_u241;
                results.add(TuplesKt.to((Object)hostString, (Object)Result.box-impl((Object)object)));
                Integer n = (Integer)(Result.isFailure-impl((Object)object) ? null : object);
                int n2 = 200;
                if (n == null || n != n2) continue;
                return true;
            }
            $this$all$iv = (Object[])results;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object e : $this$all$iv) {
                    Pair it = (Pair)e;
                    boolean bl3 = false;
                    Object $i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232 = ((Result)it.getSecond()).unbox-impl();
                    Integer n = (Integer)(Result.isFailure-impl((Object)$i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232) ? null : $i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232);
                    $i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232 = 403;
                    if (n != null && n == $i$a$-runCatching-JavadocAvailabilityService$checkAvailability$response$232) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (bl && StringsKt.startsWith$default((String)url, (String)"https://javadoc.io/", (boolean)false, (int)2, null)) {
            $this$all$iv = new Object[]{url};
            logger.lifecycle("Got 403 for element-list and package-list/ of '{}', will attempt to prime docs and then retry in 15s...", $this$all$iv);
            try {
                this.primeJavadocIo(url);
            }
            catch (IOException ex) {
                logger.error("Failed to prime Javadocs at '{}'", (Object)url, (Object)ex);
                return false;
            }
            Thread.sleep(Duration.ofSeconds(15L).toMillis());
            return this.checkAvailability(url, attemptNo + 1);
        }
        Throwable ex = null;
        for (Pair r : results) {
            GradleException gradleException;
            Object object = ((Result)r.getSecond()).unbox-impl();
            if (Result.exceptionOrNull-impl((Object)object) == null) {
                int it = ((Number)object).intValue();
                boolean bl4 = false;
                gradleException = new GradleException("Got " + it + " response code from " + (String)r.getFirst());
            } else {
                Throwable it;
                boolean bl5 = false;
                gradleException = new GradleException("Error getting response from " + (String)r.getFirst(), it);
            }
            GradleException gradleException2 = gradleException;
            if (ex == null) {
                ex = (Throwable)gradleException2;
                continue;
            }
            ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)((Throwable)gradleException2));
        }
        Throwable throwable = ex;
        if (throwable == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        logger.error("Could not locate element-list or package-list for docs: '" + url + '\'', throwable);
        return false;
    }

    static /* synthetic */ boolean checkAvailability$default(JavadocAvailabilityService javadocAvailabilityService, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkAvailability");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return javadocAvailabilityService.checkAvailability(string, n);
    }

    private final void primeJavadocIo(String url) {
        String staticUrl = StringsKt.replace$default((String)url, (String)"https://javadoc.io/doc/", (String)"https://javadoc.io/static/", (boolean)false, (int)4, null);
        URLConnection uRLConnection = new URL(staticUrl).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setInstanceFollowRedirects(true);
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            logger.error("Attempt to prime docs via '{}' returned response code {}", (Object)staticUrl, (Object)responseCode);
        }
    }

    public void onFinish(@Nullable FinishEvent event) {
    }

    @Override
    public void close() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocAvailabilityService$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "cloud-build-logic"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

