/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloudbuildlogic.javadoclinks;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.incendo.cloudbuildlogic.javadoclinks.JavadocLinksExtension;
import org.incendo.cloudbuildlogic.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0003./0B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001dJ\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010 \u001a\u00020!2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0#J\u0016\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u000bJ\u0016\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&J\u001e\u0010$\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001d2\u0006\u0010%\u001a\u00020\u000bJ\u001e\u0010$\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001d2\u0006\u0010%\u001a\u00020&J\u0016\u0010$\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u001f\u0010)\u001a\u00020*2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0,\"\u00020\u000b\u00a2\u0006\u0002\u0010-R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u00061"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension;", "", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "checkJavadocAvailability", "Lorg/gradle/api/provider/Property;", "", "getCheckJavadocAvailability", "()Lorg/gradle/api/provider/Property;", "defaultJavadocProvider", "", "getDefaultJavadocProvider", "excludes", "Lorg/gradle/api/provider/ListProperty;", "getExcludes", "()Lorg/gradle/api/provider/ListProperty;", "filter", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter;", "getFilter", "overrides", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$OverrideRule;", "getOverrides", "defaultOverrides", "", "exclude", "", "dep", "Lorg/gradle/api/artifacts/ModuleDependency;", "Lorg/gradle/api/provider/Provider;", "init", "key", "noSnapshots", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$NoSnapshots;", "exceptFor", "", "override", "link", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "passThrough", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$PassThrough;", "startsWithAnyOf", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "strings", "", "([Ljava/lang/String;)Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "DependencyFilter", "LinkOverride", "OverrideRule", "cloud-build-logic"})
public abstract class JavadocLinksExtension {
    @Inject
    public JavadocLinksExtension(@NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.init(providers);
    }

    @NotNull
    public abstract ListProperty<OverrideRule> getOverrides();

    @NotNull
    public abstract Property<DependencyFilter> getFilter();

    @NotNull
    public abstract ListProperty<String> getExcludes();

    @NotNull
    public abstract Property<String> getDefaultJavadocProvider();

    @NotNull
    public abstract Property<Boolean> getCheckJavadocAvailability();

    private final void init(ProviderFactory providers) {
        this.getFilter().convention((Object)new DependencyFilter.NoSnapshots(null, 1, null));
        this.getOverrides().addAll((Iterable)this.defaultOverrides());
        this.getDefaultJavadocProvider().convention((Object)"https://javadoc.io/doc/{group}/{name}/{version}");
        this.getCheckJavadocAvailability().convention(providers.gradleProperty("cloud-build-logic.checkJavadocAvailability").map((Transformer)init.1.INSTANCE).orElse((Object)true));
    }

    @NotNull
    public final List<OverrideRule> defaultOverrides() {
        Object[] objectArray = new OverrideRule[]{LinkOverride.KyoriRule.Companion.getRULE(), LinkOverride.PaperApiRule.Companion.getRULE(), LinkOverride.Log4jRule.Companion.getRULE()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final void override(@NotNull ModuleDependency dep, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.override(dep, (LinkOverride)new LinkOverride.Simple(link));
    }

    public final void override(@NotNull Provider<? extends ModuleDependency> dep, @NotNull String link) {
        Intrinsics.checkNotNullParameter(dep, (String)"dep");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.override((ModuleDependency)dep.get(), link);
    }

    public final void override(@NotNull ModuleDependency dep, @NotNull LinkOverride link) {
        Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        String[] stringArray = new String[]{this.key(dep)};
        this.override(new DependencyFilter.StartsWithAnyOf(stringArray), link);
    }

    public final void override(@NotNull Provider<? extends ModuleDependency> dep, @NotNull LinkOverride link) {
        Intrinsics.checkNotNullParameter(dep, (String)"dep");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.override((ModuleDependency)dep.get(), link);
    }

    public final void override(@NotNull DependencyFilter filter, @NotNull LinkOverride link) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.getOverrides().add((Object)new OverrideRule(filter, link));
    }

    public final void exclude(@NotNull ModuleDependency dep) {
        Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
        this.getExcludes().add((Object)this.key(dep));
    }

    public final void exclude(@NotNull Provider<? extends ModuleDependency> dep) {
        Intrinsics.checkNotNullParameter(dep, (String)"dep");
        this.exclude((ModuleDependency)dep.get());
    }

    private final String key(ModuleDependency dep) {
        StringBuilder stringBuilder = new StringBuilder().append(dep.getGroup()).append(':').append(dep.getName()).append(':');
        String string = dep.getVersion();
        if (string == null) {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    @NotNull
    public final DependencyFilter.NoSnapshots noSnapshots(@NotNull Set<String> exceptFor) {
        Intrinsics.checkNotNullParameter(exceptFor, (String)"exceptFor");
        return new DependencyFilter.NoSnapshots(exceptFor);
    }

    public static /* synthetic */ DependencyFilter.NoSnapshots noSnapshots$default(JavadocLinksExtension javadocLinksExtension, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: noSnapshots");
        }
        if ((n & 1) != 0) {
            set = DependencyFilter.NoSnapshots.Companion.getDEFAULT_EXCEPTIONS();
        }
        return javadocLinksExtension.noSnapshots(set);
    }

    @NotNull
    public final DependencyFilter.PassThrough passThrough() {
        return new DependencyFilter.PassThrough();
    }

    @NotNull
    public final DependencyFilter.StartsWithAnyOf startsWithAnyOf(String ... strings) {
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        return new DependencyFilter.StartsWithAnyOf(ArraysKt.toSet((Object[])strings));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00e6\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0003\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter;", "Ljava/util/function/Predicate;", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "NoSnapshots", "PassThrough", "StartsWithAnyOf", "cloud-build-logic"})
    public static interface DependencyFilter
    extends Predicate<ModuleComponentIdentifier> {

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$NoSnapshots;", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter;", "exceptFor", "", "", "(Ljava/util/Set;)V", "getExceptFor", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "test", "t", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "toString", "Companion", "cloud-build-logic"})
        @SourceDebugExtension(value={"SMAP\nJavadocLinksExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavadocLinksExtension.kt\norg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$NoSnapshots\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1747#2,3:224\n*S KotlinDebug\n*F\n+ 1 JavadocLinksExtension.kt\norg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$NoSnapshots\n*L\n187#1:224,3\n*E\n"})
        public static final class NoSnapshots
        implements DependencyFilter {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final Set<String> exceptFor;
            @NotNull
            private static final Set<String> DEFAULT_EXCEPTIONS;

            public NoSnapshots(@NotNull Set<String> exceptFor) {
                Intrinsics.checkNotNullParameter(exceptFor, (String)"exceptFor");
                this.exceptFor = exceptFor;
            }

            public /* synthetic */ NoSnapshots(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    set = DEFAULT_EXCEPTIONS;
                }
                this(set);
            }

            @Input
            @NotNull
            public final Set<String> getExceptFor() {
                return this.exceptFor;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean test(@NotNull ModuleComponentIdentifier t) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                String coords = UtilKt.coordinates(t);
                Iterable $this$any$iv = this.exceptFor;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)coords, (String)it, (boolean)false, (int)2, null)) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) {
                    return true;
                }
                if (t instanceof MavenUniqueSnapshotComponentIdentifier) return false;
                String string = t.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"t.version");
                if (StringsKt.endsWith$default((String)string, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) return false;
                return true;
            }

            @NotNull
            public final Set<String> component1() {
                return this.exceptFor;
            }

            @NotNull
            public final NoSnapshots copy(@NotNull Set<String> exceptFor) {
                Intrinsics.checkNotNullParameter(exceptFor, (String)"exceptFor");
                return new NoSnapshots(exceptFor);
            }

            public static /* synthetic */ NoSnapshots copy$default(NoSnapshots noSnapshots, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    set = noSnapshots.exceptFor;
                }
                return noSnapshots.copy(set);
            }

            @NotNull
            public String toString() {
                return "NoSnapshots(exceptFor=" + this.exceptFor + ')';
            }

            public int hashCode() {
                return ((Object)this.exceptFor).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoSnapshots)) {
                    return false;
                }
                NoSnapshots noSnapshots = (NoSnapshots)other;
                return Intrinsics.areEqual(this.exceptFor, noSnapshots.exceptFor);
            }

            public NoSnapshots() {
                this(null, 1, null);
            }

            static {
                Set set;
                Companion = new Companion(null);
                Set $this$DEFAULT_EXCEPTIONS_u24lambda_u241 = set = SetsKt.createSetBuilder();
                boolean bl = false;
                $this$DEFAULT_EXCEPTIONS_u24lambda_u241.addAll((Collection)LinkOverride.PaperApiRule.Companion.getFILTER().getStrings());
                DEFAULT_EXCEPTIONS = SetsKt.build((Set)set);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$NoSnapshots$Companion;", "", "()V", "DEFAULT_EXCEPTIONS", "", "", "getDEFAULT_EXCEPTIONS", "()Ljava/util/Set;", "cloud-build-logic"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Set<String> getDEFAULT_EXCEPTIONS() {
                    return DEFAULT_EXCEPTIONS;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$PassThrough;", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter;", "()V", "test", "", "ignore", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "cloud-build-logic"})
        public static final class PassThrough
        implements DependencyFilter {
            @Override
            public boolean test(@NotNull ModuleComponentIdentifier ignore) {
                Intrinsics.checkNotNullParameter((Object)ignore, (String)"ignore");
                return true;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter;", "strings", "", "", "([Ljava/lang/String;)V", "", "(Ljava/util/Set;)V", "getStrings", "()Ljava/util/Set;", "test", "", "id", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "cloud-build-logic"})
        @SourceDebugExtension(value={"SMAP\nJavadocLinksExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavadocLinksExtension.kt\norg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1747#2,3:224\n*S KotlinDebug\n*F\n+ 1 JavadocLinksExtension.kt\norg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf\n*L\n208#1:224,3\n*E\n"})
        public static final class StartsWithAnyOf
        implements DependencyFilter {
            @NotNull
            private final Set<String> strings;

            public StartsWithAnyOf(@NotNull Set<String> strings) {
                Intrinsics.checkNotNullParameter(strings, (String)"strings");
                this.strings = strings;
            }

            @Input
            @NotNull
            public final Set<String> getStrings() {
                return this.strings;
            }

            public StartsWithAnyOf(String ... strings) {
                Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
                this(ArraysKt.toSet((Object[])strings));
            }

            @Override
            public boolean test(@NotNull ModuleComponentIdentifier id) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                    String coords = UtilKt.coordinates(id);
                    Iterable $this$any$iv = this.strings;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)coords, (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00e6\u0080\u0001\u0018\u0000 \u00072\u00020\u0001:\u0006\u0007\b\t\n\u000b\fJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "", "link", "", "defaultProvider", "id", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "Companion", "KyoriRule", "Log4jRule", "PaperApiRule", "PassThrough", "Simple", "cloud-build-logic"})
    public static interface LinkOverride {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public String link(@NotNull String var1, @NotNull ModuleComponentIdentifier var2);

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$Companion;", "", "()V", "replaceVariables", "", "id", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "cloud-build-logic"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final String replaceVariables(@NotNull String $this$replaceVariables, @NotNull ModuleComponentIdentifier id) {
                Intrinsics.checkNotNullParameter((Object)$this$replaceVariables, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                String string = id.getGroup();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.group");
                String string2 = StringsKt.replace$default((String)$this$replaceVariables, (String)"{group}", (String)string, (boolean)false, (int)4, null);
                String string3 = id.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id.module");
                String string4 = StringsKt.replace$default((String)string2, (String)"{name}", (String)string3, (boolean)false, (int)4, null);
                String string5 = id.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"id.version");
                return StringsKt.replace$default((String)string4, (String)"{version}", (String)string5, (boolean)false, (int)4, null);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$KyoriRule;", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "()V", "link", "", "defaultProvider", "id", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "Companion", "cloud-build-logic"})
        public static final class KyoriRule
        implements LinkOverride {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final DependencyFilter.StartsWithAnyOf FILTER;
            @NotNull
            private static final OverrideRule RULE;

            @Override
            @NotNull
            public String link(@NotNull String defaultProvider, @NotNull ModuleComponentIdentifier id) {
                Intrinsics.checkNotNullParameter((Object)defaultProvider, (String)"defaultProvider");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                String string = id.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.module");
                String name = StringsKt.replace$default((String)string, (String)"adventure-", (String)"", (boolean)false, (int)4, null);
                if (StringsKt.contains$default((CharSequence)name, (CharSequence)"examination", (boolean)false, (int)2, null)) {
                    return new PassThrough().link(defaultProvider, id);
                }
                return "https://jd.advntr.dev/" + name + '/' + id.getVersion();
            }

            static {
                String[] stringArray = new String[]{"net.kyori:"};
                FILTER = new DependencyFilter.StartsWithAnyOf(stringArray);
                RULE = new OverrideRule(FILTER, new KyoriRule());
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$KyoriRule$Companion;", "", "()V", "FILTER", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "getFILTER", "()Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "RULE", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$OverrideRule;", "getRULE", "()Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$OverrideRule;", "cloud-build-logic"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final DependencyFilter.StartsWithAnyOf getFILTER() {
                    return FILTER;
                }

                @NotNull
                public final OverrideRule getRULE() {
                    return RULE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$Log4jRule;", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "()V", "link", "", "defaultProvider", "id", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "Companion", "cloud-build-logic"})
        public static final class Log4jRule
        implements LinkOverride {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final DependencyFilter.StartsWithAnyOf FILTER;
            @NotNull
            private static final OverrideRule RULE;

            @Override
            @NotNull
            public String link(@NotNull String defaultProvider, @NotNull ModuleComponentIdentifier id) {
                Intrinsics.checkNotNullParameter((Object)defaultProvider, (String)"defaultProvider");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return "https://logging.apache.org/log4j/2.x/javadoc/" + id.getModule() + '/';
            }

            static {
                String[] stringArray = new String[]{"org.apache.logging.log4j:log4j-api:", "org.apache.logging.log4j:log4j-core:"};
                FILTER = new DependencyFilter.StartsWithAnyOf(stringArray);
                RULE = new OverrideRule(FILTER, new Log4jRule());
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$Log4jRule$Companion;", "", "()V", "FILTER", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "getFILTER", "()Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "RULE", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$OverrideRule;", "getRULE", "()Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$OverrideRule;", "cloud-build-logic"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final DependencyFilter.StartsWithAnyOf getFILTER() {
                    return FILTER;
                }

                @NotNull
                public final OverrideRule getRULE() {
                    return RULE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$PaperApiRule;", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "()V", "link", "", "defaultProvider", "id", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "Companion", "cloud-build-logic"})
        public static final class PaperApiRule
        implements LinkOverride {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final DependencyFilter.StartsWithAnyOf FILTER;
            @NotNull
            private static final OverrideRule RULE;

            @Override
            @NotNull
            public String link(@NotNull String defaultProvider, @NotNull ModuleComponentIdentifier id) {
                Intrinsics.checkNotNullParameter((Object)defaultProvider, (String)"defaultProvider");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                String string = id.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.version");
                char[] cArray = new char[]{'.'};
                String ver = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                return "https://jd.papermc.io/paper/" + ver + '/';
            }

            static {
                String[] stringArray = new String[]{"io.papermc.paper:paper-api:", "com.destroystokyo.paper:paper-api:"};
                FILTER = new DependencyFilter.StartsWithAnyOf(stringArray);
                RULE = new OverrideRule(FILTER, new PaperApiRule());
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$PaperApiRule$Companion;", "", "()V", "FILTER", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "getFILTER", "()Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter$StartsWithAnyOf;", "RULE", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$OverrideRule;", "getRULE", "()Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$OverrideRule;", "cloud-build-logic"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final DependencyFilter.StartsWithAnyOf getFILTER() {
                    return FILTER;
                }

                @NotNull
                public final OverrideRule getRULE() {
                    return RULE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$PassThrough;", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "()V", "link", "", "defaultProvider", "id", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "cloud-build-logic"})
        public static final class PassThrough
        implements LinkOverride {
            @Override
            @NotNull
            public String link(@NotNull String defaultProvider, @NotNull ModuleComponentIdentifier id) {
                Intrinsics.checkNotNullParameter((Object)defaultProvider, (String)"defaultProvider");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return Companion.replaceVariables(defaultProvider, id);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride$Simple;", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "replacement", "", "(Ljava/lang/String;)V", "getReplacement", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "link", "defaultProvider", "id", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "toString", "cloud-build-logic"})
        public static final class Simple
        implements LinkOverride {
            @NotNull
            private final String replacement;

            public Simple(@NotNull String replacement) {
                Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
                this.replacement = replacement;
            }

            @Input
            @NotNull
            public final String getReplacement() {
                return this.replacement;
            }

            @Override
            @NotNull
            public String link(@NotNull String defaultProvider, @NotNull ModuleComponentIdentifier id) {
                Intrinsics.checkNotNullParameter((Object)defaultProvider, (String)"defaultProvider");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return Companion.replaceVariables(this.replacement, id);
            }

            @NotNull
            public final String component1() {
                return this.replacement;
            }

            @NotNull
            public final Simple copy(@NotNull String replacement) {
                Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
                return new Simple(replacement);
            }

            public static /* synthetic */ Simple copy$default(Simple simple, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = simple.replacement;
                }
                return simple.copy(string);
            }

            @NotNull
            public String toString() {
                return "Simple(replacement=" + this.replacement + ')';
            }

            public int hashCode() {
                return this.replacement.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Simple)) {
                    return false;
                }
                Simple simple = (Simple)other;
                return Intrinsics.areEqual((Object)this.replacement, (Object)simple.replacement);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$OverrideRule;", "", "filter", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter;", "override", "Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "(Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter;Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;)V", "getFilter", "()Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$DependencyFilter;", "getOverride", "()Lorg/incendo/cloudbuildlogic/javadoclinks/JavadocLinksExtension$LinkOverride;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cloud-build-logic"})
    public static final class OverrideRule {
        @NotNull
        private final DependencyFilter filter;
        @NotNull
        private final LinkOverride override;

        public OverrideRule(@NotNull DependencyFilter filter, @NotNull LinkOverride override) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)override, (String)"override");
            this.filter = filter;
            this.override = override;
        }

        @Nested
        @NotNull
        public final DependencyFilter getFilter() {
            return this.filter;
        }

        @Nested
        @NotNull
        public final LinkOverride getOverride() {
            return this.override;
        }

        @NotNull
        public final DependencyFilter component1() {
            return this.filter;
        }

        @NotNull
        public final LinkOverride component2() {
            return this.override;
        }

        @NotNull
        public final OverrideRule copy(@NotNull DependencyFilter filter, @NotNull LinkOverride override) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)override, (String)"override");
            return new OverrideRule(filter, override);
        }

        public static /* synthetic */ OverrideRule copy$default(OverrideRule overrideRule, DependencyFilter dependencyFilter, LinkOverride linkOverride, int n, Object object) {
            if ((n & 1) != 0) {
                dependencyFilter = overrideRule.filter;
            }
            if ((n & 2) != 0) {
                linkOverride = overrideRule.override;
            }
            return overrideRule.copy(dependencyFilter, linkOverride);
        }

        @NotNull
        public String toString() {
            return "OverrideRule(filter=" + this.filter + ", override=" + this.override + ')';
        }

        public int hashCode() {
            int result = this.filter.hashCode();
            result = result * 31 + this.override.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OverrideRule)) {
                return false;
            }
            OverrideRule overrideRule = (OverrideRule)other;
            if (!Intrinsics.areEqual((Object)this.filter, (Object)overrideRule.filter)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.override, (Object)overrideRule.override);
        }
    }
}

