/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import org.inferred.freebuilder.processor.BuildableType;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.property.MergeAction;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Excerpts;
import org.inferred.freebuilder.processor.source.FunctionalType;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Variable;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

class BuildableProperty
extends PropertyCodeGenerator {
    private final BuildableType type;
    private final FunctionalType mutatorType;

    private BuildableProperty(Datatype datatype, Property property, BuildableType type, FunctionalType mutatorType) {
        super(datatype, property);
        this.type = type;
        this.mutatorType = mutatorType;
    }

    @Override
    public void addValueFieldDeclaration(SourceBuilder code) {
        code.addLine("private final %s %s;", this.property.getType(), this.property.getField());
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private Object %s = null;", this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addSetter(code);
        this.addSetterTakingBuilder(code);
        this.addMutate(code);
        this.addGetter(code);
    }

    private void addSetter(SourceBuilder code) {
        Variable builder = new Variable("builder");
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName()).addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s %s) {", this.datatype.getBuilder(), BuilderMethods.setter(this.property), this.property.getType(), this.property.getName()).addLine("  %s.requireNonNull(%s);", Objects.class, this.property.getName()).addLine("  if (%1$s == null || %1$s instanceof %2$s) {", this.property.getField(), ModelUtils.maybeAsTypeElement(this.property.getType()).get()).addLine("    %s = %s;", this.property.getField(), this.property.getName()).addLine("  } else {", new Object[0]).addLine("    %1$s %2$s %3$s = (%2$s) %4$s;", this.type.suppressUnchecked(), this.type.builderType(), builder, this.property.getField()).addLine("    %s.clear();", builder).addLine("    %s.mergeFrom(%s);", builder, this.property.getName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addSetterTakingBuilder(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code builder} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s builder) {", this.datatype.getBuilder(), BuilderMethods.setter(this.property), this.type.builderType()).addLine("  return %s(builder.build());", BuilderMethods.setter(this.property)).addLine("}", new Object[0]);
    }

    private void addMutate(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the builder for the value that will be", new Object[0]).addLine(" * returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the builder in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), this.mutatorType.getFunctionalInterface()).addLine("  mutator.%s(%s());", this.mutatorType.getMethodName(), BuilderMethods.getBuilderMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        Variable builder = new Variable("builder");
        Variable value = new Variable("value");
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a builder for the value that will be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" */", new Object[0]).addLine("public %s %s() {", this.type.builderType(), BuilderMethods.getBuilderMethod(this.property)).addLine("  if (%s == null) {", this.property.getField()).addLine("    %s = %s;", this.property.getField(), this.type.newBuilder(BuilderFactory.TypeInference.EXPLICIT_TYPES)).addLine("  } else if (%s instanceof %s) {", this.property.getField(), ModelUtils.maybeAsTypeElement(this.property.getType()).get()).addLine("    %1$s %2$s %3$s = (%2$s) %4$s;", this.type.suppressUnchecked(), this.property.getType(), value, this.property.getField());
        if (this.type.partialToBuilder() == BuildableType.PartialToBuilderMethod.TO_BUILDER_AND_MERGE) {
            code.addLine("    %s = %s.toBuilder();", this.property.getField(), value);
        } else {
            code.addLine("    %s = %s", this.property.getField(), this.type.newBuilder(BuilderFactory.TypeInference.EXPLICIT_TYPES)).addLine("        .mergeFrom(%s);", value);
        }
        code.addLine("  }", new Object[0]).addLine("  %1$s %2$s %3$s = (%2$s) %4$s;", this.type.suppressUnchecked(), this.type.builderType(), builder, this.property.getField()).addLine("  return %s;", builder).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        this.addFieldAssignment(code, finalField, builder, "build");
    }

    @Override
    public void addPartialFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        this.addFieldAssignment(code, finalField, builder, "buildPartial");
    }

    private void addFieldAssignment(SourceBuilder code, Excerpt finalField, String builder, String buildMethod) {
        Variable fieldBuilder = new Variable(this.property.getName() + "Builder");
        Variable fieldValue = new Variable(this.property.getName() + "Value");
        code.addLine("if (%s == null) {", this.property.getField().on(builder)).addLine("  %s = %s.%s();", finalField, this.type.newBuilder(BuilderFactory.TypeInference.EXPLICIT_TYPES), buildMethod).addLine("} else if (%s instanceof %s) {", this.property.getField().on(builder), ModelUtils.maybeAsTypeElement(this.property.getType()).get());
        if (this.type.suppressUnchecked() != Excerpts.EMPTY) {
            code.addLine("  %1$s %2$s %3$s = (%2$s) %4$s;", this.type.suppressUnchecked(), this.property.getType(), fieldValue, this.property.getField().on(builder)).addLine("  %s = %s;", finalField, fieldValue);
        } else {
            code.addLine("  %s = (%s) %s;", finalField, this.property.getType(), this.property.getField().on(builder));
        }
        code.addLine("} else {", new Object[0]).addLine("  %1$s %2$s %3$s = (%2$s) %4$s;", this.type.suppressUnchecked(), this.type.builderType(), fieldBuilder, this.property.getField().on(builder)).addLine("  %s = %s.%s();", finalField, fieldBuilder, buildMethod).addLine("}", new Object[0]);
    }

    @Override
    public void addAssignToBuilder(SourceBuilder code, Variable builder) {
        if (this.type.partialToBuilder() == BuildableType.PartialToBuilderMethod.TO_BUILDER_AND_MERGE) {
            code.add("%s = %s.toBuilder();", this.property.getField().on(builder), this.property.getField());
        } else {
            code.add("%s = %s.mergeFrom(%s);", this.property.getField().on(builder), this.type.newBuilder(BuilderFactory.TypeInference.EXPLICIT_TYPES), this.property.getField());
        }
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        code.addLine("if (%s == null) {", this.property.getField()).addLine("  %s = %s.%s();", this.property.getField(), value, this.property.getGetterName()).addLine("} else {", new Object[0]).addLine("  %s().mergeFrom(%s.%s());", BuilderMethods.getBuilderMethod(this.property), value, this.property.getGetterName()).addLine("}", new Object[0]);
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        Variable fieldValue = new Variable(this.property.getName() + "Value");
        code.addLine("if (%s == null) {", this.property.getField().on(base)).addLine("  // Nothing to merge", new Object[0]).addLine("} else if (%s instanceof %s) {", this.property.getField().on(base), ModelUtils.maybeAsTypeElement(this.property.getType()).get()).addLine("  %1$s %2$s %3$s = (%2$s) %4$s;", this.type.suppressUnchecked(), this.property.getType(), fieldValue, this.property.getField().on(base)).addLine("  if (%s == null) {", this.property.getField()).addLine("    %s = %s;", this.property.getField(), fieldValue).addLine("  } else {", new Object[0]).addLine("    %s().mergeFrom(%s);", BuilderMethods.getBuilderMethod(this.property), fieldValue).addLine("  }", new Object[0]).addLine("} else {", new Object[0]).add("  %s().mergeFrom(%s.%s()", BuilderMethods.getBuilderMethod(this.property), base, BuilderMethods.getBuilderMethod(this.property));
        if (this.type.mergeBuilder() == BuildableType.MergeBuilderMethod.BUILD_PARTIAL_AND_MERGE) {
            code.add(".buildPartial()", new Object[0]);
        }
        code.add(");\n", new Object[0]).addLine("}", new Object[0]);
    }

    @Override
    public Set<MergeAction> getMergeActions() {
        return ImmutableSet.of();
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        Variable fieldBuilder = new Variable(this.property.getName() + "Builder");
        code.addLine("  if (%1$s == null || %1$s instanceof %2$s) {", this.property.getField(), ModelUtils.maybeAsTypeElement(this.property.getType()).get()).addLine("    %s = null;", this.property.getField()).addLine("  } else {", new Object[0]).addLine("    %1$s %2$s %3$s = (%2$s) %4$s;", this.type.suppressUnchecked(), this.type.builderType(), fieldBuilder, this.property.getField()).addLine("    %s.clear();", fieldBuilder).addLine("  }", new Object[0]);
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<BuildableProperty> create(PropertyCodeGenerator.Config config) {
            DeclaredType datatype = ModelUtils.maybeDeclared(config.getProperty().getType()).orElse(null);
            if (datatype == null) {
                return Optional.empty();
            }
            DeclaredType builder = BuildableType.maybeBuilder(datatype, config.getElements(), config.getTypes()).orElse(null);
            if (builder == null) {
                return Optional.empty();
            }
            BuildableType type = BuildableType.create(datatype, builder, config.getElements(), config.getTypes());
            FunctionalType mutatorType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mutator(config.getProperty()), FunctionalType.consumer(builder), config.getElements(), config.getTypes());
            return Optional.of(new BuildableProperty(config.getDatatype(), config.getProperty(), type, mutatorType));
        }
    }
}

