/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.jshell;

import org.inferred.freebuilder.shaded.org.openjdk.jdi.VMDisconnectedException;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.ClassPrepareEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.Event;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.EventIterator;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.EventQueue;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.EventSet;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.ExceptionEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.MethodEntryEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.MethodExitEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.ThreadDeathEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.ThreadStartEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.VMDeathEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.VMDisconnectEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.VMStartEvent;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.event.WatchpointEvent;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.JDIEnv;

class JDIEventHandler
implements Runnable {
    Thread thread;
    volatile boolean connected = true;
    boolean completed = false;
    String shutdownMessageKey;
    final JDIEnv env;
    private boolean vmDied = false;

    JDIEventHandler(JDIEnv env) {
        this.env = env;
        this.thread = new Thread((Runnable)this, "event-handler");
        this.thread.start();
    }

    synchronized void shutdown() {
        this.connected = false;
        this.thread.interrupt();
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EventQueue queue = this.env.vm().eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                boolean resumeStoppedApp = false;
                EventIterator it = eventSet.eventIterator();
                while (it.hasNext()) {
                    resumeStoppedApp |= this.handleEvent(it.nextEvent());
                }
                if (!resumeStoppedApp) continue;
                eventSet.resume();
            }
            catch (InterruptedException eventSet) {
            }
            catch (VMDisconnectedException discExc) {
                this.handleDisconnectedException();
                break;
            }
        }
        JDIEventHandler jDIEventHandler = this;
        synchronized (jDIEventHandler) {
            this.completed = true;
            this.notifyAll();
        }
    }

    private boolean handleEvent(Event event) {
        if (event instanceof ExceptionEvent) {
            this.exceptionEvent(event);
        } else if (event instanceof WatchpointEvent) {
            this.fieldWatchEvent(event);
        } else if (event instanceof MethodEntryEvent) {
            this.methodEntryEvent(event);
        } else if (event instanceof MethodExitEvent) {
            this.methodExitEvent(event);
        } else if (event instanceof ClassPrepareEvent) {
            this.classPrepareEvent(event);
        } else if (event instanceof ThreadStartEvent) {
            this.threadStartEvent(event);
        } else if (event instanceof ThreadDeathEvent) {
            this.threadDeathEvent(event);
        } else {
            if (event instanceof VMStartEvent) {
                this.vmStartEvent(event);
                return true;
            }
            this.handleExitEvent(event);
        }
        return true;
    }

    private void handleExitEvent(Event event) {
        if (event instanceof VMDeathEvent) {
            this.vmDied = true;
            this.shutdownMessageKey = "The application exited";
        } else if (event instanceof VMDisconnectEvent) {
            this.connected = false;
            if (!this.vmDied) {
                this.shutdownMessageKey = "The application has been disconnected";
            }
        } else {
            throw new InternalError("Unexpected event type: " + event.getClass());
        }
        this.env.shutdown();
    }

    synchronized void handleDisconnectedException() {
        EventQueue queue = this.env.vm().eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    this.handleExitEvent((Event)iter.next());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InternalError internalError) {
            }
        }
    }

    private void vmStartEvent(Event event) {
        VMStartEvent se = (VMStartEvent)event;
    }

    private void methodEntryEvent(Event event) {
        MethodEntryEvent me = (MethodEntryEvent)event;
    }

    private void methodExitEvent(Event event) {
        MethodExitEvent me = (MethodExitEvent)event;
    }

    private void fieldWatchEvent(Event event) {
        WatchpointEvent fwe = (WatchpointEvent)event;
    }

    private void classPrepareEvent(Event event) {
        ClassPrepareEvent cle = (ClassPrepareEvent)event;
    }

    private void exceptionEvent(Event event) {
        ExceptionEvent ee = (ExceptionEvent)event;
    }

    private void threadDeathEvent(Event event) {
        ThreadDeathEvent tee = (ThreadDeathEvent)event;
    }

    private void threadStartEvent(Event event) {
        ThreadStartEvent tse = (ThreadStartEvent)event;
    }
}

