/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.doclets.api;

import com.sun.javadoc.Doc;
import com.sun.javadoc.ProgramElementDoc;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class PublicAPIFilterHandler
implements InvocationHandler {
    private static final String PUBLIC_TAG = "@public";
    private static final String PRIVATE_TAG = "@private";
    private Object target;

    public PublicAPIFilterHandler(Object target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        if (args != null && ((methodName = method.getName()).equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
            args[0] = this.unwrap(args[0]);
        }
        try {
            return PublicAPIFilterHandler.filter(method.invoke(this.target, args), method.getReturnType());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private Object unwrap(Object proxy) {
        if (proxy instanceof Proxy) {
            return ((PublicAPIFilterHandler)Proxy.getInvocationHandler((Object)proxy)).target;
        }
        return proxy;
    }

    private static boolean isPublicAPI(Doc doc) {
        if (doc.tags(PRIVATE_TAG).length > 0) {
            return false;
        }
        if (doc instanceof ProgramElementDoc) {
            ProgramElementDoc peDoc = (ProgramElementDoc)doc;
            if (peDoc.containingClass() != null && peDoc.containingClass().tags(PUBLIC_TAG).length > 0) {
                return true;
            }
            if (peDoc.containingPackage().tags(PUBLIC_TAG).length > 0) {
                return true;
            }
        }
        return doc.tags(PUBLIC_TAG).length > 0;
    }

    public static Object filter(Object obj, Class<?> expect) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        if (cls.getName().startsWith("com.sun.")) {
            return Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), (InvocationHandler)new PublicAPIFilterHandler(obj));
        }
        if (obj instanceof Object[]) {
            Class<?> componentType = expect.getComponentType();
            if (componentType == null) {
                return obj;
            }
            String componentName = componentType.getName();
            if (!componentName.startsWith("com.sun.javadoc")) {
                return obj;
            }
            Object[] array = (Object[])obj;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (int i = 0; i < array.length; ++i) {
                Object entry = array[i];
                if (entry instanceof Doc && !PublicAPIFilterHandler.isPublicAPI((Doc)entry)) continue;
                list.add(entry);
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        return obj;
    }
}

