/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hadoop.sample;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.infinispan.hadoop.InfinispanInputFormat;
import org.infinispan.hadoop.InfinispanOutputFormat;
import org.infinispan.hadoop.sample.InputConverter;
import org.infinispan.hadoop.sample.MapClass;
import org.infinispan.hadoop.sample.OutputConverter;
import org.infinispan.hadoop.sample.ReduceClass;

public class InfinispanJobMain {
    public static void main(String[] args) throws Exception {
        Configuration configuration = new Configuration();
        if (args.length < 1) {
            System.err.println("Usage: hadoop jar <job jar> InfinispanJobMain <ispn-server>");
            System.exit(2);
        }
        String host = args[0];
        configuration.set("hadoop.ispn.input.remote.cache.host", host);
        configuration.set("hadoop.ispn.output.remote.cache.host", host);
        configuration.set("hadoop.ispn.input.cache.name", "map-reduce-in");
        configuration.set("hadoop.ispn.output.cache.name", "map-reduce-out");
        configuration.set("hadoop.ispn.input.converter", InputConverter.class.getName());
        configuration.set("hadoop.ispn.output.converter", OutputConverter.class.getName());
        Job job = Job.getInstance((Configuration)configuration, (String)"Infinispan word count");
        job.setJarByClass(InfinispanJobMain.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(MapClass.class);
        job.setReducerClass(ReduceClass.class);
        job.setInputFormatClass(InfinispanInputFormat.class);
        job.setOutputFormatClass(InfinispanOutputFormat.class);
        System.out.println("About to run the job!");
        boolean status = job.waitForCompletion(true);
        System.out.println("Finished executing job.");
        System.exit(status ? 0 : 1);
    }
}

