/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.images;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class Util {
    static Map<String, Object> loadYamlFromResources(String name) throws IOException {
        try (InputStream is = Util.class.getClassLoader().getResourceAsStream(name);){
            Map map = (Map)new Yaml().load(is);
            return map;
        }
    }

    static Map<String, Object> loadYaml(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Map map = (Map)new Yaml().load((InputStream)is);
            return map;
        }
    }

    static void merge(Map<String, Object> lhs, Map<String, Object> rhs) {
        if (rhs == null) {
            return;
        }
        for (String key : rhs.keySet()) {
            Object leftValue = lhs.get(key);
            if (leftValue instanceof Map) {
                Util.merge((Map)lhs.get(key), (Map)rhs.get(key));
                continue;
            }
            lhs.put(key, rhs.get(key));
        }
    }

    static <T> T get(Map<String, Object> config, String path) {
        if (config.isEmpty() || path == null) {
            return null;
        }
        String[] keys = path.split("\\.");
        Map map = config;
        for (int i = 0; i < keys.length; ++i) {
            if (i + 1 == keys.length) {
                return (T)map.get(keys[i]);
            }
            Object obj = config.get(keys[i]);
            if (obj == null) {
                return null;
            }
            map = (Map)config.get(keys[i]);
        }
        return (T)config.get(path);
    }

    static void exec(String ... args) throws InterruptedException, IOException {
        Process process = new ProcessBuilder(new String[0]).command(args).inheritIO().start();
        process.waitFor();
    }
}

