/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.impl;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.anchored.impl.AnchorManager;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.CacheException;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.notifications.Listener;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
public class AnchoredDistributionInterceptor
extends NonTxDistributionInterceptor {
    private static Log log = LogFactory.getLog(AnchoredDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    AnchorManager anchorManager;

    protected Object primaryReturnHandler(InvocationContext ctx, AbstractDataWriteCommand command, Object localResult) {
        assert (this.isReplicated);
        if (!command.isSuccessful()) {
            if (trace) {
                log.tracef("Skipping the replication of the conditional command as it did not succeed on primary owner (%s).", (Object)command);
            }
            return localResult;
        }
        LocalizedCacheTopology cacheTopology = this.checkTopologyId((TopologyAffectedCommand)command);
        DistributionInfo distributionInfo = cacheTopology.getDistribution(command.getKey());
        List owners = distributionInfo.writeOwners();
        if (owners.size() == 1) {
            return localResult;
        }
        AbstractDataWriteCommand remoteCommand = this.copyForBackups(ctx, command);
        ValueMatcher originalMatcher = command.getValueMatcher();
        remoteCommand.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
        if (!this.isSynchronous((FlagAffectedCommand)command)) {
            this.rpcManager.sendToAll((ReplicableCommand)command, DeliverOrder.PER_SENDER);
            command.setValueMatcher(originalMatcher.matcherForRetry());
            return localResult;
        }
        MapResponseCollector collector = MapResponseCollector.ignoreLeavers((boolean)this.isReplicated, (int)owners.size());
        RpcOptions rpcOptions = this.rpcManager.getSyncRpcOptions();
        CompletionStage remoteInvocation = this.rpcManager.invokeCommandOnAll((ReplicableCommand)remoteCommand, (ResponseCollector)collector, rpcOptions);
        return AnchoredDistributionInterceptor.asyncValue(remoteInvocation.handle((responses, t) -> {
            command.setValueMatcher(originalMatcher.matcherForRetry());
            CompletableFutures.rethrowExceptionIfPresent((Throwable)(t instanceof RemoteException ? t.getCause() : t));
            return localResult;
        }));
    }

    private <T extends VisitableCommand> T copyForBackups(InvocationContext ctx, T command) {
        ReplaceValueVisitor visitor = new ReplaceValueVisitor();
        try {
            VisitableCommand remoteCommand = (VisitableCommand)command.acceptVisitor(ctx, (Visitor)visitor);
            return (T)remoteCommand;
        }
        catch (Throwable throwable) {
            throw new CacheException(throwable);
        }
    }

    class ReplaceValueVisitor
    extends AbstractVisitor {
        ReplaceValueVisitor() {
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            Address keyLocation = AnchoredDistributionInterceptor.this.anchorManager.getCurrentWriter();
            CacheEntry ctxEntry = ctx.lookupEntry(command.getKey());
            if (ctxEntry.getValue() instanceof Address) {
                keyLocation = (Address)ctxEntry.getValue();
            }
            PutKeyValueCommand copy = AnchoredDistributionInterceptor.this.commandsFactory.buildPutKeyValueCommand(command.getKey(), (Object)keyLocation, command.getSegment(), command.getMetadata(), command.getFlagsBitSet());
            copy.setTopologyId(command.getTopologyId());
            return copy;
        }

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            throw new UnsupportedOperationException("Command type " + command.getClass() + " is not yet supported in anchor caches");
        }
    }
}

