/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.configuration;

import org.infinispan.anchored.configuration.AnchoredKeysConfiguration;
import org.infinispan.anchored.impl.Log;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Experimental;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.partitionhandling.PartitionHandling;

@Experimental
public class AnchoredKeysConfigurationBuilder
implements Builder<AnchoredKeysConfiguration> {
    private final AttributeSet attributes;
    private final ConfigurationBuilder rootBuilder;

    public AnchoredKeysConfigurationBuilder(ConfigurationBuilder builder) {
        this.rootBuilder = builder;
        this.attributes = AnchoredKeysConfiguration.attributeSet();
    }

    public void enabled(boolean enabled) {
        this.attributes.attribute(AnchoredKeysConfiguration.ENABLED).set((Object)enabled);
    }

    public void validate() {
        if (!this.rootBuilder.clustering().cacheMode().isReplicated()) {
            throw Log.CONFIG.replicationModeRequired();
        }
        if (this.rootBuilder.transaction().transactionMode() != null && this.rootBuilder.transaction().transactionMode().isTransactional()) {
            throw Log.CONFIG.transactionsNotSupported();
        }
        Attribute stateTransferEnabledAttribute = this.rootBuilder.clustering().stateTransfer().attributes().attribute(StateTransferConfiguration.FETCH_IN_MEMORY_STATE);
        if (!((Boolean)stateTransferEnabledAttribute.get()).booleanValue()) {
            throw Log.CONFIG.stateTransferRequired();
        }
        Attribute awaitStateTransferAttribute = this.rootBuilder.clustering().stateTransfer().attributes().attribute(StateTransferConfiguration.AWAIT_INITIAL_TRANSFER);
        if (((Boolean)awaitStateTransferAttribute.get()).booleanValue() && awaitStateTransferAttribute.isModified()) {
            throw Log.CONFIG.awaitInitialTransferNotSupported();
        }
        this.rootBuilder.clustering().stateTransfer().awaitInitialTransfer(false);
        Attribute whenSplitAttribute = this.rootBuilder.clustering().partitionHandling().attributes().attribute(PartitionHandlingConfiguration.WHEN_SPLIT);
        if (whenSplitAttribute.get() != PartitionHandling.ALLOW_READ_WRITES && whenSplitAttribute.isModified()) {
            throw Log.CONFIG.whenSplitNotSupported();
        }
        this.rootBuilder.clustering().partitionHandling().whenSplit(PartitionHandling.ALLOW_READ_WRITES);
        Attribute mergePolicyAttribute = this.rootBuilder.clustering().partitionHandling().attributes().attribute(PartitionHandlingConfiguration.MERGE_POLICY);
        if (mergePolicyAttribute.get() != MergePolicy.PREFERRED_NON_NULL && mergePolicyAttribute.isModified()) {
            throw Log.CONFIG.mergePolicyNotSupported();
        }
        this.rootBuilder.clustering().partitionHandling().mergePolicy((EntryMergePolicy)MergePolicy.PREFERRED_NON_NULL);
    }

    public AnchoredKeysConfiguration create() {
        return new AnchoredKeysConfiguration(this.attributes);
    }

    public Builder<?> read(AnchoredKeysConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

