/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.common;

import java.time.Duration;
import java.util.Optional;
import org.infinispan.api.common.Flags;

public interface CacheOptions {
    public static final CacheOptions DEFAULT = new Impl();

    public static Builder options() {
        return new Builder();
    }

    public Optional<Duration> timeout();

    public Optional<Flags<?, ?>> flags();

    public static class Builder {
        protected Duration timeout;
        protected Flags<?, ?> flags;

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder flags(Flags<?, ?> flags) {
            this.flags.addAll(flags);
            return this;
        }

        public CacheOptions build() {
            return new Impl(this.timeout, this.flags);
        }
    }

    public static class Impl
    implements CacheOptions {
        private final Duration timeout;
        private final Flags<?, ?> flags;

        protected Impl() {
            this(null, null);
        }

        protected Impl(Duration timeout, Flags<?, ?> flags) {
            this.timeout = timeout;
            this.flags = flags;
        }

        @Override
        public Optional<Duration> timeout() {
            return Optional.ofNullable(this.timeout);
        }

        public Duration rawTimeout() {
            return this.timeout;
        }

        @Override
        public Optional<Flags<?, ?>> flags() {
            return Optional.ofNullable(this.flags);
        }

        public Flags<?, ?> rawFlags() {
            return this.flags;
        }
    }
}

