/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser.mappers;

import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.MessageType;
import java.util.List;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.impl.parser.mappers.Mapper;
import org.infinispan.protostream.impl.parser.mappers.Mappers;

final class MessageTypeMapper
implements Mapper<MessageType, Descriptor> {
    MessageTypeMapper() {
    }

    @Override
    public Descriptor map(MessageType type) {
        List<MessageType> nestedMessageTypes = Mappers.filter(type.getNestedTypes(), MessageType.class);
        List<EnumType> enumTypes = Mappers.filter(type.getNestedTypes(), EnumType.class);
        List fields = type.getFields();
        List options = type.getOptions();
        return new Descriptor.Builder().withFullName(type.getFullyQualifiedName()).withName(type.getName()).withFields(Mappers.FIELD_LIST_MAPPER.map(fields)).withEnumTypes(Mappers.ENUM_LIST_MAPPER.map(enumTypes)).withNestedTypes(Mappers.MESSAGE_LIST_MAPPER.map(nestedMessageTypes)).withOptions(Mappers.OPTION_LIST_MAPPER.map(options)).withDocumentation(type.getDocumentation()).build();
    }
}

