/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public abstract class AbstractKeyValueOperation<T>
extends AbstractKeyOperation<T> {
    protected final byte[] value;
    protected final long lifespan;
    protected final long maxIdle;
    protected final TimeUnit lifespanTimeUnit;
    protected final TimeUnit maxIdleTimeUnit;

    protected AbstractKeyValueOperation(Codec codec, TransportFactory transportFactory, byte[] key, byte[] cacheName, AtomicInteger topologyId, Flag[] flags, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        super(codec, transportFactory, key, cacheName, topologyId, flags);
        this.value = value;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
    }

    protected short sendPutOperation(Transport transport, short opCode, byte opRespCode) {
        HeaderParams params = this.writeHeader(transport, opCode);
        transport.writeArray(this.key);
        this.codec.writeExpirationParams(transport, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        transport.writeArray(this.value);
        transport.flush();
        return this.readHeaderAndValidate(transport, params);
    }
}

